/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.IWrapperInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.ObjectInfoUtils;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.CompoundAssociation;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.core.model.association.InvocationChildArrayAssociation;
import org.eclipse.wb.core.model.association.InvocationChildEllipsisAssociation;
import org.eclipse.wb.core.model.association.UnknownAssociation;
import org.eclipse.wb.core.model.broadcast.EvaluationEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ChildTargetCalculator;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ExposedFieldCreationSupport;
import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IExposedCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IWrapperControlCreationSupport;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodControlCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.AbstractExplicitFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ExposingRule;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.generation.GenerationUtils;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.order.ComponentOrder;
import org.eclipse.wb.internal.core.model.order.ComponentOrderFirst;
import org.eclipse.wb.internal.core.model.util.IJavaInfoRendering;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.ExposedFieldVariableSupport;
import org.eclipse.wb.internal.core.model.variable.ExposedPropertyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public class JavaInfoUtils {
    private static final String KEY_PARAMETER_PREFIX = "Instance-level parameter: ";
    private static final String DEPENDENCY_KEY = "JavaInfo.dependencies";

    private JavaInfoUtils() {
    }

    public static TypeDeclaration getTypeDeclaration(JavaInfo javaInfo) {
        return AstNodeUtils.getEnclosingType(javaInfo.getCreationSupport().getNode());
    }

    public static MethodDeclaration getMethodDeclaration(JavaInfo javaInfo) {
        return AstNodeUtils.getEnclosingMethod(javaInfo.getCreationSupport().getNode());
    }

    public static boolean isLocalField(JavaInfo javaInfo, IField field) throws Exception {
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration(javaInfo);
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(typeDeclaration);
        String declaringTypeName = field.getDeclaringType().getFullyQualifiedName();
        return AstNodeUtils.isSuccessorOf(typeBinding, declaringTypeName);
    }

    public static boolean isImplicitlyCreated(JavaInfo javaInfo) {
        return javaInfo.getCreationSupport() instanceof IImplicitCreationSupport;
    }

    public static void scheduleSave(final JavaInfo info) {
        DesignerPlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        info.getEditor().getModelUnit().getBuffer().save(null, false);
                    }
                });
            }
        });
    }

    public static void scheduleOpenNode(final JavaInfo javaInfo, final ASTNode node) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IDesignPageSite site = IDesignPageSite.Helper.getSite((ObjectInfo)javaInfo);
                if (site != null) {
                    site.openSourcePosition(node.getStartPosition());
                }
            }
        });
    }

    public static void assertIsNotDeleted(JavaInfo javaInfo) {
        Assert.isTrue((!javaInfo.isDeleted() ? 1 : 0) != 0, (String)"Component is already deleted: %s", (Object[])new Object[]{javaInfo});
    }

    public static boolean canMove(final JavaInfo javaInfo) {
        final boolean[] forceMoveEnable = new boolean[1];
        final boolean[] forceMoveDisable = new boolean[1];
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                javaInfo.getBroadcastJava().canMove(javaInfo, forceMoveEnable, forceMoveDisable);
            }
        });
        if (forceMoveEnable[0]) {
            return true;
        }
        if (forceMoveDisable[0]) {
            return false;
        }
        return javaInfo.getCreationSupport().canReorder();
    }

    public static boolean canReparent(JavaInfo javaInfo) {
        return javaInfo.getCreationSupport().canReparent() && javaInfo.getAssociation().canDelete();
    }

    public static void setParameter(JavaInfo javaInfo, String name, String value) {
        String key = KEY_PARAMETER_PREFIX + name;
        javaInfo.putArbitraryValue(key, value);
    }

    public static String getParameter(JavaInfo javaInfo, String name) {
        AbstractExplicitFactoryCreationSupport factoryCreationSupport;
        FactoryMethodDescription factoryMethodDescription;
        String value;
        String key = KEY_PARAMETER_PREFIX + name;
        String value2 = (String)javaInfo.getArbitraryValue(key);
        if (value2 != null) {
            return value2;
        }
        if (javaInfo.getCreationSupport() instanceof AbstractExplicitFactoryCreationSupport && (value = (factoryMethodDescription = (factoryCreationSupport = (AbstractExplicitFactoryCreationSupport)javaInfo.getCreationSupport()).getDescription()).getParameter(name)) != null) {
            return value;
        }
        return javaInfo.getDescription().getParameter(name);
    }

    public static Map<String, String> getParameters(JavaInfo javaInfo) {
        HashMap parameters = Maps.newHashMap();
        parameters.putAll(JavaInfoUtils.extractArbitraryParameters(javaInfo));
        parameters.putAll(javaInfo.getDescription().getParameters());
        return parameters;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> extractArbitraryParameters(JavaInfo javaInfo) {
        HashMap parameters = Maps.newHashMap();
        for (Map.Entry arbitrary : javaInfo.getArbitraries().entrySet()) {
            void stringKey;
            Object key = arbitrary.getKey();
            Object value = arbitrary.getValue();
            Object k = key;
            if (!(k instanceof String)) continue;
            String cfr_ignored_0 = (String)k;
            String cfr_ignored_1 = (String)k;
            if (!(value instanceof String) || !stringKey.startsWith(KEY_PARAMETER_PREFIX)) continue;
            parameters.put(stringKey.substring(KEY_PARAMETER_PREFIX.length()), (String)value);
        }
        return parameters;
    }

    public static boolean hasTrueParameter(JavaInfo javaInfo, String name) {
        String parameter = JavaInfoUtils.getParameter(javaInfo, name);
        return "true".equals(parameter);
    }

    public static Object executeScriptParameter(JavaInfo javaInfo, String scriptName) throws Exception {
        String script = JavaInfoUtils.getParameter(javaInfo, scriptName);
        if (script != null) {
            return JavaInfoUtils.executeScript(javaInfo, script);
        }
        return null;
    }

    public static Object executeScript(JavaInfo javaInfo, String script) throws Exception {
        ClassLoader classLoader = JavaInfoUtils.getClassLoader(javaInfo);
        HashMap variables = Maps.newHashMap();
        variables.put("model", javaInfo);
        variables.put("object", javaInfo.getObject());
        return ScriptUtils.evaluate((ClassLoader)classLoader, (String)script, (Map)variables);
    }

    public static JavaInfo createJavaInfo(AstEditor editor, String componentClassName, CreationSupport creationSupport) throws Exception {
        Class<?> componentClass = EditorState.get(editor).getEditorLoader().loadClass(componentClassName);
        return JavaInfoUtils.createJavaInfo(editor, componentClass, creationSupport);
    }

    public static JavaInfo createJavaInfo(AstEditor editor, Class<?> componentClass, CreationSupport creationSupport) throws Exception {
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription(editor, componentClass);
        return JavaInfoUtils.createJavaInfo(editor, componentDescription, creationSupport);
    }

    public static JavaInfo createJavaInfo(AstEditor editor, ComponentDescription componentDescription, CreationSupport creationSupport) throws Exception {
        Class<?> modelClass = componentDescription.getModelClass();
        Constructor<?> modelConstructor = modelClass.getConstructor(AstEditor.class, ComponentDescription.class, CreationSupport.class);
        JavaInfo javaInfo = (JavaInfo)((Object)modelConstructor.newInstance(editor, componentDescription, creationSupport));
        ObjectInfoUtils.setNewId((ObjectInfo)javaInfo);
        return javaInfo;
    }

    public static void addExposedChildren(JavaInfo host, Class<?>[] exposedTypes) throws Exception {
        if (JavaInfoUtils.hasTrueParameter(host, "noExposedChildren")) {
            return;
        }
        JavaInfoUtils.addExposedChildred_Method(host, exposedTypes);
        JavaInfoUtils.addExposedChildred_Field(host, exposedTypes);
        JavaInfoUtils.buildExposedChildrenHierarchy(host);
    }

    private static void addExposedChildred_Method(JavaInfo host, Class<?>[] exposedTypes) throws Exception {
        Object hostObject = host.getObject();
        Assert.isNotNull((Object)hostObject);
        boolean includeProtected = JavaInfoUtils.shouldExposeProtectedMembers(host);
        List<PropertyDescriptor> propertyDescriptors = host.getDescription().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            Class<?> returnType;
            Method setMethod = ReflectionUtils.getWriteMethod((PropertyDescriptor)propertyDescriptor);
            Method getMethod = ReflectionUtils.getReadMethod((PropertyDescriptor)propertyDescriptor);
            if (getMethod == null || !includeProtected && ReflectionUtils.isProtected((Method)getMethod) || !JavaInfoUtils.isExposedType(exposedTypes, returnType = getMethod.getReturnType()) || !JavaInfoUtils.isEnabledExposeMethod(host, getMethod)) continue;
            Object methodObject = null;
            try {
                methodObject = getMethod.invoke(hostObject, new Object[0]);
                if (methodObject == null) {
                }
            }
            catch (Exception e) {}
            continue;
            if (!JavaInfoUtils.isExposeDisconnectedComponent(host, getMethod) && !JavaInfoUtils.areParentChild(host, methodObject) || JavaInfoUtils.isExposedRecursive(host, methodObject)) continue;
            JavaInfoUtils.addChildExposedByMethod(host, getMethod, setMethod, methodObject);
        }
    }

    public static JavaInfo addChildExposedByMethod(JavaInfo host, String getMethodName) throws Exception {
        Object hostObject = host.getObject();
        Assert.isNotNull((Object)hostObject);
        Method getMethod = ReflectionUtils.getMethod(hostObject.getClass(), (String)getMethodName, (Class[])new Class[0]);
        Object methodObject = getMethod.invoke(hostObject, new Object[0]);
        Assert.isNotNull((Object)methodObject);
        return JavaInfoUtils.addChildExposedByMethod(host, getMethod, null, methodObject);
    }

    private static JavaInfo addChildExposedByMethod(JavaInfo host, Method getMethod, Method setMethod, Object methodObject) throws Exception {
        JavaInfo methodJavaInfo;
        if (JavaInfoUtils.isAlreadyExposedMethod(host, getMethod)) {
            return null;
        }
        AstEditor editor = host.getEditor();
        boolean direct = JavaInfoUtils.getParentObject(methodObject) == host.getObject();
        ExposedPropertyCreationSupport creationSupport = new ExposedPropertyCreationSupport(host, getMethod, setMethod, direct);
        if (InstanceFactoryInfo.isFactory(editor, getMethod.getReturnType())) {
            methodJavaInfo = InstanceFactoryInfo.createFactory(editor, getMethod.getReturnType(), creationSupport);
        } else {
            ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription(editor, host.getDescription(), getMethod);
            methodJavaInfo = JavaInfoUtils.createJavaInfo(editor, componentDescription, (CreationSupport)creationSupport);
        }
        methodJavaInfo.setVariableSupport(new ExposedPropertyVariableSupport(methodJavaInfo, host, getMethod));
        methodJavaInfo.setAssociation(new ImplicitObjectAssociation(host));
        JavaInfoUtils.addExposedJavaInfo(host, methodJavaInfo);
        methodJavaInfo.setObject(methodObject);
        return methodJavaInfo;
    }

    private static boolean isAlreadyExposedMethod(JavaInfo host, Method getMethod) {
        String key = "JavaInfoUtils.alreadyExposed.Method";
        Set alreadyExposed = (Set)host.getArbitraryValue(key);
        if (alreadyExposed == null) {
            alreadyExposed = Sets.newHashSet();
            host.putArbitraryValue(key, alreadyExposed);
        }
        if (alreadyExposed.contains(getMethod)) {
            return true;
        }
        alreadyExposed.add(getMethod);
        return false;
    }

    private static void addExposedChildred_Field(JavaInfo host, Class<?>[] exposedTypes) throws Exception {
        Object hostObject = host.getObject();
        Assert.isNotNull((Object)hostObject);
        boolean includeProtected = JavaInfoUtils.shouldExposeProtectedMembers(host);
        List fields = ReflectionUtils.getFields(hostObject.getClass());
        for (Field field : fields) {
            Object fieldObject;
            Class<?> fieldType;
            if (ReflectionUtils.isPrivate((Field)field) || ReflectionUtils.isPackagePrivate((Field)field) || ReflectionUtils.isProtected((Field)field) && !includeProtected || !JavaInfoUtils.isExposedType(exposedTypes, fieldType = field.getType()) || !JavaInfoUtils.isEnabledExposeField(host, field) || (fieldObject = field.get(hostObject)) == null || !JavaInfoUtils.areParentChild(host, fieldObject) || JavaInfoUtils.isExposedRecursive(host, fieldObject)) continue;
            JavaInfoUtils.addChildExposedByField(host, field, fieldObject);
        }
    }

    private static JavaInfo addChildExposedByField(JavaInfo host, Field field, Object fieldObject) throws Exception {
        if (JavaInfoUtils.isAlreadyExposedField(host, field)) {
            return null;
        }
        AstEditor editor = host.getEditor();
        boolean direct = JavaInfoUtils.getParentObject(fieldObject) == host.getObject();
        ExposedFieldCreationSupport creationSupport = new ExposedFieldCreationSupport(host, field, direct);
        ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription(editor, field.getType());
        JavaInfo fieldJavaInfo = JavaInfoUtils.createJavaInfo(editor, componentDescription, (CreationSupport)creationSupport);
        fieldJavaInfo.setVariableSupport(new ExposedFieldVariableSupport(fieldJavaInfo, host, field));
        fieldJavaInfo.setAssociation(new ImplicitObjectAssociation(host));
        JavaInfoUtils.addExposedJavaInfo(host, fieldJavaInfo);
        fieldJavaInfo.setObject(fieldObject);
        return fieldJavaInfo;
    }

    private static boolean isAlreadyExposedField(JavaInfo host, Field field) {
        String key = "JavaInfoUtils.alreadyExposed.Field";
        Set alreadyExposed = (Set)host.getArbitraryValue(key);
        if (alreadyExposed == null) {
            alreadyExposed = Sets.newHashSet();
            host.putArbitraryValue(key, alreadyExposed);
        }
        if (alreadyExposed.contains(field)) {
            return true;
        }
        alreadyExposed.add(field);
        return false;
    }

    private static void addExposedJavaInfo(JavaInfo host, JavaInfo exposed) throws Exception {
        for (HierarchyProvider provider : JavaInfoUtils.getHierarchyProviders()) {
            provider.add(host, exposed);
            if (exposed.getParent() != null) break;
        }
        if (exposed.getParent() == null) {
            host.addChild(exposed);
        }
    }

    private static boolean isEnabledExposeMethod(JavaInfo host, Method getMethod) {
        String signature;
        TypeDeclaration typeDeclaration;
        for (ExposingRule rule : host.getDescription().getExposingRules()) {
            Boolean filter = rule.filter(getMethod);
            if (filter == null) continue;
            return filter != false;
        }
        return !(host.getCreationSupport() instanceof ThisCreationSupport) || AstNodeUtils.getMethodBySignature(typeDeclaration = JavaInfoUtils.getTypeDeclaration(host), signature = ReflectionUtils.getMethodSignature((Method)getMethod)) == null;
    }

    private static boolean isEnabledExposeField(JavaInfo host, Field field) {
        for (ExposingRule rule : host.getDescription().getExposingRules()) {
            Boolean filter = rule.filter(field);
            if (filter == null) continue;
            return filter != false;
        }
        return true;
    }

    private static boolean shouldExposeProtectedMembers(JavaInfo host) {
        String hostPackageName;
        if (host.getCreationSupport() instanceof ThisCreationSupport) {
            return true;
        }
        String unitPackageName = AstNodeUtils.getPackageName(host.getEditor().getAstUnit());
        return unitPackageName.equals(hostPackageName = CodeUtils.getPackage(host.getDescription().getComponentClass().getName()));
    }

    private static boolean isExposedType(Class<?>[] exposedTypes, Class<?> candidate) {
        Class<?>[] classArray = exposedTypes;
        int n = exposedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> exposedType = classArray[n2];
            if (exposedType.isAssignableFrom(candidate)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isExposeDisconnectedComponent(JavaInfo host, Method getMethod) throws Exception {
        String signature = ReflectionUtils.getMethodSignature((Method)getMethod);
        MethodDescription methodDescription = host.getDescription().getMethod(signature);
        return methodDescription != null && methodDescription.hasTrueTag("exposeDisconnectedComponent");
    }

    private static boolean isExposedRecursive(JavaInfo host, Object methodObject) {
        return host.getObject() == methodObject;
    }

    public static boolean isIndirectlyExposed(JavaInfo javaInfo) {
        CreationSupport creationSupport = javaInfo.getCreationSupport();
        if (creationSupport instanceof IExposedCreationSupport) {
            return !((IExposedCreationSupport)((Object)creationSupport)).isDirect();
        }
        if (creationSupport instanceof IWrapperControlCreationSupport) {
            JavaInfo wrapper = ((IWrapperControlCreationSupport)((Object)creationSupport)).getWrapperInfo();
            return JavaInfoUtils.isIndirectlyExposed(wrapper);
        }
        return false;
    }

    private static void buildExposedChildrenHierarchy(JavaInfo host) throws Exception {
        HashMap objectToChild = Maps.newHashMap();
        for (JavaInfo child : host.getChildrenJava()) {
            objectToChild.put(child.getObject(), child);
        }
        final ArrayList sortedChildren = Lists.newArrayList();
        JavaInfoUtils.fillChildren(sortedChildren, host.getObject(), objectToChild);
        Collections.sort(host.getChildren(), new Comparator<ObjectInfo>(){

            @Override
            public int compare(ObjectInfo o1, ObjectInfo o2) {
                boolean exposed_1 = this.isExposed(o1);
                boolean exposed_2 = this.isExposed(o2);
                if (!exposed_1 || !exposed_2) {
                    return 0;
                }
                return sortedChildren.indexOf(o1) - sortedChildren.indexOf(o2);
            }

            /*
             * WARNING - void declaration
             */
            private boolean isExposed(ObjectInfo o) {
                ObjectInfo objectInfo = o;
                if (objectInfo instanceof JavaInfo) {
                    void javaInfo;
                    JavaInfo javaInfo2 = (JavaInfo)objectInfo;
                    JavaInfo cfr_ignored_0 = (JavaInfo)objectInfo;
                    return javaInfo.getCreationSupport() instanceof IExposedCreationSupport;
                }
                return false;
            }
        });
        block1: for (JavaInfo child : sortedChildren) {
            if (!(child.getCreationSupport() instanceof IExposedCreationSupport)) continue;
            Object parentObject = JavaInfoUtils.getParentObject(child.getObject());
            while (parentObject != null) {
                JavaInfo parent = (JavaInfo)((Object)objectToChild.get(parentObject));
                if (parent != null) {
                    host.removeChild(child);
                    parent.addChild(child);
                    continue block1;
                }
                parentObject = JavaInfoUtils.getParentObject(parentObject);
            }
        }
    }

    private static Object getParentObject(Object childObject) throws Exception {
        for (HierarchyProvider provider : JavaInfoUtils.getHierarchyProviders()) {
            Object parentObject = provider.getParentObject(childObject);
            if (parentObject == null) continue;
            return parentObject;
        }
        return null;
    }

    private static boolean areParentChild(JavaInfo host, Object child) throws Exception {
        Object[] requiredParents;
        Object[] objectArray = requiredParents = JavaInfoUtils.getComponentObjects(host);
        int n = requiredParents.length;
        int n2 = 0;
        while (n2 < n) {
            Object requiredParent = objectArray[n2];
            if (JavaInfoUtils.areParentChild(requiredParent, child)) {
                return true;
            }
            for (HierarchyProvider provider : JavaInfoUtils.getHierarchyProviders()) {
                Object[] children = provider.getChildrenObjects(requiredParent);
                if (!ArrayUtils.contains((Object[])children, (Object)child)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean areParentChild(Object requiredParent, Object child) throws Exception {
        Object parent = child;
        while (parent != null) {
            if (parent == requiredParent) {
                return true;
            }
            parent = JavaInfoUtils.getParentObject(parent);
        }
        return false;
    }

    private static void fillChildren(List<JavaInfo> children, Object object, Map<Object, JavaInfo> objectToChild) throws Exception {
        JavaInfo child = objectToChild.get(object);
        if (child != null) {
            children.add(child);
        }
        ArrayList childrenObjects = Lists.newArrayList();
        for (HierarchyProvider provider : JavaInfoUtils.getHierarchyProviders()) {
            Collections.addAll(childrenObjects, provider.getChildrenObjects(object));
        }
        for (HierarchyProvider childOfChild : childrenObjects) {
            JavaInfoUtils.fillChildren(children, childOfChild, objectToChild);
        }
    }

    private static List<HierarchyProvider> getHierarchyProviders() {
        return ExternalFactoriesHelper.getElementsInstances(HierarchyProvider.class, (String)"org.eclipse.wb.core.componentsHierarchyProviders", (String)"provider");
    }

    public static void bindBinaryComponents(List<JavaInfo> components) throws Exception {
        ImmutableList reverseComponents = ImmutableList.copyOf(components).reverse();
        final HashMap objectToModel = Maps.newHashMap();
        for (JavaInfo component : components) {
            component.accept(new ObjectInfoVisitor(){

                /*
                 * WARNING - void declaration
                 */
                public void endVisit(ObjectInfo objectInfo) throws Exception {
                    ObjectInfo objectInfo2 = objectInfo;
                    if (objectInfo2 instanceof JavaInfo) {
                        void javaInfo;
                        JavaInfo javaInfo2 = (JavaInfo)objectInfo2;
                        JavaInfo cfr_ignored_0 = (JavaInfo)objectInfo2;
                        Object[] objectArray = JavaInfoUtils.getComponentObjects((JavaInfo)javaInfo);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object componentObject = objectArray[n2];
                            objectToModel.put(componentObject, javaInfo);
                            ++n2;
                        }
                    }
                }
            });
        }
        ArrayList objects = Lists.newArrayList();
        for (JavaInfo component : components) {
            if (component.getParent() != null) continue;
            Object[] objectArray = JavaInfoUtils.getComponentObjects(component);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object componentObject = objectArray[n2];
                Assert.isNotNull((Object)componentObject, (String)"No object for component: %s", (Object[])new Object[]{component});
                JavaInfoUtils.fillToolkitObjects(objects, componentObject);
                ++n2;
            }
        }
        for (JavaInfo component : components) {
            if (component.getParent() != null) continue;
            JavaInfoUtils.bindBinaryComponent_toParent(objectToModel, objects, component);
        }
        for (JavaInfo component : reverseComponents) {
            if (component.getParent() != null) continue;
            JavaInfoUtils.bindBinaryComponent_asAlias(components, component);
        }
        for (JavaInfo component : reverseComponents) {
            if (component.getParent() != null || !component.getDescription().hasTrueParameter("bindBinary.toDepth")) continue;
            JavaInfoUtils.bindBinaryComponent_toDepth(objectToModel, component);
        }
    }

    private static void bindBinaryComponent_toParent(Map<Object, JavaInfo> objectToModel, List<Object> objects, JavaInfo component) throws Exception {
        Object[] objectArray = JavaInfoUtils.getComponentObjects(component);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            int objectIndex = objects.indexOf(object);
            Object parentObject = JavaInfoUtils.getParentObject(object);
            while (parentObject != null) {
                JavaInfo parent = objectToModel.get(parentObject);
                if (parent != null) {
                    boolean added = false;
                    block2: for (JavaInfo child : parent.getChildrenJava()) {
                        Object[] objectArray2 = JavaInfoUtils.getComponentObjects(child);
                        int n3 = objectArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object childObject = objectArray2[n4];
                            int childIndex = objects.indexOf(childObject);
                            if (objectIndex < childIndex) {
                                parent.addChild(component, child);
                                added = true;
                                break block2;
                            }
                            ++n4;
                        }
                    }
                    if (!added) {
                        parent.addChild(component);
                    }
                    component.setAssociation(new UnknownAssociation());
                    return;
                }
                parentObject = JavaInfoUtils.getParentObject(parentObject);
            }
            ++n2;
        }
    }

    private static void bindBinaryComponent_asAlias(List<JavaInfo> components, JavaInfo component) throws Exception {
        Object[] objectArray = JavaInfoUtils.getComponentObjects(component);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            for (JavaInfo otherComponent : components) {
                Object[] objectArray2 = JavaInfoUtils.getComponentObjects(otherComponent);
                int n3 = objectArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    boolean otherIsSameOrChild;
                    Object otherObject = objectArray2[n4];
                    boolean bl = otherIsSameOrChild = otherComponent == component || component.isParentOf(otherComponent);
                    if (otherObject == object && !otherIsSameOrChild) {
                        List children = otherComponent.getChildren(AbstractComponentInfo.class);
                        JavaInfo nextChild = !children.isEmpty() ? (JavaInfo)((Object)children.get(0)) : null;
                        otherComponent.addChild(component, nextChild);
                        component.setAssociation(new UnknownAssociation());
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static Object[] getComponentObjects(JavaInfo component) throws Exception {
        Object object = JavaInfoUtils.getComponentObject0(component);
        if (object == null) {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        for (HierarchyProvider provider : JavaInfoUtils.getHierarchyProviders()) {
            Object[] objects = provider.getAliases(object);
            if (objects == null) continue;
            return objects;
        }
        return new Object[]{object};
    }

    private static Object getComponentObject0(JavaInfo component) {
        return component instanceof AbstractComponentInfo ? ((AbstractComponentInfo)component).getComponentObject() : component.getObject();
    }

    private static void fillToolkitObjects(List<Object> objects, Object object) throws Exception {
        objects.add(object);
        ArrayList children = Lists.newArrayList();
        for (HierarchyProvider provider : JavaInfoUtils.getHierarchyProviders()) {
            Collections.addAll(children, provider.getChildrenObjects(object));
        }
        for (HierarchyProvider child : children) {
            JavaInfoUtils.fillToolkitObjects(objects, child);
        }
    }

    private static void bindBinaryComponent_toDepth(Map<Object, JavaInfo> objectToModel, JavaInfo component) throws Exception {
        Object[] objects;
        Object[] objectArray = objects = JavaInfoUtils.getComponentObjects(component);
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            JavaInfoUtils.bindBinaryComponent_toDepth(objectToModel, component, object);
            ++n2;
        }
    }

    private static void bindBinaryComponent_toDepth(Map<Object, JavaInfo> objectToModel, JavaInfo parentInfo, Object object) throws Exception {
        for (HierarchyProvider provider : JavaInfoUtils.getHierarchyProviders()) {
            Object[] children;
            Object[] objectArray = children = provider.getChildrenObjects(object);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                JavaInfo childInfo = objectToModel.get(child);
                if (childInfo != null) {
                    if (childInfo.getParent() == null) {
                        parentInfo.addChild(childInfo);
                        childInfo.setAssociation(new UnknownAssociation());
                    }
                    JavaInfoUtils.bindBinaryComponent_toDepth(objectToModel, childInfo, child);
                } else {
                    JavaInfoUtils.bindBinaryComponent_toDepth(objectToModel, parentInfo, child);
                }
                ++n2;
            }
        }
    }

    public static void add(JavaInfo component, AssociationObject associationObject, JavaInfo container, JavaInfo nextComponent) throws Exception {
        VariableSupport variableSupport = GenerationUtils.getVariableSupport(component);
        StatementGenerator statementGenerator = GenerationUtils.getStatementGenerator(component);
        JavaInfoUtils.add(component, variableSupport, statementGenerator, associationObject, container, nextComponent);
    }

    public static void addTarget(JavaInfo component, AssociationObject associationObject, JavaInfo container, StatementTarget target) throws Exception {
        JavaInfoUtils.addTarget(component, associationObject, container, null, target);
    }

    public static void addTarget(JavaInfo component, AssociationObject associationObject, JavaInfo container, JavaInfo nextComponent, StatementTarget target) throws Exception {
        VariableSupport variableSupport = GenerationUtils.getVariableSupport(component);
        StatementGenerator statementGenerator = GenerationUtils.getStatementGenerator(component);
        JavaInfoUtils.add(component, variableSupport, statementGenerator, associationObject, container, nextComponent, target);
    }

    public static void add(JavaInfo component, VariableSupport variableSupport, StatementGenerator statementGenerator, AssociationObject associationObject, JavaInfo container, JavaInfo nextComponent) throws Exception {
        nextComponent = JavaInfoUtils.getNextComponent_useComponentOrder(component, container, nextComponent);
        StatementTarget target = JavaInfoUtils.getTarget(container, component, nextComponent);
        JavaInfoUtils.add(component, variableSupport, statementGenerator, associationObject, container, nextComponent, target);
    }

    private static JavaInfo getNextComponent_useComponentOrder(JavaInfo component, JavaInfo container, JavaInfo nextComponent) throws Exception {
        ComponentOrder order = component.getDescription().getOrder();
        if (nextComponent == null) {
            nextComponent = order.getNextComponent_whenLast(component, container);
        }
        if (nextComponent == null) {
            for (JavaInfo parentChild : container.getChildrenJava()) {
                if (parentChild.getDescription().getOrder().canBeBefore(component)) continue;
                return parentChild;
            }
        }
        return nextComponent;
    }

    public static void addFirst(JavaInfo component, AssociationObject associationObject, JavaInfo container) throws Exception {
        ComponentOrder order = ComponentOrderFirst.INSTANCE;
        JavaInfo nextComponent = order.getNextComponent_whenLast(component, container);
        StatementTarget target = JavaInfoUtils.getTarget(container, component, nextComponent);
        VariableSupport variableSupport = GenerationUtils.getVariableSupport(component);
        StatementGenerator statementGenerator = GenerationUtils.getStatementGenerator(component);
        JavaInfoUtils.add(component, variableSupport, statementGenerator, associationObject, container, nextComponent, target);
    }

    public static void add(JavaInfo component, VariableSupport variableSupport, StatementGenerator statementGenerator, AssociationObject associationObject, JavaInfo container, JavaInfo nextComponent, StatementTarget target) throws Exception {
        container.getBroadcastJava().addBefore(container, component);
        container.addChild(component, nextComponent);
        component.setVariableSupport(variableSupport);
        Association association = JavaInfoUtils.createAssociation(container, component, associationObject);
        statementGenerator.add(component, target, association);
        container.getBroadcastJava().addAfter(container, component);
    }

    private static Association createAssociation(JavaInfo container, JavaInfo component, AssociationObject associationObject) throws Exception {
        associationObject = JavaInfoUtils.getNotNullAssociationObject(associationObject);
        Association componentAssociation = component.getCreationSupport().getAssociation();
        Association containerAssociation = associationObject.getAssociation();
        if (componentAssociation != null) {
            if (associationObject.isRequired()) {
                return new CompoundAssociation(componentAssociation, containerAssociation);
            }
            return componentAssociation;
        }
        Assert.isNotNull((Object)containerAssociation, (String)"No special container association and no component creation association for %s and %s", (Object[])new Object[]{container, component});
        return containerAssociation;
    }

    private static AssociationObject getNotNullAssociationObject(AssociationObject associationObject) {
        if (associationObject == null) {
            associationObject = new AssociationObject(null, false);
        }
        return associationObject;
    }

    public static void move(JavaInfo component, AssociationObject associationObject, JavaInfo newParent, JavaInfo nextComponent) throws Exception {
        if (nextComponent == component) {
            return;
        }
        nextComponent = JavaInfoUtils.getNextComponent_useComponentOrder(component, newParent, nextComponent);
        JavaInfoUtils.move0(component, associationObject, newParent, nextComponent);
    }

    private static void move0(final JavaInfo component, AssociationObject associationObject, final JavaInfo newParent, final JavaInfo nextComponent) throws Exception {
        IMoveTargetProvider targetProvider = new IMoveTargetProvider(){

            @Override
            public void add() throws Exception {
                newParent.addChild(component, nextComponent);
            }

            @Override
            public void move() throws Exception {
                newParent.moveChild(component, nextComponent);
            }

            @Override
            public StatementTarget getTarget() throws Exception {
                return JavaInfoUtils.getTarget(newParent, component, nextComponent);
            }
        };
        JavaInfoUtils.moveProvider(component, associationObject, newParent, targetProvider);
    }

    public static void moveTarget(final JavaInfo component, AssociationObject associationObject, final JavaInfo newParent, final JavaInfo nextComponent, final StatementTarget target) throws Exception {
        IMoveTargetProvider targetProvider = new IMoveTargetProvider(){

            @Override
            public void add() throws Exception {
                newParent.addChild(component, nextComponent);
            }

            @Override
            public void move() throws Exception {
                newParent.moveChild(component, nextComponent);
            }

            @Override
            public StatementTarget getTarget() throws Exception {
                return target;
            }
        };
        JavaInfoUtils.moveProvider(component, associationObject, newParent, targetProvider);
    }

    public static void moveProvider(JavaInfo component, AssociationObject associationObject, JavaInfo newParent, IMoveTargetProvider targetProvider) throws Exception {
        Association oldAssociation = component.getAssociation();
        associationObject = JavaInfoUtils.getNotNullAssociationObject(associationObject);
        Association newAssociation = associationObject.getAssociation();
        boolean newAssociationRequired = associationObject.isRequired();
        ObjectInfo oldParent = component.getParent();
        boolean isReparenting = oldParent != newParent;
        newParent.getBroadcastJava().moveBefore0(component, oldParent, newParent);
        newParent.getBroadcastJava().moveBefore(component, oldParent, newParent);
        if (isReparenting || newAssociationRequired) {
            JavaInfoUtils.materializeVariable(component);
            oldAssociation.remove();
        } else if (oldAssociation instanceof InvocationChildArrayAssociation || oldAssociation instanceof InvocationChildEllipsisAssociation) {
            VariableSupport variableSupport = component.getVariableSupport();
            if (variableSupport instanceof EmptyVariableSupport) {
                ((EmptyVariableSupport)variableSupport).materialize();
            }
            oldAssociation.remove();
            newAssociationRequired = true;
        }
        StatementTarget componentTarget = targetProvider.getTarget();
        component.getVariableSupport().ensureInstanceReadyAt(componentTarget);
        if (isReparenting) {
            oldParent.removeChild((ObjectInfo)component);
            targetProvider.add();
        } else {
            targetProvider.move();
        }
        StatementTarget associationTarget = component.getVariableSupport().getAssociationTarget(componentTarget);
        if (isReparenting || newAssociationRequired) {
            if (component.getAssociation() == null) {
                newAssociation.add(component, associationTarget, null);
            } else {
                if (newAssociation != null) {
                    CompoundAssociation compoundAssociation = new CompoundAssociation(component.getAssociation());
                    compoundAssociation.add(newAssociation);
                    component.setAssociation(compoundAssociation);
                }
                component.getAssociation().setParent(newParent);
            }
        } else if (component.getVariableSupport() instanceof LazyVariableSupport) {
            component.getAssociation().move(associationTarget);
        }
        newParent.getBroadcastJava().moveAfter(component, oldParent, newParent);
    }

    public static StatementTarget getTarget(JavaInfo parent, JavaInfo child, JavaInfo nextChild) throws Exception {
        return new ChildTargetCalculator(parent, child, nextChild).getTarget();
    }

    public static StatementTarget getTarget(JavaInfo parent, JavaInfo nextChild) throws Exception {
        return JavaInfoUtils.getTarget(parent, null, nextChild);
    }

    public static StatementTarget getTarget(JavaInfo parent) throws Exception {
        return JavaInfoUtils.getTarget(parent, null, null);
    }

    public static void materializeVariable(JavaInfo javaInfo) throws Exception {
        if (javaInfo.getVariableSupport() instanceof EmptyVariableSupport) {
            EmptyVariableSupport variableSupport = (EmptyVariableSupport)javaInfo.getVariableSupport();
            variableSupport.materialize();
        }
    }

    public static void sortComponentsByFlow(final List<JavaInfo> components) {
        if (components.isEmpty()) {
            return;
        }
        JavaInfo someComponent = components.get(0);
        ExecutionFlowDescription flowDescription = JavaInfoUtils.getState(someComponent).getFlowDescription();
        final ArrayList sortedComponents = Lists.newArrayList();
        ExecutionFlowUtils.visit(new ExecutionFlowUtils.VisitingContext(true), flowDescription, new ExecutionFlowUtils.ExecutionFlowFrameVisitor(){

            public void postVisit(ASTNode node) {
                for (JavaInfo component : components) {
                    if (component.getCreationSupport().getNode() != node) continue;
                    sortedComponents.add(component);
                    break;
                }
            }
        });
        Collections.sort(components, new Comparator<JavaInfo>(){

            @Override
            public int compare(JavaInfo o1, JavaInfo o2) {
                int index_1 = sortedComponents.indexOf((Object)o1);
                int index_2 = sortedComponents.indexOf((Object)o2);
                return index_1 - index_2;
            }
        });
    }

    public static void sortNodesByFlow(ExecutionFlowDescription flowDescription, final boolean onEnter, final List<? extends ASTNode> nodes) {
        final ArrayList sortedNodes = Lists.newArrayList();
        ExecutionFlowUtils.visit(new ExecutionFlowUtils.VisitingContext(true), flowDescription, new ExecutionFlowUtils.ExecutionFlowFrameVisitor(){

            @Override
            public boolean enterFrame(ASTNode node) {
                if (onEnter) {
                    this.addSortedNode(node);
                }
                return super.enterFrame(node);
            }

            @Override
            public void leaveFrame(ASTNode node) {
                if (!onEnter) {
                    this.addSortedNode(node);
                }
            }

            public void preVisit(ASTNode node) {
                if (onEnter) {
                    this.addSortedNode(node);
                }
            }

            public void postVisit(ASTNode node) {
                if (!onEnter) {
                    this.addSortedNode(node);
                }
            }

            private void addSortedNode(ASTNode node) {
                if (nodes.contains(node)) {
                    sortedNodes.add(node);
                }
            }
        });
        Iterator<? extends ASTNode> I = nodes.iterator();
        while (I.hasNext()) {
            ASTNode node = I.next();
            if (sortedNodes.contains(node)) continue;
            I.remove();
        }
        Collections.sort(nodes, new Comparator<ASTNode>(){

            @Override
            public int compare(ASTNode o1, ASTNode o2) {
                int index_1 = sortedNodes.indexOf(o1);
                int index_2 = sortedNodes.indexOf(o2);
                return index_1 - index_2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isCreatedAtTarget(JavaInfo javaInfo, NodeTarget target) {
        StatementTarget statementTarget;
        ASTNode node = javaInfo.getCreationSupport().getNode();
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodDeclaration) {
            void methodDeclaration;
            MethodDeclaration methodDeclaration2 = (MethodDeclaration)aSTNode;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
            if (methodDeclaration.isConstructor()) {
                return true;
            }
        }
        if ((statementTarget = target.getStatementTarget()) != null) {
            return JavaInfoUtils.isCreatedAt(javaInfo, statementTarget);
        }
        BodyDeclarationTarget bodyDeclarationTarget = target.getBodyDeclarationTarget();
        return JavaInfoUtils.isCreatedAt(javaInfo, bodyDeclarationTarget);
    }

    private static boolean isCreatedAt(JavaInfo javaInfo, StatementTarget target) {
        ExecutionFlowDescription flowDescription = JavaInfoUtils.getState(javaInfo).getFlowDescription();
        ASTNode javaInfoNode = javaInfo.getCreationSupport().getNode();
        Statement statement = target.getStatement();
        if (statement != null) {
            ArrayList nodes = Lists.newArrayList((Object[])new ASTNode[]{statement, javaInfoNode});
            JavaInfoUtils.sortNodesByFlow(flowDescription, target.isBefore(), nodes);
            return nodes.get(0) == javaInfoNode;
        }
        Block block = target.getBlock();
        ArrayList nodes = Lists.newArrayList((Object[])new ASTNode[]{block, javaInfoNode});
        JavaInfoUtils.sortNodesByFlow(flowDescription, target.isBefore(), nodes);
        return nodes.get(0) == javaInfoNode;
    }

    private static boolean isCreatedAt(JavaInfo javaInfo, BodyDeclarationTarget target) {
        ExecutionFlowDescription flowDescription = JavaInfoUtils.getState(javaInfo).getFlowDescription();
        ASTNode javaInfoNode = javaInfo.getCreationSupport().getNode();
        BodyDeclaration bodyDeclaration = target.getDeclaration();
        if (bodyDeclaration != null) {
            ArrayList nodes = Lists.newArrayList((Object[])new ASTNode[]{bodyDeclaration, javaInfoNode});
            JavaInfoUtils.sortNodesByFlow(flowDescription, target.isBefore(), nodes);
            return nodes.get(0) == javaInfoNode;
        }
        TypeDeclaration typeDeclaration = target.getType();
        ArrayList nodes = Lists.newArrayList((Object[])new ASTNode[]{typeDeclaration, javaInfoNode});
        JavaInfoUtils.sortNodesByFlow(flowDescription, target.isBefore(), nodes);
        return nodes.get(0) == javaInfoNode;
    }

    public static StatementTarget getStatementTarget_whenAllCreated(List<? extends JavaInfo> components) throws Exception {
        Assert.isTrue((!components.isEmpty() ? 1 : 0) != 0, (String)"Can not provide target for empty components list.");
        ArrayList componentsCopy = Lists.newArrayList(components);
        JavaInfoUtils.sortComponentsByFlow(componentsCopy);
        JavaInfo lastComponent = (JavaInfo)((Object)componentsCopy.get(componentsCopy.size() - 1));
        NodeTarget nodeTarget_afterLastComponent = JavaInfoUtils.getNodeTarget_afterCreation(lastComponent);
        StatementTarget statementTarget = nodeTarget_afterLastComponent.getStatementTarget();
        if (statementTarget != null) {
            return statementTarget;
        }
        JavaInfo rootJava = components.get(0).getRootJava();
        if (rootJava.getCreationSupport() instanceof ThisCreationSupport) {
            return rootJava.getVariableSupport().getStatementTarget();
        }
        ExecutionFlowDescription flowDescription = JavaInfoUtils.getState(rootJava).getFlowDescription();
        MethodDeclaration startMethod = flowDescription.getStartMethods().get(0);
        return new StatementTarget(startMethod, true);
    }

    public static NodeTarget getNodeTarget_beforeCreation(JavaInfo javaInfo) throws Exception {
        return JavaInfoUtils.getNodeTarget_relativeCreation(javaInfo, true);
    }

    public static NodeTarget getNodeTarget_afterCreation(JavaInfo javaInfo) throws Exception {
        return JavaInfoUtils.getNodeTarget_relativeCreation(javaInfo, false);
    }

    private static NodeTarget getNodeTarget_relativeCreation(JavaInfo javaInfo, boolean before) throws Exception {
        StatementTarget statementTarget;
        CreationSupport creationSupport = javaInfo.getCreationSupport();
        if (creationSupport instanceof WrapperMethodControlCreationSupport && (statementTarget = javaInfo.getVariableSupport().getStatementTarget()) != null) {
            return new NodeTarget(statementTarget);
        }
        ASTNode node = creationSupport.getNode();
        Statement statement = AstNodeUtils.getEnclosingStatement(node);
        if (statement != null) {
            return new NodeTarget(new StatementTarget(statement, before));
        }
        BodyDeclaration bodyDeclaration = AstNodeUtils.getEnclosingNode(node, BodyDeclaration.class);
        Assert.isNotNull((Object)bodyDeclaration, (String)"No Statement and no BodyDeclaration for %s %s in %s", (Object[])new Object[]{javaInfo, node, node.getRoot()});
        return new NodeTarget(new BodyDeclarationTarget(bodyDeclaration, before));
    }

    public static void scheduleSpecialRendering(JavaInfo javaInfo) {
        if (javaInfo instanceof IJavaInfoRendering) {
            JavaInfoUtils.scheduleSpecialRendering(javaInfo, (IJavaInfoRendering)((Object)javaInfo));
        }
    }

    public static void scheduleSpecialRendering(JavaInfo javaInfo, IJavaInfoRendering rendering) {
        if (!(javaInfo.getCreationSupport() instanceof ThisCreationSupport)) {
            return;
        }
        final EditorState editorState = JavaInfoUtils.getState(javaInfo);
        final MethodDeclaration constructor = (MethodDeclaration)javaInfo.getCreationSupport().getNode();
        Block statement = constructor.getBody();
        javaInfo.addBroadcastListener(new EvaluationEventListener((Statement)statement, rendering){
            private final /* synthetic */ Statement val$statement;
            private final /* synthetic */ IJavaInfoRendering val$rendering;
            {
                this.val$statement = statement;
                this.val$rendering = iJavaInfoRendering;
            }

            @Override
            public void leaveFrame(ASTNode node) throws Exception {
                if (node == constructor) {
                    ExecutionFlowDescription flowDescription = editorState.getFlowDescription();
                    flowDescription.enterStatement(this.val$statement);
                    try {
                        this.val$rendering.render();
                    }
                    finally {
                        flowDescription.leaveStatement(this.val$statement);
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static JavaInfo getWrapped(JavaInfo original) throws Exception {
        JavaInfo javaInfo = original;
        if (javaInfo instanceof IWrapperInfo) {
            void wrapperInfo;
            IWrapperInfo iWrapperInfo = (IWrapperInfo)((Object)javaInfo);
            IWrapperInfo cfr_ignored_0 = (IWrapperInfo)((Object)javaInfo);
            return wrapperInfo.getWrapper().getWrappedInfo();
        }
        return original;
    }

    public static void deleteJavaInfo(JavaInfo javaInfo, boolean removeFromParent) throws Exception {
        ImmutableList children = ImmutableList.copyOf((Collection)javaInfo.getChildren());
        for (ObjectInfo child : children) {
            if (child.isDeleted()) continue;
            child.delete();
        }
        for (ASTNode node : javaInfo.getRelatedNodes()) {
            Statement statement;
            if (AstNodeUtils.isDanglingNode(node) || !removeFromParent && node == javaInfo.getCreationSupport().getNode() || (statement = AstNodeUtils.getEnclosingStatement(node)) == null) continue;
            javaInfo.getEditor().removeStatement(statement);
        }
        if (removeFromParent) {
            javaInfo.getParent().removeChild((ObjectInfo)javaInfo);
        }
    }

    public static boolean hasDependencyInformation(JavaInfo javaInfo) throws Exception {
        return javaInfo.getEditor().getGlobalValue(DEPENDENCY_KEY) != null;
    }

    public static boolean isDependencyChanged(JavaInfo javaInfo) throws Exception {
        Map dependencies = (Map)javaInfo.getEditor().getGlobalValue(DEPENDENCY_KEY);
        if (dependencies != null) {
            for (Map.Entry entry : dependencies.entrySet()) {
                if (((IResource)entry.getKey()).getModificationStamp() == ((Long)entry.getValue()).longValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static void rememberDependency(JavaInfo javaInfo) throws Exception {
        AstEditor editor = javaInfo.getEditor();
        HashMap dependencies = Maps.newHashMap();
        JavaInfoUtils.addDependencies(dependencies, Sets.newTreeSet(), editor.getModelUnit(), 0);
        dependencies.remove(editor.getModelUnit().getResource());
        editor.putGlobalValue(DEPENDENCY_KEY, dependencies);
    }

    private static void addDependencies(final Map<IResource, Long> dependencies, final Set<String> checkedTypes, ICompilationUnit modelUnit, final int level) throws Exception {
        if (level < 5 && dependencies.size() < 100) {
            final IJavaProject javaProject = modelUnit.getJavaProject();
            IResource resource = modelUnit.getResource();
            dependencies.put(resource, resource.getModificationStamp());
            CompilationUnit astUnit = CodeUtils.parseCompilationUnit(modelUnit);
            astUnit.accept(new ASTVisitor(){

                public void endVisit(QualifiedName node) {
                    this.addNewType(node.resolveTypeBinding());
                }

                public void endVisit(SimpleName node) {
                    this.addNewType(node.resolveTypeBinding());
                }

                private void addNewType(final ITypeBinding binding) {
                    if (binding == null) {
                        return;
                    }
                    ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

                        public void run() throws Exception {
                            String typeName = AstNodeUtils.getFullyQualifiedName(binding, false);
                            if (typeName.indexOf(46) != -1 && !checkedTypes.contains(typeName)) {
                                checkedTypes.add(typeName);
                                IType type = javaProject.findType(typeName);
                                if (type != null && !type.isBinary()) {
                                    JavaInfoUtils.addDependencies(dependencies, checkedTypes, type.getCompilationUnit(), level + 1);
                                }
                            }
                        }
                    });
                }
            });
        }
    }

    public static EditorState getState(JavaInfo javaInfo) {
        return EditorState.get(javaInfo.getEditor());
    }

    public static ClassLoader getClassLoader(JavaInfo javaInfo) {
        return JavaInfoUtils.getState(javaInfo).getEditorLoader();
    }

    public static class HierarchyProvider {
        public Object[] getAliases(Object object) throws Exception {
            return null;
        }

        public Object getParentObject(Object object) throws Exception {
            return null;
        }

        public Object[] getChildrenObjects(Object object) throws Exception {
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }

        public void add(JavaInfo host, JavaInfo exposed) throws Exception {
        }
    }

    public static interface IMoveTargetProvider {
        public void add() throws Exception;

        public void move() throws Exception;

        public StatementTarget getTarget() throws Exception;
    }
}

