/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.planning.helpers;

import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Accuracy;

public class StatisticsHelper {
    private StatisticsHelper() {
    }

    public static Optional<Double> estimateAverageBucketSize(TupleMask groupMask, Accuracy requiredAccuracy, BiFunction<TupleMask, Accuracy, Optional<Long>> estimateCardinality) {
        if (groupMask.isIdentity()) {
            return Optional.of(1.0);
        }
        Accuracy numeratorAccuracy = requiredAccuracy;
        Accuracy denominatorAccuracy = requiredAccuracy.reciprocal();
        TupleMask identityMask = TupleMask.identity(groupMask.sourceWidth);
        Optional<Long> totalCountEstimate = estimateCardinality.apply(identityMask, numeratorAccuracy);
        Optional<Long> bucketCountEstimate = estimateCardinality.apply(groupMask, denominatorAccuracy);
        return totalCountEstimate.flatMap(matchCount -> bucketCountEstimate.map(bucketCount -> bucketCount == 0L ? 0.0 : (double)matchCount.longValue() / (double)bucketCount.longValue()));
    }

    public static Optional<Double> min(Optional<Double> a, Optional<Double> b) {
        if (b.isPresent()) {
            if (a.isPresent()) {
                return Optional.of(Math.min(a.get(), b.get()));
            }
            return b;
        }
        return a;
    }

    public static Optional<Double> min(Optional<Double> a, double b) {
        if (a.isPresent()) {
            return Optional.of(Math.min(a.get(), b));
        }
        return Optional.of(b);
    }
}

