/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.text.quicksearch.internal.core.LineItem;
import org.eclipse.text.quicksearch.internal.core.QuickTextQuery;
import org.eclipse.text.quicksearch.internal.core.QuickTextSearchRequestor;
import org.eclipse.text.quicksearch.internal.core.ResourceWalker;
import org.eclipse.text.quicksearch.internal.core.pathmatch.ResourceMatcher;
import org.eclipse.text.quicksearch.internal.core.pathmatch.ResourceMatchers;
import org.eclipse.text.quicksearch.internal.core.priority.PriorityFunction;
import org.eclipse.text.quicksearch.internal.ui.Messages;
import org.eclipse.text.quicksearch.internal.util.LightSchedulingRule;

public class QuickTextSearcher {
    private final QuickTextSearchRequestor requestor;
    private QuickTextQuery query;
    private Set<LineItem> matches = new HashSet<LineItem>(2000);
    private ISchedulingRule matchesRule = new LightSchedulingRule("QuickSearchMatchesRule");
    private SearchInFilesWalker walker = null;
    private IncrementalUpdateJob incrementalUpdate;
    private QuickTextQuery newQuery;
    public static final int DEFAULT_MAX_RESULTS = 200;
    private int maxResults = 200;
    private int MAX_LINE_LEN;
    private IFile currentFile = null;
    private boolean forceRefresh = false;
    private ResourceMatcher pathMatcher = ResourceMatchers.ANY;

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public QuickTextSearcher(QuickTextQuery query, final PriorityFunction priorities, int maxLineLen, QuickTextSearchRequestor requestor) {
        this.MAX_LINE_LEN = maxLineLen;
        this.requestor = requestor;
        this.query = query;
        this.walker = this.createWalker(new PriorityFunction(){

            @Override
            public double priority(IResource r) {
                double basePriority = priorities.priority(r);
                if (basePriority == Double.NEGATIVE_INFINITY) {
                    return basePriority;
                }
                if (r.getType() == 1 && !QuickTextSearcher.this.pathMatcher.matches(r)) {
                    return Double.NEGATIVE_INFINITY;
                }
                return basePriority;
            }
        });
    }

    private SearchInFilesWalker createWalker(PriorityFunction priorities) {
        SearchInFilesWalker job = new SearchInFilesWalker();
        job.setPriorityFun(priorities);
        job.setRule(this.matchesRule);
        job.schedule();
        return job;
    }

    private void add(LineItem line) {
        if (this.matches.add(line)) {
            this.requestor.add(line);
            if (!this.isActive()) {
                this.walker.suspend();
            }
        }
    }

    public void setQuery(QuickTextQuery newQuery, boolean force) {
        if (newQuery.equalsFilter(this.query) && !force) {
            return;
        }
        this.newQuery = newQuery;
        this.forceRefresh = true;
        this.scheduleIncrementalUpdate();
    }

    public void setPathMatcher(ResourceMatcher pathMatcher) {
        if (this.pathMatcher.equals(pathMatcher)) {
            return;
        }
        this.pathMatcher = pathMatcher;
        this.setQuery(this.query, true);
    }

    public QuickTextQuery getQuery() {
        return this.newQuery != null ? this.newQuery : this.query;
    }

    private synchronized void scheduleIncrementalUpdate() {
        this.walker.suspend();
        if (this.incrementalUpdate != null) {
            this.incrementalUpdate.cancel();
        }
        this.incrementalUpdate = new IncrementalUpdateJob();
        this.incrementalUpdate.schedule();
    }

    public boolean isActive() {
        return !this.isDone() && this.matches.size() < this.maxResults;
    }

    public boolean isDone() {
        return this.walker != null && this.walker.isDone();
    }

    public void requestMoreResults() {
        if (this.walker != null && !this.walker.isDone()) {
            this.walker.requestMoreResults();
        }
    }

    public void cancel() {
        if (this.walker != null) {
            this.walker.cancel();
            this.walker = null;
        }
    }

    public IFile getCurrentFile() {
        return this.currentFile;
    }

    private class IncrementalUpdateJob
    extends Job {
        public IncrementalUpdateJob() {
            super(Messages.QuickTextSearch_updateMatchesJob);
            this.setRule(QuickTextSearcher.this.matchesRule);
        }

        protected IStatus run(IProgressMonitor monitor) {
            QuickTextQuery nq = QuickTextSearcher.this.newQuery;
            if (!QuickTextSearcher.this.forceRefresh && QuickTextSearcher.this.query.isSubFilter(nq)) {
                QuickTextSearcher.this.query = nq;
                this.performIncrementalUpdate(monitor);
            } else {
                QuickTextSearcher.this.query = nq;
                QuickTextSearcher.this.forceRefresh = false;
                this.performRestart(monitor);
            }
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }

        private void performIncrementalUpdate(IProgressMonitor mon) {
            Iterator<LineItem> items = QuickTextSearcher.this.matches.iterator();
            while (items.hasNext() && !mon.isCanceled()) {
                LineItem item = items.next();
                if (QuickTextSearcher.this.query.matchItem(item)) {
                    QuickTextSearcher.this.requestor.update(item);
                    continue;
                }
                items.remove();
                QuickTextSearcher.this.requestor.revoke(item);
            }
            if (!mon.isCanceled()) {
                QuickTextSearcher.this.walker.resume();
            }
        }

        private void performRestart(IProgressMonitor mon) {
            if (QuickTextSearcher.this.walker != null) {
                QuickTextSearcher.this.matches.clear();
                QuickTextSearcher.this.requestor.clear();
                QuickTextSearcher.this.walker.cancel();
                if (!QuickTextSearcher.this.query.isTrivial()) {
                    QuickTextSearcher.this.walker.init();
                    QuickTextSearcher.this.walker.resume();
                } else {
                    QuickTextSearcher.this.walker.stop();
                }
            }
        }
    }

    private final class SearchInFilesWalker
    extends ResourceWalker {
        private SearchInFilesWalker() {
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void visit(IFile f, IProgressMonitor mon) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 12[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void resume() {
            if (QuickTextSearcher.this.isActive()) {
                super.resume();
            }
        }

        private boolean checkCanceled(IProgressMonitor mon) {
            return mon.isCanceled();
        }

        public void requestMoreResults() {
            int currentSize = QuickTextSearcher.this.matches.size();
            QuickTextSearcher.this.maxResults = Math.max(QuickTextSearcher.this.maxResults, currentSize + currentSize / 10);
            this.resume();
        }
    }
}

