/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.model.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.AirResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.commands.ChildrenAdjustmentCommand;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.internal.operation.RegionContainerUpdateLayoutOperation;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class RegionContainerResizableEditPolicy
extends AirResizableEditPolicy {
    protected static final String REGION_AUTO_SIZE_PROPAGATOR = "sirius.region.auto.size.propagator";
    protected static final String REGION_RESIZE_PROPAGATOR = "sirius.region.resize.propagator";
    protected static final String REGION_RESIZE_INITIAL_REQUEST = "sirius.region.resize.initial.request";

    @Override
    protected Command getAutoSizeCommand(Request request) {
        Command autoSizeCommand = super.getAutoSizeCommand(request);
        if (this.concernRegionContainer()) {
            autoSizeCommand = this.getRegionContainerAutoSizeCommand(request, autoSizeCommand);
        }
        return autoSizeCommand;
    }

    protected Command getRegionContainerAutoSizeCommand(Request request, Command autoSizeCommand) {
        IDiagramElementEditPart host = (IDiagramElementEditPart)this.getHost();
        TransactionalEditingDomain domain = host.getEditingDomain();
        CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(domain, Messages.RegionContainerResizableEditPolicy_regionContainerAutoSizeCommandLabel);
        ctc.add((IUndoableOperation)new CommandProxy(autoSizeCommand));
        ICommandProxy regionContainerAutoSizeCommand = new ICommandProxy((ICommand)ctc);
        Request req = new Request();
        req.setType(request.getType());
        req.getExtendedData().put(REGION_AUTO_SIZE_PROPAGATOR, host);
        for (EditPart editPart : this.getRegionParts()) {
            if (host == editPart) continue;
            ctc.add((IUndoableOperation)new CommandProxy(editPart.getCommand(req)));
        }
        ctc.add((IUndoableOperation)CommandFactory.createICommand(domain, new RegionContainerUpdateLayoutOperation((Node)host.getModel())));
        return regionContainerAutoSizeCommand;
    }

    @Override
    protected void completeResizeCommand(CompositeTransactionalCommand ctc, ChangeBoundsRequest request) {
        if (request.getEditParts().size() > 1 && !request.isConstrainedResize()) {
            ctc.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
            return;
        }
        Collection<ChangeBoundsRequest> siblingRequests = this.getConstrainedRegionRequests(request);
        if (!siblingRequests.isEmpty()) {
            for (ChangeBoundsRequest siblingRequest : siblingRequests) {
                if (siblingRequest.getEditParts() == null) continue;
                for (IGraphicalEditPart constrainedPart : Iterables.filter((Iterable)siblingRequest.getEditParts(), IGraphicalEditPart.class)) {
                    Command constrainedCommand = constrainedPart.getCommand((Request)siblingRequest);
                    if (constrainedCommand == null) {
                        ctc.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
                        continue;
                    }
                    ctc.add((IUndoableOperation)new CommandProxy(constrainedCommand));
                }
            }
        } else if (!request.isConstrainedMove() && !request.isConstrainedResize()) {
            ctc.add((IUndoableOperation)UnexecutableCommand.INSTANCE);
        }
        ctc.add((IUndoableOperation)new ChildrenAdjustmentCommand((IGraphicalEditPart)this.getHost(), request, true, false));
    }

    private Collection<ChangeBoundsRequest> getConstrainedRegionRequests(ChangeBoundsRequest request) {
        Option<AbstractDiagramElementContainerEditPart> lastRegionPart;
        ArrayList<ChangeBoundsRequest> constrainedRequests = new ArrayList<ChangeBoundsRequest>();
        RequestQuery query = new RequestQuery((Request)request);
        Dimension sizeDelta = request.getSizeDelta().getCopy();
        Point moveDelta = request.getMoveDelta().getCopy();
        List<AbstractDiagramElementContainerEditPart> regionToResize = this.getRegionParts();
        int stackDirection = this.getStackDirection();
        Object resizePropagator = request.getExtendedData().get(REGION_RESIZE_PROPAGATOR);
        if (query.isResizeFromTop() && stackDirection == 5 || query.isResizeFromLeft() && stackDirection == 24) {
            ChangeBoundsRequest req;
            Option<AbstractDiagramElementContainerEditPart> firstRegionPart = this.getFirstRegionPart();
            if (firstRegionPart.some() && (!request.isConstrainedResize() || resizePropagator != firstRegionPart.get())) {
                req = this.initConstrainedRequest(request);
                req.setEditParts((EditPart)firstRegionPart.get());
                req.setSizeDelta(sizeDelta.getCopy());
                constrainedRequests.add(req);
            }
            regionToResize.remove(firstRegionPart.get());
            if (!(regionToResize.isEmpty() || request.isConstrainedResize() && regionToResize.contains(resizePropagator))) {
                req = this.initConstrainedRequest(request);
                req.setEditParts(new ArrayList<AbstractDiagramElementContainerEditPart>(regionToResize));
                if (stackDirection == 5) {
                    req.setSizeDelta(new Dimension(sizeDelta.width, 0));
                    req.setMoveDelta(new Point(0, -moveDelta.y));
                } else if (stackDirection == 24) {
                    req.setSizeDelta(new Dimension(0, sizeDelta.height));
                    req.setMoveDelta(new Point(-moveDelta.x, 0));
                }
                constrainedRequests.add(req);
                regionToResize.clear();
            }
        } else if ((query.isResizeFromBottom() && stackDirection == 5 || query.isResizeFromRight() && stackDirection == 24) && (lastRegionPart = this.getLastRegionPart()).some() && (!request.isConstrainedResize() || resizePropagator != lastRegionPart.get())) {
            ChangeBoundsRequest req = this.initConstrainedRequest(request);
            req.setEditParts((EditPart)lastRegionPart.get());
            req.setSizeDelta(sizeDelta.getCopy());
            constrainedRequests.add(req);
            regionToResize.remove(lastRegionPart.get());
        }
        if (request.isConstrainedResize() && resizePropagator != null) {
            regionToResize.remove(resizePropagator);
        }
        if (!regionToResize.isEmpty()) {
            if (stackDirection == 5 && (query.isResizeFromLeft() || query.isResizeFromRight()) && sizeDelta.width != 0) {
                req = this.initConstrainedRequest(request);
                req.setEditParts(new ArrayList<AbstractDiagramElementContainerEditPart>(regionToResize));
                req.setSizeDelta(new Dimension(sizeDelta.width, 0));
                constrainedRequests.add(req);
            } else if (stackDirection == 24 && (query.isResizeFromTop() || query.isResizeFromBottom()) && sizeDelta.height != 0) {
                req = this.initConstrainedRequest(request);
                req.setEditParts(new ArrayList<AbstractDiagramElementContainerEditPart>(regionToResize));
                req.setSizeDelta(new Dimension(0, sizeDelta.height));
                constrainedRequests.add(req);
            }
        }
        return constrainedRequests;
    }

    private ChangeBoundsRequest initConstrainedRequest(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest();
        req.setConstrainedResize(true);
        req.setConstrainedMove(true);
        req.setType(request.getType());
        req.setResizeDirection(request.getResizeDirection());
        req.getExtendedData().put(REGION_RESIZE_PROPAGATOR, this.getHost());
        req.getExtendedData().put("keepSameAbsoluteLocation", request.getExtendedData().get("keepSameAbsoluteLocation"));
        req.getExtendedData().put(REGION_RESIZE_INITIAL_REQUEST, request);
        return req;
    }

    private boolean concernRegionContainer() {
        boolean regionImpacted = false;
        EditPart hostPart = this.getHost();
        if (hostPart instanceof AbstractDiagramElementContainerEditPart) {
            IDiagramElementEditPart ideep = (IDiagramElementEditPart)hostPart;
            DDiagramElement dde = ideep.resolveDiagramElement();
            regionImpacted = dde instanceof DNodeContainer && new DNodeContainerExperimentalQuery((DNodeContainer)dde).isRegionContainer();
        }
        return regionImpacted;
    }

    private int getStackDirection() {
        IDiagramElementEditPart ideep;
        DDiagramElement dde;
        int direction = 0;
        EditPart hostPart = this.getHost();
        if (hostPart instanceof AbstractDiagramElementContainerEditPart && (dde = (ideep = (IDiagramElementEditPart)hostPart).resolveDiagramElement()) instanceof DNodeContainer) {
            DNodeContainerExperimentalQuery query = new DNodeContainerExperimentalQuery((DNodeContainer)dde);
            if (query.isVerticalStackContainer()) {
                direction = 5;
            } else if (query.isHorizontaltackContainer()) {
                direction = 24;
            }
        }
        return direction;
    }

    private List<AbstractDiagramElementContainerEditPart> getRegionParts() {
        AbstractDNodeContainerCompartmentEditPart comp = (AbstractDNodeContainerCompartmentEditPart)Iterables.getFirst((Iterable)Iterables.filter((Iterable)this.getHost().getChildren(), AbstractDNodeContainerCompartmentEditPart.class), null);
        if (comp != null) {
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)comp.getChildren(), AbstractDiagramElementContainerEditPart.class));
        }
        return Collections.emptyList();
    }

    private Option<AbstractDiagramElementContainerEditPart> getFirstRegionPart() {
        List<AbstractDiagramElementContainerEditPart> regionParts = this.getRegionParts();
        return Options.newSome((Object)((AbstractDiagramElementContainerEditPart)Iterables.getFirst(regionParts, null)));
    }

    private Option<AbstractDiagramElementContainerEditPart> getLastRegionPart() {
        List<AbstractDiagramElementContainerEditPart> regionParts = this.getRegionParts();
        return Options.newSome((Object)((AbstractDiagramElementContainerEditPart)Iterables.getLast(regionParts, null)));
    }
}

