/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.shell;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.handler.ShellHandler;
import org.eclipse.reddeer.core.util.DiagnosticTool;
import org.eclipse.reddeer.swt.condition.ShellIsActive;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.widgets.AbstractControl;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractShell
extends AbstractControl<Shell>
implements org.eclipse.reddeer.swt.api.Shell {
    private static final Logger log = Logger.getLogger(AbstractShell.class);

    protected AbstractShell(Shell swtShell) {
        super(swtShell, () -> {
            String string = new DiagnosticTool().getShellsDiagnosticInformation();
        });
    }

    public Control getControl() {
        return (Control)this.swtWidget;
    }

    @Override
    public String getText() {
        String text = ShellHandler.getInstance().getText((Shell)this.swtWidget);
        return text;
    }

    @Override
    public void setFocus() {
        log.debug("Set focus to Shell " + this.getText());
        ShellHandler.getInstance().setFocus((Shell)this.swtWidget);
        new WaitUntil((WaitCondition)new ShellIsActive(this));
    }

    @Override
    public void close() {
        String text = this.getText();
        log.info("Close shell " + text);
        ShellHandler.getInstance().closeShell((Shell)this.swtWidget);
        new WaitWhile((WaitCondition)new ShellIsAvailable(this));
    }

    @Override
    public boolean isMaximized() {
        return ShellHandler.getInstance().isMaximized((Shell)this.swtWidget);
    }

    @Override
    public boolean isMinimized() {
        return ShellHandler.getInstance().isMinimized((Shell)this.swtWidget);
    }

    @Override
    public void maximize() {
        ShellHandler.getInstance().maximize((Shell)this.swtWidget);
    }

    @Override
    public void minimize() {
        ShellHandler.getInstance().minimize((Shell)this.swtWidget);
    }

    @Override
    public void restore() {
        ShellHandler.getInstance().restore((Shell)this.swtWidget);
    }
}

