/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.console;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.handler.LabelHandler;
import org.eclipse.reddeer.core.handler.StyledTextHandler;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasLabel;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasLaunch;
import org.eclipse.reddeer.eclipse.condition.ConsoleIsTerminated;
import org.eclipse.reddeer.swt.impl.menu.ToolItemMenuItem;
import org.eclipse.reddeer.swt.impl.styledtext.DefaultStyledText;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;

public class ConsoleView
extends WorkbenchView {
    private static final String TERMINATE = "Terminate";
    private static final String CLEAR_CONSOLE = "Clear Console";

    public ConsoleView() {
        super("Console");
    }

    public String getConsoleText() {
        this.activate();
        WidgetIsFound widgetIsFound = new WidgetIsFound(StyledText.class, this.cTabItem.getControl(), new Matcher[0]);
        new WaitUntil((WaitCondition)widgetIsFound, TimePeriod.DEFAULT, false);
        if (widgetIsFound.getResult() == null) {
            return null;
        }
        new WaitWhile((WaitCondition)new ConsoleHasText(""), TimePeriod.SHORT, false);
        return new DefaultStyledText((ReferencedComposite)this.cTabItem).getText();
    }

    public void clearConsole() {
        log.info("Clearing console");
        this.activate();
        new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), CLEAR_CONSOLE).click();
        new WaitUntil((WaitCondition)new ConsoleHasText(""));
        log.info("Console cleared");
    }

    public boolean canClearConsole() {
        return this.toolItemExistsAndIsEnabled(CLEAR_CONSOLE);
    }

    public void removeLaunch() {
        log.info("Removing launch from console");
        this.activate();
        new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Remove Launch").click();
        log.info("Launch removed");
    }

    public void removeAllTerminatedLaunches() {
        log.info("Removing terminated launches from console");
        this.activate();
        new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Remove All Terminated Launches").click();
        new WaitWhile((WaitCondition)new ConsoleHasLaunch());
        log.info("Terminated launches cleared");
    }

    public void terminateConsole() {
        log.info("Terminating console");
        this.activate();
        DefaultToolItem terminate = new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), TERMINATE);
        if (terminate.isEnabled()) {
            terminate.click();
            new WaitUntil((WaitCondition)new ConsoleIsTerminated());
            log.info("Console terminated");
        } else {
            log.info("Console was terminated earlier");
        }
    }

    public boolean canTerminateConsole() {
        return this.toolItemExistsAndIsEnabled(TERMINATE);
    }

    private boolean toolItemExistsAndIsEnabled(String toolItemText) {
        this.activate();
        WidgetIsFound widgetIsFound = new WidgetIsFound(ToolItem.class, this.cTabItem.getFolder().getControl(), new Matcher[]{new WithTextMatcher(toolItemText)});
        widgetIsFound.test();
        Widget widget = widgetIsFound.getResult();
        if (widget == null) {
            return false;
        }
        return new DefaultToolItem((ToolItem)widget).isEnabled();
    }

    public void toggleShowConsoleOnStandardOutChange(boolean toggle) {
        this.activate();
        new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Show Console When Standard Out Changes").toggle(toggle);
    }

    public boolean consoleHasLaunch() {
        this.activate();
        return new WidgetIsFound(StyledText.class, this.cTabItem.getControl(), new Matcher[0]).test();
    }

    public boolean consoleIsTerminated() {
        String consoleLabel = this.getConsoleLabel();
        return consoleLabel != null && consoleLabel.contains("<terminated>");
    }

    public void switchConsole(String text) {
        this.switchConsole((Matcher<String>)new IsEqual((Object)text));
    }

    public void switchConsole(Matcher<String> textMatcher) {
        this.activate();
        ToolItemMenuItem menu = new ToolItemMenuItem((org.eclipse.reddeer.swt.api.ToolItem)new DefaultToolItem((ReferencedComposite)this.cTabItem.getFolder(), "Display Selected Console"), new Matcher[]{textMatcher});
        menu.select();
        new WaitUntil((WaitCondition)new ConsoleHasLabel(textMatcher));
    }

    public String getConsoleLabel() {
        this.activate();
        WidgetIsFound widgetIsFound = new WidgetIsFound(Label.class, this.cTabItem.getControl(), new Matcher[0]);
        widgetIsFound.test();
        Widget swtWidget = widgetIsFound.getResult();
        return swtWidget == null ? null : LabelHandler.getInstance().getText((Label)swtWidget);
    }

    protected Control getRegisteredControl() {
        this.activate();
        WidgetIsFound widgetIsFound = new WidgetIsFound(StyledText.class, this.cTabItem.getControl(), new Matcher[0]);
        new WaitUntil((WaitCondition)widgetIsFound, TimePeriod.SHORT, false);
        if (widgetIsFound.getResult() == null) {
            log.debug("There is no console in console view.");
            return null;
        }
        return (StyledText)widgetIsFound.getResult();
    }

    private class ConsoleHasText
    extends AbstractWaitCondition {
        private String consoleText;

        public ConsoleHasText(String consoleText) {
            this.consoleText = consoleText;
        }

        public boolean test() {
            WidgetIsFound widgetIsFound = new WidgetIsFound(StyledText.class, ConsoleView.this.cTabItem.getControl(), new Matcher[0]);
            widgetIsFound.test();
            Widget swtWidget = widgetIsFound.getResult();
            return swtWidget == null ? false : this.consoleText.equals(StyledTextHandler.getInstance().getText((StyledText)swtWidget));
        }

        public String description() {
            return "console text is \"" + this.consoleText + "\"";
        }
    }
}

