/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.adaptable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.reddeer.common.exception.AdaptableException;

public interface RedDeerAdaptable<K> {
    default public <V extends K> V getAdapter(Class<V> clazz) {
        Constructor<Object> constructor;
        Object[] constructorArguments;
        block10: {
            if (clazz == null) {
                throw new AdaptableException("Class provided to get adapted object cannot be null.");
            }
            constructorArguments = this.getAdapterConstructorArguments();
            constructor = null;
            try {
                if (constructorArguments == null | constructorArguments.length == 0) {
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    int n = constructorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Constructor<?> constr = constructorArray[n2];
                        if (constr.getParameterCount() == 0) {
                            constructor = constr;
                            break block10;
                        }
                        ++n2;
                    }
                    break block10;
                }
                constructor = clazz.getConstructor(this.getAdapterConstructorClasses());
            }
            catch (NoSuchMethodException | SecurityException exception) {
                throw new AdaptableException("There is no suitable constructor to get adapted object. Check whether getAdapterConstructorArguments methods is properly implemented and class has proper constructor(s)");
            }
        }
        if (constructor == null) {
            throw new AdaptableException("There is no suitable constructor to get adapted object. Check whether getAdapterConstructorArguments methods is properly implemented and class has proper constructor(s)");
        }
        V adapter = null;
        try {
            adapter = constructor.newInstance(constructorArguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new AdaptableException("Could not create a new adapted object. ", e.getCause());
        }
        catch (InstantiationException ex) {
            throw new AdaptableException("Could not instantiate a new adapted object. Be sure you are overriding @{link RedDeerAdaptable.getAdapterConstructorArguments} method correctly, if your adapted instance have different constructor. And make sure that instance can be created by those arguments (constructor check on arguments pass)" + ex.getCause());
        }
        return adapter;
    }

    public Object[] getAdapterConstructorArguments();

    public Class<?>[] getAdapterConstructorClasses();
}

