/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.ptp.internal.rm.lml.core.events.NodedisplayZoomEvent;
import org.eclipse.ptp.internal.rm.lml.core.model.LMLCheck;
import org.eclipse.ptp.internal.rm.lml.core.model.Node;
import org.eclipse.ptp.internal.rm.lml.core.model.RowColumnSorter;
import org.eclipse.ptp.internal.rm.lml.core.model.TreeExpansion;
import org.eclipse.ptp.rm.lml.core.elements.AlignType;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplayelement;
import org.eclipse.ptp.rm.lml.core.elements.ObjectType;
import org.eclipse.ptp.rm.lml.core.elements.PictureType;
import org.eclipse.ptp.rm.lml.core.elements.UsageType;
import org.eclipse.ptp.rm.lml.core.events.INodedisplayZoomEvent;
import org.eclipse.ptp.rm.lml.core.listeners.INodedisplayZoomListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.LMLColor;
import org.eclipse.ptp.rm.lml.core.model.LMLNodeData;
import org.eclipse.ptp.rm.lml.core.model.NodedisplayAccess;
import org.eclipse.ptp.rm.lml.core.model.OIDToObject;
import org.eclipse.ptp.rm.lml.core.model.ObjectStatus;
import org.eclipse.ptp.rm.lml.internal.ui.LMLUIPlugin;
import org.eclipse.ptp.rm.lml.ui.providers.BorderComposite;
import org.eclipse.ptp.rm.lml.ui.providers.ImageComp;
import org.eclipse.ptp.rm.lml.ui.providers.LguiWidget;
import org.eclipse.ptp.rm.lml.ui.providers.Usagebar;
import org.eclipse.ptp.rm.lml.ui.providers.support.BorderLayout;
import org.eclipse.ptp.rm.lml.ui.providers.support.ColorConversion;
import org.eclipse.ptp.rm.lml.ui.providers.support.CompositeListenerChooser;
import org.eclipse.ptp.rm.lml.ui.providers.support.JobDetector;
import org.eclipse.ptp.rm.lml.ui.providers.support.MouseInteraction;
import org.eclipse.ptp.rm.lml.ui.providers.support.RectanglePaintListener;
import org.eclipse.ptp.rm.lml.ui.providers.support.UsagebarPainter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class NodedisplayComp
extends LguiWidget
implements ObjectStatus.Updatable,
JobDetector {
    private int levelsPaintedByPaintListener = 2;
    private String title;
    private Color jobColor;
    private Font fontObject;
    private Node<LMLNodeData> node;
    private Composite pictureComp;
    private Composite mainComp;
    protected Composite innerComp = null;
    protected Usagebar usagebar;
    protected MouseInteraction mouseInteraction;
    private Label titleLabel;
    private Nodedisplayelement nodedisplayLayout;
    private Color backgroundColor;
    private Color titleBackgroundColor;
    private BorderComposite borderComp;
    private List<ImageComp> picturesList;
    private Image centerPicture;
    protected List<NodedisplayComp> innerCompsList;
    protected NodedisplayComp parentNodedisplayComp = null;
    protected int x = 0;
    protected int y = 0;
    protected RectanglePaintListener rectanglePaintListener = null;
    private final List<INodedisplayZoomListener> zoomListeners = new ArrayList<INodedisplayZoomListener>();

    public static GridData getDefaultGridData() {
        return new GridData(4, 4, true, true);
    }

    public static Rectangle getNextNodedisplayBounds(Composite innerComp) {
        Rectangle bounds = innerComp.getBounds();
        Composite currentComp = innerComp;
        while (currentComp.getParent() != null && !(currentComp.getParent() instanceof NodedisplayComp)) {
            currentComp = currentComp.getParent();
            Rectangle newBounds = currentComp.getBounds();
            bounds.x += newBounds.x;
            bounds.y += newBounds.y;
        }
        return bounds;
    }

    public NodedisplayComp(ILguiItem lguiItem, Node<LMLNodeData> node, Nodedisplayelement layout, Composite parent, int style) {
        super(lguiItem, parent, style);
        if (((LMLNodeData)node.getData()).isRootNode() && node.getChildren().size() == 0) {
            int maxLevel = 10;
            if (layout.getMaxlevel() != null) {
                maxLevel = layout.getMaxlevel().intValue();
            }
            TreeExpansion.expandLMLNode(node, (int)maxLevel);
            TreeExpansion.generateUsagebarsForAllLeaves(node);
        }
        this.init(node, layout);
    }

    public NodedisplayComp(ILguiItem lguiItem, Nodedisplay nodedisplay, Composite parent, int style) {
        this(lguiItem, (Node<LMLNodeData>)new Node((Object)new LMLNodeData("", nodedisplay)), (Nodedisplayelement)lguiItem.getLayoutAccess().getLayoutForNodedisplay(nodedisplay.getId()).getEl0(), parent, style);
    }

    protected NodedisplayComp(ILguiItem lguiItem, Node<LMLNodeData> node, Nodedisplayelement layout, int levelsPaintedByPaintListener, NodedisplayComp parentNodedisplay, int x, int y, Composite parent, int style) {
        super(lguiItem, parent, style);
        this.parentNodedisplayComp = parentNodedisplay;
        this.x = x;
        this.y = y;
        this.levelsPaintedByPaintListener = levelsPaintedByPaintListener;
        this.init(node, layout);
    }

    public void addZoomListener(INodedisplayZoomListener listener) {
        this.zoomListeners.add(listener);
    }

    @Override
    public void detectJobPositions(Set<Point> points, String jobId) {
        ObjectType object;
        for (NodedisplayComp childComp : this.innerCompsList) {
            childComp.detectJobPositions(points, jobId);
        }
        if (this.rectanglePaintListener != null) {
            this.rectanglePaintListener.detectJobPositions(points, jobId);
        }
        if (this.usagebar != null) {
            List<UsagebarPainter.JobInterval> jobintervals = this.usagebar.getJobIntervals();
            for (UsagebarPainter.JobInterval interval : jobintervals) {
                if (!interval.job.getId().equals(jobId)) continue;
                Rectangle subPaintArea = NodedisplayComp.getNextNodedisplayBounds(this.usagebar);
                Point jobPoint = this.getPositionInScrollComp(new Point(subPaintArea.x + interval.start, subPaintArea.y));
                points.add(jobPoint);
            }
        }
        if (this.node.getLowerLevelCount() == 0 && (object = this.getConnectedObject()) != null && object.getId().equals(jobId)) {
            Rectangle subPaintArea = NodedisplayComp.getNextNodedisplayBounds(this.innerComp);
            Point jobPoint = this.getPositionInScrollComp(new Point(subPaintArea.x, subPaintArea.y));
            points.add(jobPoint);
        }
    }

    public Nodedisplayelement findLayout(LMLNodeData nodeData) {
        Nodedisplayelement result = null;
        if (this.lguiItem.getNodedisplayAccess() != null) {
            ArrayList<Integer> levelNumbers = new ArrayList<Integer>();
            int i = ((LMLNodeData)this.node.getData()).getLevelIds().size();
            while (i < nodeData.getLevelIds().size()) {
                levelNumbers.add((Integer)nodeData.getLevelIds().get(i));
                ++i;
            }
            result = LMLCheck.getNodedisplayElementByLevels(levelNumbers, (Nodedisplayelement)this.nodedisplayLayout);
        }
        if (result == null) {
            return NodedisplayAccess.getDefaultLayout();
        }
        return result;
    }

    public HashMap<Node<LMLNodeData>, Color> generateNodeToColorMap(List<Node<LMLNodeData>> nodesList) {
        OIDToObject oidToObject = this.lguiItem.getOIDToObject();
        HashMap<Node<LMLNodeData>, Color> nodeToColorMap = new HashMap<Node<LMLNodeData>, Color>();
        if (oidToObject != null) {
            for (Node<LMLNodeData> node : nodesList) {
                if (node.getData() == null) continue;
                nodeToColorMap.put(node, ColorConversion.getColor(oidToObject.getColorById(((LMLNodeData)node.getData()).getDataElement().getOid())));
            }
        }
        return nodeToColorMap;
    }

    @Override
    public ILguiItem getLguiItem() {
        return this.lguiItem;
    }

    public Nodedisplayelement getNodedisplayLayout() {
        return this.nodedisplayLayout;
    }

    public Point getPositionInScrollComp(Point relPoint) {
        Rectangle bounds = null;
        bounds = this.parentNodedisplayComp == null ? this.getBounds() : NodedisplayComp.getNextNodedisplayBounds(this);
        Point pointInParent = new Point(bounds.x + relPoint.x, bounds.y + relPoint.y);
        if (this.parentNodedisplayComp == null) {
            return pointInParent;
        }
        return this.parentNodedisplayComp.getPositionInScrollComp(pointInParent);
    }

    public String getShownImpName() {
        if (this.node == null) {
            return null;
        }
        return ((LMLNodeData)this.node.getData()).getFullImpName();
    }

    public int getXPosition() {
        return this.x;
    }

    public int getYPosition() {
        return this.y;
    }

    public boolean hasParentNodedisplay() {
        return this.parentNodedisplayComp != null;
    }

    public void hideTitle() {
        this.titleLabel.setVisible(false);
        this.nodedisplayLayout.setShowtitle(Boolean.valueOf(false));
    }

    public boolean isRectangleVisible(Rectangle area) {
        if (this.parentNodedisplayComp == null) {
            Rectangle bounds = this.getBounds();
            Point parentSize = this.getParent().getSize();
            int x = -bounds.x;
            int y = -bounds.y;
            int x2 = x + parentSize.x - 1;
            int y2 = y + parentSize.y - 1;
            if (area.x + area.width <= x) {
                return false;
            }
            if (area.x > x2) {
                return false;
            }
            if (area.y > y2) {
                return false;
            }
            return area.y + area.height > y;
        }
        Rectangle bounds = NodedisplayComp.getNextNodedisplayBounds(this);
        area.x += bounds.x;
        area.y += bounds.y;
        return this.parentNodedisplayComp.isRectangleVisible(area);
    }

    public void removeZoomListener(INodedisplayZoomListener listener) {
        this.zoomListeners.remove(listener);
    }

    public void showTitle() {
        this.titleLabel.setVisible(true);
        this.nodedisplayLayout.setShowtitle(Boolean.valueOf(true));
    }

    public void updateStatus(ObjectType object, boolean mouseOver, boolean mouseDown) {
        if (this.parentNodedisplayComp == null) {
            if (this.innerComp != null) {
                this.innerComp.redraw();
            }
            return;
        }
        ObjectType connectedObject = this.getConnectedObject();
        if (this.lguiItem.getObjectStatus() != null) {
            if (this.node.getLowerLevelCount() == 0) {
                if (this.lguiItem.getObjectStatus().isMouseOver(connectedObject)) {
                    this.borderComp.setBorderWidth(this.nodedisplayLayout.getMouseborder().intValue());
                } else {
                    this.borderComp.setBorderWidth(this.nodedisplayLayout.getBorder().intValue());
                }
                if (this.lguiItem.getObjectStatus().isAnyMouseDown() && !this.lguiItem.getObjectStatus().isMouseDown(connectedObject)) {
                    this.innerComp.setBackground(ColorConversion.getColor(this.lguiItem.getOIDToObject().getColorById(null)));
                } else {
                    this.innerComp.setBackground(this.jobColor);
                }
            } else if (this.node.getLowerLevelCount() <= this.levelsPaintedByPaintListener) {
                this.innerComp.redraw();
            }
        }
    }

    private void addDisposeAction() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NodedisplayComp.this.removeUpdatable();
                if (NodedisplayComp.this.rectanglePaintListener != null) {
                    NodedisplayComp.this.rectanglePaintListener.dispose();
                }
                if (NodedisplayComp.this.titleLabel != null) {
                    NodedisplayComp.this.titleLabel.dispose();
                }
            }
        });
    }

    private void addLowestLevelListeners() {
        MouseMoveListener mouseMove = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                NodedisplayComp.this.mouseInteraction.mouseMoveAction((Node<LMLNodeData>)NodedisplayComp.this.node);
            }
        };
        MouseListener mouselistener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                NodedisplayComp.this.mouseInteraction.mouseDownAction((Node<LMLNodeData>)NodedisplayComp.this.node);
            }

            public void mouseUp(MouseEvent e) {
                if (e.x >= 0 && e.x <= NodedisplayComp.this.getSize().x && e.y >= 0 && e.y <= NodedisplayComp.this.getSize().y) {
                    NodedisplayComp.this.mouseInteraction.mouseUpAction((Node<LMLNodeData>)NodedisplayComp.this.node);
                }
            }
        };
        Listener mouseexit = new Listener(){

            public void handleEvent(Event event) {
                NodedisplayComp.this.mouseInteraction.mouseExitAction();
            }
        };
        this.borderComp.addMouseMoveListener(mouseMove);
        this.borderComp.addMouseListener(mouselistener);
        this.borderComp.addListener(7, mouseexit);
        this.innerComp.addMouseMoveListener(mouseMove);
        this.innerComp.addMouseListener(mouselistener);
        this.innerComp.addListener(7, mouseexit);
    }

    private void addMouseListenerToInnerPanelWithRectPaintListener() {
        MouseMoveAndDownListener mouseListener = new MouseMoveAndDownListener();
        this.innerComp.addMouseMoveListener((MouseMoveListener)mouseListener);
        this.innerComp.addMouseListener((MouseListener)mouseListener);
        this.innerComp.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                NodedisplayComp.this.mouseInteraction.mouseExitAction();
            }
        });
    }

    private void addZoomFunction() {
        this.titleLabel.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                NodedisplayComp.this.titleLabel.setBackground(NodedisplayComp.this.titleBackgroundColor);
                NodedisplayZoomEvent event = null;
                event = NodedisplayComp.this.parentNodedisplayComp == null ? new NodedisplayZoomEvent(null, false) : new NodedisplayZoomEvent(((LMLNodeData)NodedisplayComp.this.node.getData()).getFullImpName(), true);
                NodedisplayComp.this.notifyZoomListeners((INodedisplayZoomEvent)event);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.titleLabel.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                NodedisplayComp.this.titleLabel.setBackground(Display.getCurrent().getSystemColor(5));
            }
        });
        this.titleLabel.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                NodedisplayComp.this.titleLabel.setBackground(NodedisplayComp.this.titleBackgroundColor);
            }
        });
    }

    private void createFramePanels(Color borderColor) {
        this.borderComp = new BorderComposite(this.mainComp, 0);
        this.borderComp.setBorderColor(borderColor);
        this.borderComp.setBorderWidth(this.nodedisplayLayout.getBorder().intValue());
        this.borderComp.setLayoutData(new BorderLayout.BorderData(4));
        this.innerComp = this.node.getLowerLevelCount() == 0 || this.node.getLowerLevelCount() > this.levelsPaintedByPaintListener ? new Composite((Composite)this.borderComp, 0) : new Composite((Composite)this.borderComp, 262144);
        this.mouseInteraction = new MouseInteraction(this.lguiItem, (Control)this.innerComp);
        if (this.node.getLowerLevelCount() == 0) {
            this.innerComp.setBackground(this.jobColor);
        } else {
            this.innerComp.setBackground(this.backgroundColor);
            if (this.centerPicture != null) {
                this.innerComp.setBackgroundImage(this.centerPicture);
            }
        }
    }

    private void createPictureFrame() {
        this.pictureComp = new Composite((Composite)this, 0);
        this.pictureComp.setLayout((Layout)new BorderLayout());
        this.pictureComp.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                NodedisplayComp.this.pictureComp.layout(true);
            }
        });
        this.insertPictures();
        this.pictureComp.setBackground(this.backgroundColor);
    }

    private ObjectType getConnectedObject() {
        if (this.lguiItem.getOIDToObject() == null) {
            return null;
        }
        if (((LMLNodeData)this.node.getData()).getDataElement() == null) {
            return null;
        }
        return this.lguiItem.getOIDToObject().getObjectById(((LMLNodeData)this.node.getData()).getDataElement().getOid());
    }

    private URL getRealBundleURL(String urlString) {
        if (LMLUIPlugin.getDefault() == null) {
            return null;
        }
        int firstColon = urlString.indexOf(58);
        if (firstColon == -1) {
            return null;
        }
        String string = urlString.substring(0, firstColon);
        if (!string.equals("bundleentry")) {
            return null;
        }
        String file = urlString.substring(firstColon + 1);
        return LMLUIPlugin.getDefault().getBundle().getEntry(file);
    }

    private void init(Node<LMLNodeData> currentNode, Nodedisplayelement layout) {
        this.node = currentNode;
        this.nodedisplayLayout = layout;
        this.setLayout((Layout)new FillLayout());
        if (this.parentNodedisplayComp == null) {
            CompositeListenerChooser chooser = new CompositeListenerChooser(this.node);
            this.levelsPaintedByPaintListener = chooser.getLevelsPaintedByPaintListener();
        }
        this.innerCompsList = new ArrayList<NodedisplayComp>();
        this.addDisposeAction();
        this.backgroundColor = ColorConversion.getColor(LMLColor.stringToColor((String)this.nodedisplayLayout.getBackground()));
        this.createPictureFrame();
        this.fontObject = this.getDisplay().getSystemFont();
        this.mainComp = new Composite(this.pictureComp, 0);
        this.mainComp.setLayout((Layout)new BorderLayout());
        this.mainComp.setLayoutData((Object)new BorderLayout.BorderData(4));
        if (this.lguiItem.getOIDToObject() != null) {
            if (((LMLNodeData)this.node.getData()).getDataElement() != null) {
                this.jobColor = ColorConversion.getColor(this.lguiItem.getOIDToObject().getColorById(((LMLNodeData)this.node.getData()).getDataElement().getOid()));
                this.title = this.nodedisplayLayout.isShowfulltitle() ? ((LMLNodeData)this.node.getData()).getFullImpName() : ((LMLNodeData)this.node.getData()).getImpName();
            } else {
                this.jobColor = ColorConversion.getColor(this.lguiItem.getOIDToObject().getColorById(null));
                this.title = this.lguiItem.getNodedisplayAccess().getNodedisplayTitel(0);
            }
            this.insertTitleLabel();
            this.insertInnerPanel();
            this.lguiItem.getObjectStatus().addComponent((ObjectStatus.Updatable)this);
        }
    }

    private void insertInnerPanel() {
        Color borderColor = ColorConversion.getColor(LMLColor.stringToColor((String)this.nodedisplayLayout.getBordercolor()));
        this.createFramePanels(borderColor);
        if (this.node.getLowerLevelCount() == 0) {
            if (!this.insertUsagebar()) {
                this.addLowestLevelListeners();
            }
            return;
        }
        List reorderedChildren = new RowColumnSorter(this.node.getChildren()).reorder(this.nodedisplayLayout.isHighestrowfirst(), this.nodedisplayLayout.isHighestcolfirst(), this.nodedisplayLayout.getCols().intValue());
        if (this.node.getLowerLevelCount() <= this.levelsPaintedByPaintListener) {
            this.initRectanglePaintListener(reorderedChildren);
            this.addMouseListenerToInnerPanelWithRectPaintListener();
        } else {
            int cols = this.nodedisplayLayout.getCols().intValue();
            GridLayout layout = new GridLayout(cols, true);
            layout.horizontalSpacing = this.nodedisplayLayout.getHgap().intValue();
            layout.verticalSpacing = this.nodedisplayLayout.getVgap().intValue();
            layout.marginWidth = 1;
            layout.marginHeight = 1;
            this.innerComp.setLayout((Layout)layout);
            int index = 0;
            for (Node node : reorderedChildren) {
                NodedisplayComp innerComp = this.createNodedisplayComp(this.lguiItem, (Node<LMLNodeData>)node, this.findLayout((LMLNodeData)node.getData()), this.levelsPaintedByPaintListener, this, index % cols, index / cols, this.innerComp, 0);
                this.innerCompsList.add(innerComp);
                innerComp.setLayoutData(NodedisplayComp.getDefaultGridData());
                ++index;
            }
        }
    }

    private void insertPictures() {
        this.picturesList = new ArrayList<ImageComp>();
        List lmlPictures = this.nodedisplayLayout.getImg();
        for (PictureType picture : lmlPictures) {
            ImageComp imageComp;
            URL urlString = null;
            try {
                urlString = new URL(picture.getSrc());
            }
            catch (MalformedURLException e1) {
                urlString = this.getRealBundleURL(picture.getSrc());
            }
            if (urlString == null) continue;
            try {
                imageComp = new ImageComp(this.pictureComp, 0, urlString, picture.getWidth(), picture.getHeight());
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            if (this.parentNodedisplayComp == null) {
                imageComp.setBackground(this.backgroundColor);
            } else {
                imageComp.setBackground(this.getParent().getBackground());
            }
            switch (picture.getAlign()) {
                case WEST: {
                    imageComp.setLayoutData(new BorderLayout.BorderData(3));
                    break;
                }
                case EAST: {
                    imageComp.setLayoutData(new BorderLayout.BorderData(5));
                    break;
                }
                case NORTH: {
                    imageComp.setLayoutData(new BorderLayout.BorderData(1));
                    break;
                }
                case SOUTH: {
                    imageComp.setLayoutData(new BorderLayout.BorderData(7));
                    break;
                }
            }
            if (picture.getAlign() == AlignType.CENTER) {
                this.centerPicture = imageComp.getImage();
                continue;
            }
            this.picturesList.add(imageComp);
        }
    }

    private void insertTitleLabel() {
        if (this.nodedisplayLayout.isShowtitle()) {
            this.titleBackgroundColor = ColorConversion.getColor(LMLColor.stringToColor((String)this.nodedisplayLayout.getTitlebackground()));
            this.titleLabel = new Label(this.mainComp, 0);
            this.titleLabel.setText(this.title);
            this.titleLabel.setFont(this.fontObject);
            this.titleLabel.setBackground(this.titleBackgroundColor);
            this.titleLabel.setLayoutData((Object)new BorderLayout.BorderData(1));
            this.addZoomFunction();
        }
    }

    private boolean insertUsagebar() {
        if (!this.hasParentNodedisplay()) {
            if (this.node.getData() == null || ((LMLNodeData)this.node.getData()).getLevelIds() == null) {
                return false;
            }
            if (this.nodedisplayLayout.getMaxlevel() == null) {
                return false;
            }
            if (((LMLNodeData)this.node.getData()).getLevelIds().size() < this.nodedisplayLayout.getMaxlevel().intValue()) {
                return false;
            }
            this.innerComp.setLayout((Layout)new FillLayout());
            UsageType usageData = ((LMLNodeData)this.node.getData()).generateUsage();
            this.usagebar = new Usagebar(usageData, this.lguiItem, this.innerComp, 0);
            this.usagebar.setPaintScale(true);
            this.usagebar.setBarFactor(0.8);
            this.usagebar.setStandardFrame(this.nodedisplayLayout.getBorder().intValue());
            this.usagebar.setMouseOverFrame(this.nodedisplayLayout.getMouseborder().intValue());
            return true;
        }
        if (this.node.getData() != null && ((LMLNodeData)this.node.getData()).getDataElement() != null && ((LMLNodeData)this.node.getData()).getDataElement().getUsage() != null && ((LMLNodeData)this.node.getData()).isDataElementOnNodeLevel()) {
            this.innerComp.setLayout((Layout)new FillLayout());
            this.usagebar = new Usagebar(((LMLNodeData)this.node.getData()).getDataElement().getUsage(), this.lguiItem, this.innerComp, 0);
            this.usagebar.setPaintScale(false);
            this.usagebar.setBarFactor(1.0);
            this.usagebar.setStandardFrame(this.nodedisplayLayout.getBorder().intValue());
            this.usagebar.setMouseOverFrame(this.nodedisplayLayout.getMouseborder().intValue());
            return true;
        }
        return false;
    }

    private void removeUpdatable() {
        if (this.lguiItem.getObjectStatus() != null) {
            this.lguiItem.getObjectStatus().removeComponent((ObjectStatus.Updatable)this);
        }
        for (NodedisplayComp nodedisplayComp : this.innerCompsList) {
            nodedisplayComp.removeUpdatable();
        }
    }

    protected NodedisplayComp createNodedisplayComp(ILguiItem lguiItem, Node<LMLNodeData> node, Nodedisplayelement layout, int levelsPaintedByPaintListener, NodedisplayComp parentNodedisplay, int x, int y, Composite parent, int style) {
        return new NodedisplayComp(lguiItem, node, layout, levelsPaintedByPaintListener, parentNodedisplay, x, y, parent, style);
    }

    protected void initRectanglePaintListener(List<Node<LMLNodeData>> nodes) {
        this.rectanglePaintListener = new RectanglePaintListener(nodes, this, this.innerComp);
        this.innerComp.addPaintListener((PaintListener)this.rectanglePaintListener);
    }

    protected void notifyZoomListeners(INodedisplayZoomEvent event) {
        if (this.parentNodedisplayComp != null) {
            this.parentNodedisplayComp.notifyZoomListeners(event);
        }
        for (INodedisplayZoomListener listener : this.zoomListeners) {
            listener.handleEvent(event);
        }
    }

    private class MouseMoveAndDownListener
    implements MouseListener,
    MouseMoveListener {
        private int lastX = 0;
        private int lastY = 0;

        private MouseMoveAndDownListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            Node<LMLNodeData> focussed = NodedisplayComp.this.rectanglePaintListener.getNodeAtPos(this.lastX, this.lastY);
            if (NodedisplayComp.this.rectanglePaintListener.getUsagebarConnectedToNode(focussed) != null) {
                NodedisplayComp.this.mouseInteraction.mouseDownAction(NodedisplayComp.this.rectanglePaintListener.getJobAtPos(focussed, this.lastX));
            } else {
                NodedisplayComp.this.mouseInteraction.mouseDownAction(focussed);
            }
        }

        public void mouseMove(MouseEvent e) {
            this.lastX = e.x;
            this.lastY = e.y;
            Node<LMLNodeData> focussed = NodedisplayComp.this.rectanglePaintListener.getNodeAtPos(this.lastX, this.lastY);
            if (NodedisplayComp.this.rectanglePaintListener.getUsagebarConnectedToNode(focussed) != null) {
                NodedisplayComp.this.mouseInteraction.mouseMoveAction(NodedisplayComp.this.rectanglePaintListener.getJobAtPos(focussed, this.lastX));
            } else {
                NodedisplayComp.this.mouseInteraction.mouseMoveAction(focussed);
            }
        }

        public void mouseUp(MouseEvent e) {
            Node<LMLNodeData> focussed = NodedisplayComp.this.rectanglePaintListener.getNodeAtPos(this.lastX, this.lastY);
            if (NodedisplayComp.this.rectanglePaintListener.getUsagebarConnectedToNode(focussed) != null) {
                NodedisplayComp.this.mouseInteraction.mouseUpAction(NodedisplayComp.this.rectanglePaintListener.getJobAtPos(focussed, this.lastX));
            } else {
                NodedisplayComp.this.mouseInteraction.mouseUpAction(focussed);
            }
        }
    }
}

