/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.FindReferencesAction;
import org.eclipse.jdt.ui.actions.ShowInPackageViewAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BlankQuery;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.DependencyPropertiesDialog;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.ConditionalListSelectionDialog;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.dependencies.CalculateUsesAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ExportPackageSection
extends TableSection {
    private static final int ADD_INDEX = 0;
    private static final int REMOVE_INDEX = 1;
    private static final int PROPERTIES_INDEX = 2;
    private static final int CALCULATE_USE_INDEX = 3;
    private TableViewer fPackageViewer;
    private Action fAddAction;
    private Action fGoToAction;
    private Action fRemoveAction;
    private Action fPropertiesAction;
    private ExportPackageHeader fHeader;

    public ExportPackageSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.ExportPackageSection_add, PDEUIMessages.ExportPackageSection_remove, PDEUIMessages.ExportPackageSection_properties, PDEUIMessages.ExportPackageSection_uses});
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFragment() {
        IBaseModel iBaseModel = this.getPage().getPDEEditor().getAggregateModel();
        if (iBaseModel instanceof IPluginModelBase) {
            void model;
            IPluginModelBase iPluginModelBase = (IPluginModelBase)iBaseModel;
            IPluginModelBase cfr_ignored_0 = (IPluginModelBase)iBaseModel;
            return model.isFragmentModel();
        }
        return false;
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ExportPackageSection_title);
        if (this.isFragment()) {
            section.setDescription(PDEUIMessages.ExportPackageSection_descFragment);
        } else {
            section.setDescription(PDEUIMessages.ExportPackageSection_desc);
        }
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fPackageViewer = tablePart.getTableViewer();
        this.fPackageViewer.setContentProvider((IContentProvider)new ExportPackageContentProvider());
        this.fPackageViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPackageViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String s1 = e1.toString();
                String s2 = e2.toString();
                if (s1.contains(" ")) {
                    s1 = s1.substring(0, s1.indexOf(32));
                }
                if (s2.contains(" ")) {
                    s2 = s2.substring(0, s2.indexOf(32));
                }
                return super.compare(viewer, (Object)s1, (Object)s2);
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        GridData gd = new GridData(1808);
        if (((ManifestEditor)this.getPage().getEditor()).isEquinox()) {
            gd.verticalSpan = 2;
            gd.minimumWidth = 300;
        }
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)gd);
        this.makeActions();
        IBundleModel model = this.getBundleModel();
        this.fPackageViewer.setInput((Object)model);
        model.addModelChangedListener((IModelChangedListener)this);
        this.updateButtons();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    public void dispose() {
        IBundleModel model = this.getBundleModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    @Override
    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        Map<String, IPackageFragment> currentPackageFragments = null;
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageObject exportPackageObject;
            Object sourceObject = objectArray[n2];
            if (!(sourceObject instanceof ExportPackageObject)) {
                return false;
            }
            if (currentPackageFragments == null) {
                currentPackageFragments = this.createCurrentExportPackageMap();
            }
            if (!currentPackageFragments.containsKey((exportPackageObject = (ExportPackageObject)sourceObject).getName())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean canAddExportedPackages() {
        return this.isEditable() && this.getProjectWithJavaNature().isPresent();
    }

    private Optional<IProject> getProjectWithJavaNature() {
        Optional<IPluginModelBase> model = Optional.ofNullable(this.getModel());
        Optional<IProject> project = model.map(IModel::getUnderlyingResource).map(IResource::getProject);
        return project.filter(p -> {
            try {
                return p.hasNature("org.eclipse.jdt.core.javanature");
            }
            catch (CoreException coreException) {
                return false;
            }
        });
    }

    private Map<String, IPackageFragment> createCurrentExportPackageMap() {
        Optional<IProject> project = this.getProjectWithJavaNature();
        if (project.isEmpty()) {
            return Collections.emptyMap();
        }
        IJavaProject javaProject = JavaCore.create((IProject)project.get());
        Set currentExportPackages = this.fHeader == null ? Collections.emptySet() : this.fHeader.getPackageNames();
        return PDEJavaHelper.getPackageFragmentsHash((IJavaProject)javaProject, currentExportPackages, (boolean)this.allowJavaPackages());
    }

    private IPluginModelBase getModel() {
        return (IPluginModelBase)this.getPage().getModel();
    }

    private boolean allowJavaPackages() {
        return "true".equals(this.getBundle().getHeader("Eclipse-JREBundle"));
    }

    @Override
    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        IBundleModel model = this.getBundleModel();
        if (model == null) {
            return;
        }
        IBundle bundle = model.getBundle();
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object sourceObject = objectArray[n2];
            if (sourceObject instanceof ExportPackageObject) {
                ExportPackageObject exportPackageObject = (ExportPackageObject)sourceObject;
                exportPackageObject.reconnect(model, this.fHeader, this.getVersionAttribute());
                if (this.fHeader == null) {
                    bundle.setHeader(this.getExportedPackageHeader(), "");
                }
                this.fHeader.addPackage((PackageObject)exportPackageObject);
            }
            ++n2;
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection sel) {
        this.getPage().getPDEEditor().setSelection((ISelection)sel);
        this.updateButtons();
    }

    private void updateButtons() {
        Object[] selected = this.fPackageViewer.getStructuredSelection().toArray();
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.canAddExportedPackages());
        tablePart.setButtonEnabled(1, this.isEditable() && selected.length > 0);
        tablePart.setButtonEnabled(2, this.shouldEnableProperties(selected));
        tablePart.setButtonEnabled(3, this.isEditable() && this.fPackageViewer.getTable().getItemCount() > 0);
    }

    private boolean shouldEnableProperties(Object[] selected) {
        if (selected.length == 0) {
            return false;
        }
        if (selected.length == 1) {
            return true;
        }
        String version = ((ExportPackageObject)selected[0]).getVersion();
        int i = 1;
        while (i < selected.length) {
            ExportPackageObject object = (ExportPackageObject)selected[i];
            if (version == null ? object.getVersion() != null : !version.equals(object.getVersion())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleGoToPackage((ISelection)selection);
    }

    private IPackageFragment getPackageFragment(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            if (selection.size() != 1) {
                return null;
            }
            IBaseModel model = this.getPage().getModel();
            if (!(model instanceof IPluginModelBase)) {
                return null;
            }
            return PDEJavaHelper.getPackageFragment((String)((PackageObject)selection.getFirstElement()).getName(), (String)((IPluginModelBase)model).getPluginBase().getId(), (IProject)this.getPage().getPDEEditor().getCommonProject());
        }
        return null;
    }

    private void handleGoToPackage(ISelection selection) {
        IPackageFragment frag = this.getPackageFragment(selection);
        if (frag != null) {
            try {
                IViewPart part = PDEPlugin.getActivePage().showView("org.eclipse.jdt.ui.PackageExplorer");
                ShowInPackageViewAction action = new ShowInPackageViewAction((IWorkbenchSite)part.getSite());
                action.run((IJavaElement)frag);
            }
            catch (PartInitException partInitException) {}
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleOpenProperties();
                break;
            }
            case 3: {
                this.calculateUses();
            }
        }
    }

    private void handleOpenProperties() {
        Object[] selected = this.fPackageViewer.getStructuredSelection().toArray();
        ExportPackageObject first = (ExportPackageObject)selected[0];
        DependencyPropertiesDialog dialog = new DependencyPropertiesDialog(this.isEditable(), first);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.exported_package_properties");
        SWTUtil.setDialogSize((Dialog)dialog, 400, -1);
        if (selected.length == 1) {
            dialog.setTitle(((ExportPackageObject)selected[0]).getName());
        } else {
            dialog.setTitle(PDEUIMessages.ExportPackageSection_props);
        }
        if (dialog.open() == 0 && this.isEditable()) {
            String newVersion = dialog.getVersion();
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                ExportPackageObject object = (ExportPackageObject)selectedObject;
                if (!newVersion.equals(object.getVersion())) {
                    object.setVersion(newVersion);
                }
                ++n2;
            }
        }
    }

    private void handleRemove() {
        Object[] removed;
        Object[] objectArray = removed = this.fPackageViewer.getStructuredSelection().toArray();
        int n = removed.length;
        int n2 = 0;
        while (n2 < n) {
            Object removedObject = objectArray[n2];
            this.fHeader.removePackage((PackageObject)removedObject);
            ++n2;
        }
    }

    private void handleAdd() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        IProject project = model.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                JavaElementLabelProvider labelProvider = new JavaElementLabelProvider();
                ConditionalListSelectionDialog dialog = new ConditionalListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider, PDEUIMessages.ExportPackageSection_dialogButtonLabel);
                Set pckgs = this.fHeader == null ? Collections.emptySet() : this.fHeader.getPackageNames();
                boolean allowJava = "true".equals(this.getBundle().getHeader("Eclipse-JREBundle"));
                Runnable runnable = () -> {
                    IPackageFragment[] fragments;
                    ArrayList<IPackageFragment> elements = new ArrayList<IPackageFragment>();
                    ArrayList<IPackageFragment> conditional = new ArrayList<IPackageFragment>();
                    IPackageFragment[] iPackageFragmentArray = fragments = PDEJavaHelper.getPackageFragments((IJavaProject)JavaCore.create((IProject)project), (Collection)pckgs, (boolean)allowJava);
                    int n = fragments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragment fragment = iPackageFragmentArray[n2];
                        try {
                            if (fragment.containsJavaResources()) {
                                elements.add(fragment);
                            } else {
                                conditional.add(fragment);
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        ++n2;
                    }
                    dialog.setElements(elements.toArray());
                    dialog.setConditionalElements(conditional.toArray());
                    dialog.setMultipleSelection(true);
                    dialog.setMessage(PDEUIMessages.PackageSelectionDialog_label);
                    dialog.setTitle(PDEUIMessages.ExportPackageSection_title);
                    dialog.create();
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.export_packages");
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                };
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
                if (dialog.open() == 0) {
                    Object[] selected = dialog.getResult();
                    if (this.fHeader != null) {
                        Object[] objectArray = selected;
                        int n = selected.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object selectedObject = objectArray[n2];
                            IPackageFragment candidate = (IPackageFragment)selectedObject;
                            this.fHeader.addPackage((PackageObject)new ExportPackageObject((ManifestHeader)this.fHeader, candidate, this.getVersionAttribute()));
                            ++n2;
                        }
                    } else {
                        this.getBundle().setHeader(this.getExportedPackageHeader(), this.getValue(selected));
                        if (selected.length > 0) {
                            this.getTablePart().setButtonEnabled(3, true);
                        }
                    }
                }
                labelProvider.dispose();
            }
        }
        catch (CoreException coreException) {}
    }

    private String getValue(Object[] objects) {
        StringBuilder buffer = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IPackageFragment fragment = (IPackageFragment)object;
            if (buffer.length() > 0) {
                buffer.append("," + this.getLineDelimiter() + " ");
            }
            buffer.append(fragment.getElementName());
            ++n2;
        }
        return buffer.toString();
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        Object[] objects;
        if (event.getChangeType() == 99) {
            this.fHeader = null;
            this.markStale();
            return;
        }
        if (this.getExportedPackageHeader().equals(event.getChangedProperty())) {
            this.refresh();
            Object lastElement = this.fPackageViewer.getElementAt(this.fPackageViewer.getTable().getItemCount() - 1);
            if (lastElement != null) {
                this.fPackageViewer.setSelection((ISelection)new StructuredSelection(lastElement));
            }
            return;
        }
        Object[] objectArray = objects = event.getChangedObjects();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object changedObject = objectArray[n2];
            if (changedObject instanceof ExportPackageObject) {
                ExportPackageObject object = (ExportPackageObject)changedObject;
                switch (event.getChangeType()) {
                    case 1: {
                        this.fPackageViewer.add((Object)object);
                        this.fPackageViewer.setSelection((ISelection)new StructuredSelection((Object)object), false);
                        this.fPackageViewer.getTable().setFocus();
                        break;
                    }
                    case 2: {
                        Table table = this.fPackageViewer.getTable();
                        int index = table.getSelectionIndex();
                        this.fPackageViewer.remove((Object)object);
                        table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                        break;
                    }
                    default: {
                        this.fPackageViewer.refresh((Object)object);
                    }
                }
            }
            ++n2;
        }
    }

    public void refresh() {
        this.fPackageViewer.refresh();
        super.refresh();
    }

    private void makeActions() {
        this.fAddAction = new Action(PDEUIMessages.RequiresSection_add){

            public void run() {
                ExportPackageSection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fGoToAction = new Action(PDEUIMessages.ImportPackageSection_goToPackage){

            public void run() {
                ExportPackageSection.this.handleGoToPackage((ISelection)ExportPackageSection.this.fPackageViewer.getStructuredSelection());
            }
        };
        this.fRemoveAction = new Action(PDEUIMessages.RequiresSection_delete){

            public void run() {
                ExportPackageSection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
        this.fPropertiesAction = new Action(PDEUIMessages.ExportPackageSection_propertyAction){

            public void run() {
                ExportPackageSection.this.handleOpenProperties();
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        boolean singleSelection;
        IStructuredSelection selection = this.fPackageViewer.getStructuredSelection();
        manager.add((IAction)this.fAddAction);
        boolean bl = singleSelection = selection.size() == 1;
        if (singleSelection) {
            manager.add((IAction)this.fGoToAction);
        }
        manager.add((IContributionItem)new Separator());
        if (!selection.isEmpty()) {
            manager.add((IAction)this.fRemoveAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        if (singleSelection) {
            manager.add((IAction)new Action(PDEUIMessages.ExportPackageSection_findReferences){

                public void run() {
                    ExportPackageSection.this.doSearch((ISelection)ExportPackageSection.this.fPackageViewer.getStructuredSelection());
                }
            });
        }
        if (this.shouldEnableProperties(this.fPackageViewer.getStructuredSelection().toArray())) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fPropertiesAction);
        }
    }

    private void doSearch(ISelection sel) {
        IPackageFragment frag = this.getPackageFragment(sel);
        if (frag != null) {
            FindReferencesAction action = new FindReferencesAction((IWorkbenchSite)this.getPage().getEditorSite());
            action.run((IJavaElement)frag);
        } else if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            PackageObject exportObject = (PackageObject)selection.getFirstElement();
            NewSearchUI.runQueryInBackground((ISearchQuery)new BlankQuery(exportObject));
        }
    }

    private BundleInputContext getBundleContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (BundleInputContext)manager.findContext("bundle-context");
    }

    private IBundleModel getBundleModel() {
        BundleInputContext context = this.getBundleContext();
        return context != null ? context.getModel() : null;
    }

    private String getLineDelimiter() {
        BundleInputContext inputContext = this.getBundleContext();
        if (inputContext != null) {
            return inputContext.getLineDelimiter();
        }
        return TextUtil.getDefaultLineDelimiter();
    }

    private IBundle getBundle() {
        IBundleModel model = this.getBundleModel();
        return model != null ? model.getBundle() : null;
    }

    private String getVersionAttribute() {
        int manifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)this.getBundle());
        return manifestVersion < 2 ? "specification-version" : "version";
    }

    public String getExportedPackageHeader() {
        int manifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)this.getBundle());
        return manifestVersion < 2 ? "Provide-Package" : "Export-Package";
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    private void calculateUses() {
        IProject proj = this.getPage().getPDEEditor().getCommonProject();
        CalculateUsesAction action = new CalculateUsesAction(proj, (IBundlePluginModelBase)this.getPage().getModel());
        action.run();
    }

    class ExportPackageContentProvider
    implements IStructuredContentProvider {
        ExportPackageContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (ExportPackageSection.this.fHeader == null) {
                Bundle bundle = (Bundle)ExportPackageSection.this.getBundle();
                ExportPackageSection.this.fHeader = (ExportPackageHeader)bundle.getManifestHeader(ExportPackageSection.this.getExportedPackageHeader());
            }
            return ExportPackageSection.this.fHeader == null ? new Object[]{} : ExportPackageSection.this.fHeader.getPackages();
        }
    }
}

