/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.isite.IRepositoryReference;
import org.eclipse.pde.internal.core.site.SiteObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RepositoryReference
extends SiteObject
implements IRepositoryReference {
    private static final long serialVersionUID = 1L;
    public static final String P_LOCATION = "location";
    public static final String P_ENABLED = "enabled";
    private String fURL;
    private boolean fEnabled = true;

    @Override
    public void setURL(String url) throws CoreException {
        String old = this.fURL;
        this.fURL = url;
        this.ensureModelEditable();
        this.firePropertyChanged(P_LOCATION, old, this.fURL);
    }

    @Override
    public String getURL() {
        return this.fURL;
    }

    @Override
    public boolean getEnabled() {
        return this.fEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) throws CoreException {
        boolean old = this.fEnabled;
        this.fEnabled = enabled;
        this.ensureModelEditable();
        this.firePropertyChanged(P_ENABLED, old, this.fEnabled);
    }

    @Override
    public void parse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this.fURL = element.getAttribute(P_LOCATION);
            this.fEnabled = Boolean.parseBoolean(element.getAttribute(P_ENABLED));
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        if (this.isURLDefined()) {
            writer.print(indent + "<repository-reference location=\"" + this.fURL + "\"");
            writer.print(" enabled=\"" + this.fEnabled + "\"");
            writer.println(" />");
        }
    }

    private boolean isURLDefined() {
        return this.fURL != null && this.fURL.length() > 0;
    }

    @Override
    public boolean isValid() {
        return this.isURLDefined();
    }
}

