/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jenkins.core.client;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsException;

public class JenkinsUrlUtil {
    private final RepositoryLocation repositoryLocation;
    private final Pattern jobNamePattern = Pattern.compile("[^/]+/$");
    private final Pattern jobUrlPattern = Pattern.compile("job/[^/]+/$");
    private static final String SLASH = "/";

    public JenkinsUrlUtil(RepositoryLocation repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public String assembleJobUrl(String jobName, String folderUrl) throws JenkinsException {
        String encodedJobname;
        try {
            encodedJobname = new URI(null, jobName, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new JenkinsException(e);
        }
        if (!folderUrl.endsWith(SLASH)) {
            folderUrl = String.valueOf(folderUrl) + SLASH;
        }
        if (!encodedJobname.endsWith(SLASH)) {
            encodedJobname = String.valueOf(encodedJobname) + SLASH;
        }
        return String.valueOf(folderUrl) + "job" + SLASH + encodedJobname;
    }

    public Map<String, List<String>> groupJobNamesByFolderUrl(List<String> jobIds) throws JenkinsException {
        HashMap<String, List<String>> jobNamesByFolderUrl = new HashMap<String, List<String>>();
        for (String jobId : jobIds) {
            String folderUrl = this.getFolderUrlFromJobId(jobId);
            String jobName = this.getJobNameFromJobId(jobId);
            if (jobNamesByFolderUrl.containsKey(folderUrl)) {
                ((List)jobNamesByFolderUrl.get(folderUrl)).add(jobName);
                continue;
            }
            ArrayList<String> jobNames = new ArrayList<String>();
            jobNames.add(jobName);
            jobNamesByFolderUrl.put(folderUrl, jobNames);
        }
        return jobNamesByFolderUrl;
    }

    private String getJobNameFromJobId(String jobId) throws JenkinsException {
        Matcher matcher = this.jobNamePattern.matcher(jobId);
        if (matcher.find()) {
            String jobName = jobId.substring(matcher.start(), jobId.length());
            try {
                jobName = URLDecoder.decode(jobName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new JenkinsException(e);
            }
            if (jobName.endsWith(SLASH)) {
                return jobName.substring(0, jobName.length() - 1);
            }
            return jobName;
        }
        return jobId;
    }

    private String getFolderUrlFromJobId(String jobId) {
        Matcher matcher = this.jobUrlPattern.matcher(jobId);
        if (matcher.find()) {
            return jobId.substring(0, matcher.start());
        }
        return this.baseUrl();
    }

    public String getJobUrlFromJobId(String jobId) throws JenkinsException {
        Matcher matcher = this.jobUrlPattern.matcher(jobId);
        if (matcher.find()) {
            return jobId;
        }
        return this.assembleJobUrl(jobId, this.baseUrl());
    }

    public String baseUrl() {
        String url = this.repositoryLocation.getUrl();
        if (!url.endsWith(SLASH)) {
            url = String.valueOf(url) + SLASH;
        }
        return url;
    }

    public boolean isNestedJob(String jobId) {
        return !this.getFolderUrlFromJobId(jobId).equals(this.baseUrl());
    }

    public String getDisplayName(String jobUrl) throws JenkinsException {
        String displayName = jobUrl.substring(this.repositoryLocation.getUrl().length(), jobUrl.length());
        if (!displayName.startsWith(SLASH)) {
            displayName = SLASH + displayName;
        }
        displayName = displayName.replaceAll("/job/", SLASH);
        try {
            displayName = URLDecoder.decode(displayName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JenkinsException(e);
        }
        if (displayName.startsWith(SLASH)) {
            displayName = displayName.substring(SLASH.length());
        }
        if (displayName.endsWith(SLASH)) {
            displayName = displayName.substring(0, displayName.length() - SLASH.length());
        }
        return displayName;
    }
}

