/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.common.reflect.TypeToken;
import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.common.data.CommentDetail;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.InheritedRefRight;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.prettify.common.SparseFileContent;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountDiffPreference;
import com.google.gerrit.reviewdb.AccountGroup;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchLineComment;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.PatchSetInfo;
import com.google.gerrit.reviewdb.Project;
import com.google.gerrit.reviewdb.RefRight;
import com.google.gerrit.reviewdb.RevId;
import com.google.gerrit.reviewdb.UserIdentity;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient29;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritVersion;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.DownloadSchemeX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchScriptX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.SchemeInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AccessSectionInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.AccountInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ChangeInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommentInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommitInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ConfigInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.DiffContent;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.DiffInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.DiffPreferencesInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.DownloadSchemeInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.FileInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.GitPersonalInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.GroupInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.PermissionInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.PermissionRuleInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ProjectAccessInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ProjectInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ServerInfo;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.osgi.framework.Version;

public class GerritClient212
extends GerritClient29 {
    private final String SELF_ACCOUNT_ID = "self";

    protected GerritClient212(TaskRepository repository, Version version) {
        super(repository, version);
    }

    @Override
    protected GerritConfigX getGerritConfigFromServerInfo(IProgressMonitor monitor) throws GerritException {
        String query = "/config/server/info";
        ServerInfo serverInfo = (ServerInfo)this.getRestClient().executeGetRestRequest(query, (Type)((Object)ServerInfo.class), monitor);
        return this.convertServerInfoToGerritConfig(serverInfo);
    }

    private GerritConfigX convertServerInfoToGerritConfig(ServerInfo serverInfo) {
        GerritConfigX config = new GerritConfigX();
        config.setWildProject(new Project.NameKey(serverInfo.getGerrit().getRootProject()));
        HashMap<DownloadSchemeX, SchemeInfo> schemes = new HashMap<DownloadSchemeX, SchemeInfo>();
        serverInfo.getDownload().getSchemes().entrySet().forEach(entry -> {
            DownloadSchemeX scheme = DownloadSchemeX.fromString((String)entry.getKey());
            if (scheme != null) {
                DownloadSchemeInfo info = (DownloadSchemeInfo)entry.getValue();
                SchemeInfo schemeInfo = new SchemeInfo(info.getUrl(), info.isAuthRequired(), info.isAuthSupported(), info.getCommands(), info.getCloneCommands());
                schemes.put(scheme, schemeInfo);
            }
        });
        config.setSchemes(schemes);
        config.setDownloadSchemes(schemes.keySet().stream().map(scheme -> scheme.toDownloadScheme()).collect(Collectors.toSet()));
        return config;
    }

    @Override
    protected PatchSetDetail getPatchSetDetail(PatchSet.Id idBase, PatchSet.Id idTarget, IProgressMonitor monitor) throws GerritException {
        if (!GerritVersion.isVersion2120OrLater(this.getVersion())) {
            return super.getPatchSetDetail(idBase, idTarget, monitor);
        }
        PatchSetDetail patchSetDetail = new PatchSetDetail();
        CommitInfo commitInfo = this.retrieveCommitInfo(idTarget, monitor);
        AccountInfo accInfo = this.adaptAccountInfo(commitInfo, monitor);
        patchSetDetail.setInfo(this.adaptRestPatchSetInfo(commitInfo, accInfo, idTarget, monitor));
        patchSetDetail.setPatchSet(this.adaptRestPatchSet(commitInfo, accInfo, idTarget, monitor));
        patchSetDetail.setPatches(this.adaptRestPatches(idTarget, monitor));
        return patchSetDetail;
    }

    private AccountInfo adaptAccountInfo(CommitInfo commitInfo, IProgressMonitor monitor) throws GerritException {
        String accountId = commitInfo.getAuthor().getEmail();
        int retries = 0;
        while (true) {
            try {
                return this.retrieveAccountInfo(accountId, monitor);
            }
            catch (GerritException e) {
                if (retries >= 3) {
                    throw e;
                }
                accountId = commitInfo.getAuthor().getName();
                ++retries;
                continue;
            }
            break;
        }
    }

    @Override
    protected PatchScriptX getPatchScript(Patch.Key key, PatchSet.Id leftId, PatchSet.Id rightId, IProgressMonitor monitor) throws GerritException {
        AccountDiffPreference diffPrefs;
        if (!GerritVersion.isVersion2120OrLater(this.getVersion())) {
            return super.getPatchScript(key, leftId, rightId, monitor);
        }
        String fileName = key.getFileName();
        CommitInfo commitInfo = this.retrieveCommitInfo(rightId, monitor);
        AccountInfo accInfo = this.adaptAccountInfo(commitInfo, monitor);
        try {
            diffPrefs = this.adaptAccountDiffPref(accInfo, this.retrieveDiffPrefInfo(monitor));
        }
        catch (GerritException e) {
            diffPrefs = null;
        }
        DiffInfo diffInfo = leftId == null ? this.retrieveDiffInfoAgainstBase(rightId, fileName, monitor) : this.retrieveDiffInfoNotBase(rightId, leftId, fileName, monitor);
        CommentDetail commentDetail = new CommentDetail(leftId, rightId);
        if (diffInfo != null && diffInfo.getContent().size() > 0 && (diffInfo.getContent().get(0).getA() != null || diffInfo.getContent().get(0).getAb() != null || diffInfo.getContent().get(0).getB() != null)) {
            commentDetail = this.setCommentDetails(leftId, rightId, fileName, commentDetail, monitor);
        }
        PatchScriptX patchScriptX = new PatchScriptX();
        patchScriptX.setChangeId(new Change.Key(rightId.getParentKey().toString()));
        patchScriptX.setDiffPrefs(diffPrefs);
        patchScriptX.setComments(commentDetail);
        patchScriptX.setHeader(diffInfo.getDiff_header());
        patchScriptX.setChangeType(diffInfo.getChange_type());
        patchScriptX.setHistory(this.adaptRestPatches(rightId, monitor));
        patchScriptX.setDisplayMethodA(PatchScript.DisplayMethod.DIFF);
        patchScriptX.setDisplayMethodB(PatchScript.DisplayMethod.DIFF);
        if (diffInfo.getContent() != null) {
            patchScriptX.setEdits(this.adaptDiffContent(diffInfo, patchScriptX, monitor));
        }
        if (diffInfo.getMeta_a() != null) {
            patchScriptX.setA(this.adaptSparseFileContent_A(diffInfo, monitor));
        } else {
            patchScriptX.setA(new SparseFileContent());
        }
        if (diffInfo.getMeta_b() != null) {
            patchScriptX.setB(this.adaptSparseFileContent_B(diffInfo, monitor));
        } else {
            patchScriptX.setB(new SparseFileContent());
        }
        if (diffInfo.getDiff_header() != null && patchScriptX.isBinary()) {
            this.fetchLeftBinaryContent(patchScriptX, key, leftId, monitor);
            this.fetchRightBinaryContent(patchScriptX, key, rightId, monitor);
        }
        return patchScriptX;
    }

    private List<Patch> adaptRestPatches(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        ArrayList<Patch> patches = new ArrayList<Patch>();
        Map<String, FileInfo> infos = this.retrieveFileInfos(id, monitor);
        for (String fileName : infos.keySet()) {
            FileInfo fileInfo = infos.get(fileName);
            Patch patch = new Patch(new Patch.Key(id, fileName));
            patch.setChangeType(Patch.ChangeType.forCode((char)fileInfo.getStatus()));
            patch.setDeletions(fileInfo.getLinesDeleted());
            patch.setInsertions(fileInfo.getLinesInserted());
            patches.add(patch);
        }
        return patches;
    }

    private PatchSet adaptRestPatchSet(CommitInfo commitInfo, AccountInfo accInfo, PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        PatchSet patchSet = new PatchSet(id);
        patchSet.setRevision(new RevId(commitInfo.getCommit()));
        patchSet.setUploader(new Account.Id(accInfo.getId()));
        patchSet.setCreatedOn(this.parseTimeStamp(commitInfo.getAuthor().getDate()));
        return patchSet;
    }

    private PatchSetInfo adaptRestPatchSetInfo(CommitInfo commitInfo, AccountInfo accInfo, PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        PatchSetInfo info = new PatchSetInfo(id);
        info.setMessage(commitInfo.getMessage());
        info.setSubject(commitInfo.getSubject());
        info.setAuthor(this.toUserIdentity(commitInfo.getAuthor(), accInfo, monitor));
        info.setCommitter(this.toUserIdentity(commitInfo.getCommitter(), accInfo, monitor));
        return info;
    }

    private List<Edit> adaptDiffContent(DiffInfo diffInfo, PatchScriptX patchScriptX, IProgressMonitor monitor) throws GerritException {
        ArrayList<DiffContent> diffContent = diffInfo.getContent();
        ArrayList<Edit> editsInFile = new ArrayList<Edit>();
        int contentSize_A = 0;
        int contentSize_B = 0;
        for (DiffContent diff : diffContent) {
            Edit edit;
            if (diff.getAb() != null) {
                contentSize_A += diff.getAb().size();
                contentSize_B += diff.getAb().size();
                continue;
            }
            if (diff.getA() != null && diff.getB() != null) {
                edit = new Edit(contentSize_A, contentSize_A + diff.getA().size() - 1, contentSize_B, contentSize_B + diff.getB().size() - 1);
                editsInFile.add(edit);
                contentSize_A += diff.getA().size();
                contentSize_B += diff.getB().size();
                patchScriptX.setIntralineDifference(true);
                continue;
            }
            if (diff.getA() != null) {
                edit = new Edit(contentSize_A, contentSize_A + diff.getA().size() - 1, contentSize_B, contentSize_B);
                editsInFile.add(edit);
                contentSize_A += diff.getA().size();
                continue;
            }
            if (diff.getB() == null) continue;
            edit = new Edit(contentSize_A, contentSize_A, contentSize_B, contentSize_B + diff.getB().size() - 1);
            editsInFile.add(edit);
            contentSize_B += diff.getB().size();
        }
        return editsInFile;
    }

    private AccountDiffPreference adaptAccountDiffPref(AccountInfo accInfo, DiffPreferencesInfo diffPrefInfo) {
        AccountDiffPreference accDiffPref = new AccountDiffPreference(new Account.Id(accInfo.getId()));
        accDiffPref.setContext(diffPrefInfo.getContext());
        accDiffPref.setIgnoreWhitespace(diffPrefInfo.getIgnoreWhitespace() != null ? diffPrefInfo.getIgnoreWhitespace() : AccountDiffPreference.Whitespace.IGNORE_NONE);
        accDiffPref.setIntralineDifference(diffPrefInfo.isIntralineDifference());
        accDiffPref.setLineLength(diffPrefInfo.getLineLength());
        accDiffPref.setShowTabs(diffPrefInfo.isShowTabs());
        accDiffPref.setShowWhitespaceErrors(diffPrefInfo.isShowWhitespaceErrors());
        accDiffPref.setSyntaxHighlighting(diffPrefInfo.isSyntaxHighlighting());
        accDiffPref.setTabSize(diffPrefInfo.getTabSize());
        return accDiffPref;
    }

    private CommentDetail setCommentDetails(PatchSet.Id leftId, PatchSet.Id rightId, String fileName, CommentDetail commentDetail, IProgressMonitor monitor) throws GerritException {
        if (leftId != null) {
            Map<String, List<CommentInfo>> commentInfo_A = this.retrieveRevisionComments(leftId, monitor);
            this.adaptCommentDetails(commentInfo_A, leftId, commentDetail.getCommentsA(), fileName, commentDetail);
        }
        Map<String, List<CommentInfo>> commentInfo_B = this.retrieveRevisionComments(rightId, monitor);
        this.adaptCommentDetails(commentInfo_B, rightId, commentDetail.getCommentsB(), fileName, commentDetail);
        ChangeInfo changeInfo = this.getChangeInfo(rightId.getParentKey().get(), monitor);
        ArrayList<com.google.gerrit.common.data.AccountInfo> listAccountInfo = new ArrayList<com.google.gerrit.common.data.AccountInfo>();
        com.google.gerrit.common.data.AccountInfo accountInfo = this.setAccountFromChangeInfo(changeInfo);
        listAccountInfo.add(accountInfo);
        AccountInfoCache accCache = new AccountInfoCache(listAccountInfo);
        commentDetail.setAccountInfoCache(accCache);
        return commentDetail;
    }

    private com.google.gerrit.common.data.AccountInfo setAccountFromChangeInfo(ChangeInfo changeInfo) {
        Account account = new Account(new Account.Id(changeInfo.getOwner().getId()));
        account.setFullName(changeInfo.getOwner().getName());
        account.setUserName(changeInfo.getOwner().getUsername());
        account.setPreferredEmail(changeInfo.getOwner().getEmail());
        return new com.google.gerrit.common.data.AccountInfo(account);
    }

    private void adaptCommentDetails(Map<String, List<CommentInfo>> commentInfo, PatchSet.Id id, List<PatchLineComment> side, String file, CommentDetail commentDetail) {
        for (String filePath : commentInfo.keySet()) {
            if (!filePath.equals(file)) continue;
            List<CommentInfo> comments = commentInfo.get(filePath);
            for (CommentInfo comment : comments) {
                Patch.Key patchKey = new Patch.Key(id, filePath);
                PatchLineComment.Key patchLineCommentKey = new PatchLineComment.Key(patchKey, comment.getId());
                PatchLineComment lineComment = new PatchLineComment(patchLineCommentKey, comment.getLine(), new Account.Id(comment.getAuthor().getId()), null);
                this.populateLineComment(lineComment, comment);
                side.add(lineComment);
            }
        }
    }

    private void populateLineComment(PatchLineComment lineComment, CommentInfo commentInfo) {
        lineComment.setMessage(commentInfo.getMessage());
    }

    @Override
    protected List<ProjectDetailX> getProjectDetails(IProgressMonitor monitor, GerritConfig gerritConfig, List<Project> result) throws GerritException {
        if (!GerritVersion.isVersion2120OrLater(this.getVersion())) {
            return super.getProjectDetails(monitor, gerritConfig, result);
        }
        List<ProjectDetailX> projectDetails = this.adaptProjectDetails(gerritConfig, monitor);
        return projectDetails;
    }

    private List<ProjectDetailX> adaptProjectDetails(GerritConfig gerritConfig, IProgressMonitor monitor) throws GerritException {
        ConfigInfo configInfo = this.retrieveProjectConfigs(gerritConfig.getWildProject().get(), monitor);
        ArrayList<ProjectDetailX> projectDetails = new ArrayList<ProjectDetailX>();
        Map<String, ProjectInfo> listedProjects = this.listProjects(monitor);
        for (String projectName : listedProjects.keySet()) {
            ProjectDetailX projectDetail = new ProjectDetailX();
            ProjectAccessInfo accessRights = this.listAccessRights(projectName, monitor);
            projectDetail.setProject(this.adaptProject(configInfo, projectName, monitor));
            if (accessRights.getGroups() != null) {
                projectDetail.setGroups(this.adaptGroups(projectName, accessRights, monitor));
                projectDetail.setRights(this.adaptRights(projectName, accessRights, monitor));
            }
            if (accessRights.is_owner()) {
                projectDetail.setCanModifyDescription(true);
                projectDetail.setCanModifyMergeType(true);
                projectDetail.setCanModifyAgreements(true);
                projectDetail.setCanModifyAccess(true);
            }
            projectDetails.add(projectDetail);
        }
        return projectDetails;
    }

    private Project adaptProject(ConfigInfo configInfo, String projectName, IProgressMonitor monitor) throws GerritException {
        Project project = new Project(new Project.NameKey(projectName));
        project.setDescription(configInfo.getDescription());
        project.setUseContributorAgreements(configInfo.getUse_contributor_agreements().isValue());
        project.setUseSignedOffBy(configInfo.getUse_signed_off_by().isValue());
        project.setParent(new Project.NameKey(this.retrieveParentProject(projectName, monitor)));
        return project;
    }

    private Map<AccountGroup.Id, AccountGroup> adaptGroups(String projectName, ProjectAccessInfo accessRights, IProgressMonitor monitor) throws GerritException {
        HashMap<AccountGroup.Id, AccountGroup> groups = new HashMap<AccountGroup.Id, AccountGroup>();
        Map<String, GroupInfo> groupInfos = accessRights.getGroups();
        if (groupInfos != null) {
            for (String groupUuid : groupInfos.keySet()) {
                GroupInfo groupInfo = groupInfos.get(groupUuid);
                AccountGroup.Id groupId = new AccountGroup.Id(groupInfo.getGroup_id());
                String groupName = groupInfo.getName();
                if (groupInfo.getName() == null) {
                    groupName = groupUuid;
                }
                groups.put(groupId, this.setAccountGroup(groupInfo, groupName, groupId, groupUuid));
            }
        }
        return groups;
    }

    private List<InheritedRefRight> adaptRights(String projectName, ProjectAccessInfo accessRights, IProgressMonitor monitor) throws GerritException {
        ArrayList<InheritedRefRight> inheritedRights = new ArrayList<InheritedRefRight>();
        Map<String, AccessSectionInfo> localAccessRights = accessRights.getLocal();
        for (String refName : localAccessRights.keySet()) {
            RefRight.RefPattern refPattern = new RefRight.RefPattern(refName);
            Map<String, PermissionInfo> accessSectionInfo = localAccessRights.get(refName).getPermissions();
            for (String permissionName : accessSectionInfo.keySet()) {
                ApprovalCategory.Id categoryId = new ApprovalCategory.Id(permissionName);
                Map<String, PermissionRuleInfo> rules = accessSectionInfo.get(permissionName).getRules();
                for (String groupUuid : rules.keySet()) {
                    if (!this.getGroupType(groupUuid).equals((Object)AccountGroup.Type.INTERNAL) || !accessRights.getGroups().containsKey(groupUuid)) continue;
                    AccountGroup.Id groupId = new AccountGroup.Id(accessRights.getGroups().get(groupUuid).getGroup_id());
                    RefRight refRight = new RefRight(new RefRight.Key(new Project.NameKey(projectName), refPattern, categoryId, groupId));
                    boolean inherited = true;
                    if (accessRights.getInherits_from() == null) {
                        inherited = false;
                    }
                    InheritedRefRight inheritedrefRight = new InheritedRefRight(refRight, inherited, accessRights.is_owner());
                    inheritedRights.add(inheritedrefRight);
                }
            }
        }
        return inheritedRights;
    }

    private AccountGroup setAccountGroup(GroupInfo groupInfo, String groupName, AccountGroup.Id groupId, String groupUuid) {
        AccountGroup.NameKey nameKey = new AccountGroup.NameKey(groupName);
        AccountGroup accGroup = new AccountGroup(nameKey, groupId);
        accGroup.setDescription(groupInfo.getDescription());
        accGroup.setExternalNameKey(new AccountGroup.ExternalNameKey(groupName));
        accGroup.setNameKey(nameKey);
        accGroup.setOwnerGroupId(groupId);
        if (groupUuid != null) {
            accGroup.setType(this.getGroupType(groupUuid));
        }
        return accGroup;
    }

    private AccountGroup.Type getGroupType(String groupUuid) {
        if (groupUuid.matches("^[0-9a-f]{40}$")) {
            return AccountGroup.Type.INTERNAL;
        }
        if (groupUuid.startsWith("global")) {
            return AccountGroup.Type.SYSTEM;
        }
        if (groupUuid.startsWith("ldap")) {
            return AccountGroup.Type.LDAP;
        }
        return AccountGroup.Type.INTERNAL;
    }

    private SparseFileContent adaptSparseFileContent_A(DiffInfo diffInfo, IProgressMonitor monitor) {
        SparseFileContent sparseFileContent = new SparseFileContent();
        sparseFileContent.setSize(diffInfo.getMeta_a().getLines());
        sparseFileContent.setPath(diffInfo.getMeta_a().getName());
        sparseFileContent.setMissingNewlineAtEnd(false);
        this.adaptLineContent_A(sparseFileContent, diffInfo);
        return sparseFileContent;
    }

    private SparseFileContent adaptSparseFileContent_B(DiffInfo diffInfo, IProgressMonitor monitor) {
        SparseFileContent sparseFileContent = new SparseFileContent();
        sparseFileContent.setSize(diffInfo.getMeta_b().getLines());
        sparseFileContent.setPath(diffInfo.getMeta_b().getName());
        sparseFileContent.setMissingNewlineAtEnd(false);
        this.adaptLineContent_B(sparseFileContent, diffInfo);
        return sparseFileContent;
    }

    private void adaptLineContent_A(SparseFileContent sparseFileContent, DiffInfo diffInfo) {
        ArrayList<DiffContent> diffContent = diffInfo.getContent();
        int contentIdx = 0;
        int i = 0;
        while (i < diffContent.size()) {
            if (((DiffContent)diffContent.get(i)).getAb() != null) {
                this.addLinesAndConvertToStrings(sparseFileContent, ((DiffContent)diffContent.get(i)).getAb(), contentIdx);
                contentIdx += ((DiffContent)diffContent.get(i)).getAb().size();
            } else if (((DiffContent)diffContent.get(i)).getA() != null) {
                this.addLinesAndConvertToStrings(sparseFileContent, ((DiffContent)diffContent.get(i)).getA(), contentIdx);
                contentIdx += ((DiffContent)diffContent.get(i)).getA().size();
            }
            ++i;
        }
    }

    private void adaptLineContent_B(SparseFileContent sparseFileContent, DiffInfo diffInfo) {
        ArrayList<DiffContent> diffContent = diffInfo.getContent();
        int contentIdx = 0;
        int i = 0;
        while (i < diffContent.size()) {
            if (((DiffContent)diffContent.get(i)).getAb() != null) {
                this.addLinesAndConvertToStrings(sparseFileContent, ((DiffContent)diffContent.get(i)).getAb(), contentIdx);
                contentIdx += ((DiffContent)diffContent.get(i)).getAb().size();
            } else if (((DiffContent)diffContent.get(i)).getB() != null) {
                this.addLinesAndConvertToStrings(sparseFileContent, ((DiffContent)diffContent.get(i)).getB(), contentIdx);
                contentIdx += ((DiffContent)diffContent.get(i)).getB().size();
            }
            ++i;
        }
    }

    private void addLinesAndConvertToStrings(SparseFileContent sparseFileContent, ArrayList<String> ab, int idx) {
        for (String string : ab) {
            sparseFileContent.addLine(idx, string);
            ++idx;
        }
    }

    private CommitInfo retrieveCommitInfo(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        String commitQuery = String.format("/changes/%s/revisions/%s/commit", id.getParentKey().get(), id.get());
        return (CommitInfo)this.getRestClient().executeGetRestRequest(commitQuery, (Type)((Object)CommitInfo.class), monitor);
    }

    private Map<String, FileInfo> retrieveFileInfos(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        String commitQuery = String.format("/changes/%s/revisions/%s/files", id.getParentKey().get(), id.get());
        Type mapTypeToken = new TypeToken<Map<String, FileInfo>>(){}.getType();
        return (Map)this.getRestClient().executeGetRestRequest(commitQuery, mapTypeToken, monitor);
    }

    private AccountInfo retrieveAccountInfo(String accountId, IProgressMonitor monitor) throws GerritException {
        String accQuery = String.format("/accounts/%s", GerritClient212.encode(accountId));
        return (AccountInfo)this.getRestClient().executeGetRestRequest(accQuery, (Type)((Object)AccountInfo.class), monitor);
    }

    private DiffInfo retrieveDiffInfoNotBase(PatchSet.Id targetId, PatchSet.Id baseId, String fileName, IProgressMonitor monitor) throws GerritException {
        String query = String.format("/changes/%s/revisions/%s/files/%s/diff?base=%s", targetId.getParentKey().get(), targetId.get(), GerritClient212.encode(fileName), baseId.get());
        return (DiffInfo)this.getRestClient().executeGetRestRequest(query, (Type)((Object)DiffInfo.class), monitor);
    }

    private DiffInfo retrieveDiffInfoAgainstBase(PatchSet.Id targetId, String fileName, IProgressMonitor monitor) throws GerritException {
        String query = String.format("/changes/%s/revisions/%s/files/%s/diff", targetId.getParentKey().get(), targetId.get(), GerritClient212.encode(fileName));
        return (DiffInfo)this.getRestClient().executeGetRestRequest(query, (Type)((Object)DiffInfo.class), monitor);
    }

    private Map<String, List<CommentInfo>> retrieveRevisionComments(PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        String query = String.format("/changes/%s/revisions/%s/comments/", id.getParentKey().get(), id.get());
        Type mapTypeToken = new TypeToken<Map<String, List<CommentInfo>>>(){}.getType();
        return (Map)this.getRestClient().executeGetRestRequest(query, mapTypeToken, monitor);
    }

    private ConfigInfo retrieveProjectConfigs(String projectName, IProgressMonitor monitor) throws GerritException {
        String query = String.format("/projects/%s/config", GerritClient212.encode(projectName));
        return (ConfigInfo)this.getRestClient().executeGetRestRequest(query, (Type)((Object)ConfigInfo.class), monitor);
    }

    private Map<String, ProjectInfo> listProjects(IProgressMonitor monitor) throws GerritException {
        String query = String.format("/projects/?n=25", new Object[0]);
        Type mapTypeToken = new TypeToken<Map<String, ProjectInfo>>(){}.getType();
        return (Map)this.getRestClient().executeGetRestRequest(query, mapTypeToken, monitor);
    }

    private String retrieveParentProject(String projectName, IProgressMonitor monitor) throws GerritException {
        String query = String.format("/projects/%s/parent", GerritClient212.encode(projectName));
        return (String)this.getRestClient().executeGetRestRequest(query, (Type)((Object)String.class), monitor);
    }

    private ProjectAccessInfo listAccessRights(String projectName, IProgressMonitor monitor) throws GerritException {
        String query = String.format("/projects/%s/access", GerritClient212.encode(projectName));
        return (ProjectAccessInfo)this.getRestClient().executeGetRestRequest(query, (Type)((Object)ProjectAccessInfo.class), monitor);
    }

    private DiffPreferencesInfo retrieveDiffPrefInfo(IProgressMonitor monitor) throws GerritException {
        String query = String.format("/accounts/self/preferences.diff", new Object[0]);
        return (DiffPreferencesInfo)this.getRestClient().executeGetRestRequest(query, (Type)((Object)DiffPreferencesInfo.class), monitor);
    }

    private UserIdentity toUserIdentity(GitPersonalInfo info, AccountInfo accInfo, IProgressMonitor monitor) throws GerritException {
        UserIdentity userIdentity = new UserIdentity();
        userIdentity.setAccount(new Account.Id(accInfo.getId()));
        userIdentity.setEmail(info.getEmail());
        userIdentity.setName(info.getName());
        userIdentity.setTimeZone(info.getTimeZoneOffset());
        userIdentity.setDate(this.parseTimeStamp(info.getDate()));
        return userIdentity;
    }

    private Timestamp parseTimeStamp(String date) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
            Date parsedDate = dateFormat.parse(date);
            return new Timestamp(parsedDate.getTime());
        }
        catch (ParseException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", e.getMessage(), (Throwable)e));
            return null;
        }
    }
}

