/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util;

import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class URIUtils {
    private URIUtils() {
    }

    public static URI getResourceURI(IResource resource) {
        return URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
    }

    public static IResource getResource(URI resourceURI) {
        IWorkspaceRoot wsRoot;
        try {
            wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
        catch (RuntimeException e) {
            return null;
        }
        if (resourceURI.isPlatformResource()) {
            String wsRelativePath = resourceURI.toPlatformString(true);
            return wsRoot.findMember((IPath)new Path(wsRelativePath));
        }
        if (resourceURI.isFile() && !resourceURI.isRelative()) {
            try {
                IFile[] files = wsRoot.findFilesForLocationURI(new java.net.URI(resourceURI.toString()));
                if (files.length > 0) {
                    return files[0];
                }
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public static IFile getFile(URI uri) {
        IResource resource = URIUtils.getResource(uri);
        return resource instanceof IFile ? (IFile)resource : null;
    }

    public static void refresh(URI uri) {
        IFile file = URIUtils.getFile(uri);
        if (file != null) {
            try {
                file.getParent().refreshLocal(1, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

