/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl;

import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.clazz.ASTUtils;
import org.eclipse.jst.ws.jaxws.utils.internal.text.JaxWsUtilMessages;
import org.eclipse.jst.ws.jaxws.utils.resources.EditResourcesManager;
import org.eclipse.jst.ws.jaxws.utils.resources.FileUtils;
import org.eclipse.jst.ws.jaxws.utils.resources.IFileUtils;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class AnnotationUtils {
    private static AnnotationUtils utils = null;
    private final IFileUtils fileUtils = FileUtils.getInstance();

    public static AnnotationUtils getInstance() {
        if (utils == null) {
            utils = new AnnotationUtils();
        }
        return utils;
    }

    public IDocument getDocument(ICompilationUnit unit) throws CoreException {
        String source = unit.getBuffer().getContents();
        return new Document(source);
    }

    public void removeAnnotations(IJavaElement javaElement, Set<String> annotations, boolean deepRemove) throws AnnotationGeneratorException, MalformedTreeException, FileNotFoundException, CoreException, BadLocationException {
        ICompilationUnit declaringTypeCompUnit;
        IType declaringType;
        if (javaElement instanceof IType) {
            IMethod[] tmpMethods;
            int n;
            IType type = (IType)javaElement;
            ICompilationUnit cUnit = type.getCompilationUnit();
            String className = type.getElementName();
            CompilationUnit unit = ASTUtils.getInstance().createCompilationUnit(cUnit, null);
            AbstractTypeDeclaration typeDeclaration = ASTUtils.getInstance().getTypeDeclaration(className, unit);
            if (typeDeclaration == null) {
                throw new AnnotationGeneratorException("typeDeclaration should not be null", MessageFormat.format(JaxWsUtilMessages.AnnotationUtils_ParamShouldNotBeNullMsg, "typeDeclaration"));
            }
            this.removeTypeAnnotations(type, typeDeclaration, unit, cUnit, annotations);
            if (!deepRemove) {
                return;
            }
            IField[] tmpFields = type.getFields();
            if (tmpFields != null && tmpFields.length > 0) {
                IField[] iFieldArray = tmpFields;
                n = tmpFields.length;
                int n2 = 0;
                while (n2 < n) {
                    IField tmpField = iFieldArray[n2];
                    this.removeFieldAnnotations(tmpField, type, cUnit, annotations);
                    ++n2;
                }
            }
            if ((tmpMethods = type.getMethods()) != null && tmpMethods.length > 0) {
                IMethod[] iMethodArray = tmpMethods;
                int n3 = tmpMethods.length;
                n = 0;
                while (n < n3) {
                    IMethod tmpMethod = iMethodArray[n];
                    this.removeMethodAnnotations(tmpMethod, type, cUnit, annotations);
                    String[] stringArray = tmpMethod.getParameterNames();
                    int n4 = stringArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String paramName = stringArray[n5];
                        ITypeParameter typeParameter = tmpMethod.getTypeParameter(paramName);
                        this.removeParamAnnotations(typeParameter, type, cUnit, annotations, paramName);
                        ++n5;
                    }
                    ++n;
                }
            }
        }
        if (javaElement instanceof IField) {
            IField field = (IField)javaElement;
            declaringType = field.getDeclaringType();
            declaringTypeCompUnit = declaringType.getCompilationUnit();
            this.removeFieldAnnotations(field, declaringType, declaringTypeCompUnit, annotations);
        }
        if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            declaringType = method.getDeclaringType();
            declaringTypeCompUnit = declaringType.getCompilationUnit();
            this.removeMethodAnnotations(method, declaringType, declaringTypeCompUnit, annotations);
            if (!deepRemove) {
                return;
            }
            String[] stringArray = method.getParameterNames();
            int n = stringArray.length;
            int n6 = 0;
            while (n6 < n) {
                String paramName = stringArray[n6];
                ITypeParameter param = method.getTypeParameter(paramName);
                this.removeParamAnnotations(param, declaringType, declaringTypeCompUnit, annotations, paramName);
                ++n6;
            }
        }
        if (javaElement instanceof ITypeParameter) {
            ITypeParameter typeParameter = (ITypeParameter)javaElement;
            IMethod tmpMethod = (IMethod)typeParameter.getDeclaringMember();
            IType declaringType2 = tmpMethod.getDeclaringType();
            ICompilationUnit declaringTypeCompUnit2 = declaringType2.getCompilationUnit();
            this.removeParamAnnotations(typeParameter, declaringType2, declaringTypeCompUnit2, annotations, null);
        }
    }

    private void removeTypeAnnotations(IType type, AbstractTypeDeclaration typeDeclaration, CompilationUnit unit, ICompilationUnit cUnit, Set<String> annotationsSet) throws CoreException, MalformedTreeException, BadLocationException, FileNotFoundException, AnnotationGeneratorException {
        unit.recordModifications();
        if (this.removeAnnotations(typeDeclaration.modifiers(), annotationsSet)) {
            IDocument doc = AnnotationUtils.getInstance().getDocument(cUnit);
            TextEdit edit = unit.rewrite(doc, null);
            edit.apply(doc);
            this.saveContent(cUnit, doc);
        }
    }

    private void removeFieldAnnotations(IField field, IType declaringType, ICompilationUnit declaringTypeCompUnit, Set<String> annotationsSet) throws CoreException, MalformedTreeException, BadLocationException, FileNotFoundException, AnnotationGeneratorException {
        ICompilationUnit fcUnit = field.getCompilationUnit();
        String className = declaringType.getElementName();
        CompilationUnit fUnit = ASTUtils.getInstance().createCompilationUnit(fcUnit, null);
        AbstractTypeDeclaration fBodyDeclaration = ASTUtils.getInstance().getTypeDeclaration(className, fUnit);
        fBodyDeclaration = ASTUtils.getInstance().getFieldDeclaration(field, (TypeDeclaration)fBodyDeclaration);
        fUnit.recordModifications();
        if (this.removeAnnotations(fBodyDeclaration.modifiers(), annotationsSet)) {
            IDocument doc = this.getDocument(declaringTypeCompUnit);
            TextEdit edit = fUnit.rewrite(doc, null);
            edit.apply(doc);
            this.saveContent(declaringTypeCompUnit, doc);
        }
    }

    private void removeMethodAnnotations(IMethod method, IType declaringType, ICompilationUnit declaringTypeCompUnit, Set<String> annotationsSet) throws CoreException, MalformedTreeException, BadLocationException, FileNotFoundException, AnnotationGeneratorException {
        ICompilationUnit mcUnit = method.getCompilationUnit();
        String className = declaringType.getElementName();
        CompilationUnit mUnit = ASTUtils.getInstance().createCompilationUnit(mcUnit, null);
        AbstractTypeDeclaration mBodyDeclaration = ASTUtils.getInstance().getTypeDeclaration(className, mUnit);
        mBodyDeclaration = ASTUtils.getInstance().getMethodDeclaration(method, (TypeDeclaration)mBodyDeclaration);
        mUnit.recordModifications();
        if (this.removeAnnotations(mBodyDeclaration.modifiers(), annotationsSet)) {
            IDocument doc = this.getDocument(declaringTypeCompUnit);
            TextEdit edit = mUnit.rewrite(doc, null);
            edit.apply(doc);
            this.saveContent(declaringTypeCompUnit, doc);
        }
    }

    private void removeParamAnnotations(ITypeParameter param, IType declaringType, ICompilationUnit declaringTypeCompUnit, Set<String> annotationsSet, String paramName) throws CoreException, MalformedTreeException, BadLocationException, FileNotFoundException, AnnotationGeneratorException {
        IMethod tmpMethod = (IMethod)param.getDeclaringMember();
        String className = declaringType.getElementName();
        ICompilationUnit mcUnit = tmpMethod.getCompilationUnit();
        CompilationUnit mUnit = ASTUtils.getInstance().createCompilationUnit(mcUnit, null);
        AbstractTypeDeclaration mBodyDeclaration = ASTUtils.getInstance().getTypeDeclaration(className, mUnit);
        mBodyDeclaration = ASTUtils.getInstance().getMethodDeclaration(tmpMethod, (TypeDeclaration)mBodyDeclaration);
        mUnit.recordModifications();
        for (Object object : ((MethodDeclaration)mBodyDeclaration).parameters()) {
            if (!(object instanceof SingleVariableDeclaration)) continue;
            SingleVariableDeclaration svd = (SingleVariableDeclaration)object;
            if (paramName != null && !svd.getName().toString().equals(paramName) || !this.removeAnnotations(svd.modifiers(), annotationsSet)) continue;
            IDocument doc = this.getDocument(declaringTypeCompUnit);
            TextEdit edit = mUnit.rewrite(doc, null);
            edit.apply(doc);
            this.saveContent(declaringTypeCompUnit, doc);
        }
    }

    private void saveContent(ICompilationUnit cUnit, IDocument doc) throws FileNotFoundException, JavaModelException, AnnotationGeneratorException {
        IStatus status = new EditResourcesManager().setFileEditable((IFile)cUnit.getResource());
        if (status.getSeverity() != 0) {
            throw new AnnotationGeneratorException("Annotattion could not be stored, the file is not writable", JaxWsUtilMessages.AnnotationCannotBeStoredMsg);
        }
        this.fileUtils.setCompilationUnitContentAndSaveDirtyEditors(cUnit, doc.get(), true, null);
    }

    public void removeAnnotation(IJavaElement javaElement, String annotationName) throws AnnotationGeneratorException, FileNotFoundException, CoreException, BadLocationException {
        ICompilationUnit declaringTypeCompUnit;
        IType declaringType;
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            ICompilationUnit cUnit = type.getCompilationUnit();
            String className = type.getElementName();
            CompilationUnit unit = ASTUtils.getInstance().createCompilationUnit(cUnit, null);
            AbstractTypeDeclaration typeDeclaration = ASTUtils.getInstance().getTypeDeclaration(className, unit);
            if (typeDeclaration == null) {
                throw new AnnotationGeneratorException("typeDeclaration should not be null", MessageFormat.format(JaxWsUtilMessages.AnnotationUtils_ParamShouldNotBeNullMsg, "typeDeclaration"));
            }
            this.removeTypeAnnotation(type, typeDeclaration, unit, cUnit, annotationName);
        }
        if (javaElement instanceof IField) {
            IField field = (IField)javaElement;
            declaringType = field.getDeclaringType();
            declaringTypeCompUnit = declaringType.getCompilationUnit();
            this.removeFieldAnnotation(field, declaringType, declaringTypeCompUnit, annotationName);
        }
        if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            declaringType = method.getDeclaringType();
            declaringTypeCompUnit = declaringType.getCompilationUnit();
            this.removeMethodAnnotation(method, declaringType, declaringTypeCompUnit, annotationName);
        }
        if (javaElement instanceof ITypeParameter) {
            ITypeParameter typeParameter = (ITypeParameter)javaElement;
            IMethod tmpMethod = (IMethod)typeParameter.getDeclaringMember();
            IType declaringType2 = tmpMethod.getDeclaringType();
            ICompilationUnit declaringTypeCompUnit2 = declaringType2.getCompilationUnit();
            this.removeParamAnnotation(typeParameter, declaringType2, declaringTypeCompUnit2, annotationName);
        }
    }

    private void removeTypeAnnotation(IType type, AbstractTypeDeclaration typeDeclaration, CompilationUnit unit, ICompilationUnit cUnit, String annotationName) throws CoreException, MalformedTreeException, BadLocationException, FileNotFoundException, AnnotationGeneratorException {
        unit.recordModifications();
        if (this.removeAnnotation(typeDeclaration.modifiers(), annotationName)) {
            IDocument doc = AnnotationUtils.getInstance().getDocument(cUnit);
            TextEdit edit = unit.rewrite(doc, null);
            edit.apply(doc);
            this.saveContent(cUnit, doc);
        }
    }

    private void removeFieldAnnotation(IField field, IType declaringType, ICompilationUnit declaringTypeCompUnit, String annotationName) throws CoreException, MalformedTreeException, BadLocationException, FileNotFoundException, AnnotationGeneratorException {
        ICompilationUnit fcUnit = field.getCompilationUnit();
        String className = declaringType.getElementName();
        CompilationUnit fUnit = ASTUtils.getInstance().createCompilationUnit(fcUnit, null);
        AbstractTypeDeclaration fBodyDeclaration = ASTUtils.getInstance().getTypeDeclaration(className, fUnit);
        fBodyDeclaration = ASTUtils.getInstance().getFieldDeclaration(field, (TypeDeclaration)fBodyDeclaration);
        fUnit.recordModifications();
        if (this.removeAnnotation(fBodyDeclaration.modifiers(), annotationName)) {
            IDocument doc = this.getDocument(declaringTypeCompUnit);
            TextEdit edit = fUnit.rewrite(doc, null);
            edit.apply(doc);
            this.saveContent(declaringTypeCompUnit, doc);
        }
    }

    private void removeMethodAnnotation(IMethod method, IType declaringType, ICompilationUnit declaringTypeCompUnit, String annotationName) throws CoreException, MalformedTreeException, BadLocationException, FileNotFoundException, AnnotationGeneratorException {
        ICompilationUnit mcUnit = method.getCompilationUnit();
        String className = declaringType.getElementName();
        CompilationUnit mUnit = ASTUtils.getInstance().createCompilationUnit(mcUnit, null);
        AbstractTypeDeclaration mBodyDeclaration = ASTUtils.getInstance().getTypeDeclaration(className, mUnit);
        mBodyDeclaration = ASTUtils.getInstance().getMethodDeclaration(method, (TypeDeclaration)mBodyDeclaration);
        mUnit.recordModifications();
        if (this.removeAnnotation(mBodyDeclaration.modifiers(), annotationName)) {
            IDocument doc = this.getDocument(declaringTypeCompUnit);
            TextEdit edit = mUnit.rewrite(doc, null);
            edit.apply(doc);
            this.saveContent(declaringTypeCompUnit, doc);
        }
    }

    private void removeParamAnnotation(ITypeParameter param, IType declaringType, ICompilationUnit declaringTypeCompUnit, String annotationName) throws CoreException, MalformedTreeException, BadLocationException, FileNotFoundException, AnnotationGeneratorException {
        IMethod tmpMethod = (IMethod)param.getDeclaringMember();
        String className = declaringType.getElementName();
        ICompilationUnit mcUnit = tmpMethod.getCompilationUnit();
        className = tmpMethod.getParent().getElementName();
        CompilationUnit mUnit = ASTUtils.getInstance().createCompilationUnit(mcUnit, null);
        AbstractTypeDeclaration mBodyDeclaration = ASTUtils.getInstance().getTypeDeclaration(className, mUnit);
        mBodyDeclaration = ASTUtils.getInstance().getMethodDeclaration(tmpMethod, (TypeDeclaration)mBodyDeclaration);
        mUnit.recordModifications();
        for (Object object : ((MethodDeclaration)mBodyDeclaration).parameters()) {
            if (!(object instanceof SingleVariableDeclaration) || !this.removeAnnotation(((SingleVariableDeclaration)object).modifiers(), annotationName)) continue;
            IDocument doc = this.getDocument(declaringTypeCompUnit);
            TextEdit edit = mUnit.rewrite(doc, null);
            edit.apply(doc);
            this.saveContent(declaringTypeCompUnit, doc);
        }
    }

    private boolean removeAnnotation(List modifiers, String annotationName) {
        Annotation[] mAnnotations;
        Annotation[] annotationArray = mAnnotations = this.extractAnnotations(modifiers);
        int n = mAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation mAnnotation = annotationArray[n2];
            if (this.validateAnnotatation(mAnnotation, annotationName)) {
                modifiers.remove(mAnnotation);
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean removeAnnotations(List modifiers, Set<String> annotationsSet) {
        boolean changed = false;
        Annotation[] mAnnotations = this.extractAnnotations(modifiers);
        int mai = 0;
        while (mai < mAnnotations.length) {
            if (annotationsSet != null) {
                if (annotationsSet.contains(mAnnotations[mai].getTypeName().getFullyQualifiedName())) {
                    modifiers.remove(mAnnotations[mai]);
                    changed = true;
                }
            } else {
                modifiers.remove(mAnnotations[mai]);
                changed = true;
            }
            ++mai;
        }
        return changed;
    }

    private Annotation[] extractAnnotations(List modifiers) {
        Iterator iterator = modifiers.iterator();
        HashSet<Annotation> annotationsSet = new HashSet<Annotation>();
        while (iterator.hasNext()) {
            IExtendedModifier modif = (IExtendedModifier)iterator.next();
            if (!modif.isAnnotation()) continue;
            annotationsSet.add((Annotation)modif);
        }
        return annotationsSet.toArray(new Annotation[annotationsSet.size()]);
    }

    private boolean validateAnnotatation(Annotation mAnnotation, String annotationName) {
        String mAnnotationString = mAnnotation.toString();
        int index = mAnnotationString.indexOf("(");
        mAnnotationString = index == -1 ? mAnnotationString.trim() : mAnnotationString.substring(0, index).trim();
        return mAnnotationString.endsWith(annotationName);
    }
}

