/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.layout.FlowContext;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigureLayout;

public abstract class FlowFigure
extends Figure {
    private String _displayString;

    public void add(IFigure child, Object constraint, int index) {
        super.add(child, constraint, index);
        if (child instanceof FlowFigure) {
            FlowFigure ff = (FlowFigure)child;
            if (this.getLayoutManager() instanceof FlowContext) {
                ff.setOriginalFlowContext((FlowContext)this.getLayoutManager());
            } else {
                PDPlugin.getLogger(((Object)((Object)this)).getClass()).error("layout is not FlowContext", new Throwable("This exception is artificial so  we can get a stack trace"));
            }
        }
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
    }

    public abstract void postValidate();

    public void setBounds(Rectangle r) {
        if (this.getBounds().equals((Object)r)) {
            return;
        }
        this.erase();
        this.bounds.x = r.x;
        this.bounds.y = r.y;
        this.bounds.width = r.width;
        this.bounds.height = r.height;
        this.fireFigureMoved();
        this.repaint();
    }

    public void setOriginalFlowContext(FlowContext flowContext) {
        ((FlowFigureLayout)this.getLayoutManager()).setOriginalFlowContext(flowContext);
    }

    public String toString() {
        if (this._displayString == null) {
            return super.toString();
        }
        return String.valueOf(this._displayString) + " " + ((Object)((Object)this)).getClass().getName();
    }

    public FlowContext getFlowContext() {
        return ((FlowFigureLayout)this.getLayoutManager()).getFlowContext();
    }

    protected void paintChildren(Graphics graphics) {
        Rectangle clip = Rectangle.SINGLETON;
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (child.isVisible() && child.intersects(graphics.getClip(clip))) {
                child.paint(graphics);
                graphics.restoreState();
            }
            ++i;
        }
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty()) {
            return;
        }
        if (this.useLocalCoordinates()) {
            graphics.translate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
            graphics.pushState();
            this.paintChildren(graphics);
            graphics.popState();
            graphics.restoreState();
        } else {
            this.paintChildren(graphics);
        }
    }
}

