/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.jsf.common.internal.managedobject.IManagedObject;
import org.eclipse.jst.jsf.common.internal.policy.IIteratorPolicy;
import org.eclipse.jst.jsf.common.internal.policy.IdentifierOrderedIteratorPolicy;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.JSFCoreTraceOptions;
import org.eclipse.jst.jsf.designtime.internal.Messages;
import org.eclipse.jst.jsf.designtime.internal.view.model.AbstractTagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.CompositeTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.DefaultJSPTagResolver;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDNamespace;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TagIntrospectingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.UnresolvedJSPTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.persistence.PersistedDataTagStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry.LibraryOperation;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry.TLDRegistryPreferences;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry.TagIndexListener;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;

public final class TLDTagRegistry
extends AbstractTagRegistry
implements IManagedObject {
    private final IProject _project;
    private final Map<String, TLDNamespace> _nsResolved;
    private final CompositeTagResolvingStrategy<TLDElementDeclaration> _resolver;
    private boolean _hasBeenInitialized = false;
    private final ConcurrentLinkedQueue<LibraryOperation> _changeOperations = new ConcurrentLinkedQueue();
    private final Job _changeJob;
    private final PersistedDataTagStrategy _persistedTagStrategy;
    private TagIndexListener _tagIndexListener;
    private final TLDRegistryPreferences _prefs;
    private final MyPropertyListener _myPropertyListener;

    TLDTagRegistry(IProject project) {
        this._project = project;
        this._nsResolved = new HashMap<String, TLDNamespace>();
        this._prefs = new TLDRegistryPreferences(JSFCorePlugin.getDefault().getPreferenceStore());
        this._myPropertyListener = new MyPropertyListener();
        this._prefs.addListener(this._myPropertyListener);
        this._prefs.load();
        IdentifierOrderedIteratorPolicy<String> policy = this.getTagResolvingPolicy();
        this._resolver = new CompositeTagResolvingStrategy((IIteratorPolicy<String>)policy);
        this._resolver.addStrategy(new TagIntrospectingStrategy(this._project));
        this._resolver.addStrategy(new DefaultJSPTagResolver(this._project));
        this._resolver.addStrategy(new UnresolvedJSPTagResolvingStrategy());
        this._persistedTagStrategy = new PersistedDataTagStrategy(this._project);
        this._persistedTagStrategy.init();
        this._resolver.addStrategy(this._persistedTagStrategy);
        this._changeJob = new ChangeJob(project.getName());
    }

    private IdentifierOrderedIteratorPolicy<String> getTagResolvingPolicy() {
        List<String> prefOrdering = this._prefs.getEnabledIds();
        ArrayList<String> strategyOrdering = new ArrayList<String>(prefOrdering);
        strategyOrdering.add("org.eclipse.jst.jsf.designtime.UnresolvedJSPTagResolvingStrategy");
        IdentifierOrderedIteratorPolicy policy = new IdentifierOrderedIteratorPolicy(strategyOrdering);
        policy.setExcludeNonExplicitValues(true);
        return policy;
    }

    @Override
    protected final void doDispose() {
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
            JSFCoreTraceOptions.log("TLDTagRegistry: Disposing for project " + this._project.toString());
        }
        this.checkpoint();
        this._prefs.removeListener(this._myPropertyListener);
        this._prefs.dispose();
        this._nsResolved.clear();
        this._changeOperations.clear();
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
            JSFCoreTraceOptions.log("TLDTagRegistry: Done disposing registry for " + this._project.toString());
        }
    }

    @Override
    protected void cleanupPersistentState() {
    }

    public synchronized void checkpoint() {
        try {
            this._persistedTagStrategy.save(this._nsResolved);
        }
        catch (IOException e) {
            JSFCorePlugin.log(e, "Checkpointing JSP tags failed");
        }
        catch (ClassNotFoundException e) {
            JSFCorePlugin.log(e, "Checkpointing JSP tags failed");
        }
    }

    @Override
    protected Job getRefreshJob(final boolean flushCaches) {
        return new Job(String.valueOf(Messages.TLDTagRegistry_RefreshJob) + this._project.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
                    JSFCoreTraceOptions.log("TLDTagRegistry.refresh: start");
                }
                TLDTagRegistry tLDTagRegistry = TLDTagRegistry.this;
                synchronized (tLDTagRegistry) {
                    if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
                        JSFCoreTraceOptions.log("TLDTagRegistry.refresh: start");
                    }
                    ArrayList<TLDNamespace> namespaces = new ArrayList<TLDNamespace>(TLDTagRegistry.this._nsResolved.values());
                    if (flushCaches) {
                        TLDTagRegistry.this._persistedTagStrategy.clear();
                    } else {
                        TLDTagRegistry.this.checkpoint();
                    }
                    TLDTagRegistry.this._nsResolved.clear();
                    TLDTagRegistry.this.fireEvent(new ITagRegistry.TagRegistryChangeEvent(TLDTagRegistry.this, ITagRegistry.TagRegistryChangeEvent.EventType.REMOVED_NAMESPACE, namespaces));
                    TLDTagRegistry.this.initialize(true);
                    if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
                        JSFCoreTraceOptions.log("TLDTagRegistry.refresh: finished");
                    }
                    return Status.OK_STATUS;
                }
            }
        };
    }

    private void initialize(boolean fireEvent) {
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
            JSFCoreTraceOptions.log("TLDTagRegistry.initialize: start");
        }
        ITaglibRecord[] tldrecs = TaglibIndex.getAvailableTaglibRecords((IPath)this._project.getFullPath());
        ArrayList<TLDNamespace> affectedObjects = new ArrayList<TLDNamespace>();
        ITaglibRecord[] iTaglibRecordArray = tldrecs;
        int n = tldrecs.length;
        int n2 = 0;
        while (n2 < n) {
            ITaglibRecord tldrec = iTaglibRecordArray[n2];
            TLDNamespace ns = this.initialize(tldrec, fireEvent);
            if (ns != null) {
                affectedObjects.add(ns);
            }
            ++n2;
        }
        this._hasBeenInitialized = true;
        if (this._tagIndexListener == null) {
            if (JSFCoreTraceOptions.TRACE_TLDREGISTRYMANAGER) {
                JSFCoreTraceOptions.log("TLDRegistryManager: installing tag index listener due to create instance for " + this._project.toString());
            }
            this._tagIndexListener = new TagIndexListener(this);
            TaglibIndex.addTaglibIndexListener((ITaglibIndexListener)this._tagIndexListener);
        }
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
            JSFCoreTraceOptions.log("TLDTagRegistry.initialize: finished");
        }
    }

    TLDNamespace initialize(ITaglibRecord tagRecord, boolean fireEvent) {
        if (tagRecord.getRecordType() == 4) {
            CMDocumentFactoryTLD factory;
            TLDDocument doc;
            if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_CHANGES) {
                JSFCoreTraceOptions.log("TLDTagRegistry.initialize_TagRecord: Initializing new tld record: " + tagRecord.toString());
            }
            long startTime = 0L;
            if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_PERF) {
                startTime = System.nanoTime();
            }
            if ((doc = (TLDDocument)(factory = new CMDocumentFactoryTLD()).createCMDocument(tagRecord)) != null) {
                TLDNamespace ns = new TLDNamespace(doc, this._resolver);
                this._nsResolved.put(doc.getUri(), ns);
                if (fireEvent) {
                    this.fireEvent(new ITagRegistry.TagRegistryChangeEvent(this, ITagRegistry.TagRegistryChangeEvent.EventType.ADDED_NAMESPACE, Collections.singletonList(ns)));
                }
                if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_PERF) {
                    System.out.printf("Time to update namespace %s was %d\n", ns.getNSUri(), System.nanoTime() - startTime);
                }
                return ns;
            }
        } else if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_CHANGES) {
            JSFCoreTraceOptions.log("TLDTagRegistry.initialize_TagRecord: Skipping tag record for " + tagRecord.toString());
        }
        return null;
    }

    void remove(ITaglibRecord tagRecord) {
        String uri = tagRecord.getDescriptor().getURI();
        TLDNamespace ns = this._nsResolved.remove(uri);
        if (ns != null) {
            this.fireEvent(new ITagRegistry.TagRegistryChangeEvent(this, ITagRegistry.TagRegistryChangeEvent.EventType.REMOVED_NAMESPACE, Collections.singletonList(ns)));
        }
    }

    @Override
    public final synchronized Collection<? extends Namespace> getAllTagLibraries() {
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
            JSFCoreTraceOptions.log("TLDTagRegistry.getAllTagLibraries: start");
        }
        long startTime = 0L;
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_PERF) {
            startTime = System.nanoTime();
        }
        if (!this._hasBeenInitialized) {
            this.initialize(false);
        }
        HashSet<TLDNamespace> allTagLibraries = new HashSet<TLDNamespace>();
        allTagLibraries.addAll(this._nsResolved.values());
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY_PERF) {
            System.out.println("Time to getAllTagLibraries for JSP: " + (System.nanoTime() - startTime));
        }
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
            JSFCoreTraceOptions.log("TLDTagRegistry.getAllTagLibraries: finished");
        }
        return allTagLibraries;
    }

    @Override
    public final synchronized Namespace getTagLibrary(String uri) {
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
            JSFCoreTraceOptions.log("TLDTagRegistry.getTagLibrary: start uri=" + uri);
        }
        if (!this._hasBeenInitialized) {
            this.initialize(false);
        }
        Namespace ns = this._nsResolved.get(uri);
        if (JSFCoreTraceOptions.TRACE_JSPTAGREGISTRY) {
            JSFCoreTraceOptions.log("TLDTagRegistry.getTagLibrary: finished, result=" + ns.toString());
        }
        return ns;
    }

    public String toString() {
        return String.format("TLDRegistry for project %s, isDisposed=%s, hasBeenInitialized=%s, numberOfNamespace=%d", this._project.toString(), this.isDisposed(), this._hasBeenInitialized, this._nsResolved.size());
    }

    void addLibraryOperation(LibraryOperation operation) {
        this._changeOperations.add(operation);
        this._changeJob.schedule();
    }

    private class ChangeJob
    extends Job {
        private int _rescheduleTime;

        public ChangeJob(String projectName) {
            super(String.valueOf(Messages.TLDTagRegistry_UpdateJob) + projectName);
            this._rescheduleTime = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            TLDTagRegistry tLDTagRegistry = TLDTagRegistry.this;
            synchronized (tLDTagRegistry) {
                this._rescheduleTime = -1;
                LibraryOperation operation = null;
                MultiStatus multiStatus = new MultiStatus("org.eclipse.jst.jsf.core", 0, "Result of change job", new Throwable());
                while ((operation = TLDTagRegistry.this._changeOperations.poll()) != null) {
                    this._rescheduleTime = 10000;
                    operation.run();
                    multiStatus.add(operation.getResult());
                }
                if (this._rescheduleTime >= 0 && !monitor.isCanceled()) {
                    this.schedule(this._rescheduleTime);
                }
                return multiStatus;
            }
        }
    }

    private class MyPropertyListener
    extends TLDRegistryPreferences.PropertyListener {
        private MyPropertyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void strategyOrderChanged() {
            TLDTagRegistry tLDTagRegistry = TLDTagRegistry.this;
            synchronized (tLDTagRegistry) {
                TLDTagRegistry.this._prefs.load();
                IdentifierOrderedIteratorPolicy<String> policy = TLDTagRegistry.this.getTagResolvingPolicy();
                TLDTagRegistry.this._resolver.setPolicy((IIteratorPolicy)policy);
            }
        }
    }
}

