/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.runtime.internal.model.ViewObject;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.ActionSourceInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.ActionSourceInfo2;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.EditableValueHolderInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.INamingContainerInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.ValueHolderInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentFactory;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterDecorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.Decorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorDecorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IComponentPropertyHandler;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IComponentTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IConverterTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagAttributeHandler;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IValidatorTagElement;
import org.eclipse.jst.jsf.common.util.JDTBeanProperty;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.view.ComponentConstructionData;
import org.eclipse.jst.jsf.designtime.internal.view.DTComponentIntrospector;
import org.eclipse.jst.jsf.designtime.internal.view.ViewObjectConstructionStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewObjectMappingService;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.ICustomViewMapper;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.CustomViewMapperExtensionLoader;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLViewObjectConstructionStrategy
extends ViewObjectConstructionStrategy<Element> {
    private static final String GENERATED_ID = "_generatedId";
    private final ComponentConstructionData _constructionData;
    private final XMLViewDefnAdapter _adapter;
    private final XMLViewObjectMappingService _mappingService;

    public XMLViewObjectConstructionStrategy(XMLViewDefnAdapter adapter, ComponentConstructionData constructionData, XMLViewObjectMappingService mappingService) {
        if (adapter == null || constructionData == null) {
            throw new IllegalArgumentException("adapter and constructionData must not be null");
        }
        this._constructionData = constructionData;
        this._adapter = adapter;
        this._mappingService = mappingService;
    }

    @Override
    public ViewObject createViewObject(Element element, ITagElement tagElement) {
        try {
            if (tagElement instanceof IComponentTagElement) {
                String id = null;
                ComponentTypeInfo typeInfo = ((IComponentTagElement)tagElement).getComponent();
                if (!"javax.faces.ViewRoot".equals(typeInfo.getComponentType())) {
                    id = this.calculateId(element, this._constructionData);
                }
                return this.findBestComponent(tagElement.getUri(), element, id, (IComponentTagElement)tagElement);
            }
            if (tagElement instanceof IConverterTagElement) {
                ConverterTypeInfo typeInfo = ((IConverterTagElement)tagElement).getConverter();
                ComponentInfo parent = this._constructionData.getParent();
                if ((parent = this.findFirstParent("javax.faces.component.ValueHolder", parent)) != null) {
                    parent.addDecorator((Decorator)new ConverterDecorator(parent, typeInfo), ComponentFactory.CONVERTER);
                }
            } else if (tagElement instanceof IValidatorTagElement) {
                ValidatorTypeInfo typeInfo = ((IValidatorTagElement)tagElement).getValidator();
                ComponentInfo parent = this._constructionData.getParent();
                if ((parent = this.findFirstParent("javax.faces.component.EditableValueHolder", parent)) != null) {
                    parent.addDecorator((Decorator)new ValidatorDecorator(parent, typeInfo), ComponentFactory.VALIDATOR);
                }
            }
        }
        catch (Exception e) {
            JSFCorePlugin.log(e, "Error constructing view object");
        }
        return null;
    }

    private ComponentInfo findFirstParent(String matchingType, ComponentInfo start) {
        ComponentInfo parent = start;
        while (parent != null && parent.getComponentTypeInfo() != null && !parent.getComponentTypeInfo().isInstanceOf(matchingType)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private ComponentInfo findBestComponent(String uri, Element srcElement, String id, IComponentTagElement tagElement) {
        ComponentTypeInfo typeInfo;
        Object bestComponent = null;
        ComponentInfo parent = this._constructionData.getParent();
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        HashMap<String, String> attributeToPropertyMap = new HashMap<String, String>();
        this.populateInitMap(uri, initMap, srcElement, tagElement, attributeToPropertyMap);
        if (initMap.get("id") == null) {
            initMap.put("id", id);
        }
        bestComponent = (typeInfo = tagElement.getComponent()).isInstanceOf("javax.faces.component.UIInput") ? ComponentFactory.createUIInputInfo((ComponentInfo)parent, (ComponentTypeInfo)typeInfo, initMap) : (typeInfo.isInstanceOf("javax.faces.component.UIOutput") ? ComponentFactory.createUIOutputInfo((ComponentInfo)parent, (ComponentTypeInfo)typeInfo, initMap) : (typeInfo.isInstanceOf("javax.faces.component.UICommand") ? ComponentFactory.createUICommandInfo((ComponentInfo)parent, (ComponentTypeInfo)typeInfo, initMap) : (typeInfo.isInstanceOf("javax.faces.component.UIData") ? ComponentFactory.createUIDataInfo((ComponentInfo)parent, (ComponentTypeInfo)typeInfo, initMap) : (typeInfo.isInstanceOf("javax.faces.component.UIForm") ? ComponentFactory.createUIFormInfo((ComponentInfo)parent, (ComponentTypeInfo)typeInfo, initMap) : ComponentFactory.createComponentInfo((ComponentInfo)this._constructionData.getParent(), (ComponentTypeInfo)typeInfo, initMap)))));
        this.addTypeAdapters((ComponentInfo)bestComponent);
        this.maybeMapXMLToViewObjects((ViewObject)bestComponent, srcElement, attributeToPropertyMap, this._constructionData.getDocument());
        this.maybeUpdateViewObject((ComponentInfo)bestComponent, srcElement, (ITagElement)tagElement);
        return bestComponent;
    }

    private void populateInitMap(String uri, Map<String, Object> initMap, Element srcElement, IComponentTagElement tagElement, Map<String, String> attributeToPropertyMap) {
        ComponentTypeInfo typeInfo = tagElement.getComponent();
        Map attributeHandlers = tagElement.getAttributeHandlers();
        NamedNodeMap nodeMap = srcElement.getAttributes();
        if (nodeMap != null && attributeHandlers != null) {
            Map<String, JDTBeanProperty> properties = null;
            int i = 0;
            while (i < nodeMap.getLength()) {
                ITagAttributeHandler attrHandler;
                String name;
                Attr attr = (Attr)nodeMap.item(i);
                if (attr != null && (name = attr.getLocalName()) != null && (attrHandler = (ITagAttributeHandler)attributeHandlers.get(name)) instanceof IComponentPropertyHandler) {
                    if (properties == null) {
                        properties = DTComponentIntrospector.getBeanProperties(typeInfo, this._constructionData.getProject());
                    }
                    this.mapComponentProperty(uri, srcElement, properties, (IComponentPropertyHandler)attrHandler, attr, name, initMap, attributeHandlers, attributeToPropertyMap);
                }
                ++i;
            }
        }
    }

    private void mapComponentProperty(String uri, Element srcElement, Map<String, JDTBeanProperty> properties, IComponentPropertyHandler attrHandler, Attr attr, String attributeName, Map initMap, Map<String, ITagAttributeHandler> attributeHandlers, Map<String, String> attributeToPropertyMap) {
        String propertyName = attrHandler.getPropertyName();
        if (properties.containsKey(propertyName)) {
            ICustomViewMapper.PropertyMapping mapping;
            String id = attrHandler.getCustomHandler();
            ICustomViewMapper mapper = null;
            if (id != null && (mapper = CustomViewMapperExtensionLoader.getCustomViewMapper(id)) != null && (mapping = mapper.mapToComponentProperty(uri, srcElement, attr)) != null) {
                initMap.put(mapping.getName(), mapping.getProperty());
                attributeToPropertyMap.put(attributeName, mapping.getName());
                return;
            }
            String value = attr.getValue();
            if (value != null) {
                Object convertedValue = this.convertFromString(value, properties.get(propertyName));
                initMap.put(propertyName, convertedValue);
            }
            attributeToPropertyMap.put(attributeName, propertyName);
        }
    }

    private void maybeMapXMLToViewObjects(ViewObject mappedObject, Element node, Map<String, String> attributeToProperties, IDocument document) {
        if (mappedObject != null && this._mappingService != null) {
            String uri = this._adapter.getNamespace(node, document);
            IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(document, (Node)node);
            XMLViewObjectMappingService.ElementData elementData = XMLViewObjectMappingService.createElementData(uri, node.getLocalName(), context, attributeToProperties);
            if (elementData != null) {
                this._mappingService.createMapping(elementData, mappedObject);
            }
        }
    }

    private void maybeUpdateViewObject(ComponentInfo bestComponent, Element srcElement, ITagElement tagElement) {
        if (srcElement.getAttributes() == null) {
            return;
        }
        int i = 0;
        while (i < srcElement.getAttributes().getLength()) {
            ITagAttributeHandler handler;
            Attr attr = (Attr)srcElement.getAttributes().item(i);
            Map attributeHandlers = tagElement.getAttributeHandlers();
            if (attributeHandlers != null && (handler = (ITagAttributeHandler)attributeHandlers.get(attr.getLocalName())) != null) {
                String id = handler.getCustomHandler();
                ICustomViewMapper mapper = null;
                if (id != null && (mapper = CustomViewMapperExtensionLoader.getCustomViewMapper(id)) != null) {
                    mapper.doAttributeActions(bestComponent, srcElement, attr);
                }
            }
            ++i;
        }
    }

    private Object convertFromString(String convertValue, JDTBeanProperty ofThisType) {
        String signature = ofThisType.getTypeSignature();
        Object result = null;
        switch (Signature.getTypeSignatureKind((String)signature)) {
            case 2: {
                result = this.convertFromBaseType(convertValue, signature);
                break;
            }
            case 1: {
                if ("Ljava.lang.String;".equals(signature)) {
                    result = convertValue;
                    break;
                }
                if (!"Ljava.lang.Object;".equals(signature)) break;
                result = convertValue;
            }
        }
        return result;
    }

    private Object convertFromBaseType(String convertValue, String signature) {
        if ("Z".equals(signature)) {
            return Boolean.valueOf(convertValue);
        }
        if ("I".equals(signature) || "B".equals(signature) || "S".equals(signature)) {
            try {
                return Integer.valueOf(convertValue);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if ("J".equals(convertValue)) {
            try {
                return Long.valueOf(convertValue);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private void addTypeAdapters(ComponentInfo component) {
        String[] interfaceNames = component.getComponentTypeInfo().getInterfaces();
        HashSet<String> interfaceNameSets = new HashSet<String>();
        String[] stringArray = interfaceNames;
        int n = interfaceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            interfaceNameSets.add(interfaceName);
            ++n2;
        }
        if (interfaceNameSets.contains("javax.faces.component.ActionSource")) {
            if (interfaceNameSets.contains("javax.faces.component.ActionSource2") && component.getAdapter(ComponentFactory.ACTION_SOURCE2) == null) {
                component.addAdapter(ComponentFactory.ACTION_SOURCE2, (Object)new ActionSourceInfo2(null, null, false, null));
            }
            if (component.getAdapter(ComponentFactory.ACTION_SOURCE) == null) {
                component.addAdapter(ComponentFactory.ACTION_SOURCE, (Object)new ActionSourceInfo(null, null, false));
            }
        }
        if (interfaceNameSets.contains("javax.faces.component.ValueHolder")) {
            if (interfaceNameSets.contains("javax.faces.component.EditableValueHolder") && component.getAdapter(ComponentFactory.EDITABLE_VALUE_HOLDER) == null) {
                component.addAdapter(ComponentFactory.EDITABLE_VALUE_HOLDER, (Object)new EditableValueHolderInfo(null, null, null, false, false, true, false, null, null, null));
            }
            if (component.getAdapter(ComponentFactory.VALUE_HOLDER) == null) {
                component.addAdapter(ComponentFactory.VALUE_HOLDER, (Object)new ValueHolderInfo(null, null, null));
            }
        }
        if (interfaceNameSets.contains("javax.faces.component.NamingContainer") && component.getAdapter(ComponentFactory.NAMING_CONTAINER) == null) {
            component.addAdapter(ComponentFactory.NAMING_CONTAINER, (Object)INamingContainerInfo.ADAPTER);
        }
    }

    protected String calculateId(Element element, ComponentConstructionData constructionData) {
        String id = this._adapter.getId(element);
        if (id != null) {
            return id;
        }
        String prefix = this._adapter.getGeneratedIdPrefix();
        return String.valueOf(prefix != null ? prefix : GENERATED_ID) + constructionData.increment();
    }

    public final ComponentConstructionData getConstructionData() {
        return this._constructionData;
    }
}

