/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ConvertMemberTypeDescriptor;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.manipulation.BindingLabelProviderCore;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public final class MoveInnerToTopRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_FIELD = "field";
    private static final String ATTRIBUTE_MANDATORY = "mandatory";
    private static final String ATTRIBUTE_POSSIBLE = "possible";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_FIELD_NAME = "fieldName";
    private static final String ATTRIBUTE_PARAMETER_NAME = "parameterName";
    private TextChangeManager fChangeManager;
    private CodeGenerationSettings fCodeGenerationSettings;
    private boolean fCreateInstanceField;
    private String fEnclosingInstanceFieldName;
    private boolean fIsInstanceFieldCreationMandatory;
    private boolean fIsInstanceFieldCreationPossible;
    private boolean fMarkInstanceFieldAsFinal;
    private String fNameForEnclosingInstanceConstructorParameter;
    private String fNewSourceOfInputType;
    private CompilationUnitRewrite fSourceRewrite;
    private Collection<IBinding> fStaticImports;
    private IType fType;
    private String fQualifiedTypeName;
    private Collection<ITypeBinding> fTypeImports;

    private static void addTypeParameters(CompilationUnit unit, IType type, Map<String, ITypeBinding> map) throws JavaModelException {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)type);
        Assert.isNotNull(map);
        AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(type, unit);
        if (declaration instanceof TypeDeclaration) {
            ITypeBinding binding = null;
            TypeParameter parameter2 = null;
            for (TypeParameter parameter2 : ((TypeDeclaration)declaration).typeParameters()) {
                binding = parameter2.resolveBinding();
                if (binding == null || map.containsKey(binding.getKey())) continue;
                map.put(binding.getKey(), binding);
            }
            IType declaring = type.getDeclaringType();
            if (declaring != null && !JdtFlags.isStatic((IMember)type)) {
                MoveInnerToTopRefactoring.addTypeParameters(unit, declaring, map);
            }
        }
    }

    private static boolean containsNonStatic(MethodInvocation[] invocations) {
        MethodInvocation[] methodInvocationArray = invocations;
        int n = invocations.length;
        int n2 = 0;
        while (n2 < n) {
            MethodInvocation invocation = methodInvocationArray[n2];
            if (!MoveInnerToTopRefactoring.isStatic(invocation)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean containsNonStatic(SimpleName[] fieldNames) {
        SimpleName[] simpleNameArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName fieldName = simpleNameArray[n2];
            if (!MoveInnerToTopRefactoring.isStaticFieldName(fieldName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean containsStatusEntry(RefactoringStatus status, RefactoringStatusEntry other) {
        return status.getEntries((entry1, entry2) -> entry1.getMessage().compareTo(entry2.getMessage()), other).length > 0;
    }

    private static AbstractTypeDeclaration findTypeDeclaration(IType enclosing, AbstractTypeDeclaration[] declarations) {
        String typeName = enclosing.getElementName();
        AbstractTypeDeclaration[] abstractTypeDeclarationArray = declarations;
        int n = declarations.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTypeDeclaration declaration = abstractTypeDeclarationArray[n2];
            if (declaration.getName().getIdentifier().equals(typeName)) {
                return declaration;
            }
            ++n2;
        }
        return null;
    }

    private static AbstractTypeDeclaration findTypeDeclaration(IType type, CompilationUnit unit) {
        List<IType> types = MoveInnerToTopRefactoring.getDeclaringTypes(type);
        types.add(type);
        AbstractTypeDeclaration[] declarations = unit.types().toArray(new AbstractTypeDeclaration[unit.types().size()]);
        AbstractTypeDeclaration declaration = null;
        for (IType enclosing : types) {
            declaration = MoveInnerToTopRefactoring.findTypeDeclaration(enclosing, declarations);
            Assert.isNotNull((Object)declaration);
            declarations = MoveInnerToTopRefactoring.getAbstractTypeDeclarations(declaration);
        }
        Assert.isNotNull(declaration);
        return declaration;
    }

    public static AbstractTypeDeclaration[] getAbstractTypeDeclarations(AbstractTypeDeclaration declaration) {
        int typeCount = 0;
        ListIterator iterator = declaration.bodyDeclarations().listIterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof AbstractTypeDeclaration)) continue;
            ++typeCount;
        }
        AbstractTypeDeclaration[] declarations = new AbstractTypeDeclaration[typeCount];
        int next = 0;
        ListIterator iterator2 = declaration.bodyDeclarations().listIterator();
        while (iterator2.hasNext()) {
            BodyDeclaration object = (BodyDeclaration)iterator2.next();
            if (!(object instanceof AbstractTypeDeclaration)) continue;
            declarations[next++] = (AbstractTypeDeclaration)object;
        }
        return declarations;
    }

    private static List<IType> getDeclaringTypes(IType type) {
        IType declaringType = type.getDeclaringType();
        if (declaringType == null) {
            return new ArrayList<IType>(0);
        }
        List<IType> result = MoveInnerToTopRefactoring.getDeclaringTypes(declaringType);
        result.add(declaringType);
        return result;
    }

    private static String[] getFieldNames(IType type) {
        try {
            IField[] fields = type.getFields();
            ArrayList<String> result = new ArrayList<String>(fields.length);
            IField[] iFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                result.add(field.getElementName());
                ++n2;
            }
            return result.toArray(new String[result.size()]);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static Set<ICompilationUnit> getMergedSet(Set<ICompilationUnit> s1, Set<ICompilationUnit> s2) {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(s1);
        result.addAll(s2);
        return result;
    }

    private static String[] getParameterNamesOfAllConstructors(IType type) throws JavaModelException {
        HashSet<String> result = new HashSet<String>();
        IMethod[] iMethodArray = JavaElementUtil.getAllConstructors(type);
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod constructor = iMethodArray[n2];
            result.addAll(Arrays.asList(constructor.getParameterNames()));
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private static ASTNode[] getReferenceNodesIn(CompilationUnit cuNode, Map<ICompilationUnit, SearchMatch[]> references, ICompilationUnit cu) {
        SearchMatch[] results = references.get(cu);
        if (results == null) {
            return new ASTNode[0];
        }
        return ASTNodeSearchUtil.getAstNodes(results, cuNode);
    }

    private static boolean isCorrespondingTypeBinding(ITypeBinding binding, IType type) {
        if (binding == null) {
            return false;
        }
        return Bindings.getFullyQualifiedName(binding).equals(JavaElementUtil.createSignature((IMember)type));
    }

    private static boolean isStatic(MethodInvocation invocation) {
        IMethodBinding methodBinding = invocation.resolveMethodBinding();
        if (methodBinding == null) {
            return false;
        }
        return JdtFlags.isStatic(methodBinding);
    }

    private static boolean isStaticFieldName(SimpleName name) {
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        if (!variableBinding.isField()) {
            return false;
        }
        return JdtFlags.isStatic(variableBinding);
    }

    public MoveInnerToTopRefactoring(IType type, CodeGenerationSettings settings) throws JavaModelException {
        this.fType = type;
        this.fCodeGenerationSettings = settings;
        this.fMarkInstanceFieldAsFinal = true;
        if (this.fType != null) {
            this.initialize();
        }
    }

    public MoveInnerToTopRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this.fType = null;
        this.fCodeGenerationSettings = null;
        this.fMarkInstanceFieldAsFinal = true;
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    private void initialize() throws JavaModelException {
        this.fQualifiedTypeName = JavaModelUtil.concatenateName(this.fType.getPackageFragment().getElementName(), this.fType.getElementName());
        this.fEnclosingInstanceFieldName = this.getInitialNameForEnclosingInstanceField();
        this.fSourceRewrite = new CompilationUnitRewrite(this.fType.getCompilationUnit());
        this.fIsInstanceFieldCreationPossible = !JdtFlags.isStatic((IMember)this.fType) && !this.fType.isAnnotation() && !this.fType.isEnum() && (this.fType.getDeclaringType() != null || JavaElementUtil.isMainType(this.fType));
        this.fCreateInstanceField = this.fIsInstanceFieldCreationMandatory = this.fIsInstanceFieldCreationPossible && this.isInstanceFieldCreationMandatory();
    }

    private void addEnclosingInstanceDeclaration(AbstractTypeDeclaration declaration, ASTRewrite rewrite) throws CoreException {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        AST ast = declaration.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
        FieldDeclaration newField = ast.newFieldDeclaration(fragment);
        newField.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.getEnclosingInstanceAccessModifiers()));
        newField.setType(this.createEnclosingType(ast));
        String comment = CodeGeneration.getFieldComment(this.fType.getCompilationUnit(), declaration.getName().getIdentifier(), this.fEnclosingInstanceFieldName, StubUtility.getLineDelimiterUsed(this.fType.getJavaProject()));
        if (comment != null && comment.length() > 0) {
            Javadoc doc = (Javadoc)rewrite.createStringPlaceholder(comment, 29);
            newField.setJavadoc(doc);
        }
        rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertFirst((ASTNode)newField, null);
    }

    private void addEnclosingInstanceTypeParameters(ITypeBinding[] parameters, AbstractTypeDeclaration declaration, ASTRewrite rewrite) {
        Assert.isNotNull((Object)parameters);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        if (declaration instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)declaration;
            List existing = type.typeParameters();
            HashSet<String> names = new HashSet<String>();
            TypeParameter parameter2 = null;
            for (TypeParameter parameter2 : existing) {
                names.add(parameter2.getName().getIdentifier());
            }
            ListRewrite rewriter = rewrite.getListRewrite((ASTNode)type, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            ITypeBinding[] iTypeBindingArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding parameter2 = iTypeBindingArray[n2];
                String name = parameter2.getName();
                if (!names.contains(name)) {
                    parameter2 = type.getAST().newTypeParameter();
                    parameter2.setName(type.getAST().newSimpleName(name));
                    rewriter.insertLast((ASTNode)parameter2, null);
                }
                ++n2;
            }
        }
    }

    private void addImportsToTargetUnit(ICompilationUnit targetUnit, IProgressMonitor monitor) throws CoreException, JavaModelException {
        monitor.beginTask("", 2);
        try {
            ImportRewrite rewrite = StubUtility.createImportRewrite(targetUnit, true);
            if (this.fTypeImports != null) {
                ITypeBinding type2 = null;
                for (ITypeBinding type2 : this.fTypeImports) {
                    rewrite.addImport(type2);
                }
            }
            if (this.fStaticImports != null) {
                IBinding binding2 = null;
                for (IBinding binding2 : this.fStaticImports) {
                    rewrite.addStaticImport(binding2);
                }
            }
            this.fTypeImports = null;
            this.fStaticImports = null;
            TextEdit edits = rewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            JavaModelUtil.applyEdit(targetUnit, edits, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    private void addInheritedTypeQualifications(AbstractTypeDeclaration declaration, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)targetRewrite);
        CompilationUnit unit = (CompilationUnit)declaration.getRoot();
        ITypeBinding binding = declaration.resolveBinding();
        if (binding != null) {
            Type type2 = null;
            if (declaration instanceof TypeDeclaration && (type2 = ((TypeDeclaration)declaration).getSuperclassType()) != null && unit.findDeclaringNode((IBinding)binding) != null) {
                this.addTypeQualification(type2, targetRewrite, group);
            }
            List types = null;
            if (declaration instanceof TypeDeclaration) {
                types = ((TypeDeclaration)declaration).superInterfaceTypes();
            } else if (declaration instanceof EnumDeclaration) {
                types = ((EnumDeclaration)declaration).superInterfaceTypes();
            }
            if (types != null) {
                for (Type type2 : types) {
                    if (unit.findDeclaringNode((IBinding)type2.resolveBinding()) == null) continue;
                    this.addTypeQualification(type2, targetRewrite, group);
                }
            }
        }
    }

    private void addParameterToConstructor(ASTRewrite rewrite, MethodDeclaration declaration) throws JavaModelException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)declaration);
        AST ast = declaration.getAST();
        String name = this.getNameForEnclosingInstanceConstructorParameter();
        SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
        variable.setType(this.createEnclosingType(ast));
        variable.setName(ast.newSimpleName(name));
        rewrite.getListRewrite((ASTNode)declaration, MethodDeclaration.PARAMETERS_PROPERTY).insertFirst((ASTNode)variable, null);
        JavadocUtil.addParamJavadoc(name, declaration, rewrite, this.fType.getJavaProject(), null);
    }

    private void addSimpleTypeQualification(CompilationUnitRewrite targetRewrite, ITypeBinding declaring, SimpleType simpleType, TextEditGroup group) {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaring);
        Assert.isNotNull((Object)simpleType);
        AST ast = targetRewrite.getRoot().getAST();
        if (!(simpleType.getName() instanceof QualifiedName)) {
            targetRewrite.getASTRewrite().replace((ASTNode)simpleType, (ASTNode)ast.newQualifiedType(targetRewrite.getImportRewrite().addImport(declaring, ast), ast.newSimpleName(simpleType.getName().getFullyQualifiedName())), group);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)simpleType);
        }
    }

    private void addTypeQualification(Type type, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        ITypeBinding declaring;
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)targetRewrite);
        ITypeBinding binding = type.resolveBinding();
        if (!type.isVar() && binding != null && (declaring = binding.getDeclaringClass()) != null) {
            ParameterizedType parameterizedType;
            Type rawType;
            if (type instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)type;
                this.addSimpleTypeQualification(targetRewrite, declaring, simpleType, group);
            } else if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getType()) instanceof SimpleType) {
                this.addSimpleTypeQualification(targetRewrite, declaring, (SimpleType)rawType, group);
            }
        }
    }

    private RefactoringStatus checkConstructorParameterNames() {
        RefactoringStatus result = new RefactoringStatus();
        CompilationUnit cuNode = new RefactoringASTParser(IASTSharedValues.SHARED_AST_LEVEL).parse((ITypeRoot)this.fType.getCompilationUnit(), false);
        MethodDeclaration[] methodDeclarationArray = this.getConstructorDeclarationNodes(MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, cuNode));
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration constructor = methodDeclarationArray[n2];
            for (SingleVariableDeclaration param : constructor.parameters()) {
                if (!this.fEnclosingInstanceFieldName.equals(param.getName().getIdentifier())) continue;
                Object[] keys = new String[]{BasicElementLabels.getJavaElementName(param.getName().getIdentifier()), BasicElementLabels.getJavaElementName(this.fType.getElementName())};
                String msg = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_name_used, keys);
                result.addError(msg, JavaStatusContext.create((ITypeRoot)this.fType.getCompilationUnit(), (ASTNode)param));
            }
            ++n2;
        }
        return result;
    }

    public RefactoringStatus checkEnclosingInstanceName(String name) {
        if (!this.fCreateInstanceField) {
            return new RefactoringStatus();
        }
        RefactoringStatus result = Checks.checkFieldName(name, (IJavaElement)this.fType);
        if (!Checks.startsWithLowerCase(name)) {
            result.addWarning(RefactoringCoreMessages.MoveInnerToTopRefactoring_names_start_lowercase);
        }
        if (this.fType.getField(name).exists()) {
            Object[] keys = new String[]{BasicElementLabels.getJavaElementName(name), BasicElementLabels.getJavaElementName(this.fType.getElementName())};
            String msg = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_already_declared, keys);
            result.addError(msg, JavaStatusContext.create((IMember)this.fType.getField(name)));
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        try {
            RefactoringStatus result = new RefactoringStatus();
            if (JdtFlags.isStatic((IMember)this.fType)) {
                result.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
            }
            String newCUName = JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName());
            if (this.fType.getPackageFragment().getCompilationUnit(newCUName).exists()) {
                String message = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_compilation_Unit_exists, new String[]{BasicElementLabels.getResourceName(newCUName), JavaElementLabelsCore.getElementLabel((IJavaElement)this.fType.getPackageFragment(), 0x200009L)});
                result.addFatalError(message);
            }
            result.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
            result.merge(Checks.checkCompilationUnitName(newCUName, (IJavaElement)this.fType));
            result.merge(this.checkConstructorParameterNames());
            result.merge(this.checkTypeNameInPackage());
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getValidationContext(), pm));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    private RefactoringStatus checkTypeNameInPackage() throws JavaModelException {
        IType type = Checks.findTypeInPackage(this.fType.getPackageFragment(), this.fType.getElementName());
        if (type == null || !type.exists() || this.fType.equals(type)) {
            return null;
        }
        String message = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_type_exists, new String[]{BasicElementLabels.getJavaElementName(this.fType.getElementName()), JavaElementLabelsCore.getElementLabel((IJavaElement)this.fType.getPackageFragment(), 0x200009L)});
        return RefactoringStatus.createErrorStatus((String)message);
    }

    private Expression createAccessExpressionToEnclosingInstanceFieldText(ASTNode node, IBinding binding, AbstractTypeDeclaration declaration) {
        if (Modifier.isStatic((int)binding.getModifiers())) {
            return node.getAST().newName(this.fType.getDeclaringType().getTypeQualifiedName('.'));
        }
        if (this.isInAnonymousTypeInsideInputType(node, declaration) || this.isInLocalTypeInsideInputType(node, declaration) || this.isInNonStaticMemberTypeInsideInputType(node, declaration)) {
            return this.createQualifiedReadAccessExpressionForEnclosingInstance(node.getAST());
        }
        return this.createReadAccessExpressionForEnclosingInstance(node.getAST());
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        boolean enclosing;
        monitor.beginTask(RefactoringCoreMessages.MoveInnerToTopRefactoring_creating_change, 1);
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fType.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String description = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fType.getElementName()));
        String header = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_descriptor_description, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)this.fType, 2235681801344L), JavaElementLabelsCore.getElementLabel(this.fType.getParent(), 2235681801344L)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_original_pattern, JavaElementLabelsCore.getElementLabel((IJavaElement)this.fType, 2235681801344L)));
        boolean bl = enclosing = this.fEnclosingInstanceFieldName != null && !"".equals(this.fEnclosingInstanceFieldName);
        if (enclosing) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_field_pattern, BasicElementLabels.getJavaElementName(this.fEnclosingInstanceFieldName)));
        }
        if (this.fNameForEnclosingInstanceConstructorParameter != null && !"".equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_parameter_pattern, BasicElementLabels.getJavaElementName(this.fNameForEnclosingInstanceConstructorParameter)));
        }
        if (enclosing && this.fMarkInstanceFieldAsFinal) {
            comment.addSetting(RefactoringCoreMessages.MoveInnerToTopRefactoring_declare_final);
        }
        ConvertMemberTypeDescriptor descriptor = RefactoringSignatureDescriptorFactory.createConvertMemberTypeDescriptor(project, description, comment.asString(), arguments, 786438);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fType));
        if (enclosing) {
            arguments.put(ATTRIBUTE_FIELD_NAME, this.fEnclosingInstanceFieldName);
        }
        if (this.fNameForEnclosingInstanceConstructorParameter != null && !"".equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            arguments.put(ATTRIBUTE_PARAMETER_NAME, this.fNameForEnclosingInstanceConstructorParameter);
        }
        arguments.put(ATTRIBUTE_FIELD, Boolean.toString(this.fCreateInstanceField));
        arguments.put(ATTRIBUTE_FINAL, Boolean.toString(this.fMarkInstanceFieldAsFinal));
        arguments.put(ATTRIBUTE_POSSIBLE, Boolean.toString(this.fIsInstanceFieldCreationPossible));
        arguments.put(ATTRIBUTE_MANDATORY, Boolean.toString(this.fIsInstanceFieldCreationMandatory));
        DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.MoveInnerToTopRefactoring_move_to_Top);
        result.addAll((Change[])this.fChangeManager.getAllChanges());
        result.add(this.createCompilationUnitForMovedType((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        return result;
    }

    private TextChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        TextChangeManager manager = new TextChangeManager();
        try {
            monitor.beginTask(RefactoringCoreMessages.MoveInnerToTopRefactoring_creating_preview, 4);
            HashMap<ICompilationUnit, CompilationUnitRewrite> rewrites = new HashMap<ICompilationUnit, CompilationUnitRewrite>(2);
            this.fSourceRewrite.clearASTAndImportRewrites();
            rewrites.put(this.fSourceRewrite.getCu(), this.fSourceRewrite);
            MemberVisibilityAdjustor adjustor = new MemberVisibilityAdjustor((IJavaElement)this.fType.getPackageFragment(), (IMember)this.fType);
            adjustor.setRewrites(rewrites);
            adjustor.setVisibilitySeverity(2);
            adjustor.setFailureSeverity(2);
            adjustor.setStatus(status);
            adjustor.adjustVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            LinkedHashMap<String, ITypeBinding> parameters = new LinkedHashMap<String, ITypeBinding>();
            MoveInnerToTopRefactoring.addTypeParameters(this.fSourceRewrite.getRoot(), this.fType, parameters);
            ITypeBinding[] bindings = new ITypeBinding[parameters.size()];
            parameters.values().toArray(bindings);
            Map<ICompilationUnit, SearchMatch[]> typeReferences = this.createTypeReferencesMapping((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
            Map<Object, Object> constructorReferences = null;
            constructorReferences = JdtFlags.isStatic((IMember)this.fType) ? new HashMap(0) : this.createConstructorReferencesMapping((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
            if (this.fCreateInstanceField) {
                IType type = this.fType;
                Modifier.ModifierKeyword keyword = null;
                while ((type = type.getDeclaringType()) != null) {
                    if (adjustor.getAdjustments().containsKey(type) || !Modifier.isPrivate((int)type.getFlags())) continue;
                    adjustor.getAdjustments().put((IMember)type, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)type, keyword, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning, new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)type), MemberVisibilityAdjustor.getLabel(keyword)}), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)type.getCompilationUnit(), type.getSourceRange()))));
                }
            }
            monitor.worked(1);
            ICompilationUnit inputCU = this.fType.getCompilationUnit();
            for (ICompilationUnit unit : MoveInnerToTopRefactoring.getMergedSet(typeReferences.keySet(), constructorReferences.keySet())) {
                CompilationUnitRewrite targetRewrite = this.getCompilationUnitRewrite(unit);
                this.createCompilationUnitRewrite(bindings, targetRewrite, typeReferences, constructorReferences, adjustor.getAdjustments().containsKey(this.fType), inputCU, unit, false, status, monitor);
                if (unit.equals(inputCU)) {
                    try {
                        adjustor.setStatus(new RefactoringStatus());
                        adjustor.rewriteVisibility(targetRewrite.getCu(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    finally {
                        adjustor.setStatus(status);
                    }
                    this.fNewSourceOfInputType = this.createNewSource(targetRewrite, unit);
                    targetRewrite.clearASTAndImportRewrites();
                    this.createCompilationUnitRewrite(bindings, targetRewrite, typeReferences, constructorReferences, adjustor.getAdjustments().containsKey(this.fType), inputCU, unit, true, status, monitor);
                }
                adjustor.rewriteVisibility(targetRewrite.getCu(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                manager.manage(unit, (TextChange)targetRewrite.createChange(true));
            }
            if (this.fNewSourceOfInputType == null) {
                this.fNewSourceOfInputType = this.createNewSource(this.fSourceRewrite, inputCU);
            }
        }
        finally {
            monitor.done();
        }
        return manager;
    }

    private Change createCompilationUnitForMovedType(IProgressMonitor pm) throws CoreException {
        ICompilationUnit newCuWC = null;
        try {
            newCuWC = this.fType.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName())).getWorkingCopy(null);
            String source = this.createSourceForNewCu(newCuWC, pm);
            CreateCompilationUnitChange createCompilationUnitChange = new CreateCompilationUnitChange(this.fType.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(this.fType.getCompilationUnit(), this.fType.getElementName())), source, null);
            return createCompilationUnitChange;
        }
        finally {
            if (newCuWC != null) {
                newCuWC.discardWorkingCopy();
            }
        }
    }

    private void createCompilationUnitRewrite(ITypeBinding[] parameters, CompilationUnitRewrite targetRewrite, Map<ICompilationUnit, SearchMatch[]> typeReferences, Map<ICompilationUnit, SearchMatch[]> constructorReferences, boolean visibilityWasAdjusted, ICompilationUnit sourceUnit, ICompilationUnit targetUnit, boolean remove, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        ASTNode reference;
        Assert.isNotNull((Object)parameters);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull(typeReferences);
        Assert.isNotNull(constructorReferences);
        Assert.isNotNull((Object)sourceUnit);
        Assert.isNotNull((Object)targetUnit);
        CompilationUnit root = targetRewrite.getRoot();
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        if (targetUnit.equals(sourceUnit)) {
            AbstractTypeDeclaration declaration = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, root);
            TextEditGroup qualifierGroup = this.fSourceRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_qualifier);
            ITypeBinding binding = declaration.resolveBinding();
            if (!remove) {
                if (!JdtFlags.isStatic((IMember)this.fType) && this.fCreateInstanceField) {
                    if (JavaElementUtil.getAllConstructors(this.fType).length == 0) {
                        this.createConstructor(declaration, rewrite);
                    } else {
                        this.modifyConstructors(declaration, rewrite);
                    }
                    this.addInheritedTypeQualifications(declaration, targetRewrite, qualifierGroup);
                    this.addEnclosingInstanceDeclaration(declaration, rewrite);
                }
                this.fTypeImports = new HashSet<ITypeBinding>();
                this.fStaticImports = new HashSet<IBinding>();
                ImportRewriteUtil.collectImports(this.fType.getJavaProject(), (ASTNode)declaration, this.fTypeImports, this.fStaticImports, false);
                this.handleParametrizedTypeImports(this.fTypeImports);
                this.removeEnclosingTypeImports(binding);
            }
            this.addEnclosingInstanceTypeParameters(parameters, declaration, rewrite);
            this.modifyAccessToEnclosingInstance(targetRewrite, declaration, monitor);
            if (binding != null) {
                this.modifyInterfaceMemberModifiers(binding);
                ITypeBinding declaring = binding.getDeclaringClass();
                if (declaring != null) {
                    declaration.accept((ASTVisitor)new TypeReferenceQualifier(binding, null));
                }
            }
            TextEditGroup groupMove = targetRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_label);
            if (remove) {
                rewrite.remove((ASTNode)declaration, groupMove);
                targetRewrite.getImportRemover().registerRemovedNode((ASTNode)declaration);
            } else {
                int newFlags = JdtFlags.clearFlag(8, declaration.getModifiers());
                if (!visibilityWasAdjusted && (Modifier.isPrivate((int)declaration.getModifiers()) || Modifier.isProtected((int)declaration.getModifiers()))) {
                    newFlags = JdtFlags.clearFlag(6, newFlags);
                    RefactoringStatusEntry entry = new RefactoringStatusEntry(2, Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_visibility_type_warning, new String[]{BindingLabelProviderCore.getBindingLabel((IBinding)binding, 2235681801344L)}), JavaStatusContext.create((ITypeRoot)this.fSourceRewrite.getCu()));
                    if (!MoveInnerToTopRefactoring.containsStatusEntry(status, entry)) {
                        status.addEntry(entry);
                    }
                }
                ModifierRewrite.create(rewrite, (ASTNode)declaration).setModifiers(newFlags, groupMove);
            }
        }
        ASTNode[] aSTNodeArray = MoveInnerToTopRefactoring.getReferenceNodesIn(root, typeReferences, targetUnit);
        int n = aSTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            reference = aSTNodeArray[n2];
            this.updateTypeReference(parameters, reference, targetRewrite, targetUnit);
            ++n2;
        }
        aSTNodeArray = MoveInnerToTopRefactoring.getReferenceNodesIn(root, constructorReferences, targetUnit);
        n = aSTNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            reference = aSTNodeArray[n2];
            this.updateConstructorReference(parameters, reference, targetRewrite, targetUnit);
            ++n2;
        }
    }

    private void removeEnclosingTypeImports(ITypeBinding binding) {
        if (binding != null && this.fTypeImports != null) {
            Iterator<ITypeBinding> iterator = this.fTypeImports.iterator();
            block0: while (iterator.hasNext()) {
                ITypeBinding typeBinding;
                ITypeBinding parentBinding = typeBinding = iterator.next();
                while (parentBinding != null) {
                    if (parentBinding == binding) {
                        iterator.remove();
                        continue block0;
                    }
                    parentBinding = parentBinding.getDeclaringClass();
                }
            }
        }
    }

    private void handleParametrizedTypeImports(Collection<ITypeBinding> imports) {
        if (imports != null) {
            Iterator<ITypeBinding> iterator = imports.iterator();
            HashSet<ITypeBinding> additionalTypeImports = new HashSet<ITypeBinding>();
            while (iterator.hasNext()) {
                ITypeBinding typeBinding = iterator.next();
                if (!typeBinding.isParameterizedType()) continue;
                this.addParametrizedTypeArgumentImports(additionalTypeImports, typeBinding);
                iterator.remove();
            }
            imports.addAll(additionalTypeImports);
        }
    }

    private void addParametrizedTypeArgumentImports(Collection<ITypeBinding> importsList, ITypeBinding typeBinding) {
        if (importsList != null && typeBinding != null && typeBinding.isParameterizedType()) {
            ITypeBinding basicType = typeBinding.getTypeDeclaration();
            ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
            importsList.add(basicType);
            ITypeBinding[] iTypeBindingArray = typeArguments;
            int n = typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding typeArgument = iTypeBindingArray[n2];
                if (typeArgument.isParameterizedType()) {
                    this.addParametrizedTypeArgumentImports(importsList, typeArgument);
                } else {
                    importsList.add(typeArgument);
                }
                ++n2;
            }
        }
    }

    private void createConstructor(AbstractTypeDeclaration declaration, ASTRewrite rewrite) throws CoreException {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        AST ast = declaration.getAST();
        MethodDeclaration constructor = ast.newMethodDeclaration();
        constructor.setConstructor(true);
        constructor.setName(ast.newSimpleName(declaration.getName().getIdentifier()));
        String comment = CodeGeneration.getMethodComment(this.fType.getCompilationUnit(), this.fType.getElementName(), this.fType.getElementName(), this.getNewConstructorParameterNames(), new String[0], null, null, StubUtility.getLineDelimiterUsed(this.fType.getJavaProject()));
        if (comment != null && comment.length() > 0) {
            Javadoc doc = (Javadoc)rewrite.createStringPlaceholder(comment, 29);
            constructor.setJavadoc(doc);
        }
        if (this.fCreateInstanceField) {
            SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
            String name = this.getNameForEnclosingInstanceConstructorParameter();
            variable.setName(ast.newSimpleName(name));
            variable.setType(this.createEnclosingType(ast));
            constructor.parameters().add(variable);
            Block body = ast.newBlock();
            Assignment assignment = ast.newAssignment();
            if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
                assignment.setLeftHandSide((Expression)access);
            } else {
                assignment.setLeftHandSide((Expression)ast.newSimpleName(this.fEnclosingInstanceFieldName));
            }
            assignment.setRightHandSide((Expression)ast.newSimpleName(name));
            ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
            body.statements().add(statement);
            constructor.setBody(body);
        } else {
            constructor.setBody(ast.newBlock());
        }
        rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertFirst((ASTNode)constructor, null);
    }

    private Map<ICompilationUnit, SearchMatch[]> createConstructorReferencesMapping(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        HashMap<ICompilationUnit, SearchMatch[]> result = new HashMap<ICompilationUnit, SearchMatch[]>();
        SearchResultGroup[] searchResultGroupArray = ConstructorReferenceFinder.getConstructorReferences(this.fType, pm, status);
        int n = searchResultGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup group = searchResultGroupArray[n2];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.put(cu, group.getSearchResults());
            }
            ++n2;
        }
        return result;
    }

    private Expression createEnclosingInstanceCreationString(ASTNode node, ICompilationUnit cu) throws JavaModelException {
        Assert.isTrue((node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        Assert.isNotNull((Object)cu);
        Expression expression = null;
        expression = node instanceof ClassInstanceCreation ? ((ClassInstanceCreation)node).getExpression() : ((SuperConstructorInvocation)node).getExpression();
        AST ast = node.getAST();
        if (expression != null) {
            return expression;
        }
        if (JdtFlags.isStatic((IMember)this.fType)) {
            return null;
        }
        if (this.isInsideSubclassOfDeclaringType(node)) {
            return ast.newThisExpression();
        }
        if (node.getStartPosition() >= this.fType.getSourceRange().getOffset() && ASTNodes.getExclusiveEnd(node) <= this.fType.getSourceRange().getOffset() + this.fType.getSourceRange().getLength()) {
            if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
                return access;
            }
            return ast.newSimpleName(this.fEnclosingInstanceFieldName);
        }
        if (this.isInsideTypeNestedInDeclaringType(node)) {
            ThisExpression qualified = ast.newThisExpression();
            qualified.setQualifier((Name)ast.newSimpleName(this.fType.getDeclaringType().getElementName()));
            return qualified;
        }
        return null;
    }

    private Type createEnclosingType(AST ast) throws JavaModelException {
        Assert.isNotNull((Object)ast);
        ITypeParameter[] parameters = this.fType.getDeclaringType().getTypeParameters();
        Type type = ASTNodeFactory.newType(ast, this.fType.getDeclaringType().getTypeQualifiedName('.'));
        if (parameters.length > 0) {
            ParameterizedType parameterized = ast.newParameterizedType(type);
            ITypeParameter[] iTypeParameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeParameter parameter = iTypeParameterArray[n2];
                parameterized.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameter.getElementName())));
                ++n2;
            }
            return parameterized;
        }
        return type;
    }

    private String createNewSource(CompilationUnitRewrite targetRewrite, ICompilationUnit unit) throws CoreException, JavaModelException {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)unit);
        CompilationUnitChange change = targetRewrite.createChange(true);
        if (change == null) {
            change = new CompilationUnitChange("", unit);
        }
        String source = change.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        parser.setProject(this.fType.getJavaProject());
        parser.setResolveBindings(false);
        parser.setSource(source.toCharArray());
        AbstractTypeDeclaration declaration = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, (CompilationUnit)parser.createAST(null));
        TargetSourceRangeComputer.SourceRange sourceRange = new TargetSourceRangeComputer().computeSourceRange((ASTNode)declaration);
        return source.substring(sourceRange.getStartPosition(), sourceRange.getStartPosition() + sourceRange.getLength());
    }

    private Expression createQualifiedReadAccessExpressionForEnclosingInstance(AST ast) {
        ThisExpression expression = ast.newThisExpression();
        expression.setQualifier(ast.newName(new String[]{this.fType.getElementName()}));
        FieldAccess access = ast.newFieldAccess();
        access.setExpression((Expression)expression);
        access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
        return access;
    }

    private Expression createReadAccessExpressionForEnclosingInstance(AST ast) {
        if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            FieldAccess access = ast.newFieldAccess();
            access.setExpression((Expression)ast.newThisExpression());
            access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
            return access;
        }
        return ast.newSimpleName(this.fEnclosingInstanceFieldName);
    }

    private String createSourceForNewCu(ICompilationUnit unit, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)monitor);
        try {
            String content;
            monitor.beginTask("", 2);
            String separator = StubUtility.getLineDelimiterUsed(this.fType.getJavaProject());
            String block = this.getAlignedSourceBlock(unit, this.fNewSourceOfInputType);
            String fileComment = null;
            if (StubUtility.doAddComments(unit.getJavaProject())) {
                fileComment = CodeGeneration.getFileComment(unit, separator);
            }
            if ((content = CodeGeneration.getCompilationUnitContent(unit, fileComment, null, block, separator)) == null) {
                StringBuilder buffer = new StringBuilder();
                if (!this.fType.getPackageFragment().isDefaultPackage()) {
                    buffer.append("package ").append(this.fType.getPackageFragment().getElementName()).append(';');
                }
                buffer.append(separator).append(separator);
                buffer.append(block);
                content = buffer.toString();
            }
            unit.getBuffer().setContents(content);
            this.addImportsToTargetUnit(unit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
        return unit.getSource();
    }

    private Map<ICompilationUnit, SearchMatch[]> createTypeReferencesMapping(IProgressMonitor pm, RefactoringStatus status) throws JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fType, (int)3, (int)24);
        if (pattern == null) {
            return Map.of();
        }
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(pattern);
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaElement)this.fType));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        HashMap<ICompilationUnit, SearchMatch[]> result = new HashMap<ICompilationUnit, SearchMatch[]>();
        SearchResultGroup[] searchResultGroupArray = (SearchResultGroup[])engine.getResults();
        int n = searchResultGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchResultGroup group = searchResultGroupArray[n2];
            ICompilationUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.put(cu, group.getSearchResults());
            }
            ++n2;
        }
        return result;
    }

    private String getAlignedSourceBlock(ICompilationUnit unit, String block) {
        Assert.isNotNull((Object)block);
        String[] lines = Strings.convertIntoLines(block);
        Strings.trimIndentation(lines, unit, false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed(this.fType.getJavaProject()));
    }

    private CompilationUnitRewrite getCompilationUnitRewrite(ICompilationUnit unit) {
        Assert.isNotNull((Object)unit);
        if (unit.equals(this.fType.getCompilationUnit())) {
            return this.fSourceRewrite;
        }
        return new CompilationUnitRewrite(unit);
    }

    private MethodDeclaration[] getConstructorDeclarationNodes(AbstractTypeDeclaration declaration) {
        if (declaration instanceof TypeDeclaration) {
            ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(2);
            MethodDeclaration[] methodDeclarationArray = ((TypeDeclaration)declaration).getMethods();
            int n = methodDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration declaration2 = methodDeclarationArray[n2];
                if (declaration2.isConstructor()) {
                    result.add(declaration2);
                }
                ++n2;
            }
            return result.toArray(new MethodDeclaration[result.size()]);
        }
        return new MethodDeclaration[0];
    }

    public boolean getCreateInstanceField() {
        return this.fCreateInstanceField;
    }

    private int getEnclosingInstanceAccessModifiers() {
        if (this.fMarkInstanceFieldAsFinal) {
            return 18;
        }
        return 2;
    }

    public String getEnclosingInstanceName() {
        return this.fEnclosingInstanceFieldName;
    }

    private String getInitialNameForEnclosingInstanceField() {
        IType enclosingType = this.fType.getDeclaringType();
        if (enclosingType == null) {
            return "";
        }
        String[] suggestedNames = StubUtility.getFieldNameSuggestions(this.fType.getDeclaringType(), this.getEnclosingInstanceAccessModifiers(), MoveInnerToTopRefactoring.getFieldNames(this.fType));
        if (suggestedNames.length > 0) {
            return suggestedNames[0];
        }
        String name = enclosingType.getElementName();
        if (name.isEmpty()) {
            return "";
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public IType getInputType() {
        return this.fType;
    }

    public String getName() {
        return RefactoringCoreMessages.MoveInnerToTopRefactoring_name;
    }

    private String getNameForEnclosingInstanceConstructorParameter() throws JavaModelException {
        if (this.fNameForEnclosingInstanceConstructorParameter != null) {
            return this.fNameForEnclosingInstanceConstructorParameter;
        }
        String[] suggestedNames = StubUtility.getArgumentNameSuggestions(this.fType.getDeclaringType(), MoveInnerToTopRefactoring.getParameterNamesOfAllConstructors(this.fType));
        this.fNameForEnclosingInstanceConstructorParameter = suggestedNames.length > 0 ? suggestedNames[0] : this.fEnclosingInstanceFieldName;
        return this.fNameForEnclosingInstanceConstructorParameter;
    }

    private String[] getNewConstructorParameterNames() throws JavaModelException {
        if (!this.fCreateInstanceField) {
            return new String[0];
        }
        return new String[]{this.getNameForEnclosingInstanceConstructorParameter()};
    }

    private ASTNode getNewQualifiedNameNode(ITypeBinding[] parameters, Name name) {
        AST ast = name.getAST();
        boolean raw = false;
        ITypeBinding binding = name.resolveTypeBinding();
        if (binding != null && binding.isRawType()) {
            raw = true;
        }
        if (parameters != null && parameters.length > 0 && !raw) {
            ParameterizedType type = ast.newParameterizedType((Type)ast.newSimpleType(ast.newName(this.fQualifiedTypeName)));
            ITypeBinding[] iTypeBindingArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding parameter = iTypeBindingArray[n2];
                type.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameter.getName())));
                ++n2;
            }
            return type;
        }
        return ast.newName(this.fQualifiedTypeName);
    }

    private ASTNode getNewUnqualifiedTypeNode(ITypeBinding[] parameters, Name name) {
        AST ast = name.getAST();
        boolean raw = false;
        ITypeBinding binding = name.resolveTypeBinding();
        if (binding != null && binding.isRawType()) {
            raw = true;
        }
        if (parameters != null && parameters.length > 0 && !raw) {
            ParameterizedType type = ast.newParameterizedType((Type)ast.newSimpleType((Name)ast.newSimpleName(this.fType.getElementName())));
            ITypeBinding[] iTypeBindingArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding parameter = iTypeBindingArray[n2];
                type.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameter.getName())));
                ++n2;
            }
            return type;
        }
        return ast.newSimpleType((Name)ast.newSimpleName(this.fType.getElementName()));
    }

    private boolean insertExpressionAsParameter(ClassInstanceCreation cic, ASTRewrite rewrite, ICompilationUnit cu, TextEditGroup group) throws JavaModelException {
        Expression expression = this.createEnclosingInstanceCreationString((ASTNode)cic, cu);
        if (expression == null) {
            return false;
        }
        rewrite.getListRewrite((ASTNode)cic, ClassInstanceCreation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)expression, group);
        return true;
    }

    private boolean insertExpressionAsParameter(SuperConstructorInvocation sci, ASTRewrite rewrite, ICompilationUnit cu, TextEditGroup group) throws JavaModelException {
        Expression expression = this.createEnclosingInstanceCreationString((ASTNode)sci, cu);
        if (expression == null) {
            return false;
        }
        rewrite.getListRewrite((ASTNode)sci, SuperConstructorInvocation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)expression, group);
        return true;
    }

    public boolean isCreatingInstanceFieldMandatory() {
        return this.fIsInstanceFieldCreationMandatory;
    }

    public boolean isCreatingInstanceFieldPossible() {
        return this.fIsInstanceFieldCreationPossible;
    }

    private boolean isInAnonymousTypeInsideInputType(ASTNode node, AbstractTypeDeclaration declaration) {
        AnonymousClassDeclaration anonymous = ASTNodes.getParent(node, AnonymousClassDeclaration.class);
        return anonymous != null && ASTNodes.isParent((ASTNode)anonymous, (ASTNode)declaration);
    }

    private boolean isInLocalTypeInsideInputType(ASTNode node, AbstractTypeDeclaration declaration) {
        TypeDeclarationStatement statement = ASTNodes.getParent(node, TypeDeclarationStatement.class);
        return statement != null && ASTNodes.isParent((ASTNode)statement, (ASTNode)declaration);
    }

    private boolean isInNonStaticMemberTypeInsideInputType(ASTNode node, AbstractTypeDeclaration declaration) {
        AbstractTypeDeclaration nested = ASTNodes.getParent(node, AbstractTypeDeclaration.class);
        return nested != null && !declaration.equals((Object)nested) && !Modifier.isStatic((int)nested.getFlags()) && ASTNodes.isParent((ASTNode)nested, (ASTNode)declaration);
    }

    private boolean isInsideSubclassOfDeclaringType(ASTNode node) {
        boolean isAnonymous;
        Assert.isTrue((node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        AbstractTypeDeclaration declaration = ASTNodes.getParent(node, AbstractTypeDeclaration.class);
        Assert.isNotNull((Object)declaration);
        AnonymousClassDeclaration anonymous = ASTNodes.getParent(node, AnonymousClassDeclaration.class);
        boolean bl = isAnonymous = anonymous != null && ASTNodes.isParent((ASTNode)anonymous, (ASTNode)declaration);
        if (isAnonymous) {
            return anonymous != null && this.isSubclassBindingOfEnclosingType(anonymous.resolveBinding());
        }
        return this.isSubclassBindingOfEnclosingType(declaration.resolveBinding());
    }

    private boolean isInsideTypeNestedInDeclaringType(ASTNode node) {
        Assert.isTrue((node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        AbstractTypeDeclaration declaration = ASTNodes.getParent(node, AbstractTypeDeclaration.class);
        Assert.isNotNull((Object)declaration);
        ITypeBinding enclosing = declaration.resolveBinding();
        while (enclosing != null) {
            if (MoveInnerToTopRefactoring.isCorrespondingTypeBinding(enclosing, this.fType.getDeclaringType())) {
                return true;
            }
            enclosing = enclosing.getDeclaringClass();
        }
        return false;
    }

    private boolean isInstanceFieldCreationMandatory() {
        AbstractTypeDeclaration typeDeclaration = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, this.fSourceRewrite.getRoot());
        ITypeBinding typeBinding = typeDeclaration.resolveBinding();
        if (typeBinding == null || Modifier.isStatic((int)typeBinding.getModifiers())) {
            return false;
        }
        MemberAccessNodeCollector collector = new MemberAccessNodeCollector(typeBinding);
        typeDeclaration.accept((ASTVisitor)collector);
        return MoveInnerToTopRefactoring.containsNonStatic(collector.getMethodInvocations()) || MoveInnerToTopRefactoring.containsNonStatic(collector.getSimpleFieldNames());
    }

    public boolean isInstanceFieldMarkedFinal() {
        return this.fMarkInstanceFieldAsFinal;
    }

    private boolean isSubclassBindingOfEnclosingType(ITypeBinding binding) {
        while (binding != null) {
            if (MoveInnerToTopRefactoring.isCorrespondingTypeBinding(binding, this.fType.getDeclaringType())) {
                return true;
            }
            binding = binding.getSuperclass();
        }
        return false;
    }

    private void modifyAccessToEnclosingInstance(CompilationUnitRewrite targetRewrite, AbstractTypeDeclaration declaration, IProgressMonitor monitor) {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)monitor);
        ITypeBinding typeBinding = declaration.resolveBinding();
        if (typeBinding == null) {
            return;
        }
        MemberAccessNodeCollector collector = new MemberAccessNodeCollector(typeBinding);
        declaration.accept((ASTVisitor)collector);
        this.modifyAccessToMethodsFromEnclosingInstance(targetRewrite, collector.getMethodInvocations(), declaration);
        this.modifyAccessToFieldsFromEnclosingInstance(targetRewrite, collector.getSimpleFieldNames(), declaration);
    }

    private void modifyAccessToFieldsFromEnclosingInstance(CompilationUnitRewrite targetRewrite, SimpleName[] simpleNames, AbstractTypeDeclaration declaration) {
        SimpleName[] simpleNameArray = simpleNames;
        int n = simpleNames.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName simpleName = simpleNameArray[n2];
            IBinding binding = simpleName.resolveBinding();
            if (binding instanceof IVariableBinding && !(simpleName.getParent() instanceof FieldAccess)) {
                IVariableBinding variable = (IVariableBinding)binding;
                FieldAccess access = simpleName.getAST().newFieldAccess();
                access.setExpression(this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)simpleName, (IBinding)variable, declaration));
                access.setName(simpleName.getAST().newSimpleName(simpleName.getIdentifier()));
                targetRewrite.getASTRewrite().replace((ASTNode)simpleName, (ASTNode)access, null);
                targetRewrite.getImportRemover().registerRemovedNode((ASTNode)simpleName);
            }
            ++n2;
        }
    }

    private void modifyAccessToMethodsFromEnclosingInstance(CompilationUnitRewrite targetRewrite, MethodInvocation[] methodInvocations, AbstractTypeDeclaration declaration) {
        MethodInvocation[] methodInvocationArray = methodInvocations;
        int n = methodInvocations.length;
        int n2 = 0;
        while (n2 < n) {
            MethodInvocation invocation = methodInvocationArray[n2];
            IMethodBinding binding = invocation.resolveMethodBinding();
            if (binding != null) {
                Expression target = invocation.getExpression();
                if (target == null) {
                    Expression expression = this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)invocation, (IBinding)binding, declaration);
                    targetRewrite.getASTRewrite().set((ASTNode)invocation, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)expression, null);
                } else if (invocation.getExpression() instanceof ThisExpression && ((ThisExpression)invocation.getExpression()).getQualifier() != null) {
                    targetRewrite.getASTRewrite().replace((ASTNode)target, (ASTNode)this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)invocation, (IBinding)binding, declaration), null);
                    targetRewrite.getImportRemover().registerRemovedNode((ASTNode)target);
                }
            }
            ++n2;
        }
    }

    private void modifyConstructors(AbstractTypeDeclaration declaration, ASTRewrite rewrite) throws CoreException {
        MethodDeclaration[] methodDeclarationArray = this.getConstructorDeclarationNodes(declaration);
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration declaration2 = methodDeclarationArray[n2];
            Assert.isTrue((boolean)declaration2.isConstructor());
            this.addParameterToConstructor(rewrite, declaration2);
            this.setEnclosingInstanceFieldInConstructor(rewrite, declaration2);
            ++n2;
        }
    }

    private void modifyInterfaceMemberModifiers(ITypeBinding binding) {
        ASTNode node;
        Assert.isNotNull((Object)binding);
        ITypeBinding declaring = binding.getDeclaringClass();
        while (declaring != null && !declaring.isInterface()) {
            declaring = declaring.getDeclaringClass();
        }
        if (declaring != null && (node = ASTNodes.findDeclaration((IBinding)binding, (ASTNode)this.fSourceRewrite.getRoot())) instanceof AbstractTypeDeclaration) {
            ModifierRewrite.create(this.fSourceRewrite.getASTRewrite(), node).setVisibility(1, null);
        }
    }

    public void setCreateInstanceField(boolean create) {
        Assert.isTrue((boolean)this.fIsInstanceFieldCreationPossible);
        Assert.isTrue((!this.fIsInstanceFieldCreationMandatory ? 1 : 0) != 0);
        this.fCreateInstanceField = create;
    }

    private void setEnclosingInstanceFieldInConstructor(ASTRewrite rewrite, MethodDeclaration decl) throws JavaModelException {
        AST ast = decl.getAST();
        Block body = decl.getBody();
        List statements = body.statements();
        if (statements.isEmpty()) {
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide(this.createReadAccessExpressionForEnclosingInstance(ast));
            assignment.setRightHandSide((Expression)ast.newSimpleName(this.getNameForEnclosingInstanceConstructorParameter()));
            rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertFirst((ASTNode)ast.newExpressionStatement((Expression)assignment), null);
        } else {
            Statement first = (Statement)statements.get(0);
            if (first instanceof ConstructorInvocation) {
                rewrite.getListRewrite((ASTNode)first, ConstructorInvocation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)ast.newSimpleName(this.fEnclosingInstanceFieldName), null);
            } else {
                int index = 0;
                if (first instanceof SuperConstructorInvocation) {
                    ++index;
                }
                Assignment assignment = ast.newAssignment();
                assignment.setLeftHandSide(this.createReadAccessExpressionForEnclosingInstance(ast));
                assignment.setRightHandSide((Expression)ast.newSimpleName(this.getNameForEnclosingInstanceConstructorParameter()));
                rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)ast.newExpressionStatement((Expression)assignment), index, null);
            }
        }
    }

    public void setEnclosingInstanceName(String name) {
        Assert.isNotNull((Object)name);
        this.fEnclosingInstanceFieldName = name;
    }

    public void setMarkInstanceFieldAsFinal(boolean mark) {
        this.fMarkInstanceFieldAsFinal = mark;
    }

    private void updateConstructorReference(ClassInstanceCreation creation, CompilationUnitRewrite targetRewrite, ICompilationUnit unit, TextEditGroup group) throws JavaModelException {
        Expression expression;
        Assert.isNotNull((Object)creation);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)unit);
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        if (this.fCreateInstanceField) {
            this.insertExpressionAsParameter(creation, rewrite, unit, group);
        }
        if ((expression = creation.getExpression()) != null) {
            rewrite.remove((ASTNode)expression, null);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
        }
    }

    private void updateConstructorReference(ITypeBinding[] parameters, ASTNode reference, CompilationUnitRewrite targetRewrite, ICompilationUnit cu) throws CoreException {
        TextEditGroup group = targetRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_update_constructor_reference);
        if (reference instanceof SuperConstructorInvocation) {
            this.updateConstructorReference((SuperConstructorInvocation)reference, targetRewrite, cu, group);
        } else if (reference instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)reference, targetRewrite, cu, group);
        } else if (reference.getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)reference.getParent(), targetRewrite, cu, group);
        } else if (reference.getParent() instanceof ParameterizedType && reference.getParent().getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference(parameters, (ParameterizedType)reference.getParent(), targetRewrite, cu, group);
        }
    }

    private void updateConstructorReference(ITypeBinding[] parameters, ParameterizedType type, CompilationUnitRewrite targetRewrite, ICompilationUnit cu, TextEditGroup group) throws CoreException {
        ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)type, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
        TypeParameter parameter = null;
        int index = type.typeArguments().size();
        while (index < parameters.length) {
            parameter = targetRewrite.getRoot().getAST().newTypeParameter();
            parameter.setName(targetRewrite.getRoot().getAST().newSimpleName(parameters[index].getName()));
            rewrite.insertLast((ASTNode)parameter, group);
            ++index;
        }
        if (type.getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)type.getParent(), targetRewrite, cu, group);
        }
    }

    private void updateConstructorReference(SuperConstructorInvocation invocation, CompilationUnitRewrite targetRewrite, ICompilationUnit unit, TextEditGroup group) throws CoreException {
        Expression expression;
        Assert.isNotNull((Object)invocation);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)unit);
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        if (this.fCreateInstanceField) {
            this.insertExpressionAsParameter(invocation, rewrite, unit, group);
        }
        if ((expression = invocation.getExpression()) != null) {
            rewrite.remove((ASTNode)expression, null);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
        }
    }

    private boolean updateNameReference(ITypeBinding[] parameters, Name name, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        if (ASTNodes.asString((ASTNode)name).equals(this.fType.getFullyQualifiedName('.'))) {
            targetRewrite.getASTRewrite().replace((ASTNode)name, this.getNewQualifiedNameNode(parameters, name), group);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
            return true;
        }
        targetRewrite.getASTRewrite().replace((ASTNode)name, this.getNewUnqualifiedTypeNode(parameters, name), group);
        targetRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
        return true;
    }

    private boolean updateParameterizedTypeReference(ITypeBinding[] parameters, ParameterizedType type, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        if (!(type.getParent() instanceof ClassInstanceCreation)) {
            ListRewrite rewrite = targetRewrite.getASTRewrite().getListRewrite((ASTNode)type, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
            AST ast = targetRewrite.getRoot().getAST();
            SimpleType simpleType = null;
            int index = type.typeArguments().size();
            while (index < parameters.length) {
                simpleType = ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getName()));
                rewrite.insertLast((ASTNode)simpleType, group);
                ++index;
            }
        }
        return true;
    }

    private boolean updateReference(ITypeBinding[] parameters, ASTNode node, CompilationUnitRewrite rewrite, TextEditGroup group) {
        if (node.getLocationInParent() == ParameterizedType.TYPE_PROPERTY) {
            this.updateParameterizedTypeReference(parameters, (ParameterizedType)node.getParent(), rewrite, group);
            return this.updateNameReference(new ITypeBinding[0], ((SimpleType)node).getName(), rewrite, group);
        }
        if (node instanceof QualifiedName) {
            return this.updateNameReference(parameters, (Name)((QualifiedName)node), rewrite, group);
        }
        if (node instanceof SimpleType) {
            return this.updateNameReference(parameters, ((SimpleType)node).getName(), rewrite, group);
        }
        return false;
    }

    private void updateReferenceInImport(ImportDeclaration enclosingImport, ASTNode node, CompilationUnitRewrite rewrite) {
        IBinding binding = enclosingImport.resolveBinding();
        if (binding instanceof ITypeBinding) {
            ITypeBinding type = (ITypeBinding)binding;
            ImportRewrite rewriter = rewrite.getImportRewrite();
            if (enclosingImport.isStatic()) {
                String typeName;
                String oldImport = ASTNodes.asString(node);
                StringBuilder buffer = new StringBuilder(oldImport);
                int index = buffer.indexOf(typeName = this.fType.getDeclaringType().getElementName());
                if (index >= 0) {
                    buffer.delete(index, index + typeName.length() + 1);
                    String newImport = buffer.toString();
                    if (enclosingImport.isOnDemand()) {
                        rewriter.removeStaticImport(oldImport + ".*");
                        rewriter.addStaticImport(newImport, "*", false);
                    } else {
                        rewriter.removeStaticImport(oldImport);
                        int offset = newImport.lastIndexOf(46);
                        if (offset >= 0 && offset < newImport.length() - 1) {
                            rewriter.addStaticImport(newImport.substring(0, offset), newImport.substring(offset + 1), false);
                        }
                    }
                }
            } else {
                rewriter.removeImport(type.getQualifiedName());
            }
        }
    }

    private void updateTypeReference(ITypeBinding[] parameters, ASTNode node, CompilationUnitRewrite rewrite, ICompilationUnit cu) {
        ImportDeclaration enclosingImport = ASTNodes.getParent(node, ImportDeclaration.class);
        if (enclosingImport != null) {
            this.updateReferenceInImport(enclosingImport, node, rewrite);
        } else {
            TextEditGroup group = rewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_update_type_reference);
            this.updateReference(parameters, node, rewrite, group);
            if (!this.fType.getPackageFragment().equals(cu.getParent())) {
                String name = this.fType.getPackageFragment().getElementName() + "." + this.fType.getElementName();
                rewrite.getImportRemover().registerAddedImport(name);
                rewrite.getImportRewrite().addImport(name);
            }
        }
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String createField;
        String parameterName;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.move.inner");
            }
            this.fType = (IType)element;
            this.fCodeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fType.getJavaProject());
            try {
                this.initialize();
            }
            catch (JavaModelException exception) {
                JavaManipulationPlugin.log(exception);
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        String fieldName = arguments.getAttribute(ATTRIBUTE_FIELD_NAME);
        if (fieldName != null && !"".equals(fieldName)) {
            this.fEnclosingInstanceFieldName = fieldName;
        }
        if ((parameterName = arguments.getAttribute(ATTRIBUTE_PARAMETER_NAME)) != null && !"".equals(parameterName)) {
            this.fNameForEnclosingInstanceConstructorParameter = parameterName;
        }
        if ((createField = arguments.getAttribute(ATTRIBUTE_FIELD)) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FIELD));
        }
        this.fCreateInstanceField = Boolean.parseBoolean(createField);
        String markFinal = arguments.getAttribute(ATTRIBUTE_FINAL);
        if (markFinal == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
        }
        this.fMarkInstanceFieldAsFinal = Boolean.parseBoolean(markFinal);
        String possible = arguments.getAttribute(ATTRIBUTE_POSSIBLE);
        if (possible == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POSSIBLE));
        }
        this.fIsInstanceFieldCreationPossible = Boolean.parseBoolean(possible);
        String mandatory = arguments.getAttribute(ATTRIBUTE_MANDATORY);
        if (mandatory == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_MANDATORY));
        }
        this.fIsInstanceFieldCreationMandatory = Boolean.parseBoolean(mandatory);
        return new RefactoringStatus();
    }

    private static class MemberAccessNodeCollector
    extends ASTVisitor {
        private final ITypeBinding fCurrentType;
        private final List<MethodInvocation> fMethodAccesses = new ArrayList<MethodInvocation>(0);
        private final List<Name> fSimpleNames = new ArrayList<Name>(0);

        MemberAccessNodeCollector(ITypeBinding currType) {
            Assert.isNotNull((Object)currType);
            this.fCurrentType = currType;
        }

        MethodInvocation[] getMethodInvocations() {
            return this.fMethodAccesses.toArray(new MethodInvocation[this.fMethodAccesses.size()]);
        }

        SimpleName[] getSimpleFieldNames() {
            return this.fSimpleNames.toArray(new SimpleName[this.fSimpleNames.size()]);
        }

        public boolean visit(FieldAccess node) {
            node.getExpression().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(MethodInvocation node) {
            Expression expression = node.getExpression();
            if (expression == null) {
                IMethodBinding binding = node.resolveMethodBinding();
                if (binding != null && this.isAccessToOuter(binding.getDeclaringClass())) {
                    this.fMethodAccesses.add(node);
                }
            } else {
                expression.accept((ASTVisitor)this);
            }
            List arguments = node.arguments();
            for (Expression argument : arguments) {
                argument.accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(QualifiedName node) {
            node.getQualifier().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(SimpleName node) {
            IVariableBinding variableBinding;
            IBinding binding = node.resolveBinding();
            if (binding instanceof IVariableBinding && (variableBinding = (IVariableBinding)binding).isField() && this.isAccessToOuter(variableBinding.getDeclaringClass())) {
                this.fSimpleNames.add((Name)node);
            }
            return false;
        }

        public boolean visit(ThisExpression node) {
            ITypeBinding binding;
            Name qualifier = node.getQualifier();
            if (qualifier != null && (binding = qualifier.resolveTypeBinding()) != null && binding != this.fCurrentType.getTypeDeclaration()) {
                this.fSimpleNames.add(qualifier);
            }
            return super.visit(node);
        }

        private boolean isAccessToOuter(ITypeBinding binding) {
            if (Bindings.isSuperType(binding = binding.getTypeDeclaration(), this.fCurrentType, false)) {
                return false;
            }
            ITypeBinding outer = this.fCurrentType.getDeclaringClass();
            while (outer != null) {
                if (Bindings.isSuperType(binding, outer, false)) {
                    return true;
                }
                outer = outer.getDeclaringClass();
            }
            return false;
        }
    }

    private class TypeReferenceQualifier
    extends ASTVisitor {
        private final TextEditGroup fGroup;
        private final ITypeBinding fTypeBinding;

        public TypeReferenceQualifier(ITypeBinding type, TextEditGroup group) {
            Assert.isNotNull((Object)type);
            Assert.isNotNull((Object)type.getDeclaringClass());
            this.fTypeBinding = type;
            this.fGroup = group;
        }

        public boolean visit(ClassInstanceCreation node) {
            Assert.isNotNull((Object)node);
            if (MoveInnerToTopRefactoring.this.fCreateInstanceField) {
                AST ast = node.getAST();
                Type type = node.getType();
                ITypeBinding binding = type.resolveBinding();
                if (binding != null && binding.getDeclaringClass() != null && !Bindings.equals((IBinding)binding, (IBinding)this.fTypeBinding) && MoveInnerToTopRefactoring.this.fSourceRewrite.getRoot().findDeclaringNode((IBinding)binding) != null) {
                    if (!Modifier.isStatic((int)binding.getModifiers())) {
                        SimpleName expression = null;
                        if (MoveInnerToTopRefactoring.this.fCodeGenerationSettings.useKeywordThis || MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName.equals(MoveInnerToTopRefactoring.this.fNameForEnclosingInstanceConstructorParameter)) {
                            FieldAccess access = ast.newFieldAccess();
                            access.setExpression((Expression)ast.newThisExpression());
                            access.setName(ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName));
                            expression = access;
                        } else {
                            expression = ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName);
                        }
                        if (node.getExpression() != null) {
                            MoveInnerToTopRefactoring.this.fSourceRewrite.getImportRemover().registerRemovedNode((ASTNode)node.getExpression());
                        }
                        MoveInnerToTopRefactoring.this.fSourceRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)ClassInstanceCreation.EXPRESSION_PROPERTY, (Object)expression, this.fGroup);
                    } else {
                        MoveInnerToTopRefactoring.this.addTypeQualification(type, MoveInnerToTopRefactoring.this.fSourceRewrite, this.fGroup);
                    }
                }
            }
            return true;
        }

        public boolean visit(QualifiedType node) {
            Assert.isNotNull((Object)node);
            return false;
        }

        public boolean visit(SimpleType node) {
            ITypeBinding declaring;
            ITypeBinding binding;
            Assert.isNotNull((Object)node);
            if (!(node.getParent() instanceof ClassInstanceCreation) && (binding = node.resolveBinding()) != null && (declaring = binding.getDeclaringClass()) != null && !Bindings.equals((IBinding)declaring, (IBinding)this.fTypeBinding.getDeclaringClass()) && !Bindings.equals((IBinding)binding, (IBinding)this.fTypeBinding) && MoveInnerToTopRefactoring.this.fSourceRewrite.getRoot().findDeclaringNode((IBinding)binding) != null && Modifier.isStatic((int)binding.getModifiers())) {
                MoveInnerToTopRefactoring.this.addTypeQualification((Type)node, MoveInnerToTopRefactoring.this.fSourceRewrite, this.fGroup);
            }
            return super.visit(node);
        }

        public boolean visit(ThisExpression node) {
            ITypeBinding binding;
            Assert.isNotNull((Object)node);
            Name name = node.getQualifier();
            if (MoveInnerToTopRefactoring.this.fCreateInstanceField && name != null && (binding = node.resolveTypeBinding()) != null && Bindings.equals((IBinding)binding, (IBinding)this.fTypeBinding.getDeclaringClass())) {
                AST ast = node.getAST();
                SimpleName expression = null;
                if (MoveInnerToTopRefactoring.this.fCodeGenerationSettings.useKeywordThis || MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName.equals(MoveInnerToTopRefactoring.this.fNameForEnclosingInstanceConstructorParameter)) {
                    FieldAccess access = ast.newFieldAccess();
                    access.setExpression((Expression)ast.newThisExpression());
                    access.setName(ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName));
                    expression = access;
                } else {
                    expression = ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName);
                }
                MoveInnerToTopRefactoring.this.fSourceRewrite.getASTRewrite().replace((ASTNode)node, (ASTNode)expression, null);
            }
            return super.visit(node);
        }
    }
}

