/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.MissingContentManager;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.help.internal.webapp.WebappResources;
import org.eclipse.help.internal.webapp.data.RequestScope;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.BreadcrumbsFilter;
import org.eclipse.help.internal.webapp.servlet.ExtraFilters;
import org.eclipse.help.internal.webapp.servlet.FramesetFilter;
import org.eclipse.help.internal.webapp.servlet.InjectionFilter;
import org.eclipse.help.internal.webapp.servlet.ShowInTocFilter;
import org.eclipse.help.internal.webapp.servlet.TocFragmentServlet;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;
import org.eclipse.help.webapp.IFilter;

public class NavServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String XHTML_1 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n<title>";
    private static final String XHTML_2 = "</title>\n</head>\n<body>\n";
    private static final String XHTML_2_RTL = "</title>\n</head>\n<body dir = \"rtl\">\n";
    private static final String XHTML_3 = "</body>\n</html>";
    private static final IFilter[] filters = new IFilter[]{new FramesetFilter(), new InjectionFilter(false), new BreadcrumbsFilter(), new ShowInTocFilter(), new ExtraFilters()};

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ITopic topic;
        String path;
        Locale locale = this.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("text/html; charset=UTF-8");
        try {
            path = req.getPathInfo().substring(1);
            topic = this.getTopic(path, locale);
        }
        catch (Exception exception) {
            this.showPageNotFoundPage(req, resp);
            return;
        }
        Object out = resp.getOutputStream();
        IFilter[] iFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IFilter filter = iFilterArray[n2];
            out = filter.filter(req, (OutputStream)out);
            ++n2;
        }
        Throwable throwable = null;
        Object var8_11 = null;
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
            AbstractHelpScope scope = RequestScope.getScope(req, resp, false);
            this.writeContent(topic, path, locale, writer, UrlUtil.isRTL(req, resp), scope);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void showPageNotFoundPage(HttpServletRequest req, HttpServletResponse resp) {
        Object href;
        int navIndex;
        String errorPage = MissingContentManager.getInstance().getPageNotFoundPage(req.getServletPath(), false);
        if (errorPage != null && errorPage.length() > 0 && (navIndex = ((String)(href = req.getRequestURL().toString())).indexOf("/nav")) >= 0) {
            href = ((String)href).substring(0, navIndex);
            href = (String)href + "/nftopic";
            if (errorPage.charAt(0) != '/') {
                href = (String)href + "/";
            }
            href = (String)href + errorPage;
            try {
                resp.sendRedirect((String)href);
                return;
            }
            catch (IOException iOException) {}
        }
        resp.setStatus(404);
    }

    protected Locale getLocale(HttpServletRequest req, HttpServletResponse resp) {
        String nl = UrlUtil.getLocale(req, resp);
        StringTokenizer locales = new StringTokenizer(nl, "_");
        Locale locale = locales.countTokens() == 1 ? new Locale(locales.nextToken(), "") : (locales.countTokens() == 2 ? new Locale(locales.nextToken(), locales.nextToken()) : (locales.countTokens() == 3 ? new Locale(locales.nextToken(), locales.nextToken(), locales.nextToken()) : Locale.getDefault()));
        return locale;
    }

    protected ITopic getTopic(String topicPath, Locale locale) {
        StringTokenizer tok = new StringTokenizer(topicPath, "_");
        int index = Integer.parseInt(tok.nextToken());
        ITopic topic = HelpPlugin.getTocManager().getTocs(locale.toString())[index].getTopic(null);
        while (tok.hasMoreTokens()) {
            index = Integer.parseInt(tok.nextToken());
            topic = topic.getSubtopics()[index];
        }
        return topic;
    }

    private void writeContent(ITopic topic, String path, Locale locale, PrintWriter writer, boolean isRTL, AbstractHelpScope scope) {
        writer.write(XHTML_1);
        writer.write(topic.getLabel());
        if (isRTL) {
            writer.write(XHTML_2_RTL);
        } else {
            writer.write(XHTML_2);
        }
        writer.write("<h1 class=\"NavTitle\">" + topic.getLabel() + "</h1>\n");
        writer.write("<h3 class=\"NavListTitle\">" + WebappResources.getString("TocHeading", locale) + "</h3>\n");
        writer.write("<ul class=\"NavList\">\n");
        ITopic[] subtopics = topic.getSubtopics();
        int i = 0;
        while (i < subtopics.length) {
            if (ScopeUtils.showInTree((ITopic)subtopics[i], (AbstractHelpScope)scope)) {
                writer.write("<li><a href=\"");
                Object href = subtopics[i].getHref();
                if (href == null) {
                    href = path + "_" + i;
                } else {
                    href = XMLGenerator.xmlEscape(UrlUtil.getHelpURL((String)href));
                    href = TocFragmentServlet.fixupHref((String)href, path + "_" + i);
                }
                writer.write((String)href);
                writer.write("\">" + subtopics[i].getLabel() + "</a></li>\n");
            }
            ++i;
        }
        writer.write("</ul>\n");
        writer.write(XHTML_3);
    }
}

