/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.util;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.emf.parsley.dsl.typing.EmfParsleyDslTypeSystem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;

public class EmfParsleyDslGuiceModuleHelper {
    @Inject
    @Extension
    private IJvmModelAssociations _iJvmModelAssociations;
    @Inject
    @Extension
    private OverrideHelper _overrideHelper;
    @Inject
    @Extension
    private EmfParsleyDslTypeSystem _emfParsleyDslTypeSystem;

    public JvmGenericType getModuleInferredType(Module module) {
        return (JvmGenericType)IterableExtensions.head(this.getInferredJavaTypes(module));
    }

    public Iterable<JvmGenericType> getInferredJavaTypes(EObject o) {
        return Iterables.filter((Iterable)this._iJvmModelAssociations.getJvmElements(o), JvmGenericType.class);
    }

    public Iterable<JvmOperation> getAllGuiceValueBindingsMethodsInSuperclass(Module module) {
        return this.getAllGuiceValueBindingsMethodsInSuperclass(this.getModuleInferredType(module));
    }

    public Iterable<JvmOperation> getAllGuiceTypeBindingsMethodsInSuperclass(Module module) {
        Functions.Function1 _function = it -> it.getSimpleName().startsWith("bind") && IterableExtensions.head((Iterable)((JvmParameterizedTypeReference)it.getReturnType()).getArguments()) != null;
        return IterableExtensions.filter(this.superTypeJvmOperations(module), (Functions.Function1)_function);
    }

    public Iterable<JvmOperation> getAllGuiceProviderBindingsMethodsInSuperclass(Module module) {
        Functions.Function1 _function = it -> it.getSimpleName().startsWith("provide");
        return IterableExtensions.filter(this.superTypeJvmOperations(module), (Functions.Function1)_function);
    }

    public Iterable<JvmOperation> getAllGuiceValueBindingsMethodsInSuperclass(JvmGenericType type) {
        Functions.Function1 _function = it -> it.getSimpleName().startsWith("value");
        return IterableExtensions.filter(this.superTypeJvmOperations(type), (Functions.Function1)_function);
    }

    public Iterable<JvmGenericType> getAllWithExtendsClauseInferredJavaTypes(Module module) {
        Functions.Function1 _function = it -> this.getInferredJavaTypes((EObject)it);
        return Iterables.concat((Iterable)IterableExtensions.map(this.getAllWithExtendsClause(module), (Functions.Function1)_function));
    }

    public Iterable<WithExtendsClause> getAllWithExtendsClause(Module module) {
        return Iterables.filter((Iterable)module.eContents(), WithExtendsClause.class);
    }

    public ResolvedFeatures getJavaResolvedFeatures(JvmGenericType type) {
        return this._overrideHelper.getResolvedFeatures((JvmDeclaredType)type);
    }

    public String getJavaMethodResolvedErasedSignature(IResolvedOperation op) {
        return op.getResolvedErasureSignature();
    }

    public boolean containsConstructorAcceptingPluginParameter(EObject context, JvmTypeReference typeRef) {
        JvmType type = typeRef.getType();
        if (type instanceof JvmGenericType) {
            Functions.Function1 _function = it -> it.getParameters().size() == 1 && this._emfParsleyDslTypeSystem.isConformant(context, AbstractUIPlugin.class, ((JvmFormalParameter)IterableExtensions.head((Iterable)it.getParameters())).getParameterType());
            return IterableExtensions.exists((Iterable)((JvmGenericType)type).getDeclaredConstructors(), (Functions.Function1)_function);
        }
        return false;
    }

    private Iterable<JvmOperation> superTypeJvmOperations(Module module) {
        return this.superTypeJvmOperations(this.getModuleInferredType(module));
    }

    private Iterable<JvmOperation> superTypeJvmOperations(JvmGenericType type) {
        if (type == null) {
            return CollectionLiterals.emptyList();
        }
        JvmType _type = ((JvmTypeReference)IterableExtensions.head((Iterable)type.getSuperTypes())).getType();
        return Iterables.filter((Iterable)((JvmGenericType)_type).getAllFeatures(), JvmOperation.class);
    }
}

