/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.style.unsettable.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ButtonAlignmentType implements Enumerator
{
    RIGHT(0, "RIGHT", "RIGHT"),
    LEFT(0, "LEFT", "LEFT");

    public static final int RIGHT_VALUE = 0;
    public static final int LEFT_VALUE = 0;
    private static final ButtonAlignmentType[] VALUES_ARRAY;
    public static final List<ButtonAlignmentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ButtonAlignmentType[]{RIGHT, LEFT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ButtonAlignmentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ButtonAlignmentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ButtonAlignmentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ButtonAlignmentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ButtonAlignmentType get(int value) {
        switch (value) {
            case 0: {
                return RIGHT;
            }
        }
        return null;
    }

    private ButtonAlignmentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

