/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.tools.emf.ui.common.IClassContributionProvider;
import org.eclipse.e4.tools.emf.ui.common.IModelElementProvider;
import org.eclipse.e4.tools.emf.ui.common.IProviderStatusCallback;
import org.eclipse.e4.tools.emf.ui.common.ProviderStatus;
import org.eclipse.e4.tools.emf.ui.common.ResourceSearchScope;
import org.eclipse.e4.tools.emf.ui.internal.common.ClassContributionCollector;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.FilteredContributionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class TargetPlatformContributionCollector
extends ClassContributionCollector {
    CopyOnWriteArrayList<Entry> cacheEntry = new CopyOnWriteArrayList();
    HashSet<String> cacheBundleId = new HashSet();
    HashSet<String> cachePackage = new HashSet();
    HashSet<String> cacheLocation = new HashSet();
    private Pattern patternFile;
    protected String cacheName;
    protected boolean stopFiltering;
    private static HashMap<String, List<String>> outputDirectories = new HashMap();

    private TargetPlatformContributionCollector() {
    }

    protected TargetPlatformContributionCollector(String cacheName) {
        this.cacheName = cacheName;
        this.patternFile = this.getFilePattern();
        this.addContributor(new IClassContributionProvider(){

            @Override
            public void findContribution(IClassContributionProvider.Filter filter, IClassContributionProvider.ContributionResultHandler handler) {
                Pattern patternName = PatternConstructor.createPattern((String)filter.namePattern, (boolean)false);
                TargetPlatformContributionCollector.this.reloadCache(false, filter.getProviderStatusCallback());
                int maxResults = filter.maxResults;
                if (maxResults == 0) {
                    maxResults = 100;
                }
                int found = 0;
                boolean more = false;
                TargetPlatformContributionCollector.this.stopFiltering = false;
                for (Entry e : TargetPlatformContributionCollector.this.cacheEntry) {
                    Matcher m;
                    if (TargetPlatformContributionCollector.this.stopFiltering) break;
                    IProgressMonitor monitor = filter.getProgressMonitor();
                    if (monitor != null) {
                        if (monitor.isCanceled()) {
                            TargetPlatformContributionCollector.this.stopFiltering = true;
                            break;
                        }
                        monitor.subTask(Messages.TargetPlatformContributionCollector_Searching + " " + e.installLocation);
                    }
                    if (E.notEmpty(filter.getBundles()) && !filter.getBundles().contains(e.bundleSymName) || E.notEmpty(filter.getPackages()) && !filter.getPackages().contains(e.pakage)) continue;
                    if (E.notEmpty(filter.getLocations())) {
                        boolean locationFound = false;
                        for (String location : filter.getLocations()) {
                            if (!e.installLocation.startsWith(location)) continue;
                            locationFound = true;
                            break;
                        }
                        if (!locationFound) continue;
                    }
                    if (!filter.isIncludeNonBundles() && e.bundleSymName == null) continue;
                    if (filter.getSearchScope().contains((Object)ResourceSearchScope.WORKSPACE) && filter.project != null) {
                        IWorkspace workspace = filter.project.getWorkspace();
                        boolean fnd = false;
                        IProject[] iProjectArray = workspace.getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            String path = project.getName();
                            if (e.installLocation.contains(path)) {
                                fnd = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!fnd) continue;
                    }
                    if (!(m = patternName.matcher(e.name)).find()) continue;
                    if (++found > maxResults) {
                        more = true;
                        handler.moreResults(-1, filter);
                        break;
                    }
                    handler.result(TargetPlatformContributionCollector.this.makeData(e));
                }
                if (!more) {
                    if (TargetPlatformContributionCollector.this.stopFiltering) {
                        handler.moreResults(-2, filter);
                    } else {
                        handler.moreResults(0, filter);
                    }
                }
            }
        });
        this.addModelElementContributor(new IModelElementProvider(){

            @Override
            public void getModelElements(IModelElementProvider.Filter filter, IModelElementProvider.ModelResultHandler handler) {
            }

            @Override
            public void clearCache() {
                TargetPlatformContributionCollector.this.stopFiltering = true;
                TargetPlatformContributionCollector.this.cacheEntry.clear();
                TargetPlatformContributionCollector.this.cacheBundleId.clear();
                TargetPlatformContributionCollector.this.cachePackage.clear();
                TargetPlatformContributionCollector.this.cacheLocation.clear();
                outputDirectories.clear();
            }
        });
    }

    protected IClassContributionProvider.ContributionData makeData(Entry e) {
        IPath ip = IPath.fromOSString((String)e.path);
        ip = ip.addTrailingSeparator().makeRelative();
        ip = ip.append(e.name);
        String className = ip.toOSString().replace(File.separatorChar, '.');
        IClassContributionProvider.ContributionData data = new IClassContributionProvider.ContributionData(e.bundleSymName, className, "Java", e.installLocation);
        data.installLocation = e.installLocation;
        data.resourceRelativePath = e.relativePath;
        return data;
    }

    public Collection<String> getBundleIds() {
        this.reloadCache(false, null);
        return new ArrayList<String>(this.cacheBundleId);
    }

    public Collection<String> getPackages() {
        this.reloadCache(false, null);
        return new ArrayList<String>(this.cachePackage);
    }

    public Collection<String> getLocations() {
        this.reloadCache(false, null);
        return new ArrayList<String>(this.cacheLocation);
    }

    private void reloadCache(boolean force, final IProviderStatusCallback providerStatusCallback) {
        if (this.cacheEntry.isEmpty() || force) {
            if (providerStatusCallback != null) {
                providerStatusCallback.onStatusChanged(ProviderStatus.INITIALIZING);
            }
            this.cacheEntry.clear();
            this.cacheBundleId.clear();
            this.cachePackage.clear();
            this.cacheLocation.clear();
            outputDirectories.clear();
            final Job job = new Job(Messages.TargetPlatformContributionCollector_BuildTargetPlatformIndex){

                protected IStatus run(IProgressMonitor monitor) {
                    IProject[] projects = PDECore.getWorkspace().getRoot().getProjects();
                    IPluginModelBase[] models = TargetPlatformHelper.getPDEState().getTargetModels();
                    int total = projects.length + models.length;
                    monitor.beginTask(Messages.TargetPlatformContributionCollector_updatingTargetPlatformCache + TargetPlatformContributionCollector.this.cacheName + ")", total);
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject pj = iProjectArray[n2];
                        if (monitor.isCanceled()) break;
                        String rootDirectory = pj.getLocation().toOSString();
                        monitor.subTask(rootDirectory);
                        monitor.worked(1);
                        TargetPlatformContributionCollector.this.visit(monitor, FilteredContributionDialog.getBundle(rootDirectory), rootDirectory, new File(rootDirectory));
                        ++n2;
                    }
                    iProjectArray = models;
                    n = models.length;
                    n2 = 0;
                    while (n2 < n) {
                        block27: {
                            IProject pluginModelBase = iProjectArray[n2];
                            monitor.subTask(pluginModelBase.getPluginBase().getId());
                            monitor.worked(1);
                            if (monitor.isCanceled()) break;
                            IPluginBase pluginBase = pluginModelBase.getPluginBase();
                            if (pluginBase != null) {
                                try {
                                    String installLocation = pluginModelBase.getInstallLocation();
                                    if (installLocation.endsWith(".jar")) {
                                        URL url = new URL("file:///" + installLocation);
                                        Throwable throwable = null;
                                        Object var13_16 = null;
                                        try (ZipInputStream zis = new ZipInputStream(url.openStream());){
                                            while (true) {
                                                Matcher m;
                                                ZipEntry entry;
                                                if ((entry = zis.getNextEntry()) == null) {
                                                    break block27;
                                                }
                                                String name2 = entry.getName();
                                                if (TargetPlatformContributionCollector.this.shouldIgnore(name2) || !(m = TargetPlatformContributionCollector.this.patternFile.matcher(name2)).matches()) continue;
                                                Entry e = new Entry();
                                                e.installLocation = installLocation;
                                                TargetPlatformContributionCollector.this.cacheLocation.add(installLocation);
                                                e.name = m.group(2);
                                                e.path = m.group(1);
                                                if (e.path != null) {
                                                    e.pakage = e.path.replace("/", ".");
                                                    if (e.pakage.startsWith(".")) {
                                                        e.pakage = e.pakage.substring(1);
                                                    }
                                                    if (e.pakage.endsWith(".")) {
                                                        e.pakage = e.pakage.substring(0, e.pakage.length() - 1);
                                                    }
                                                } else {
                                                    e.pakage = "";
                                                }
                                                TargetPlatformContributionCollector.this.cachePackage.add(e.pakage);
                                                e.bundleSymName = pluginBase.getId();
                                                if (e.path == null) {
                                                    e.path = "";
                                                }
                                                TargetPlatformContributionCollector.this.cacheEntry.add(e);
                                                TargetPlatformContributionCollector.this.cacheBundleId.add(pluginBase.getId());
                                            }
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            throw throwable;
                                        }
                                    }
                                    String bundle = TargetPlatformContributionCollector.getBundle(new File(installLocation));
                                    if (bundle != null) {
                                        TargetPlatformContributionCollector.this.visit(monitor, bundle, installLocation, new File(installLocation));
                                    }
                                }
                                catch (MalformedURLException e) {
                                    e.printStackTrace();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        ++n2;
                    }
                    monitor.done();
                    if (monitor.isCanceled()) {
                        if (providerStatusCallback != null) {
                            providerStatusCallback.onStatusChanged(ProviderStatus.CANCELLED);
                        }
                        return Status.CANCEL_STATUS;
                    }
                    if (providerStatusCallback != null) {
                        providerStatusCallback.onStatusChanged(ProviderStatus.READY);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            Display.getDefault().syncExec(new Runnable(){
                boolean runInBackground = false;

                @Override
                public void run() {
                    ProgressMonitorDialog dlg = new ProgressMonitorDialog(Display.getDefault().getActiveShell()){

                        protected Control createContents(Composite parent) {
                            Composite ret = (Composite)super.createContents(parent);
                            Label label = new Label(ret, 0);
                            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
                            label.setText(Messages.TargetPlatformContributionCollector_pleaseWait);
                            return ret;
                        }

                        protected void createButtonsForButtonBar(Composite parent) {
                            Button button = this.createButton(parent, 101, Messages.TargetPlatformContributionCollector_RunInBackground, false);
                            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    runInBackground = true;
                                }
                            });
                            super.createButtonsForButtonBar(parent);
                            button.setCursor(this.arrowCursor);
                        }

                        protected void cancelPressed() {
                            job.cancel();
                        }
                    };
                    try {
                        dlg.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.TargetPlatformContributionCollector_WaitingForTargetPlatformIndexingToComplete, -1);
                                while (job.getState() == 4 && !runInBackground) {
                                    Thread.sleep(100L);
                                }
                                monitor.done();
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        e1.printStackTrace();
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
    }

    /*
     * Exception decompiling
     */
    public static String getBundle(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 10[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void visit(IProgressMonitor monitor, String bundleName, String installLocation, File file) {
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fChild = fileArray[n2];
            if (monitor.isCanceled()) break;
            if (fChild.isDirectory()) {
                this.visit(monitor, bundleName, installLocation, fChild);
            } else {
                Matcher m;
                String name2 = fChild.getAbsolutePath().substring(installLocation.length() + 1);
                if (!this.shouldIgnore(name2 = TargetPlatformContributionCollector.stripOutputDirectory(name2, installLocation)) && (m = this.patternFile.matcher(name2)).matches()) {
                    Entry e = new Entry();
                    e.installLocation = installLocation;
                    this.cacheLocation.add(installLocation);
                    e.name = m.group(2);
                    if (!e.name.contains("$")) {
                        e.path = m.group(1);
                        if (e.path != null) {
                            e.pakage = e.path.replace("/", ".");
                            if (e.pakage.startsWith(".")) {
                                e.pakage = e.pakage.substring(1);
                            }
                            if (e.pakage.endsWith(".")) {
                                e.pakage = e.pakage.substring(0, e.pakage.length() - 1);
                            }
                        } else {
                            e.pakage = "";
                        }
                        if (e.path == null) {
                            e.path = "";
                        }
                        e.relativePath = IPath.fromOSString((String)file.getAbsolutePath().replace(e.installLocation, "")).makeRelative().toOSString();
                        e.bundleSymName = bundleName;
                        this.cachePackage.add(e.pakage);
                        this.cacheEntry.add(e);
                        if (bundleName != null) {
                            this.cacheBundleId.add(bundleName);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private static String stripOutputDirectory(String path, String installLocation) {
        if (installLocation.matches(".*\\.jar")) {
            return path;
        }
        for (String sourceDirectory : TargetPlatformContributionCollector.getOutputDirectories(installLocation)) {
            if (!path.startsWith(sourceDirectory)) continue;
            path = path.substring(sourceDirectory.length());
            break;
        }
        return path;
    }

    private static List<String> getOutputDirectories(String installLocation) {
        List<String> ret = outputDirectories.get(installLocation);
        if (ret == null) {
            ret = new ArrayList<String>();
            outputDirectories.put(installLocation, ret);
            try {
                File file = new File(installLocation + File.separator + ".classpath");
                Document doc = XmlProcessorFactory.parseWithErrorOnDOCTYPE((File)file);
                XPath xp = XPathFactory.newInstance().newXPath();
                NodeList list = (NodeList)xp.evaluate("//classpathentry[@kind='output']/@path", doc, XPathConstants.NODESET);
                int i = 0;
                while (i < list.getLength()) {
                    String value = list.item(i).getNodeValue();
                    ret.add(value);
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    protected boolean shouldIgnore(String name) {
        return false;
    }

    protected abstract Pattern getFilePattern();

    static class Entry {
        String name;
        String path;
        String installLocation;
        String relativePath;
        String bundleSymName;
        String pakage;

        Entry() {
        }
    }
}

