/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.cdt.ui.editor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.ui.text.folding.ICFoldingStructureProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.cdt.ui.CDTStructureBridge;
import org.eclipse.mylyn.internal.cdt.ui.CDTUIBridgePlugin;
import org.eclipse.mylyn.internal.cdt.ui.CDTUiBridge;
import org.eclipse.mylyn.internal.cdt.ui.editor.Messages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.progress.UIJob;

public class ActiveFoldingListener
extends AbstractContextListener {
    private final CEditor editor;
    private ICFoldingStructureProvider updater;
    private static CDTStructureBridge bridge = (CDTStructureBridge)ContextCore.getStructureBridge((String)"c/c++");
    private boolean enabled = false;
    private boolean isDisposed = false;
    private final IPropertyChangeListener PREFERENCE_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
                ActiveFoldingListener.this.enabled = Boolean.parseBoolean(event.getNewValue().toString());
                ActiveFoldingListener.this.updateFolding();
            }
        }
    };

    public ActiveFoldingListener(CEditor editor) {
        this.editor = editor;
        ContextCore.getContextManager().addListener((AbstractContextListener)this);
        CDTUIBridgePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.PREFERENCE_LISTENER);
        this.enabled = CDTUIBridgePlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled");
        try {
            Class<CEditor> clazz = CEditor.class;
            Field f = clazz.getDeclaredField("fProjectionModelUpdater");
            f.setAccessible(true);
            ICFoldingStructureProvider updater = (ICFoldingStructureProvider)f.get(editor);
            if (updater instanceof ICFoldingStructureProvider) {
                this.updater = updater;
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "Could not install active folding on provider: " + clazz + ", must extend " + ICFoldingStructureProvider.class.getName()));
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "Could not install auto folding, reflection denied", (Throwable)e));
        }
        UIJob j = new UIJob(Messages.ActiveFoldingListener_Updating_Folding){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!ActiveFoldingListener.this.isDisposed) {
                    ActiveFoldingListener.this.updateFolding();
                }
                return Status.OK_STATUS;
            }
        };
        j.schedule(1000L);
    }

    public void dispose() {
        this.isDisposed = true;
        ContextCore.getContextManager().removeListener((AbstractContextListener)this);
        CDTUIBridgePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.PREFERENCE_LISTENER);
    }

    public void updateFolding() {
        if (!this.enabled || !ContextCore.getContextManager().isContextActive()) {
            this.editor.resetProjection();
        } else {
            if (this.editor.getEditorInput() == null) {
                return;
            }
            try {
                ArrayList<ICElement> toExpand = new ArrayList<ICElement>();
                ArrayList<ICElement> toCollapse = new ArrayList<ICElement>();
                ICElement element = CDTUiBridge.getInputCElement(this.editor);
                if (element instanceof ITranslationUnit) {
                    ITranslationUnit compilationUnit = (ITranslationUnit)element;
                    List<ICElement> allChildren = ActiveFoldingListener.getAllChildren((IParent)compilationUnit);
                    for (ICElement child : allChildren) {
                        IInteractionElement interactionElement = ContextCore.getContextManager().getElement(bridge.getHandleIdentifier(child));
                        if (interactionElement != null && interactionElement.getInterest().isInteresting()) {
                            toExpand.add(child);
                            continue;
                        }
                        toCollapse.add(child);
                    }
                }
                if (this.updater != null) {
                    this.collapseAllElements();
                    Point selectedRange = this.editor.getViewer().getSelectedRange();
                    this.expandElements(toExpand.toArray(new ICElement[toExpand.size()]));
                    this.editor.getViewer().setSelectedRange(selectedRange.x, selectedRange.y);
                    this.editor.getViewer().revealRange(selectedRange.x, selectedRange.y);
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", "Could not update folding", (Throwable)e));
            }
        }
    }

    protected void collapseElements(ICElement[] elements) {
        ICElement[] iCElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement element = iCElementArray[n2];
            this.collapse(element);
            ++n2;
        }
    }

    private void collapseAllElements() {
        CSourceViewer viewer = (CSourceViewer)this.editor.getViewer();
        if (viewer != null) {
            viewer.doOperation(21);
        }
    }

    private void collapse(ICElement element) {
    }

    protected void expandElements(ICElement[] elements) {
        ICElement[] iCElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement element = iCElementArray[n2];
            this.expand(element);
            ++n2;
        }
    }

    private void expand(ICElement element) {
        CSourceViewer viewer = (CSourceViewer)this.editor.getViewer();
        if (element instanceof ISourceReference && !(element instanceof ITranslationUnit)) {
            ISourceReference reference = (ISourceReference)element;
            try {
                viewer.exposeModelRange((IRegion)new Region(reference.getSourceRange().getIdStartPos(), 0));
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
    }

    private static List<ICElement> getAllChildren(IParent parentElement) {
        ArrayList<ICElement> allChildren = new ArrayList<ICElement>();
        try {
            ICElement[] iCElementArray = parentElement.getChildren();
            int n = iCElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICElement child = iCElementArray[n2];
                allChildren.add(child);
                if (child instanceof IParent) {
                    allChildren.addAll(ActiveFoldingListener.getAllChildren((IParent)child));
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return allChildren;
    }

    public void updateFolding(List<IInteractionElement> elements) {
        try {
            for (IInteractionElement element : elements) {
                if (this.updater == null || !this.enabled) {
                    return;
                }
                Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
                if (!(object instanceof ICElement)) continue;
                ICElement member = (ICElement)object;
                if (element.getInterest().isInteresting()) {
                    ICElement[] childsChildren;
                    this.expandElements(new ICElement[]{member});
                    if (!(member instanceof IParent)) {
                        return;
                    }
                    ICElement[] children = ((IParent)member).getChildren();
                    if (children.length != 1) continue;
                    this.expandElements(new ICElement[]{children[0]});
                    if (!(children[0] instanceof IParent) || (childsChildren = ((IParent)children[0]).getChildren()).length != 1) continue;
                    this.expandElements(new ICElement[]{childsChildren[0]});
                    continue;
                }
                this.collapseElements(new ICElement[]{member});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void contextChanged(ContextChangeEvent event) {
        switch (event.getEventKind()) {
            case ACTIVATED: 
            case DEACTIVATED: {
                if (!CDTUIBridgePlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) break;
                this.updateFolding();
                break;
            }
            case CLEARED: {
                if (!event.isActiveContext() || !CDTUIBridgePlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) break;
                this.updateFolding();
                break;
            }
            case INTEREST_CHANGED: {
                this.updateFolding(event.getElements());
            }
        }
    }

    public static void resetProjection(CEditor editor2) {
    }
}

