/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation.validators;

import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.Messages;
import org.eclipse.bpmn2.modeler.core.validation.validators.ProcessValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;

public class DataAssociationValidator
extends AbstractBpmn2ElementValidator<DataAssociation> {
    public DataAssociationValidator(IValidationContext ctx) {
        super(ctx);
    }

    public DataAssociationValidator(AbstractBpmn2ElementValidator parent) {
        super(parent);
    }

    @Override
    public IStatus validate(DataAssociation object) {
        if (!(object.eContainer() instanceof Event)) {
            int severity = ProcessValidator.isContainingProcessExecutable((EObject)object) ? 4 : 2;
            EObject[] resultLocus = new EObject[]{object.eContainer()};
            if (object instanceof DataOutputAssociation) {
                if (DataAssociationValidator.isEmpty(object.getTargetRef()) && object.getAssignment().size() == 0 && object.getTransformation() == null) {
                    ItemAwareElement source;
                    ItemAwareElement itemAwareElement = source = object.getSourceRef().size() > 0 ? (ItemAwareElement)object.getSourceRef().get(0) : null;
                    if (source != null) {
                        this.addStatus((EObject)object, resultLocus, severity, Messages.DataAssociationValidator_Output_Uninitialized, this.getName((EObject)source));
                    } else {
                        this.addMissingFeatureStatus((EObject)object, "targetRef", resultLocus, severity);
                    }
                }
            } else if (object instanceof DataInputAssociation && DataAssociationValidator.isEmpty(object.getSourceRef()) && object.getAssignment().size() == 0 && object.getTransformation() == null) {
                ItemAwareElement target = object.getTargetRef();
                if (target != null) {
                    this.addStatus((EObject)object, resultLocus, severity, Messages.DataAssociationValidator_Input_Uninitialized, this.getName((EObject)target));
                } else {
                    this.addMissingFeatureStatus((EObject)object, "sourceRef", resultLocus, severity);
                }
            }
        }
        return this.getResult();
    }
}

