/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.formatter;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ant.internal.ui.editor.formatter.FormattingPreferences;

public class XmlTagFormatter {
    public static String format(String tagText, FormattingPreferences prefs, String indent, String lineDelimiter) {
        Tag tag;
        if (tagText.startsWith("</") || tagText.startsWith("<%") || tagText.startsWith("<?") || tagText.startsWith("<[")) {
            return tagText;
        }
        try {
            tag = new TagParser().parse(tagText);
        }
        catch (ParseException parseException) {
            return tagText;
        }
        return new TagFormatter().format(tag, prefs, indent, lineDelimiter);
    }

    public static class AttributePair {
        private String fAttribute;
        private String fValue;
        private char fQuote;

        public AttributePair(String attribute, String value, char attributeQuote) {
            this.fAttribute = attribute;
            this.fValue = value;
            this.fQuote = attributeQuote;
        }

        public String getAttribute() {
            return this.fAttribute;
        }

        public String getValue() {
            return this.fValue;
        }

        public char getQuote() {
            return this.fQuote;
        }
    }

    protected static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException(String message) {
            super(message);
        }
    }

    protected static class Tag {
        private List<AttributePair> fAttributes = new ArrayList<AttributePair>();
        private boolean fClosed;
        private String fElementName;

        protected Tag() {
        }

        public void addAttribute(String attribute, String value, char quote) {
            this.fAttributes.add(new AttributePair(attribute, value, quote));
        }

        public int attributeCount() {
            return this.fAttributes.size();
        }

        public AttributePair getAttributePair(int i) {
            return this.fAttributes.get(i);
        }

        public String getElementName() {
            return this.fElementName;
        }

        public boolean isClosed() {
            return this.fClosed;
        }

        public int minimumLength() {
            int length = 2;
            if (this.isClosed()) {
                ++length;
            }
            length += this.getElementName().length();
            if (this.attributeCount() > 0 || this.isClosed()) {
                ++length;
            }
            int i = 0;
            while (i < this.attributeCount()) {
                AttributePair attributePair = this.getAttributePair(i);
                length += attributePair.getAttribute().length();
                length += attributePair.getValue().length();
                length += 4;
                ++i;
            }
            if (this.attributeCount() > 0 && !this.isClosed()) {
                --length;
            }
            return length;
        }

        public void setAttributes(List<AttributePair> attributePair) {
            this.fAttributes.clear();
            this.fAttributes.addAll(attributePair);
        }

        public void setClosed(boolean closed) {
            this.fClosed = closed;
        }

        public void setElementName(String elementName) {
            this.fElementName = elementName;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(500);
            sb.append('<');
            sb.append(this.getElementName());
            if (this.attributeCount() > 0 || this.isClosed()) {
                sb.append(' ');
            }
            int i = 0;
            while (i < this.attributeCount()) {
                AttributePair attributePair = this.getAttributePair(i);
                sb.append(attributePair.getAttribute());
                sb.append('=');
                sb.append(attributePair.getQuote());
                sb.append(attributePair.getValue());
                sb.append(attributePair.getQuote());
                if (this.isClosed() || i != this.attributeCount() - 1) {
                    sb.append(' ');
                }
                ++i;
            }
            if (this.isClosed()) {
                sb.append('/');
            }
            sb.append('>');
            return sb.toString();
        }
    }

    protected static class TagFormatter {
        protected TagFormatter() {
        }

        private int countChar(char searchChar, String inTargetString) {
            StringCharacterIterator iter = new StringCharacterIterator(inTargetString);
            int i = 0;
            if (iter.first() == searchChar) {
                ++i;
            }
            while (iter.getIndex() < iter.getEndIndex()) {
                if (iter.next() != searchChar) continue;
                ++i;
            }
            return i;
        }

        public String format(Tag tag, FormattingPreferences prefs, String indent, String lineDelimiter) {
            if (prefs.wrapLongTags() && this.lineRequiresWrap(indent + tag.toString(), prefs.getMaximumLineWidth(), prefs.getTabWidth())) {
                return this.wrapTag(tag, prefs, indent, lineDelimiter);
            }
            return tag.toString();
        }

        protected boolean lineRequiresWrap(String line, int lineWidth, int tabWidth) {
            return this.tabExpandedLineWidth(line, tabWidth) > lineWidth;
        }

        protected int tabExpandedLineWidth(String line, int tabWidth) {
            int tabCount = this.countChar('\t', line);
            return line.length() - tabCount + tabCount * tabWidth;
        }

        protected String wrapTag(Tag tag, FormattingPreferences prefs, String indent, String lineDelimiter) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append('<');
            sb.append(tag.getElementName());
            sb.append(' ');
            if (tag.attributeCount() > 0) {
                AttributePair pair = tag.getAttributePair(0);
                sb.append(pair.getAttribute());
                sb.append('=');
                sb.append(pair.getQuote());
                sb.append(tag.getAttributePair(0).getValue());
                sb.append(pair.getQuote());
            }
            if (tag.attributeCount() > 1) {
                char[] extraIndent = new char[tag.getElementName().length() + 2];
                Arrays.fill(extraIndent, ' ');
                int i = 1;
                while (i < tag.attributeCount()) {
                    AttributePair pair = tag.getAttributePair(i);
                    sb.append(lineDelimiter);
                    sb.append(indent);
                    sb.append(extraIndent);
                    sb.append(pair.getAttribute());
                    sb.append('=');
                    sb.append(pair.getQuote());
                    sb.append(pair.getValue());
                    sb.append(pair.getQuote());
                    ++i;
                }
            }
            if (prefs.alignElementCloseChar()) {
                sb.append(lineDelimiter);
                sb.append(indent);
            } else if (tag.isClosed()) {
                sb.append(' ');
            }
            if (tag.isClosed()) {
                sb.append('/');
            }
            sb.append('>');
            return sb.toString();
        }
    }

    protected static class TagParser {
        private String fElementName;
        private String fParseText;

        protected TagParser() {
        }

        protected List<AttributePair> getAttibutes(String elementText) throws ParseException {
            ArrayList<AttributePair> attributePairs = new ArrayList<AttributePair>();
            StringCharacterIterator iter = new StringCharacterIterator(elementText.substring(this.getElementName(elementText).length() + 2));
            class Mode {
                private int mode;

                Mode() {
                }

                public void setAttributeNameSearching() {
                    this.mode = 0;
                }

                public void setAttributeNameFound() {
                    this.mode = 1;
                }

                public void setAttributeValueSearching() {
                    this.mode = 2;
                }

                public void setAttributeValueFound() {
                    this.mode = 3;
                }

                public void setFinished() {
                    this.mode = 4;
                }

                public boolean isAttributeNameSearching() {
                    return this.mode == 0;
                }

                public boolean isAttributeNameFound() {
                    return this.mode == 1;
                }

                public boolean isAttributeValueSearching() {
                    return this.mode == 2;
                }

                public boolean isAttributeValueFound() {
                    return this.mode == 3;
                }

                public boolean isFinished() {
                    return this.mode == 4;
                }
            }
            Mode mode = new Mode();
            mode.setAttributeNameSearching();
            char attributeQuote = '\"';
            StringBuilder currentAttributeName = null;
            StringBuilder currentAttributeValue = null;
            char c = iter.first();
            while (iter.getIndex() < iter.getEndIndex()) {
                switch (c) {
                    case '\"': 
                    case '\'': {
                        if (mode.isAttributeValueSearching()) {
                            attributeQuote = c;
                            mode.setAttributeValueFound();
                            currentAttributeValue = new StringBuilder(1024);
                            break;
                        }
                        if (mode.isAttributeValueFound() && attributeQuote == c) {
                            AttributePair pair = new AttributePair(currentAttributeName.toString(), currentAttributeValue.toString(), attributeQuote);
                            attributePairs.add(pair);
                            mode.setAttributeNameSearching();
                            break;
                        }
                        if (mode.isAttributeValueFound() && attributeQuote != c) {
                            currentAttributeValue.append(c);
                            break;
                        }
                        throw new ParseException("Unexpected '" + c + "' when parsing:\n\t" + elementText);
                    }
                    case '=': {
                        if (mode.isAttributeValueFound()) {
                            currentAttributeValue.append(c);
                            break;
                        }
                        if (mode.isAttributeNameFound()) {
                            mode.setAttributeValueSearching();
                            break;
                        }
                        throw new ParseException("Unexpected '" + c + "' when parsing:\n\t" + elementText);
                    }
                    case '/': 
                    case '>': {
                        if (mode.isAttributeValueFound()) {
                            currentAttributeValue.append(c);
                            break;
                        }
                        if (mode.isAttributeNameSearching()) {
                            mode.setFinished();
                            break;
                        }
                        if (mode.isFinished()) break;
                        throw new ParseException("Unexpected '" + c + "' when parsing:\n\t" + elementText);
                    }
                    default: {
                        if (mode.isAttributeValueFound()) {
                            currentAttributeValue.append(c);
                            break;
                        }
                        if (mode.isFinished()) {
                            if (Character.isWhitespace(c)) break;
                            throw new ParseException("Unexpected '" + c + "' when parsing:\n\t" + elementText);
                        }
                        if (Character.isWhitespace(c)) break;
                        if (mode.isAttributeNameSearching()) {
                            mode.setAttributeNameFound();
                            currentAttributeName = new StringBuilder(255);
                            currentAttributeName.append(c);
                            break;
                        }
                        if (!mode.isAttributeNameFound()) break;
                        currentAttributeName.append(c);
                    }
                }
                c = iter.next();
            }
            if (!mode.isFinished()) {
                throw new ParseException("Element did not complete normally.");
            }
            return attributePairs;
        }

        protected String getElementName(String tagText) throws ParseException {
            if (!tagText.equals(this.fParseText) || this.fElementName == null) {
                int endOfTag = this.tagEnd(tagText);
                if (tagText.length() > 2 && endOfTag > 1) {
                    this.fParseText = tagText;
                    this.fElementName = tagText.substring(1, endOfTag);
                } else {
                    throw new ParseException("No element name for the tag:\n\t" + tagText);
                }
            }
            return this.fElementName;
        }

        protected boolean isClosed(String tagText) {
            return tagText.charAt(tagText.lastIndexOf(62) - 1) == '/';
        }

        public Tag parse(String tagText) throws ParseException {
            Tag tag = new Tag();
            tag.setElementName(this.getElementName(tagText));
            tag.setAttributes(this.getAttibutes(tagText));
            tag.setClosed(this.isClosed(tagText));
            return tag;
        }

        private int tagEnd(String text) {
            int i = 1;
            while (i < text.length()) {
                char c = text.charAt(i);
                if (!Character.isLetterOrDigit(c) && c != ':' && c != '.' && c != '-' && c != '_') {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

