/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.java;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.OrmException;
import com.google.gwtorm.client.RowVersion;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.Util;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class JavaColumnModel
extends ColumnModel {
    private final Field field;

    public JavaColumnModel(Field columnField) throws OrmException {
        this.field = columnField;
        this.initName(this.field.getName(), this.field.getAnnotation(Column.class));
        if (Modifier.isPrivate(this.field.getModifiers())) {
            throw new OrmException("Field " + this.field.getName() + " of " + this.field.getDeclaringClass().getName() + " must not be private");
        }
        if (Modifier.isFinal(this.field.getModifiers())) {
            throw new OrmException("Field " + this.field.getName() + " of " + this.field.getDeclaringClass().getName() + " must not be final");
        }
        boolean bl = this.rowVersion = this.field.getAnnotation(RowVersion.class) != null;
        if (this.rowVersion && this.field.getType() != Integer.TYPE) {
            throw new OrmException("Field " + this.field.getName() + " of " + this.field.getDeclaringClass().getName() + " must have type 'int'");
        }
        if (this.isNested()) {
            ArrayList<JavaColumnModel> col = new ArrayList<JavaColumnModel>();
            for (Class<?> in = this.field.getType(); in != null; in = in.getSuperclass()) {
                for (Field f : in.getDeclaredFields()) {
                    if (f.getAnnotation(Column.class) == null) continue;
                    col.add(new JavaColumnModel(f));
                }
            }
            this.initNestedColumns(col);
        }
    }

    @Override
    public String getFieldName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getPrimitiveType() {
        return this.isPrimitive() ? this.field.getType() : null;
    }

    @Override
    public String getNestedClassName() {
        return this.isPrimitive() ? null : this.field.getType().getName();
    }

    public Class<?> getNestedClass() {
        return this.field.getType();
    }

    private boolean isPrimitive() {
        return Util.isSqlPrimitive(this.field.getType());
    }
}

