/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaMergeViewer;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.text.JavaScriptTextTools;

public class JavaTextViewer
extends Viewer {
    private SourceViewer fSourceViewer;
    private Object fInput;

    JavaTextViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 0x2000300);
        JavaScriptTextTools tools = JavaCompareUtilities.getJavaTextTools();
        if (tools != null) {
            IPreferenceStore store = JavaScriptPlugin.getDefault().getCombinedPreferenceStore();
            this.fSourceViewer.configure((SourceViewerConfiguration)new JavaScriptSourceViewerConfiguration(tools.getColorManager(), store, null, "___java_partitioning"));
        }
        this.fSourceViewer.setEditable(false);
        String symbolicFontName = JavaMergeViewer.class.getName();
        Font font = JFaceResources.getFont((String)symbolicFontName);
        if (font != null) {
            this.fSourceViewer.getTextWidget().setFont(font);
        }
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void setInput(Object input) {
        if (input instanceof IStreamContentAccessor) {
            Document document = new Document(JavaTextViewer.getString(input));
            JavaCompareUtilities.setupDocument((IDocument)document);
            this.fSourceViewer.setDocument((IDocument)document);
        }
        this.fInput = input;
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection s, boolean reveal) {
    }

    public void refresh() {
    }

    private static String getString(Object input) {
        if (input instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)input;
            try {
                return JavaCompareUtilities.readString(sca);
            }
            catch (CoreException ex) {
                JavaScriptPlugin.log(ex);
            }
        }
        return "";
    }
}

