/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.gef.command.CompoundEditCommand;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.OutlineImageFigure;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.header.IHeadersProvider;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.helpers.BroadcastListenerHelper;
import org.eclipse.wb.core.model.IObjectInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.Polyline;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Transposer;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsolutePolicyUtils;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.KeyboardMovingLayoutEditPolicy;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IPasteComponentProcessor;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.swt.gef.ControlsLayoutRequestValidator;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormHeaderEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormHeaderLayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormSelectionEditPolicyClassic;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormUtils;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplClassic;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutPreferences;
import org.eclipse.wb.internal.swt.model.layout.form.IFormAttachmentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ICompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public class FormLayoutEditPolicyClassic<C extends IControlInfo>
extends KeyboardMovingLayoutEditPolicy
implements IHeadersProvider {
    private static final int EXTENSION = 8;
    private final IFormLayoutInfo<C> layout;
    private final ObjectInfo layoutModel;
    private final FormLayoutInfoImplClassic<C> layoutImpl;
    private static final Color offsetColor = AbsolutePolicyUtils.COLOR_FEEDBACK;
    private static final Color baseColor = DrawUtils.getShiftedColor((Color)offsetColor, (int)-32);
    private static final Color controlColor = DrawUtils.getShiftedColor((Color)offsetColor, (int)32);
    private final Map<EditPart, List<Figure>> feedbacks = Maps.newHashMap();
    private Map<EditPart, Figure> moveFeedbacks;
    private int lastMouseQuadrant;
    private int frozenYValue;
    private CompoundEditCommand moveChildredCommand;
    private Point startLocation;
    private CompoundEditCommand createCommand;
    private Map<EditPart, TextFeedback> xTextFeedbacks = Maps.newHashMap();
    private Map<EditPart, TextFeedback> yTextFeedbacks = Maps.newHashMap();
    private TextFeedback createControlHintFeedbackX;
    private TextFeedback createControlHintFeedbackY;
    private FormHeaderLayoutEditPolicy<C> headersPolicyHorizontal;
    private FormHeaderLayoutEditPolicy<C> headersPolicyVertical;

    public FormLayoutEditPolicyClassic(IFormLayoutInfo<C> layout) {
        this.layout = layout;
        this.layoutModel = layout.getUnderlyingModel();
        this.layoutImpl = (FormLayoutInfoImplClassic)layout.getImpl();
        new BroadcastListenerHelper(layout.getUnderlyingModel(), (EditPolicy)this, (Object)new ObjectEventListener(){

            public void refreshed() throws Exception {
                FormLayoutEditPolicyClassic.this.showSelectionFeedbacks();
            }
        });
    }

    protected void decorateChild(EditPart child) {
        if (this.layout.getControls().contains(child.getModel())) {
            child.installEditPolicy((Object)"Selection Feedback", new FormSelectionEditPolicyClassic<C>(this.layout));
        }
    }

    protected void showLayoutTargetFeedback(final Request request) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                if (request instanceof ChangeBoundsRequest) {
                    FormLayoutEditPolicyClassic.this.showMoveFeedback((ChangeBoundsRequest)request);
                } else if (request instanceof CreateRequest) {
                    FormLayoutEditPolicyClassic.this.showCreateFeedback((CreateRequest)request);
                } else if (request instanceof PasteRequest) {
                    FormLayoutEditPolicyClassic.this.showPasteFeedback((PasteRequest)request);
                }
            }
        });
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.moveFeedbacks != null) {
            for (Figure feedback : this.moveFeedbacks.values()) {
                this.removeFeedback(feedback);
            }
            this.moveFeedbacks = null;
        }
        this.removeFeedbacks();
        this.frozenYValue = 0;
    }

    protected String getResizeRequestType() {
        return "_absolute_resize";
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return ControlsLayoutRequestValidator.INSTANCE;
    }

    private void showMoveFeedback(ChangeBoundsRequest request) throws Exception {
        this.moveChildredCommand = new CompoundEditCommand(this.layoutModel);
        for (EditPart part : request.getEditParts()) {
            this.showMoveFeedback(request, (GraphicalEditPart)part);
        }
    }

    private void showMoveFeedback(ChangeBoundsRequest request, GraphicalEditPart part) throws Exception {
        Rectangle widgetBounds = part.getFigure().getBounds().getCopy();
        FigureUtils.translateFigureToAbsolute2((Figure)part.getFigure().getParent(), (Translatable)widgetBounds);
        this.translateAbsoluteToModel((Translatable)widgetBounds);
        Point moveDelta = request.getMoveDelta();
        widgetBounds.x += moveDelta.x;
        widgetBounds.y = this.isFreezeVerticalAxis((Request)request) ? this.frozenYValue : (this.frozenYValue = widgetBounds.y + moveDelta.y);
        this.showMoveFeedback(part, widgetBounds);
    }

    private void showMoveFeedback(GraphicalEditPart part, Rectangle bounds) throws Exception {
        Figure moveFeedback;
        final IControlInfo control = (IControlInfo)part.getModel();
        if (control.getParent() != this.layout.getComposite()) {
            this.moveChildredCommand.add((Command)new EditCommand(this.layoutModel){

                protected void executeEdit() throws Exception {
                    FormLayoutEditPolicyClassic.this.layout.commandMove(control, null);
                }
            });
        }
        FormSelectionEditPolicyClassic formSelectionPolicy = null;
        EditPolicy selectionPolicy = part.getEditPolicy((Object)"Selection Feedback");
        if (selectionPolicy instanceof FormSelectionEditPolicyClassic) {
            formSelectionPolicy = (FormSelectionEditPolicyClassic)selectionPolicy;
        }
        int quadrant = 0;
        if (formSelectionPolicy != null && !this.isKeyboardMoving() && (quadrant = formSelectionPolicy.getMouseQuadrant()) == -1) {
            quadrant = this.lastMouseQuadrant;
        }
        this.lastMouseQuadrant = quadrant;
        if (this.moveFeedbacks == null) {
            this.moveFeedbacks = Maps.newHashMap();
        }
        if ((moveFeedback = this.moveFeedbacks.get(part)) == null) {
            moveFeedback = new OutlineImageFigure(control.getImage(), AbsolutePolicyUtils.COLOR_OUTLINE);
            this.moveFeedbacks.put((EditPart)part, moveFeedback);
            this.addFeedback(moveFeedback);
        }
        String xText = "";
        String yText = "";
        TextFeedback xTextFeedback = this.getTextFeedback(this.xTextFeedbacks, (EditPart)part, true);
        TextFeedback yTextFeedback = this.getTextFeedback(this.yTextFeedbacks, (EditPart)part, false);
        IFormAttachmentInfo<IControlInfo> leftAttachment = this.layoutImpl.getAttachment(control, 1);
        IFormAttachmentInfo<IControlInfo> rightAttachment = this.layoutImpl.getAttachment(control, 4);
        IFormAttachmentInfo<IControlInfo> topAttachment = this.layoutImpl.getAttachment(control, 8);
        IFormAttachmentInfo<IControlInfo> bottomAttachment = this.layoutImpl.getAttachment(control, 32);
        this.removeFeedbacks((EditPart)part);
        if (formSelectionPolicy != null) {
            formSelectionPolicy.hideSelection();
        }
        Point location = bounds.getTopLeft();
        List<Object> hAttachables = this.getAttachableControls(null, true, false);
        List<Object> vAttachables = this.getAttachableControls(null, false, false);
        if (quadrant == 0 || quadrant == 2) {
            xText = this.showLeftSideFeedbacks(part, control, bounds, location, xText, leftAttachment, hAttachables, false);
        }
        if (quadrant == 0 || quadrant == 1) {
            yText = this.showTopSideFeedbacks(part, control, bounds, location, yText, topAttachment, vAttachables, false);
        }
        if (quadrant == 1 || quadrant == 3) {
            xText = this.showRightSideFeedbacks(part, control, bounds, xText, rightAttachment, hAttachables, false);
        }
        if (quadrant == 2 || quadrant == 3) {
            yText = this.showBottomSideFeedbacks(part, control, bounds, yText, bottomAttachment, vAttachables, false);
        }
        ICompositeInfo composite = this.layout.getComposite();
        Dimension parentSize = composite.getClientArea().getSize();
        Rectangle feedbackBounds = bounds.getCopy();
        this.translateModelToFeedback((Translatable)feedbackBounds);
        moveFeedback.setBounds(feedbackBounds);
        this.updateTextFeedback(xTextFeedback, xText, bounds, parentSize, quadrant == 0 || quadrant == 2, true);
        this.updateTextFeedback(yTextFeedback, yText, bounds, parentSize, quadrant == 0 || quadrant == 1, false);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        return this.moveChildredCommand;
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        return this.moveChildredCommand;
    }

    private void showCreateFeedback(CreateRequest request) throws Exception {
        final IControlInfo newChild = (IControlInfo)request.getNewObject();
        this.createCommand = new CompoundEditCommand(this.layoutModel);
        this.createCommand.add((Command)new EditCommand(this.layout){

            protected void executeEdit() throws Exception {
                FormLayoutEditPolicyClassic.this.layout.commandCreate(newChild, null);
            }
        });
        this.showCreateFeedback(request, newChild);
    }

    private void showCreateFeedback(CreateRequest request, C newChild) throws Exception {
        Dimension preferredSize;
        Point topLeftPoint;
        if (this.moveFeedbacks == null) {
            this.moveFeedbacks = Maps.newHashMap();
        }
        this.removeFeedbacks();
        Figure moveFeedback = this.moveFeedbacks.get(this.getHost());
        Image image = newChild.getImage();
        if (moveFeedback == null) {
            moveFeedback = new OutlineImageFigure(image);
            this.moveFeedbacks.put((EditPart)this.getHost(), moveFeedback);
            this.addFeedback(moveFeedback);
        }
        GraphicalEditPart host = this.getHost();
        String xText = "";
        String yText = "";
        TextFeedback locationFeedbackX = this.getTextFeedback(this.xTextFeedbacks, (EditPart)host, true);
        TextFeedback locationFeedbackY = this.getTextFeedback(this.yTextFeedbacks, (EditPart)host, false);
        Point loc = request.getLocation().getCopy();
        ICompositeInfo composite = this.layout.getComposite();
        Dimension parentSize = composite.getClientArea().getSize();
        this.translateAbsoluteToModel((Translatable)loc);
        Dimension size = request.getSize();
        if (size != null) {
            topLeftPoint = new Point(this.startLocation.x, this.startLocation.y);
            preferredSize = new Dimension(size.width + loc.x - this.startLocation.x, size.height + loc.y - this.startLocation.y);
            this.frozenYValue = 0;
        } else {
            preferredSize = newChild.getPreferredSize();
            boolean freezeVerticalAxis = this.isFreezeVerticalAxis((Request)request);
            int y = freezeVerticalAxis ? this.frozenYValue : (this.frozenYValue = loc.y - preferredSize.height / 2);
            topLeftPoint = new Point(loc.x - preferredSize.width / 2, y);
        }
        Rectangle bounds = new Rectangle(topLeftPoint.x, topLeftPoint.y, preferredSize.width, preferredSize.height);
        if (size == null) {
            this.startLocation = bounds.getLocation();
        }
        List<Object> ctrls = this.getAttachableControls(null, false, true);
        xText = this.showLeftSideFeedbacks(host, newChild, bounds, loc, xText, null, ctrls, true);
        this.updateTextFeedback(locationFeedbackX, xText, bounds, parentSize, true, true);
        yText = this.showTopSideFeedbacks(host, newChild, bounds, loc, yText, null, ctrls, true);
        this.updateTextFeedback(locationFeedbackY, yText, bounds, parentSize, true, false);
        if (size != null) {
            if (this.createControlHintFeedbackX == null) {
                this.createControlHintFeedbackX = this.createTextFeedback(true);
                this.createControlHintFeedbackX.add();
            }
            if (this.createControlHintFeedbackY == null) {
                this.createControlHintFeedbackY = this.createTextFeedback(false);
                this.createControlHintFeedbackY.add();
            }
            xText = this.showRightSideFeedbacks(host, newChild, bounds, xText, null, ctrls, true);
            this.updateTextFeedback(this.createControlHintFeedbackX, xText, bounds, parentSize, false, true);
            yText = this.showBottomSideFeedbacks(host, newChild, bounds, yText, null, ctrls, true);
            this.updateTextFeedback(this.createControlHintFeedbackY, yText, bounds, parentSize, false, false);
        }
        Rectangle feedbackBounds = bounds.getCopy();
        this.translateModelToFeedback((Translatable)feedbackBounds);
        moveFeedback.setBounds(feedbackBounds);
    }

    private void updateTextFeedback(TextFeedback feedback, String text, Rectangle bounds, Dimension parentSize_, boolean isLeading, boolean isHorizontal) {
        int x;
        feedback.setText(text);
        Transposer t = new Transposer(!isHorizontal);
        Dimension textSize = t.t(feedback.getSize());
        Rectangle textBounds = t.t(bounds.getCopy());
        Dimension parentSize = t.t(parentSize_.getCopy());
        textBounds.y = parentSize.height + 1;
        int n = x = isLeading ? textBounds.x : textBounds.right();
        if ((x -= textSize.width / 2) < 0) {
            x = 0;
        } else if (x + textSize.width > parentSize.width) {
            x = parentSize.width - textSize.width;
        }
        textBounds.x = x;
        textBounds = t.t(textBounds);
        this.translateModelToFeedback((Translatable)textBounds);
        feedback.setLocation(textBounds.getLocation());
    }

    protected Command getCreateCommand(CreateRequest request) {
        return this.createCommand;
    }

    private void showPasteFeedback(PasteRequest request) throws Exception {
        Rectangle bounds;
        List pastingComponents = GlobalState.getPasteRequestProcessor().getPastingComponents(request);
        if (this.moveFeedbacks == null) {
            this.moveFeedbacks = Maps.newHashMap();
        }
        if (this.moveFeedbacks == null) {
            this.moveFeedbacks = Maps.newHashMap();
        }
        this.removeFeedbacks();
        GraphicalEditPart host = this.getHost();
        String xText = "";
        String yText = "";
        TextFeedback locationFeedbackX = this.getTextFeedback(this.xTextFeedbacks, (EditPart)host, true);
        TextFeedback locationFeedbackY = this.getTextFeedback(this.yTextFeedbacks, (EditPart)host, false);
        Point loc = request.getLocation().getCopy();
        this.translateAbsoluteToModel((Translatable)loc);
        Figure moveFeedback = this.moveFeedbacks.get(this.getHost());
        Rectangle[] relativeBounds = new Rectangle[pastingComponents.size()];
        if (pastingComponents.size() > 1) {
            if (moveFeedback == null) {
                moveFeedback = new OutlineImageFigure(null);
                this.moveFeedbacks.put((EditPart)this.getHost(), moveFeedback);
                this.addFeedback(moveFeedback);
            }
            bounds = new Rectangle();
            int offsetX = Integer.MAX_VALUE;
            int offsetY = Integer.MAX_VALUE;
            for (IObjectInfo objInfo : pastingComponents) {
                IControlInfo model = (IControlInfo)objInfo;
                Rectangle modelBounds = model.getBounds().getCopy();
                offsetX = Math.min(offsetX, modelBounds.x);
                offsetY = Math.min(offsetY, modelBounds.y);
            }
            int i = 0;
            while (i < pastingComponents.size()) {
                C control = this.getControlFromList(pastingComponents, i);
                Rectangle modelBounds = control.getBounds().getCopy();
                relativeBounds[i] = new Rectangle(modelBounds.x - offsetX, modelBounds.y - offsetY, modelBounds.width, modelBounds.height);
                bounds.union(relativeBounds[i]);
                moveFeedback.add((Figure)new OutlineImageFigure(control.getImage(), AbsolutePolicyUtils.COLOR_OUTLINE), relativeBounds[i]);
                ++i;
            }
        } else {
            C model = this.getControlFromList(pastingComponents, 0);
            bounds = new Rectangle(new Point(0, 0), model.getBounds().getSize());
            relativeBounds[0] = bounds.getCopy();
            if (moveFeedback == null) {
                moveFeedback = new OutlineImageFigure(model.getImage(), AbsolutePolicyUtils.COLOR_OUTLINE);
                this.moveFeedbacks.put((EditPart)this.getHost(), moveFeedback);
                this.addFeedback(moveFeedback);
            }
        }
        bounds.x = loc.x - bounds.width / 2;
        bounds.y = this.isFreezeVerticalAxis((Request)request) ? this.frozenYValue : (this.frozenYValue = loc.y - bounds.height / 2);
        List<Object> ctrls = this.getAttachableControls(null, false, true);
        ICompositeInfo composite = this.layout.getComposite();
        Dimension parentSize = composite.getClientArea().getSize();
        this.createCommand = new CompoundEditCommand(this.layoutModel);
        this.createCommand.add(GlobalState.getPasteRequestProcessor().getPasteCommand(request, new IPasteComponentProcessor(){

            public void process(Object component) throws Exception {
                FormLayoutEditPolicyClassic.this.layout.commandCreate((IControlInfo)component, null);
            }
        }));
        int i = 0;
        while (i < pastingComponents.size()) {
            C pasted = this.getControlFromList(pastingComponents, i);
            final Dimension size = new Dimension(relativeBounds[i].width, relativeBounds[i].height);
            Rectangle pastedBounds = new Rectangle(bounds.x + relativeBounds[i].x, bounds.y + relativeBounds[i].y, relativeBounds[i].width, relativeBounds[i].height);
            xText = this.showLeftSideFeedbacks(host, pasted, pastedBounds, loc, xText, null, ctrls, true);
            if (i == 0) {
                this.updateTextFeedback(locationFeedbackX, xText, pastedBounds, parentSize, true, true);
            }
            yText = this.showTopSideFeedbacks(host, pasted, pastedBounds, loc, yText, null, ctrls, true);
            if (i == 0) {
                this.updateTextFeedback(locationFeedbackY, yText, pastedBounds, parentSize, true, false);
            }
            this.createCommand.add((Command)new EditCommand(this.layout, (IControlInfo)pasted, pastedBounds){
                private final /* synthetic */ IControlInfo val$pasted;
                private final /* synthetic */ Rectangle val$pastedBounds;
                {
                    this.val$pasted = iControlInfo;
                    this.val$pastedBounds = rectangle;
                    super($anonymous0);
                }

                protected void executeEdit() throws Exception {
                    if (size.width != this.val$pasted.getPreferredSize().width) {
                        FormLayoutEditPolicyClassic.this.layout.setAttachmentOffset(this.val$pasted, 4, this.val$pastedBounds.x + size.width);
                    }
                    if (size.height != this.val$pasted.getPreferredSize().height) {
                        FormLayoutEditPolicyClassic.this.layout.setAttachmentOffset(this.val$pasted, 32, this.val$pastedBounds.y + size.height);
                    }
                }
            });
            ++i;
        }
        Rectangle feedbackBounds = bounds.getCopy();
        this.translateModelToFeedback((Translatable)feedbackBounds);
        moveFeedback.setBounds(feedbackBounds);
    }

    private C getControlFromList(List<IObjectInfo> list, int i) {
        return (C)((IControlInfo)list.get(i));
    }

    protected Command getPasteCommand(PasteRequest request) {
        return this.createCommand;
    }

    private String showBottomSideFeedbacks(GraphicalEditPart part, C control, Rectangle bounds, String locationY, IFormAttachmentInfo<C> bottomAttachment, List<C> attachables, boolean createControl) {
        int layoutMarginTop = FormUtils.getLayoutMarginTop(this.layout);
        int sens = this.layout.getPreferences().getSnapSensitivity();
        int vMargin = this.layout.getPreferences().getVerticalContainerGap();
        int vpMargin = this.layout.getPreferences().getVerticalPercentsGap();
        int vwMargin = this.layout.getPreferences().getVerticalComponentGap();
        int parentHeight = this.layout.getContainerSize().height;
        int y = bounds.bottom();
        boolean controlFound = false;
        EditCommand cmd = null;
        if (this.useSnap()) {
            if (vwMargin > -1) {
                IControlInfo child = null;
                int cmdSide = 0;
                int cmdOffset = 0;
                Iterator<C> I = FormLayoutEditPolicyClassic.sortControlsByAxisRange(attachables, true, bounds.right()).iterator();
                while (I.hasNext() && !controlFound) {
                    child = (IControlInfo)I.next();
                    Rectangle childBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                    int left = Math.min(bounds.x, childBounds.x);
                    int right = Math.max(bounds.right(), childBounds.right());
                    if (FormUtils.between(childBounds.y - vwMargin - y, 0, sens)) {
                        controlFound = true;
                        this.setVBounds(bounds, childBounds.y - vwMargin, createControl);
                        this.addVLine((EditPart)part, child, childBounds.y, controlColor);
                        this.addVLine((EditPart)part, left, right, childBounds.y - vwMargin, offsetColor);
                        locationY = String.valueOf(this.getChildSideString(child, "y")) + "-" + vwMargin;
                        cmdSide = 8;
                        cmdOffset = -vwMargin;
                        continue;
                    }
                    if (FormUtils.between(childBounds.y - y, -sens, vwMargin)) {
                        controlFound = true;
                        this.setVBounds(bounds, childBounds.y, createControl);
                        this.addVLine((EditPart)part, left, right, childBounds.y, offsetColor);
                        this.addVLine((EditPart)part, child, childBounds.y, controlColor);
                        locationY = this.getChildSideString(child, "y");
                        cmdSide = 8;
                        cmdOffset = 0;
                        continue;
                    }
                    if (!FormUtils.between(childBounds.bottom() - y, -sens, sens)) continue;
                    controlFound = true;
                    this.setVBounds(bounds, childBounds.bottom(), createControl);
                    this.addVLine((EditPart)part, left, right, childBounds.bottom(), offsetColor);
                    this.addVLine((EditPart)part, child, childBounds.bottom(), controlColor);
                    locationY = this.getChildSideString(child, "bottom");
                    cmdSide = 32;
                    cmdOffset = 0;
                }
                if (controlFound) {
                    cmd = this.getBindToControlCommand(createControl, control, 32, child, cmdSide, cmdOffset);
                }
            }
            if (!controlFound) {
                boolean snappedToPercent = false;
                List<Integer> formLayoutVPercents = this.layout.getPreferences().getVerticalPercents();
                for (Integer percent : formLayoutVPercents) {
                    int percentY = (int)((double)percent.intValue() / 100.0 * (double)parentHeight) + layoutMarginTop;
                    int offset = 0;
                    if (FormUtils.between(percentY - vpMargin - y, 0, sens) && vpMargin > -1) {
                        this.setVBounds(bounds, percentY - vpMargin, createControl);
                        this.addVLine((EditPart)part, percentY, baseColor);
                        this.addVLine((EditPart)part, percentY - vpMargin, offsetColor);
                        locationY = String.valueOf(percent.toString()) + "%-" + vpMargin;
                        offset = -vpMargin;
                        snappedToPercent = true;
                    } else if (FormUtils.between(percentY - y, -sens, vpMargin)) {
                        this.setVBounds(bounds, percentY, createControl);
                        this.addVLine((EditPart)part, percentY, offsetColor);
                        locationY = String.valueOf(percent.toString()) + "%";
                        snappedToPercent = true;
                    }
                    if (!snappedToPercent) continue;
                    if (createControl) {
                        cmd = new CreateToPercentOffsetCommand(this, control, 32, percent.intValue(), offset);
                        break;
                    }
                    cmd = new MoveToPercentOffsetCommand(this, control, 32, percent.intValue(), offset);
                    break;
                }
                if (!snappedToPercent) {
                    int bottomPoint = parentHeight - vMargin + layoutMarginTop;
                    if (vMargin > -1 && y > bottomPoint) {
                        this.setVBounds(bounds, bottomPoint, createControl);
                        this.addVLine((EditPart)part, bottomPoint, offsetColor);
                        locationY = "--> " + String.valueOf(vMargin);
                        cmd = createControl ? new CreateToMarginCommand(this, control, 32, 32, vMargin) : new MoveToMarginCommand(this, control, 32, 32, vMargin);
                    } else {
                        this.setVBounds(bounds, FormUtils.snapGrid(bounds.bottom(), sens), createControl);
                        locationY = this.getLocationString(bottomAttachment, bounds.bottom() - layoutMarginTop, parentHeight);
                        cmd = createControl ? new CreateToOffsetCommand(this, control, 32, parentHeight, FormUtils.snapGrid(y - layoutMarginTop, sens)) : new MoveToOffsetCommand(this, control, 32, parentHeight, FormUtils.snapGrid(y - layoutMarginTop, sens));
                    }
                }
            }
        } else {
            locationY = this.getLocationString(bottomAttachment, bounds.bottom(), parentHeight);
            cmd = createControl ? new CreateToOffsetCommand(this, control, 32, parentHeight, y - layoutMarginTop) : new MoveToOffsetCommand(this, control, 32, parentHeight, y - layoutMarginTop);
        }
        this.addVLine((EditPart)part, bounds.bottom(), this.layout.getComposite().getClientArea().width, IColorConstants.red);
        if (createControl) {
            this.createCommand.add((Command)cmd);
        } else {
            this.moveChildredCommand.add((Command)cmd);
        }
        return locationY;
    }

    private String showRightSideFeedbacks(GraphicalEditPart part, C control, Rectangle bounds, String locationX, IFormAttachmentInfo<C> rightAttachment, List<C> attachables, boolean createControl) {
        int layoutMarginLeft = FormUtils.getLayoutMarginLeft(this.layout);
        int hMargin = this.layout.getPreferences().getHorizontalContainerGap();
        int hwMargin = this.layout.getPreferences().getHorizontalComponentGap();
        int hpMargin = this.layout.getPreferences().getHorizontalPercentsGap();
        int sens = this.layout.getPreferences().getSnapSensitivity();
        int parentWidth = this.layout.getContainerSize().width;
        int x = bounds.right();
        boolean controlFound = false;
        EditCommand cmd = null;
        if (this.useSnap()) {
            if (hwMargin > -1) {
                IControlInfo child = null;
                int cmdSide = 0;
                int cmdOffset = 0;
                Iterator<C> I = FormLayoutEditPolicyClassic.sortControlsByAxisRange(attachables, false, bounds.bottom()).iterator();
                while (I.hasNext() && !controlFound) {
                    child = (IControlInfo)I.next();
                    Rectangle childBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                    int top = Math.min(bounds.y, childBounds.y);
                    int bottom = Math.max(bounds.bottom(), childBounds.bottom());
                    if (FormUtils.between(childBounds.x - hwMargin - x, 0, sens)) {
                        controlFound = true;
                        this.setHBounds(bounds, childBounds.x - hwMargin, createControl);
                        this.addHLine((EditPart)part, child, childBounds.x, controlColor);
                        this.addHLine((EditPart)part, top, bottom, childBounds.x - hwMargin, offsetColor);
                        locationX = String.valueOf(this.getChildSideString(child, "x")) + "-" + hwMargin;
                        cmdSide = 1;
                        cmdOffset = -hwMargin;
                        continue;
                    }
                    if (FormUtils.between(childBounds.x - x, -sens, hwMargin)) {
                        controlFound = true;
                        this.setHBounds(bounds, childBounds.x, createControl);
                        this.addHLine((EditPart)part, top, bottom, childBounds.x, offsetColor);
                        this.addHLine((EditPart)part, child, childBounds.x, controlColor);
                        locationX = this.getChildSideString(child, "x");
                        cmdSide = 1;
                        cmdOffset = 0;
                        continue;
                    }
                    if (!FormUtils.between(childBounds.right() - x, -sens, sens)) continue;
                    controlFound = true;
                    this.setHBounds(bounds, childBounds.right(), createControl);
                    this.addHLine((EditPart)part, top, bottom, childBounds.right(), offsetColor);
                    this.addHLine((EditPart)part, child, childBounds.right(), controlColor);
                    locationX = this.getChildSideString(child, "right");
                    cmdSide = 4;
                    cmdOffset = 0;
                }
                if (controlFound) {
                    cmd = this.getBindToControlCommand(createControl, control, 4, child, cmdSide, cmdOffset);
                }
            }
            if (!controlFound) {
                boolean snappedToPercent = false;
                List<Integer> formLayoutHPercents = this.layout.getPreferences().getHorizontalPercents();
                for (Integer percent : formLayoutHPercents) {
                    int percentX = (int)((double)percent.intValue() / 100.0 * (double)parentWidth) + layoutMarginLeft;
                    int offset = 0;
                    if (FormUtils.between(percentX - hpMargin - x, 0, sens) && hpMargin > -1) {
                        this.setHBounds(bounds, percentX - hpMargin, createControl);
                        this.addHLine((EditPart)part, percentX, baseColor);
                        this.addHLine((EditPart)part, percentX - hpMargin, offsetColor);
                        locationX = String.valueOf(percent.toString()) + "%-" + hpMargin;
                        offset = hpMargin;
                        snappedToPercent = true;
                    } else if (FormUtils.between(percentX - x, -sens, hwMargin)) {
                        this.setHBounds(bounds, percentX, createControl);
                        this.addHLine((EditPart)part, percentX, offsetColor);
                        locationX = String.valueOf(percent.toString()) + "%";
                        snappedToPercent = true;
                    }
                    if (!snappedToPercent) continue;
                    if (createControl) {
                        cmd = new CreateToPercentOffsetCommand(this, control, 4, percent.intValue(), -offset);
                        break;
                    }
                    cmd = new MoveToPercentOffsetCommand(this, control, 4, percent.intValue(), -offset);
                    break;
                }
                if (!snappedToPercent) {
                    int rightPoint = parentWidth - hMargin + layoutMarginLeft;
                    if (hMargin > -1 && x > rightPoint) {
                        this.setHBounds(bounds, rightPoint, createControl);
                        this.addHLine((EditPart)part, rightPoint, offsetColor);
                        locationX = String.valueOf(-hMargin);
                        locationX = "--> " + String.valueOf(hMargin);
                        cmd = createControl ? new CreateToMarginCommand(this, control, 4, 4, hMargin) : new MoveToMarginCommand(this, control, 4, 4, hMargin);
                    } else {
                        this.setHBounds(bounds, FormUtils.snapGrid(bounds.right(), sens), createControl);
                        locationX = this.getLocationString(rightAttachment, bounds.right() - layoutMarginLeft, parentWidth);
                        cmd = createControl ? new CreateToOffsetCommand(this, control, 4, parentWidth, FormUtils.snapGrid(x - layoutMarginLeft, sens)) : new MoveToOffsetCommand(this, control, 4, parentWidth, FormUtils.snapGrid(x - layoutMarginLeft, sens));
                    }
                }
            }
        } else {
            locationX = this.getLocationString(rightAttachment, bounds.right() - layoutMarginLeft, parentWidth);
            cmd = createControl ? new CreateToOffsetCommand(this, control, 4, parentWidth, x - layoutMarginLeft) : new MoveToOffsetCommand(this, control, 4, parentWidth, x - layoutMarginLeft);
        }
        this.addHLine((EditPart)part, bounds.right(), this.layout.getComposite().getClientArea().height, IColorConstants.red);
        if (createControl) {
            this.createCommand.add(cmd);
        } else {
            this.moveChildredCommand.add(cmd);
        }
        return locationX;
    }

    private String showTopSideFeedbacks(GraphicalEditPart part, C control, Rectangle bounds, Point location, String locationY, IFormAttachmentInfo<C> topAttachment, List<C> attachables, boolean createControl) {
        int layoutMarginTop = FormUtils.getLayoutMarginTop(this.layout);
        int vModelMargin = this.layout.getPreferences().getVerticalContainerGap();
        int vMargin = vModelMargin + layoutMarginTop;
        int sens = this.layout.getPreferences().getSnapSensitivity();
        int vpMargin = this.layout.getPreferences().getVerticalPercentsGap();
        int vwMargin = this.layout.getPreferences().getVerticalComponentGap();
        int parentHeight = this.layout.getContainerSize().height;
        int y = bounds.y;
        boolean controlFound = false;
        EditCommand cmd = null;
        if (this.useSnap()) {
            if (vwMargin > -1) {
                IControlInfo child = null;
                int cmdSide = 0;
                int cmdOffset = 0;
                Iterator<C> I = FormLayoutEditPolicyClassic.sortControlsByAxisRange(attachables, true, location.x).iterator();
                while (I.hasNext() && !controlFound) {
                    child = (IControlInfo)I.next();
                    Rectangle childBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                    int left = Math.min(bounds.x, childBounds.x);
                    int right = Math.max(bounds.right(), childBounds.right());
                    if (FormUtils.between(y - (childBounds.bottom() + vwMargin), 0, sens)) {
                        controlFound = true;
                        bounds.y = childBounds.bottom() + vwMargin;
                        this.addVLine((EditPart)part, child, childBounds.bottom(), controlColor);
                        this.addVLine((EditPart)part, left, right, childBounds.bottom() + vwMargin, offsetColor);
                        locationY = String.valueOf(this.getChildSideString(child, "bottom")) + "+" + vwMargin;
                        cmdSide = 32;
                        cmdOffset = vwMargin;
                        continue;
                    }
                    if (FormUtils.between(y - childBounds.bottom(), -sens, vwMargin)) {
                        controlFound = true;
                        bounds.y = childBounds.bottom();
                        this.addVLine((EditPart)part, left, right, childBounds.bottom(), offsetColor);
                        this.addVLine((EditPart)part, child, childBounds.bottom(), controlColor);
                        locationY = this.getChildSideString(child, "bottom");
                        cmdSide = 32;
                        cmdOffset = 0;
                        continue;
                    }
                    if (!FormUtils.between(y - childBounds.y, -sens, sens)) continue;
                    controlFound = true;
                    bounds.y = childBounds.y;
                    this.addVLine((EditPart)part, left, right, childBounds.y, offsetColor);
                    this.addVLine((EditPart)part, child, childBounds.y, controlColor);
                    locationY = this.getChildSideString(child, "y");
                    cmdSide = 8;
                    cmdOffset = 0;
                }
                if (controlFound) {
                    cmd = this.getBindToControlCommand(createControl, control, 8, child, cmdSide, cmdOffset);
                }
            }
            if (!controlFound) {
                boolean snappedToPercent = false;
                List<Integer> formLayoutVPercents = this.layout.getPreferences().getVerticalPercents();
                for (Integer percent : formLayoutVPercents) {
                    int percentY = (int)((double)percent.intValue() / 100.0 * (double)parentHeight) + layoutMarginTop;
                    int offset = 0;
                    if (FormUtils.between(y - (percentY + vpMargin), 0, sens) && vpMargin > -1) {
                        bounds.y = percentY + vpMargin;
                        this.addVLine((EditPart)part, percentY, baseColor);
                        this.addVLine((EditPart)part, percentY + vpMargin, offsetColor);
                        locationY = String.valueOf(percent.toString()) + "%+" + vpMargin;
                        offset = vpMargin;
                        snappedToPercent = true;
                    } else if (FormUtils.between(y - percentY, -sens, vwMargin)) {
                        bounds.y = percentY;
                        this.addVLine((EditPart)part, percentY, offsetColor);
                        locationY = String.valueOf(percent.toString()) + "%";
                        snappedToPercent = true;
                    }
                    if (!snappedToPercent) continue;
                    if (createControl) {
                        cmd = new CreateToPercentOffsetCommand(this, control, 8, percent.intValue(), offset);
                        break;
                    }
                    cmd = new MoveToPercentOffsetCommand(this, control, 8, percent.intValue(), offset);
                    break;
                }
                if (!snappedToPercent) {
                    if (vMargin > -1 && y < vMargin) {
                        bounds.y = vMargin;
                        this.addVLine((EditPart)part, vMargin, offsetColor);
                        cmd = createControl ? new CreateToMarginCommand(this, control, 8, 8, vModelMargin) : new MoveToMarginCommand(this, control, 8, 8, vModelMargin);
                    } else {
                        bounds.y = FormUtils.snapGrid(y, sens);
                        cmd = createControl ? new CreateToOffsetCommand(this, control, 8, parentHeight, FormUtils.snapGrid(y - layoutMarginTop, sens)) : new MoveToOffsetCommand(this, control, 8, parentHeight, FormUtils.snapGrid(y - layoutMarginTop, sens));
                    }
                    locationY = this.getLocationString(topAttachment, bounds.y - layoutMarginTop, parentHeight);
                }
            }
        } else {
            locationY = this.getLocationString(topAttachment, bounds.y - layoutMarginTop, parentHeight);
            cmd = createControl ? new CreateToOffsetCommand(this, control, 8, parentHeight, y - layoutMarginTop) : new MoveToOffsetCommand(this, control, 8, parentHeight, y - layoutMarginTop);
        }
        this.addVLine((EditPart)part, bounds.y, this.layout.getComposite().getClientArea().width, IColorConstants.red);
        if (createControl) {
            this.createCommand.add(cmd);
        } else {
            this.moveChildredCommand.add(cmd);
        }
        return locationY;
    }

    private String showLeftSideFeedbacks(GraphicalEditPart part, C control, Rectangle bounds, Point location, String locationX, IFormAttachmentInfo<C> leftAttachment, List<C> attachables, boolean createControl) {
        int layoutMarginLeft = FormUtils.getLayoutMarginLeft(this.layout);
        int hModelMargin = this.layout.getPreferences().getHorizontalContainerGap();
        int hMargin = hModelMargin + layoutMarginLeft;
        int hwMargin = this.layout.getPreferences().getHorizontalComponentGap();
        int hpMargin = this.layout.getPreferences().getHorizontalPercentsGap();
        int sens = this.layout.getPreferences().getSnapSensitivity();
        int parentWidth = this.layout.getContainerSize().width;
        int x = bounds.x;
        boolean controlFound = false;
        EditCommand cmd = null;
        if (this.useSnap()) {
            if (hwMargin > -1) {
                IControlInfo child = null;
                int cmdSide = 0;
                int cmdOffset = 0;
                Iterator<C> I = FormLayoutEditPolicyClassic.sortControlsByAxisRange(attachables, false, location.y).iterator();
                while (I.hasNext() && !controlFound) {
                    child = (IControlInfo)I.next();
                    Rectangle childBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                    int top = Math.min(bounds.y, childBounds.y);
                    int bottom = Math.max(bounds.bottom(), childBounds.bottom());
                    if (FormUtils.between(x - (childBounds.right() + hwMargin), 0, sens)) {
                        controlFound = true;
                        bounds.x = childBounds.right() + hwMargin;
                        this.addHLine((EditPart)part, child, childBounds.right(), controlColor);
                        this.addHLine((EditPart)part, top, bottom, childBounds.right() + hwMargin, offsetColor);
                        locationX = String.valueOf(this.getChildSideString(child, "right")) + "+" + hwMargin;
                        cmdSide = 4;
                        cmdOffset = hwMargin;
                        continue;
                    }
                    if (FormUtils.between(x - childBounds.right(), -sens, hwMargin)) {
                        controlFound = true;
                        bounds.x = childBounds.right();
                        this.addHLine((EditPart)part, top, bottom, childBounds.right(), offsetColor);
                        this.addHLine((EditPart)part, child, childBounds.right(), controlColor);
                        locationX = this.getChildSideString(child, "right");
                        cmdSide = 4;
                        cmdOffset = 0;
                        continue;
                    }
                    if (!FormUtils.between(x - childBounds.x, -sens, sens)) continue;
                    controlFound = true;
                    bounds.x = childBounds.x;
                    this.addHLine((EditPart)part, top, bottom, childBounds.x, offsetColor);
                    this.addHLine((EditPart)part, child, childBounds.x, controlColor);
                    locationX = this.getChildSideString(child, "x");
                    cmdSide = 1;
                    cmdOffset = 0;
                }
                if (controlFound) {
                    cmd = this.getBindToControlCommand(createControl, control, 1, child, cmdSide, cmdOffset);
                }
            }
            if (!controlFound) {
                boolean snappedToPercent = false;
                List<Integer> formLayoutHPercents = this.layout.getPreferences().getHorizontalPercents();
                for (Integer percent : formLayoutHPercents) {
                    int percentX = (int)((double)percent.intValue() / 100.0 * (double)parentWidth) + layoutMarginLeft;
                    int offset = 0;
                    if (FormUtils.between(x - (percentX + hpMargin), 0, sens) && hpMargin > -1) {
                        bounds.x = percentX + hpMargin;
                        this.addHLine((EditPart)part, percentX, baseColor);
                        this.addHLine((EditPart)part, percentX + hpMargin, offsetColor);
                        locationX = String.valueOf(percent.toString()) + "%+" + hpMargin;
                        offset = hpMargin;
                        snappedToPercent = true;
                    } else if (FormUtils.between(x - percentX, -sens, hwMargin)) {
                        bounds.x = percentX;
                        this.addHLine((EditPart)part, percentX, offsetColor);
                        locationX = String.valueOf(percent.toString()) + "%";
                        snappedToPercent = true;
                    }
                    if (!snappedToPercent) continue;
                    if (createControl) {
                        cmd = new CreateToPercentOffsetCommand(this, control, 1, percent.intValue(), offset);
                        break;
                    }
                    cmd = new MoveToPercentOffsetCommand(this, control, 1, percent.intValue(), offset);
                    break;
                }
                if (!snappedToPercent) {
                    if (hMargin > -1 && x < hMargin) {
                        bounds.x = hMargin;
                        this.addHLine((EditPart)part, hMargin, offsetColor);
                        cmd = createControl ? new CreateToMarginCommand(this, control, 1, 1, hModelMargin) : new MoveToMarginCommand(this, control, 1, 1, hModelMargin);
                    } else {
                        bounds.x = FormUtils.snapGrid(x, sens);
                        cmd = createControl ? new CreateToOffsetCommand(this, control, 1, parentWidth, FormUtils.snapGrid(x - layoutMarginLeft, sens)) : new MoveToOffsetCommand(this, control, 1, parentWidth, FormUtils.snapGrid(x - layoutMarginLeft, sens));
                    }
                    locationX = this.getLocationString(leftAttachment, bounds.x - layoutMarginLeft, parentWidth);
                }
            }
        } else {
            locationX = this.getLocationString(leftAttachment, bounds.x - layoutMarginLeft, parentWidth);
            cmd = createControl ? new CreateToOffsetCommand(this, control, 1, parentWidth, x - layoutMarginLeft) : new MoveToOffsetCommand(this, control, 1, parentWidth, x - layoutMarginLeft);
        }
        this.addHLine((EditPart)part, bounds.x, this.layout.getComposite().getClientArea().height, IColorConstants.red);
        if (createControl) {
            this.createCommand.add(cmd);
        } else {
            this.moveChildredCommand.add(cmd);
        }
        return locationX;
    }

    private String getLocationString(IFormAttachmentInfo<C> attachment, int coord, int parentDimension) {
        String locationX = attachment == null || attachment.getNumerator() != 100 ? String.valueOf(String.valueOf(coord)) + " <--" : "--> " + String.valueOf(parentDimension - coord);
        return locationX;
    }

    private String getChildSideString(C child, String side) {
        String variableName = FormUtils.getVariableName(child);
        if (variableName != null) {
            return variableName;
        }
        Rectangle bounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
        if (side.equals("x")) {
            return String.valueOf(bounds.x);
        }
        if (side.equals("right")) {
            return String.valueOf(bounds.right());
        }
        if (side.equals("y")) {
            return String.valueOf(bounds.y);
        }
        if (side.equals("bottom")) {
            return String.valueOf(bounds.bottom());
        }
        return "???";
    }

    private Command getBindToControlCommand(boolean createControl, C control, int controlSide, C child, int cmdSide, int cmdOffset) {
        if (createControl) {
            return new CreateToControlCommand(this, control, controlSide, child, cmdSide, cmdOffset);
        }
        return new MoveToControlCommand(this, control, controlSide, child, cmdSide, cmdOffset);
    }

    public boolean useSnap() {
        if (this.isKeyboardMoving()) {
            return false;
        }
        return !DesignerPlugin.isShiftPressed();
    }

    private boolean isFreezeVerticalAxis(Request request) {
        return request.isControlKeyPressed() && this.frozenYValue != 0;
    }

    private Polyline addHFeedbackLine(int x, int y1, int y2, Color color) {
        return this.addFeedbackLine(x, y1, x, y2, color);
    }

    private Polyline addVFeedbackLine(int y, int x1, int x2, Color color) {
        return this.addFeedbackLine(x1, y, x2, y, color);
    }

    private Polyline addFeedbackLine(int x1, int y1, int x2, int y2, Color color) {
        Polyline line = new Polyline();
        Point p1 = new Point(x1, y1);
        Point p2 = new Point(x2, y2);
        this.translateModelToFeedback((Translatable)p1);
        this.translateModelToFeedback((Translatable)p2);
        line.addPoint(p1);
        line.addPoint(p2);
        line.setForeground(color);
        line.setLineStyle(3);
        this.addFeedback((Figure)line);
        return line;
    }

    private void addFeedbackLine(EditPart part, Polyline line) {
        LinkedList partFeedbacks;
        if (part == null) {
            part = this.getHost();
        }
        if ((partFeedbacks = this.feedbacks.get(part)) == null) {
            partFeedbacks = Lists.newLinkedList();
            this.feedbacks.put(part, partFeedbacks);
        }
        partFeedbacks.add(line);
    }

    private void addHLine(EditPart part, int x, int parentHeight, Color color) {
        Polyline line = this.addHFeedbackLine(x, parentHeight - 5, parentHeight + 5, color);
        line.setLineWidth(3);
        line.setLineStyle(1);
        this.addFeedbackLine(part, line);
    }

    private void addHLine(EditPart part, C component, int x, Color color) {
        Rectangle bounds = FormSelectionEditPolicyClassic.getControlModelBounds(component);
        Polyline line = this.addHFeedbackLine(x, bounds.y, bounds.bottom(), color);
        line.setLineWidth(2);
        line.setLineStyle(1);
        this.addFeedbackLine(part, line);
    }

    private void addHLine(EditPart part, int x, Color color) {
        ICompositeInfo composite = this.layout.getComposite();
        int parentHeight = composite.getClientArea().height;
        Polyline line = this.addHFeedbackLine(x, 0, parentHeight, color);
        this.addFeedbackLine(part, line);
    }

    private void addHLine(EditPart part, int top, int bottom, int x, Color color) {
        Polyline line = this.addHFeedbackLine(x, top - 8, bottom + 8, color);
        this.addFeedbackLine(part, line);
    }

    private void addVLine(EditPart part, int y, int parentWidth, Color color) {
        Polyline line = this.addVFeedbackLine(y, parentWidth - 5, parentWidth + 5, color);
        line.setLineWidth(3);
        line.setLineStyle(1);
        this.addFeedbackLine(part, line);
    }

    private void addVLine(EditPart part, C component, int y, Color color) {
        Rectangle bounds = FormSelectionEditPolicyClassic.getControlModelBounds(component);
        Polyline line = this.addVFeedbackLine(y, bounds.x, bounds.right(), color);
        line.setLineWidth(2);
        line.setLineStyle(1);
        this.addFeedbackLine(part, line);
    }

    private void addVLine(EditPart part, int y, Color color) {
        ICompositeInfo composite = this.layout.getComposite();
        int parentWidth = composite.getClientArea().width;
        Polyline line = this.addVFeedbackLine(y, 0, parentWidth, color);
        this.addFeedbackLine(part, line);
    }

    private void addVLine(EditPart part, int left, int right, int y, Color color) {
        Polyline line = this.addVFeedbackLine(y, left - 8, right + 8, color);
        this.addFeedbackLine(part, line);
    }

    private void removeFeedbacks() {
        for (EditPart part : this.feedbacks.keySet()) {
            this.removeFeedbacks(part);
        }
        this.feedbacks.clear();
        this.hideLocationHints();
    }

    private void removeFeedbacks(EditPart part) {
        List<Figure> partFeedbacks = this.feedbacks.get(part);
        if (partFeedbacks == null) {
            return;
        }
        for (Figure figure : partFeedbacks) {
            this.removeFeedback(figure);
        }
        partFeedbacks.clear();
    }

    private void showSelectionFeedbacks() {
        for (EditPart child : this.getHost().getChildren()) {
            if (!this.layout.getControls().contains(child.getModel()) || child.getSelected() == 0) continue;
            FormSelectionEditPolicyClassic editPolicy = (FormSelectionEditPolicyClassic)child.getEditPolicy((Object)"Selection Feedback");
            editPolicy.showSelection();
        }
    }

    protected void translateModelToFeedback(Translatable t) {
        PolicyUtils.translateModelToFeedback((LayoutEditPolicy)this, (Translatable)t);
    }

    protected void translateAbsoluteToModel(Translatable t) {
        PolicyUtils.translateAbsoluteToModel((LayoutEditPolicy)this, (Translatable)t);
    }

    private void setHBounds(Rectangle r, int right, boolean createControl) {
        if (createControl) {
            r.width = right - r.x;
        } else {
            r.x = right - r.width;
        }
    }

    private void setVBounds(Rectangle r, int bottom, boolean createControl) {
        if (createControl) {
            r.height = bottom - r.y;
        } else {
            r.y = bottom - r.height;
        }
    }

    static <C extends IControlInfo> List<C> sortControlsByAxisRange(List<C> components, boolean isX, int value) {
        return FormSelectionEditPolicyClassic.sortControlsByAxisRange(components, isX, value);
    }

    private List<C> getAttachableControls(C control, boolean horizontal, final boolean includeSelected) throws Exception {
        List<C> attachableControls = control != null ? FormUtils.getAttachableControls(this.layout, control, horizontal) : FormUtils.getAttachableControls(this.layout);
        CollectionUtils.filter(attachableControls, (Predicate)new Predicate(){

            public boolean evaluate(Object input) {
                try {
                    EditPart part = FormLayoutEditPolicyClassic.this.getHost().getViewer().getEditPartByModel(input);
                    if (!includeSelected && part.getSelected() != 0) {
                    }
                }
                finally {
                    return false;
                }
                return true;
            }
        });
        return attachableControls;
    }

    private Layer getTextFeedbackLayer() {
        return this.getLayer("Feedback Layer Abv 1");
    }

    private void hideLocationHints() {
        for (TextFeedback feedback : this.xTextFeedbacks.values()) {
            feedback.remove();
        }
        for (TextFeedback feedback : this.yTextFeedbacks.values()) {
            feedback.remove();
        }
        this.xTextFeedbacks = Maps.newHashMap();
        this.yTextFeedbacks = Maps.newHashMap();
        if (this.createControlHintFeedbackX != null) {
            this.createControlHintFeedbackX.remove();
            this.createControlHintFeedbackX = null;
        }
        if (this.createControlHintFeedbackY != null) {
            this.createControlHintFeedbackY.remove();
            this.createControlHintFeedbackY = null;
        }
    }

    public TextFeedback createTextFeedback(boolean isHorizontal) {
        TextFeedback textFeedback = new TextFeedback(this.getTextFeedbackLayer(), isHorizontal);
        return textFeedback;
    }

    protected TextFeedback getTextFeedback(Map<EditPart, TextFeedback> map, EditPart key, boolean isHorizontal) {
        TextFeedback textFeedback = map.get(key);
        if (textFeedback == null) {
            textFeedback = this.createTextFeedback(isHorizontal);
            textFeedback.add();
        }
        map.put(key, textFeedback);
        return textFeedback;
    }

    public EditPart createHeaderEditPart(boolean isHorizontal, Object model) {
        return new FormHeaderEditPart<C>(this.layout, model, isHorizontal, this.getHostFigure());
    }

    public void buildContextMenu(IMenuManager manager, boolean isHorizontal) {
        FormHeaderLayoutEditPolicy<C> headersPolicy = isHorizontal ? this.headersPolicyHorizontal : this.headersPolicyVertical;
        headersPolicy.buildContextMenu(manager);
    }

    public LayoutEditPolicy getContainerLayoutPolicy(boolean isHorizontal) {
        FormHeaderLayoutEditPolicy<C> headersPolicy = new FormHeaderLayoutEditPolicy<C>(this.layout, (LayoutEditPolicy)this, isHorizontal);
        if (isHorizontal) {
            this.headersPolicyHorizontal = headersPolicy;
        } else {
            this.headersPolicyVertical = headersPolicy;
        }
        return headersPolicy;
    }

    public List<?> getHeaders(boolean isHorizontal) {
        List<Integer> values = isHorizontal ? this.layout.getPreferences().getHorizontalPercents() : this.layout.getPreferences().getVerticalPercents();
        ArrayList results = Lists.newArrayList();
        for (Integer percent : values) {
            results.add(new FormLayoutPreferences.PercentsInfo(percent));
        }
        return results;
    }

    public void handleDoubleClick(boolean isHorizontal) {
    }

    private final class CreateToControlCommand
    extends EditCommand {
        private final C child;
        private final int side;
        private final C control;
        private final int position;
        private final int offset;
        final /* synthetic */ FormLayoutEditPolicyClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public CreateToControlCommand(C child, int side, C control, int position, int offset) {
            this.this$0 = (FormLayoutEditPolicyClassic)n;
            super(child);
            this.child = child;
            this.side = side;
            this.control = control;
            this.position = position;
            this.offset = offset;
        }

        protected void executeEdit() throws Exception {
            this.this$0.layoutImpl.createToControl(this.child, this.side, this.control, this.position, this.offset);
        }
    }

    private final class CreateToMarginCommand
    extends EditCommand {
        private final C child;
        private final int side;
        private final int direction;
        private final int marginValue;
        final /* synthetic */ FormLayoutEditPolicyClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private CreateToMarginCommand(C child, int side, int direction, int marginValue) {
            this.this$0 = (FormLayoutEditPolicyClassic)n;
            super(child);
            this.child = child;
            this.side = side;
            this.direction = direction;
            this.marginValue = marginValue;
        }

        protected void executeEdit() throws Exception {
            this.this$0.layoutImpl.createToMargin(this.child, this.side, this.direction, this.marginValue);
        }
    }

    private final class CreateToOffsetCommand
    extends EditCommand {
        private final C child;
        private final int side;
        private final int parentSize;
        private final int offset;
        final /* synthetic */ FormLayoutEditPolicyClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public CreateToOffsetCommand(C child, int side, int parentSize, int offset) {
            this.this$0 = (FormLayoutEditPolicyClassic)n;
            super(child);
            this.child = child;
            this.side = side;
            this.parentSize = parentSize;
            this.offset = offset;
        }

        protected void executeEdit() throws Exception {
            this.this$0.layoutImpl.createToOffset(this.child, this.side, this.parentSize, this.offset);
        }
    }

    private final class CreateToPercentOffsetCommand
    extends EditCommand {
        private final C child;
        private final int side;
        private final int percent;
        private final int offset;
        final /* synthetic */ FormLayoutEditPolicyClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public CreateToPercentOffsetCommand(C child, int side, int percent, int offset) {
            this.this$0 = (FormLayoutEditPolicyClassic)n;
            super(child);
            this.child = child;
            this.side = side;
            this.percent = percent;
            this.offset = offset;
        }

        protected void executeEdit() throws Exception {
            this.this$0.layoutImpl.createToPercentOffset(this.child, this.side, this.percent, this.offset);
        }
    }

    private final class MoveToControlCommand
    extends EditCommand {
        private final C control;
        private final int offset;
        private final int position;
        private final C child;
        private final int side;
        final /* synthetic */ FormLayoutEditPolicyClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public MoveToControlCommand(C child, int side, C attachToControl, int position, int offset) {
            this.this$0 = (FormLayoutEditPolicyClassic)n;
            super(child);
            this.child = child;
            this.side = side;
            this.control = attachToControl;
            this.position = position;
            this.offset = offset;
        }

        protected void executeEdit() throws Exception {
            this.this$0.layoutImpl.moveToControl(this.child, this.side, this.control, this.position, this.offset);
        }
    }

    private final class MoveToMarginCommand
    extends EditCommand {
        private final int marginValue;
        private final int direction;
        private final int side;
        private final C child;
        final /* synthetic */ FormLayoutEditPolicyClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private MoveToMarginCommand(C child, int side, int direction, int marginValue) {
            this.this$0 = (FormLayoutEditPolicyClassic)n;
            super(child);
            this.child = child;
            this.side = side;
            this.direction = direction;
            this.marginValue = marginValue;
        }

        protected void executeEdit() throws Exception {
            this.this$0.layoutImpl.moveToMargin(this.child, this.side, this.direction, this.marginValue);
        }
    }

    private final class MoveToOffsetCommand
    extends EditCommand {
        private final int offset;
        private final int parentSize;
        private final C child;
        private final int side;
        final /* synthetic */ FormLayoutEditPolicyClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private MoveToOffsetCommand(C child, int side, int parentSize, int offset) {
            this.this$0 = (FormLayoutEditPolicyClassic)n;
            super(child);
            this.child = child;
            this.side = side;
            this.parentSize = parentSize;
            this.offset = offset;
        }

        protected void executeEdit() throws Exception {
            this.this$0.layoutImpl.moveToOffset(this.child, this.side, this.parentSize, this.offset);
        }
    }

    private final class MoveToPercentOffsetCommand
    extends EditCommand {
        private final int offset;
        private final int percent;
        private final C child;
        private final int side;
        final /* synthetic */ FormLayoutEditPolicyClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        private MoveToPercentOffsetCommand(C child, int side, int percent, int offset) {
            this.this$0 = (FormLayoutEditPolicyClassic)n;
            super(child);
            this.child = child;
            this.side = side;
            this.percent = percent;
            this.offset = offset;
        }

        public void executeEdit() throws Exception {
            this.this$0.layoutImpl.moveToPercentOffset(this.child, this.side, this.percent, this.offset);
        }
    }
}

