/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.absolute;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.layout.LayoutPolicyUtils;
import org.eclipse.wb.core.gef.policy.layout.generic.AbstractPopupFigure;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.Polyline;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Transposer;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsoluteBasedSelectionEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsolutePolicyUtils;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.LineEndFigure;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.AnchorsActionsSupport;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.IActionImageProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.ComponentAttachmentInfo;
import org.eclipse.wb.internal.core.gef.policy.snapping.IAbsoluteLayoutCommands;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;

public abstract class AbsoluteComplexSelectionEditPolicy<C extends IAbstractComponentInfo>
extends AbsoluteBasedSelectionEditPolicy<C>
implements IActionImageProvider {
    private static final int MIN_LEFT_SPACE = 10;
    private static final int INITIAL_RIGHT_SPACE = 10;
    private static final int FIGURES_SPACE = 10;
    private List<Figure> m_feedbacks;
    private List<Figure> m_alignmentFigures;
    private final IAbsoluteLayoutCommands m_layout;

    public AbsoluteComplexSelectionEditPolicy(IAbsoluteLayoutCommands layoutCommands) {
        this.m_layout = layoutCommands;
    }

    @Override
    protected void showSelection() {
        super.showSelection();
        ExecutionUtils.runRethrow(new RunnableEx(){

            @Override
            public void run() throws Exception {
                IAbstractComponentInfo widget = (IAbstractComponentInfo)AbsoluteComplexSelectionEditPolicy.this.getHostModel();
                AbsoluteComplexSelectionEditPolicy.this.drawFeedbacks(widget, 1);
                AbsoluteComplexSelectionEditPolicy.this.drawFeedbacks(widget, 4);
                AbsoluteComplexSelectionEditPolicy.this.drawFeedbacks(widget, 8);
                AbsoluteComplexSelectionEditPolicy.this.drawFeedbacks(widget, 32);
            }
        });
        if (this.getHost().getSelected() == 2) {
            this.showAlignmentFigures();
        }
    }

    private void drawFeedbacks(IAbstractComponentInfo widget, int side) throws Exception {
        ComponentAttachmentInfo neighborAttachment;
        while ((neighborAttachment = this.getComponentAttachmentInfo(widget, side)) != null) {
            this.addFeedbackToComponent(widget, neighborAttachment.getTarget(), side, neighborAttachment.getAlignment());
            widget = neighborAttachment.getTarget();
        }
        if (this.isAttached(widget, side)) {
            this.addFeedbackToParent(widget, side);
        }
    }

    @Override
    protected void hideSelection() {
        super.hideSelection();
        for (Figure figure : this.getFeedbacks()) {
            FigureUtils.removeFigure(figure);
        }
        this.m_feedbacks = new ArrayList<Figure>();
        this.hideAlignmentFigures();
    }

    private Dimension getParentSize(IAbstractComponentInfo parent) {
        Rectangle compositeBounds = parent.getModelBounds().getCopy();
        Insets clientAreaInsets = parent.getClientAreaInsets();
        return compositeBounds.crop(clientAreaInsets).getSize().expand(-1, -1);
    }

    private void addFeedbackToComponent(IAbstractComponentInfo widget, IAbstractComponentInfo neighborWidget, int side, int neighborSide) {
        Assert.isTrue(!((side != 1 && side != 4 || neighborSide != 1 && neighborSide != 4) && (side != 8 && side != 32 || neighborSide != 8 && neighborSide != 32) && side != 2 && neighborSide != 2));
        Transposer t = new Transposer(!PlacementUtils.isHorizontalSide(side));
        Rectangle widgetBounds = t.t(widget.getModelBounds().getCopy());
        Rectangle neighborBounds = t.t(neighborWidget.getModelBounds().getCopy());
        int x1 = PlacementUtils.isTrailingSide(neighborSide) ? neighborBounds.right() : neighborBounds.x;
        int x2 = PlacementUtils.isTrailingSide(side) ? widgetBounds.right() : widgetBounds.x;
        int y = widgetBounds.getLeft().y;
        Point p2 = t.t(new Point(x1, y));
        Point p1 = t.t(new Point(x2, y));
        this.addLineFeedback(p1, p2, PlacementUtils.isHorizontalSide(side));
        int lineStartY = widgetBounds.y > neighborBounds.y ? neighborBounds.y : widgetBounds.y;
        int lineEndY = widgetBounds.bottom() < neighborBounds.bottom() ? neighborBounds.bottom() : widgetBounds.bottom();
        Point p3 = t.t(new Point(x1, lineStartY));
        Point p4 = t.t(new Point(x1, lineEndY));
        PolicyUtils.translateModelToFeedback(this, (Translatable)p3);
        PolicyUtils.translateModelToFeedback(this, (Translatable)p4);
        this.addSimpleLineFeedback(p3, p4);
    }

    private void addFeedbackToParent(IAbstractComponentInfo widget, int side) {
        IAbstractComponentInfo parent = (IAbstractComponentInfo)((Object)widget.getParent());
        Transposer t = new Transposer(!PlacementUtils.isHorizontalSide(side));
        Dimension parentSize = t.t(this.getParentSize(parent));
        Rectangle widgetBounds = t.t(widget.getModelBounds().getCopy());
        int x1 = PlacementUtils.isTrailingSide(side) ? parentSize.width : 0;
        int x2 = PlacementUtils.isTrailingSide(side) ? widgetBounds.right() : widgetBounds.x;
        int y = widgetBounds.getLeft().y;
        Point p2 = t.t(new Point(x1, y));
        Point p1 = t.t(new Point(x2, y));
        this.addLineFeedback(p1, p2, PlacementUtils.isHorizontalSide(side));
    }

    private void addLineFeedback(Point p1, Point p2, boolean isHorizontal) {
        PolicyUtils.translateModelToFeedback(this, (Translatable)p1);
        PolicyUtils.translateModelToFeedback(this, (Translatable)p2);
        this.addSimpleLineFeedback(p1, p2);
        Transposer t = new Transposer(!isHorizontal);
        p1 = t.t(p1);
        p2 = t.t(p2);
        if (Math.abs(p2.x - p1.x) > 3) {
            this.addLineEndFeedback(t.t(p2), isHorizontal, p2.x > p1.x);
        }
    }

    private void addSimpleLineFeedback(Point begin, Point end) {
        Polyline line = new Polyline();
        line.addPoint(begin);
        line.addPoint(end);
        line.setForeground(AbsolutePolicyUtils.COLOR_FEEDBACK);
        line.setLineStyle(2);
        this.addMyFeedback(line);
    }

    private void addLineEndFeedback(Point point, boolean isHorizontal, boolean isTrailing) {
        int alignment = isHorizontal ? (isTrailing ? 4 : 1) : (isTrailing ? 32 : 8);
        LineEndFigure lineEndFigure = new LineEndFigure(alignment, AbsolutePolicyUtils.COLOR_FEEDBACK);
        this.addMyFeedback(lineEndFigure);
        Dimension size = lineEndFigure.getSize();
        lineEndFigure.setLocation(new Point(point.x - size.width / 2, point.y - size.height / 2));
    }

    private void addMyFeedback(Figure figure) {
        this.getFeedbacks().add(figure);
        this.getLayer("Handle Layer Sub 2").add(figure);
    }

    private List<Figure> getFeedbacks() {
        if (this.m_feedbacks == null) {
            this.m_feedbacks = Lists.newArrayList();
        }
        return this.m_feedbacks;
    }

    protected Figure createAlignmentFigure(IAbstractComponentInfo widget, boolean isHorizontal) {
        IEditPartViewer viewer = this.getHost().getViewer();
        return isHorizontal ? new HorizontalPopupFigure(viewer, widget) : new VerticalPopupFigure(viewer, widget);
    }

    public final void showAlignmentFigures() {
        if (this.m_alignmentFigures == null) {
            this.m_alignmentFigures = Lists.newArrayList();
            List<EditPart> editParts = this.getHost().getParent().getChildren();
            for (EditPart editPart : editParts) {
                this.showAlignmentFigures(editPart);
            }
        }
    }

    public final void hideAlignmentFigures() {
        if (this.m_alignmentFigures != null) {
            for (Figure figure : this.m_alignmentFigures) {
                figure.getParent().remove(figure);
            }
            this.m_alignmentFigures = null;
        }
    }

    private void showAlignmentFigures(EditPart editPart) {
        Figure verticalFigure;
        Object model = editPart.getModel();
        if (!(model instanceof IAbstractComponentInfo)) {
            return;
        }
        IAbstractComponentInfo widget = (IAbstractComponentInfo)model;
        String showFiguresString = null;
        if (!LayoutPolicyUtils.shouldShowSideFigures(showFiguresString, editPart)) {
            return;
        }
        int offset = 10;
        Figure horizontalFigure = this.createAlignmentFigure(widget, true);
        if (horizontalFigure != null) {
            this.addAlignmentFigure(widget, horizontalFigure, offset += horizontalFigure.getSize().width);
            offset += 10;
        }
        if ((verticalFigure = this.createAlignmentFigure(widget, false)) != null) {
            this.addAlignmentFigure(widget, verticalFigure, offset += verticalFigure.getSize().width);
            offset += 10;
        }
    }

    private void addAlignmentFigure(IAbstractComponentInfo component, Figure figure, int offset) {
        Layer layer = this.getLayer("Clickable Layer");
        Rectangle cellRect = component.getModelBounds().getCopy();
        PolicyUtils.translateModelToFeedback(this, (Translatable)cellRect);
        Dimension figureSize = figure.getSize();
        Point figureLocation = new Point(cellRect.right() - offset, cellRect.y - figureSize.height / 2);
        if (figureLocation.x < cellRect.x + 10) {
            return;
        }
        layer.add(figure);
        figure.setLocation(figureLocation);
        this.m_alignmentFigures.add(figure);
    }

    protected boolean isAttached(final IAbstractComponentInfo widget, final int side) {
        return ExecutionUtils.runObject(new RunnableObjectEx<Boolean>(){

            @Override
            public Boolean runObject() throws Exception {
                return AbsoluteComplexSelectionEditPolicy.this.m_layout.isAttached(widget, side);
            }
        });
    }

    protected abstract ComponentAttachmentInfo getComponentAttachmentInfo(IAbstractComponentInfo var1, int var2) throws Exception;

    protected class HorizontalPopupFigure
    extends AbstractPopupFigure {
        private final IAbstractComponentInfo m_widget;

        protected HorizontalPopupFigure(IEditPartViewer viewer, IAbstractComponentInfo widget) {
            super(viewer, 9, 5);
            this.m_widget = widget;
        }

        @Override
        protected Image getImage() {
            boolean isLeftAttached = AbsoluteComplexSelectionEditPolicy.this.isAttached(this.m_widget, 1);
            boolean isRightAttached = AbsoluteComplexSelectionEditPolicy.this.isAttached(this.m_widget, 4);
            if (isLeftAttached && isRightAttached) {
                return AbsoluteComplexSelectionEditPolicy.this.getActionImage("h/both.gif");
            }
            if (isRightAttached) {
                return AbsoluteComplexSelectionEditPolicy.this.getActionImage("h/right.gif");
            }
            return AbsoluteComplexSelectionEditPolicy.this.getActionImage("h/left.gif");
        }

        @Override
        protected void fillMenu(IMenuManager manager) {
            new AnchorsActionsSupport(AbsoluteComplexSelectionEditPolicy.this.getPlacementsSupport(), AbsoluteComplexSelectionEditPolicy.this).fillAnchorsActions((IContributionManager)manager, this.m_widget, true);
        }
    }

    protected class VerticalPopupFigure
    extends AbstractPopupFigure {
        private final IAbstractComponentInfo m_widget;

        protected VerticalPopupFigure(IEditPartViewer viewer, IAbstractComponentInfo widget) {
            super(viewer, 5, 9);
            this.m_widget = widget;
        }

        @Override
        protected Image getImage() {
            boolean isTopAttached = AbsoluteComplexSelectionEditPolicy.this.isAttached(this.m_widget, 8);
            boolean isBottomAttached = AbsoluteComplexSelectionEditPolicy.this.isAttached(this.m_widget, 32);
            if (isTopAttached && isBottomAttached) {
                return AbsoluteComplexSelectionEditPolicy.this.getActionImage("v/both.gif");
            }
            if (isBottomAttached) {
                return AbsoluteComplexSelectionEditPolicy.this.getActionImage("v/bottom.gif");
            }
            return AbsoluteComplexSelectionEditPolicy.this.getActionImage("v/top.gif");
        }

        @Override
        protected void fillMenu(IMenuManager manager) {
            new AnchorsActionsSupport(AbsoluteComplexSelectionEditPolicy.this.getPlacementsSupport(), AbsoluteComplexSelectionEditPolicy.this).fillAnchorsActions((IContributionManager)manager, this.m_widget, false);
        }
    }
}

