/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.sdk.browser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.userstorage.IBlob;
import org.eclipse.userstorage.IStorage;
import org.eclipse.userstorage.StorageFactory;
import org.eclipse.userstorage.oauth.EclipseOAuthCredentialsProvider;
import org.eclipse.userstorage.oauth.OAuthParameters;
import org.eclipse.userstorage.sdk.browser.EditableOAuthParameters;
import org.eclipse.userstorage.sdk.browser.OAuthClientDetailsDialog;
import org.eclipse.userstorage.spi.ICredentialsProvider;

public class USSBrowsingView
extends ViewPart {
    private static final String APP_TOKEN_OOMPH = "cNhDr0INs8T109P8h6E1r_GvU3I";
    private static final String APP_TOKEN_MPC = "MZ04RMOpksKN5GpxKXafq2MSjSP";
    private TableViewer viewer;
    private Action showMPCBucketAction;
    private Action showOomphBucketAction;
    private Action setOAuthParametersAction;
    private Action restoreDefaultOAuthParametersAction;
    private StatusLineContributionItem statusText;
    private Text appTokenText;
    private Button useOAuth;
    private EditableOAuthParameters oauthParameters;
    private OAuthClientDetailsDialog dialog;

    private void resetDefaults() {
        this.oauthParameters = new EditableOAuthParameters();
        this.dialog = new OAuthClientDetailsDialog(this.getSite().getShell(), this.oauthParameters);
        this.refresh();
    }

    public void createPartControl(Composite c) {
        this.resetDefaults();
        Composite parent = new Composite(c, 0);
        Composite header = new Composite(parent, 0);
        header.setLayout((Layout)new RowLayout());
        Label label = new Label(header, 0);
        label.setText("Application Token:");
        this.appTokenText = new Text(header, 2052);
        this.appTokenText.setMessage("Application token");
        GC gc = new GC((Drawable)this.appTokenText);
        int fontWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        this.appTokenText.setLayoutData((Object)new RowData(30 * fontWidth, -1));
        this.useOAuth = new Button(header, 32);
        this.useOAuth.setText("Use OAuth?");
        this.useOAuth.setSelection(true);
        this.appTokenText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                USSBrowsingView.this.refresh();
            }
        });
        this.useOAuth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                USSBrowsingView.this.refresh();
            }
        });
        Composite tableContainer = new Composite(parent, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(tableContainer, 2818);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridDataFactory.defaultsFor((Control)this.viewer.getControl()).grab(true, true).applyTo(this.viewer.getControl());
        TableViewerColumn tvcBlobId = new TableViewerColumn(this.viewer, 16384);
        tableLayout.setColumnData((Widget)tvcBlobId.getColumn(), (ColumnLayoutData)new ColumnWeightData(20));
        tvcBlobId.getColumn().setText("Blob ID");
        tvcBlobId.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                IBlob blob = (IBlob)cell.getElement();
                cell.setText(blob.getKey());
            }
        });
        TableViewerColumn tvcBlobContent = new TableViewerColumn(this.viewer, 16384);
        tableLayout.setColumnData((Widget)tvcBlobContent.getColumn(), (ColumnLayoutData)new ColumnWeightData(80));
        tvcBlobContent.getColumn().setText("Content");
        tvcBlobContent.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                try {
                    IBlob blob = (IBlob)cell.getElement();
                    String text = blob.getContentsUTF();
                    cell.setText(text);
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableContainer);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void refresh() {
        if (this.appTokenText == null) {
            return;
        }
        this.applicationTokenChanged(this.appTokenText.getText(), this.useOAuth.getSelection());
    }

    protected void applicationTokenChanged(String appToken, boolean useOAuth) {
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        try {
            final IStorage storage = StorageFactory.DEFAULT.create(appToken);
            if (useOAuth) {
                EclipseOAuthCredentialsProvider credentialsProvider = new EclipseOAuthCredentialsProvider((OAuthParameters)this.oauthParameters);
                credentialsProvider.setShell((IShellProvider)this.getViewSite());
                storage.setCredentialsProvider((ICredentialsProvider)credentialsProvider);
            }
            Job loadBlobs = new Job("Load blobs"){

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                    final ArrayList<IBlob> blobs = new ArrayList<IBlob>();
                    try {
                        for (IBlob b : storage.getBlobs()) {
                            blobs.add(b);
                            progress.worked(1);
                        }
                    }
                    catch (IOException e) {
                        return new Status(4, ((Object)((Object)this)).getClass().getName(), 0, "Unable to load blobs", (Throwable)e);
                    }
                    USSBrowsingView.this.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            USSBrowsingView.this.update(storage, blobs);
                            this.done(Status.OK_STATUS);
                        }
                    });
                    return ASYNC_FINISH;
                }
            };
            loadBlobs.schedule();
        }
        catch (Exception e) {
            this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(e.getMessage());
        }
    }

    protected void update(IStorage storage, List<IBlob> blobs) {
        this.viewer.setInput(blobs);
        this.statusText.setText("Service: " + storage.getService().toString());
        this.statusText.getParent().update(true);
    }

    protected void asyncExec(Runnable runnable) {
        Display d = this.getSite().getShell().getDisplay();
        if (!d.isDisposed()) {
            d.asyncExec(runnable);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                USSBrowsingView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        this.statusText = new StatusLineContributionItem(this.getViewSite().getId());
        bars.getStatusLineManager().add((IContributionItem)this.statusText);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.showMPCBucketAction);
        manager.add((IAction)this.showOomphBucketAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.setOAuthParametersAction);
        manager.add((IAction)this.restoreDefaultOAuthParametersAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    private void makeActions() {
        this.showMPCBucketAction = new Action(){

            public void run() {
                USSBrowsingView.this.appTokenText.setText(USSBrowsingView.APP_TOKEN_MPC);
                USSBrowsingView.this.useOAuth.setSelection(true);
                USSBrowsingView.this.applicationTokenChanged(USSBrowsingView.APP_TOKEN_MPC, true);
            }
        };
        this.showMPCBucketAction.setText("Browse Marketplace Data");
        this.showMPCBucketAction.setToolTipText("Use Eclipse Marketplace USS application token");
        this.showOomphBucketAction = new Action(){

            public void run() {
                USSBrowsingView.this.appTokenText.setText(USSBrowsingView.APP_TOKEN_OOMPH);
                USSBrowsingView.this.useOAuth.setSelection(true);
                USSBrowsingView.this.applicationTokenChanged(USSBrowsingView.APP_TOKEN_OOMPH, true);
            }
        };
        this.showOomphBucketAction.setText("Browse Oomph Data");
        this.showOomphBucketAction.setToolTipText("Use Oomph USS application token");
        this.restoreDefaultOAuthParametersAction = new Action(){

            public void run() {
                USSBrowsingView.this.resetDefaults();
            }
        };
        this.restoreDefaultOAuthParametersAction.setText("Restore Default OAuth Client Parameters");
        this.setOAuthParametersAction = new Action(){

            public void run() {
                if (USSBrowsingView.this.dialog.open() == 0) {
                    USSBrowsingView.this.refresh();
                }
            }
        };
        this.setOAuthParametersAction.setText("Set OAuth Client Parameters");
    }

    private void hookDoubleClickAction() {
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

