/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.wizards;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.wizards.SelectLanguageConfigurationWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;

public final class LanguageConfigurationImportWizard
extends Wizard
implements IImportWizard {
    private @Nullable SelectLanguageConfigurationWizardPage mainPage;
    private @Nullable ILanguageConfigurationDefinition createdDefinition;
    private ILanguageConfigurationRegistryManager registryManager;
    private final boolean save;

    public LanguageConfigurationImportWizard(boolean save) {
        this.save = save;
        this.registryManager = LanguageConfigurationRegistryManager.getInstance();
    }

    public void setRegistryManager(ILanguageConfigurationRegistryManager registryManager) {
        this.registryManager = registryManager;
    }

    public void addPages() {
        this.mainPage = new SelectLanguageConfigurationWizardPage(this.registryManager);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        assert (this.mainPage != null);
        ILanguageConfigurationDefinition definition = this.mainPage.getDefinition();
        this.registryManager.registerLanguageConfigurationDefinition(definition);
        if (this.save) {
            try {
                this.registryManager.save();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
                return false;
            }
        }
        this.createdDefinition = definition;
        return true;
    }

    public void init(@Nullable IWorkbench workbench, @Nullable IStructuredSelection selection) {
    }

    public @Nullable ILanguageConfigurationDefinition getCreatedDefinition() {
        return this.createdDefinition;
    }
}

