/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.adapters;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.CacheState;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.FsClipboard;
import org.eclipse.ui.IActionFilter;

public class NodeStateFilter
implements IActionFilter {
    private IFSTreeNode node;

    public NodeStateFilter(IFSTreeNode node) {
        Assert.isNotNull((Object)node);
        this.node = node;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals("cache.state") && this.node.isFile()) {
            if (UIPlugin.isAutoSaving()) {
                return false;
            }
            CacheState state = this.node.getCacheState();
            if (value == null) {
                value = CacheState.consistent.name();
            }
            return value.equals(state.name());
        }
        if (name.equals("edit.cut")) {
            FsClipboard cb = UIPlugin.getClipboard();
            if (!cb.isEmpty() && cb.isCutOp()) {
                List<IFSTreeNode> files = cb.getFiles();
                for (IFSTreeNode file : files) {
                    if (this.node != file) continue;
                    return true;
                }
            }
        } else {
            if (name.equals("hidden")) {
                if (value == null) {
                    value = "true";
                }
                boolean result = false;
                if (!this.node.isRootDirectory()) {
                    result = this.node.isWindowsNode() ? this.node.isHidden() : this.node.getName().startsWith(".");
                }
                return Boolean.toString(result).equals(value);
            }
            if (name.equals("isRevealOnConnect")) {
                boolean expect;
                boolean bl = expect = value == null || Boolean.parseBoolean(value);
                return expect == this.node.isRevealOnConnect();
            }
        }
        return false;
    }
}

