/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ExecutionEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.LifelineEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceDiagramEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsTreeIterator;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;

public final class EditPartsHelper {
    private EditPartsHelper() {
    }

    public static Predicate<IGraphicalEditPart> isValid() {
        return IsValidPredicate.INSTANCE;
    }

    public static Set<SequenceMessageEditPart> getAllMessages(IGraphicalEditPart element) {
        HashSet<SequenceMessageEditPart> allMessages = new HashSet<SequenceMessageEditPart>();
        allMessages.addAll(EditPartsHelper.getAllMessagesFrom(element));
        allMessages.addAll(EditPartsHelper.getAllMessagesTo(element));
        return allMessages;
    }

    public static List<SequenceMessageEditPart> getAllMessagesFrom(IGraphicalEditPart element) {
        ArrayList<SequenceMessageEditPart> messagesParts = new ArrayList<SequenceMessageEditPart>();
        EditPartsHelper.addAllMessagesFrom(element, messagesParts);
        return messagesParts;
    }

    private static List<SequenceMessageEditPart> getAllMessagesTo(IGraphicalEditPart element) {
        ArrayList<SequenceMessageEditPart> messagesParts = new ArrayList<SequenceMessageEditPart>();
        EditPartsHelper.addAllMessagesTo(element, messagesParts);
        return messagesParts;
    }

    public static List<ExecutionEditPart> getAllExecutions(IGraphicalEditPart element) {
        return Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.filter((Iterator)((Object)new EditPartsTreeIterator(element)), ExecutionEditPart.class), EditPartsHelper.isValid()));
    }

    public static List<LifelineEditPart> getAllLifelines(IGraphicalEditPart element) {
        return Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.filter((Iterator)((Object)new EditPartsTreeIterator(element)), LifelineEditPart.class), EditPartsHelper.isValid()));
    }

    private static void addAllMessagesFrom(IGraphicalEditPart element, Collection<SequenceMessageEditPart> messages) {
        for (IGraphicalEditPart connectionPart : Iterables.filter((Iterable)element.getSourceConnections(), IGraphicalEditPart.class)) {
            if (!(connectionPart instanceof SequenceMessageEditPart) || !EditPartsHelper.isValid().apply((Object)connectionPart)) continue;
            messages.add((SequenceMessageEditPart)connectionPart);
        }
        if (element instanceof SequenceMessageEditPart && EditPartsHelper.isValid().apply((Object)element)) {
            messages.add((SequenceMessageEditPart)element);
        }
        for (IGraphicalEditPart child : Iterables.filter((Iterable)element.getChildren(), IGraphicalEditPart.class)) {
            EditPartsHelper.addAllMessagesFrom(child, messages);
        }
    }

    private static void addAllMessagesTo(IGraphicalEditPart element, Collection<SequenceMessageEditPart> messages) {
        for (IGraphicalEditPart connectionPart : Iterables.filter((Iterable)element.getTargetConnections(), IGraphicalEditPart.class)) {
            if (!(connectionPart instanceof SequenceMessageEditPart) || !EditPartsHelper.isValid().apply((Object)connectionPart)) continue;
            messages.add((SequenceMessageEditPart)connectionPart);
        }
        if (element instanceof SequenceMessageEditPart && EditPartsHelper.isValid().apply((Object)element)) {
            messages.add((SequenceMessageEditPart)element);
        }
        for (IGraphicalEditPart child : Iterables.filter((Iterable)element.getChildren(), IGraphicalEditPart.class)) {
            EditPartsHelper.addAllMessagesTo(child, messages);
        }
    }

    public static LifelineEditPart findParentLifeline(IGraphicalEditPart part) {
        LifelineEditPart result = part instanceof LifelineEditPart && EditPartsHelper.isValid().apply((Object)part) ? (LifelineEditPart)part : (part != null ? (LifelineEditPart)new EditPartQuery(part).getFirstAncestorOfType(LifelineEditPart.class) : null);
        return result;
    }

    public static ISequenceEventEditPart findISequenceEvent(SingleEventEnd end, SequenceDiagramEditPart sdep) {
        for (ISequenceEventEditPart ise : Iterables.concat(EditPartsHelper.getAllExecutions((IGraphicalEditPart)sdep), EditPartsHelper.getAllMessagesFrom((IGraphicalEditPart)sdep))) {
            EObject semanticEvent = ise.resolveTargetSemanticElement();
            if (!end.getSemanticEvent().equals(semanticEvent)) continue;
            return ise;
        }
        return null;
    }

    public static SequenceDiagramEditPart getSequenceDiagramPart(IGraphicalEditPart editPart) {
        if (editPart instanceof SequenceDiagramEditPart) {
            return (SequenceDiagramEditPart)editPart;
        }
        IGraphicalEditPart current = editPart;
        if (editPart instanceof ConnectionEditPart) {
            ConnectionEditPart conn = (ConnectionEditPart)editPart;
            current = (IGraphicalEditPart)conn.getSource();
        }
        return (SequenceDiagramEditPart)((Object)new EditPartQuery(current).getFirstAncestorOfType(SequenceDiagramEditPart.class));
    }

    public static <T extends EditPart> SequenceDiagram getSequenceDiagram(T host) {
        Object parent = host;
        while (parent != null && !(parent instanceof ISequenceEventEditPart) && !(parent instanceof SequenceDiagramEditPart)) {
            parent = parent.getParent();
        }
        SequenceDiagram sequenceDiagram = null;
        if (parent instanceof SequenceDiagramEditPart) {
            sequenceDiagram = ((SequenceDiagramEditPart)((Object)parent)).getSequenceDiagram();
        } else if (parent instanceof ISequenceEventEditPart) {
            sequenceDiagram = ((ISequenceEventEditPart)parent).getISequenceEvent().getDiagram();
        }
        return sequenceDiagram;
    }

    private static enum IsValidPredicate implements Predicate<IGraphicalEditPart>
    {
        INSTANCE;


        public boolean apply(IGraphicalEditPart input) {
            return input.getParent() != null;
        }
    }
}

