/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.launcher.LaunchAction;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginConfigurationSection
extends TableSection {
    private TableViewer fConfigurationsTable;
    private TableEditor fLevelColumnEditor;
    private TableEditor fAutoColumnEditor;

    public PluginConfigurationSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, PluginConfigurationSection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{PDEUIMessages.Product_PluginSection_add, PDEUIMessages.Product_PluginSection_recommended, PDEUIMessages.PluginSection_remove, PDEUIMessages.Product_PluginSection_removeAll};
        return labels;
    }

    private static List<String[]> getBundlesWithStartLevels() {
        return List.of(new String[]{"org.apache.felix.scr", "2", "start"}, new String[]{"org.eclipse.core.runtime", "", "start"}, new String[]{"org.eclipse.equinox.common", "2", "start"}, new String[]{"org.eclipse.equinox.event", "2", "start"}, new String[]{"org.eclipse.equinox.simpleconfigurator", "1", "start"});
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ConfigurationPageMock_sectionTitle);
        section.setDescription(PDEUIMessages.ConfigurationPageMock_sectionDesc);
        GridData sectionData = new GridData(4, 4, true, true);
        sectionData.horizontalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 3, toolkit);
        this.createViewerPartControl(container, 65540, 3, toolkit);
        this.fConfigurationsTable = this.getTablePart().getTableViewer();
        final Table table = this.fConfigurationsTable.getTable();
        final TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(PDEUIMessages.PluginConfigurationSection_tablePluginTitle);
        column1.setWidth(300);
        final TableColumn levelColumnEditor = new TableColumn(table, 16384);
        levelColumnEditor.setText(PDEUIMessages.EquinoxPluginBlock_levelColumn);
        final TableColumn autoColumnEditor = new TableColumn(table, 16384);
        autoColumnEditor.setText(PDEUIMessages.EquinoxPluginBlock_autoColumn);
        table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int size = table.getSize().x;
                column1.setWidth(size / 7 * 4);
                levelColumnEditor.setWidth(size / 7 * 2);
                autoColumnEditor.setWidth(size / 7 * 1);
            }
        });
        table.setHeaderVisible(true);
        toolkit.paintBordersFor(container);
        this.fConfigurationsTable.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fConfigurationsTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fConfigurationsTable.setInput((Object)this.getProduct());
        this.createEditors();
        section.setClient((Control)container);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        this.getTablePart().setButtonEnabled(0, this.isEditable());
        this.updateRemoveButtons(true, true);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleAddDefaults();
                break;
            }
            case 2: {
                this.handleRemove();
                break;
            }
            case 3: {
                this.handleRemoveAll();
            }
        }
    }

    private void handleAdd() {
        Set<IPluginModelBase> pluginModelBases = LaunchAction.getModels(this.getProduct());
        IPluginConfiguration[] configs = this.getProduct().getPluginConfigurations();
        pluginModelBases.removeIf(p -> p instanceof IFragmentModel || this.pluginConfigurationContainsProductPlugin(configs, (IPluginModelBase)p));
        PluginSelectionDialog pluginSelectionDialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (IPluginModelBase[])pluginModelBases.toArray(IPluginModelBase[]::new), true);
        if (pluginSelectionDialog.open() == 0) {
            Object[] objectArray = pluginSelectionDialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IPluginModelBase pluginModelBase = (IPluginModelBase)object;
                this.addPlugin(pluginModelBase.getPluginBase().getId());
                ++n2;
            }
        }
    }

    private boolean pluginConfigurationContainsProductPlugin(IPluginConfiguration[] configs, IPluginModelBase plugin) {
        String bsn = plugin.getPluginBase().getId();
        return Arrays.stream(configs).map(IPluginConfiguration::getId).anyMatch(bsn::equals);
    }

    private void handleRemove() {
        IStructuredSelection ssel = this.fConfigurationsTable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            Object[] objects = ssel.toArray();
            IPluginConfiguration[] configurations = new IPluginConfiguration[objects.length];
            System.arraycopy(objects, 0, configurations, 0, objects.length);
            this.getProduct().removePluginConfigurations(configurations);
        }
        this.clearEditors();
    }

    private void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removePluginConfigurations(product.getPluginConfigurations());
        this.clearEditors();
    }

    private void handleAddDefaults() {
        List<String[]> plugins = PluginConfigurationSection.getBundlesWithStartLevels();
        IProduct product = this.getProduct();
        if (!plugins.isEmpty()) {
            StringBuilder bundlesList = new StringBuilder();
            bundlesList.append('\n');
            bundlesList.append('\n');
            for (String[] config : plugins) {
                bundlesList.append('\t');
                bundlesList.append(config[0]);
                bundlesList.append(", ");
                String startLevel = config[1];
                if (startLevel.length() > 0) {
                    bundlesList.append(PDEUIMessages.EquinoxPluginBlock_levelColumn);
                    bundlesList.append(' ');
                    bundlesList.append(startLevel);
                } else {
                    String defaultLevelColumn = NLS.bind((String)PDEUIMessages.EquinoxPluginBlock_defaultLevelColumn, (Object)"Default");
                    bundlesList.append(defaultLevelColumn);
                }
                if ("start".equals(config[2])) {
                    bundlesList.append(", ");
                    bundlesList.append(PDEUIMessages.EquinoxPluginBlock_autoColumn);
                }
                bundlesList.append('\n');
            }
            bundlesList.append('\n');
            if (MessageDialog.openConfirm((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.Product_PluginSection_RecommendedBundles_title, (String)NLS.bind((String)PDEUIMessages.Product_PluginSection_RecommendedBundles_message, (Object)bundlesList.toString()))) {
                ArrayList<IPluginConfiguration> pluginConfigs = new ArrayList<IPluginConfiguration>();
                IProductModelFactory factory = product.getModel().getFactory();
                for (String[] pluginStartConfig : plugins) {
                    IPluginConfiguration configuration = factory.createPluginConfiguration();
                    configuration.setId(pluginStartConfig[0]);
                    String startString = pluginStartConfig[1];
                    if (startString.length() > 0) {
                        configuration.setStartLevel(Integer.parseInt(startString));
                    }
                    configuration.setAutoStart("start".equals(pluginStartConfig[2]));
                    pluginConfigs.add(configuration);
                }
                product.addPluginConfigurations((IPluginConfiguration[])pluginConfigs.toArray(IPluginConfiguration[]::new));
                this.showControls();
            }
        } else {
            MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.Product_PluginSection_RecommendedBundles_title, (String)PDEUIMessages.Product_PluginSection_NoRecommendedBundles_message);
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.updateRemoveButtons(true, false);
    }

    private void addPlugin(String id) {
        IProduct product = this.getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IPluginConfiguration configuration = factory.createPluginConfiguration();
        configuration.setId(id);
        product.addPluginConfigurations(new IPluginConfiguration[]{configuration});
        this.fConfigurationsTable.setSelection((ISelection)new StructuredSelection((Object)configuration));
        this.showControls();
    }

    private ILabelProvider getLabelProvider() {
        return new LabelProvider();
    }

    private void clearEditors() {
        Control oldEditor = this.fLevelColumnEditor.getEditor();
        if (oldEditor != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
        if ((oldEditor = this.fAutoColumnEditor.getEditor()) != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
    }

    private void createEditors() {
        Table table = this.fConfigurationsTable.getTable();
        this.fLevelColumnEditor = new TableEditor(table);
        this.fLevelColumnEditor.horizontalAlignment = 0x1000000;
        this.fLevelColumnEditor.minimumWidth = 40;
        this.fLevelColumnEditor.grabHorizontal = true;
        if (Util.isMac()) {
            this.fLevelColumnEditor.minimumHeight = 27;
        }
        this.fAutoColumnEditor = new TableEditor(table);
        this.fAutoColumnEditor.horizontalAlignment = 0x1000000;
        this.fAutoColumnEditor.grabHorizontal = true;
        this.fAutoColumnEditor.minimumWidth = 50;
        table.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.showControls()));
    }

    private void showControls() {
        this.clearEditors();
        Table table = this.fConfigurationsTable.getTable();
        IStructuredSelection selection = this.fConfigurationsTable.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        TableItem item = table.getSelection()[0];
        if (item != null && !this.isEditable()) {
            return;
        }
        if (item != null) {
            IPluginConfiguration ppc = (IPluginConfiguration)selection.getFirstElement();
            Spinner spinner = new Spinner((Composite)table, 2048);
            spinner.setMinimum(0);
            String level = item.getText(1);
            int defaultLevel = level.length() == 0 || "default".equals(level) ? 0 : Integer.parseInt(level);
            spinner.setSelection(defaultLevel);
            spinner.addModifyListener(e -> {
                int selection1 = spinner.getSelection();
                item.setText(1, selection1 == 0 ? "default" : Integer.toString(selection1));
                ppc.setStartLevel(selection1);
            });
            this.fLevelColumnEditor.setEditor((Control)spinner, item, 1);
            CCombo combo = new CCombo((Composite)table, 2056);
            combo.setItems(new String[]{Boolean.toString(true), Boolean.toString(false)});
            combo.setText(item.getText(2));
            combo.pack();
            combo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                item.setText(2, combo.getText());
                ppc.setAutoStart(Boolean.parseBoolean(combo.getText()));
            }));
            this.fAutoColumnEditor.setEditor((Control)combo, item, 2);
        }
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleGlobalRefresh();
            return;
        }
        Table table = this.fConfigurationsTable.getTable();
        int count = table.getItemCount();
        Object[] objects = e.getChangedObjects();
        boolean refreshRemove = false;
        boolean refreshRemoveAll = false;
        if (e.getChangeType() == 1) {
            if (count == 0) {
                refreshRemoveAll = true;
            }
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IPluginConfiguration) {
                    this.fConfigurationsTable.add(object);
                }
                ++n2;
            }
        } else if (e.getChangeType() == 2) {
            refreshRemoveAll = true;
            refreshRemove = true;
            int index = table.getSelectionIndex();
            boolean global = false;
            Object[] objectArray = objects;
            int n = objects.length;
            int n3 = 0;
            while (n3 < n) {
                Object object = objectArray[n3];
                if (object instanceof IPluginConfiguration) {
                    this.fConfigurationsTable.remove(object);
                } else if (object instanceof IProductPlugin) {
                    global = true;
                    break;
                }
                ++n3;
            }
            if (global) {
                this.handleGlobalRefresh();
            }
            if (count == 0) {
                table.deselectAll();
                this.clearEditors();
            } else if (index < count) {
                table.setSelection(index);
            } else {
                table.setSelection(count - 1);
            }
        }
        this.getTablePart().setButtonEnabled(0, this.isEditable());
        this.updateRemoveButtons(refreshRemove, refreshRemoveAll);
    }

    private void handleGlobalRefresh() {
        this.fConfigurationsTable.setInput((Object)this.getProduct());
        this.fConfigurationsTable.refresh();
    }

    private void updateRemoveButtons(boolean updateRemove, boolean updateRemoveAll) {
        EditableTablePart tablePart = this.getTablePart();
        if (updateRemove) {
            IStructuredSelection selection = this.getViewerSelection();
            tablePart.setButtonEnabled(2, this.isEditable() && !selection.isEmpty());
        }
        int count = this.fConfigurationsTable.getTable().getItemCount();
        if (updateRemoveAll) {
            tablePart.setButtonEnabled(3, this.isEditable() && count > 0);
        }
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private IProduct fProduct;

        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.fProduct.getPluginConfigurations();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput == newInput) {
                return;
            }
            this.fProduct = (IProduct)newInput;
        }
    }

    private class LabelProvider
    extends PDELabelProvider {
        private LabelProvider() {
        }

        @Override
        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return super.getColumnImage(PluginRegistry.findModel((String)((IPluginConfiguration)obj).getId()), index);
            }
            return null;
        }

        @Override
        public String getColumnText(Object obj, int index) {
            IPluginConfiguration configuration = (IPluginConfiguration)obj;
            return switch (index) {
                case 0 -> configuration.getId();
                case 1 -> {
                    if (configuration.getStartLevel() == 0) {
                        yield "default";
                    }
                    yield Integer.toString(configuration.getStartLevel());
                }
                case 2 -> Boolean.toString(configuration.isAutoStart());
                default -> null;
            };
        }
    }
}

