/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.commands;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityActivityContentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Constraint;

public class CreateActionLocalConditionViewCommand
extends Command {
    private ActivityActivityContentCompartmentEditPart compartment = null;
    private ICommandProxy elementCreationCommand = null;
    private CompoundCommand viewsCreationCommand = null;
    private EditPart linkedActionEditPart;
    private IHintedType type;
    private TransactionalEditingDomain editingDomain;

    @Deprecated
    public CreateActionLocalConditionViewCommand(IHintedType conditionType, ActivityActivityContentCompartmentEditPart graphicalParent, EObject containerAction, EditPart actionPart) {
        this(null, conditionType, graphicalParent, containerAction, actionPart);
    }

    public CreateActionLocalConditionViewCommand(TransactionalEditingDomain editingDomain, IHintedType conditionType, ActivityActivityContentCompartmentEditPart graphicalParent, EObject containerAction, EditPart actionPart) {
        this.elementCreationCommand = CreateActionLocalConditionViewCommand.getElementCreationCommand(containerAction, conditionType, (EditPart)graphicalParent);
        this.compartment = graphicalParent;
        this.linkedActionEditPart = actionPart;
        this.type = conditionType;
        this.editingDomain = editingDomain;
    }

    private static ICommandProxy getElementCreationCommand(EObject containerAction, IHintedType conditionType, EditPart part) {
        CreateElementRequest createElementReq = new CreateElementRequest(containerAction, (IElementType)conditionType);
        IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((EObject)containerAction);
        if (commandService == null) {
            return null;
        }
        ICommand semanticCommand = commandService.getEditCommand((IEditCommandRequest)createElementReq);
        if (semanticCommand != null && semanticCommand.canExecute()) {
            return new ICommandProxy(semanticCommand);
        }
        return null;
    }

    private IHintedType getLinkType() {
        if (UMLElementTypes.Constraint_LocalPreconditionShape.equals(this.type)) {
            return (IHintedType)UMLElementTypes.Action_LocalPreconditionEdge;
        }
        if (UMLElementTypes.Constraint_LocalPostconditionShape.equals(this.type)) {
            return (IHintedType)UMLElementTypes.Action_LocalPostconditionEdge;
        }
        if (UMLElementTypes.IntervalConstraint_LocalPreconditionShape.equals(this.type)) {
            return (IHintedType)UMLElementTypes.Action_LocalPreconditionEdge;
        }
        if (UMLElementTypes.IntervalConstraint_LocalPostconditionShape.equals(this.type)) {
            return (IHintedType)UMLElementTypes.Action_LocalPostconditionEdge;
        }
        if (UMLElementTypes.DurationConstraint_LocalPreconditionShape.equals(this.type)) {
            return (IHintedType)UMLElementTypes.Action_LocalPreconditionEdge;
        }
        if (UMLElementTypes.DurationConstraint_LocalPostconditionShape.equals(this.type)) {
            return (IHintedType)UMLElementTypes.Action_LocalPostconditionEdge;
        }
        if (UMLElementTypes.TimeConstraint_LocalPreconditionShape.equals(this.type)) {
            return (IHintedType)UMLElementTypes.Action_LocalPreconditionEdge;
        }
        if (UMLElementTypes.TimeConstraint_LocalPostconditionShape.equals(this.type)) {
            return (IHintedType)UMLElementTypes.Action_LocalPostconditionEdge;
        }
        return null;
    }

    public boolean canExecute() {
        return this.elementCreationCommand != null && this.elementCreationCommand.canExecute();
    }

    public void execute() {
        Object constraint = null;
        if (this.elementCreationCommand != null) {
            this.elementCreationCommand.execute();
            constraint = this.elementCreationCommand.getICommand().getCommandResult().getReturnValue();
        }
        if (constraint instanceof Constraint && this.compartment != null && this.type != null) {
            IAdaptable targetAdapter;
            this.viewsCreationCommand = new CompoundCommand();
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter((EObject)constraint), Node.class, this.type.getSemanticHint(), this.compartment.getDiagramPreferencesHint());
            CreateViewRequest request = new CreateViewRequest(descriptor);
            Command nodeCreationCommand = this.compartment.getCommand((Request)request);
            this.viewsCreationCommand.add(nodeCreationCommand);
            if (this.linkedActionEditPart != null && this.getLinkType() != null && (targetAdapter = this.extractResult(nodeCreationCommand)) != null) {
                SemanticAdapter sourceAdapter = new SemanticAdapter(null, this.linkedActionEditPart.getModel());
                CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getLinkType(), this.getLinkType().getSemanticHint(), this.compartment.getDiagramPreferencesHint());
                TransactionalEditingDomain usedEditingDomain = this.editingDomain;
                if (usedEditingDomain == null) {
                    usedEditingDomain = EditorUtils.getTransactionalEditingDomain();
                }
                CommonDeferredCreateConnectionViewCommand aLinkCommand = new CommonDeferredCreateConnectionViewCommand(usedEditingDomain, this.getLinkType().getSemanticHint(), (IAdaptable)sourceAdapter, targetAdapter, this.compartment.getViewer(), this.compartment.getDiagramPreferencesHint(), linkdescriptor, null);
                aLinkCommand.setElement((EObject)constraint);
                this.viewsCreationCommand.add((Command)new ICommandProxy((ICommand)aLinkCommand));
            }
            this.viewsCreationCommand.execute();
        }
    }

    private IAdaptable extractResult(Command nodeCreationCommand) {
        if (nodeCreationCommand instanceof ICommandProxy) {
            ICommand createConstraintNodeCommand = ((ICommandProxy)nodeCreationCommand).getICommand();
            IAdaptable targetAdapter = (IAdaptable)createConstraintNodeCommand.getCommandResult().getReturnValue();
            return targetAdapter;
        }
        if (nodeCreationCommand instanceof CompoundCommand) {
            Object[] childrenCmd;
            Object[] objectArray = childrenCmd = ((CompoundCommand)nodeCreationCommand).getChildren();
            int n = childrenCmd.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable result;
                Object command = objectArray[n2];
                if (command instanceof Command && (result = this.extractResult((Command)command)) != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public void undo() {
        if (this.viewsCreationCommand != null) {
            this.viewsCreationCommand.undo();
        }
        if (this.elementCreationCommand != null) {
            this.elementCreationCommand.undo();
        }
    }
}

