/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.infra.widgets.editors.StringEditorWithCompletionWrapper;
import org.eclipse.papyrus.infra.widgets.editors.StyledTextStringEditor;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.infra.widgets.util.ISetPapyrusConverter;
import org.eclipse.papyrus.infra.widgets.validator.AbstractValidator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class CompletionStyledTextStringEditor
extends StyledTextStringEditor
implements ISetPapyrusConverter {
    private StringEditorWithCompletionWrapper wrapper;
    protected IPapyrusConverter parser;

    public CompletionStyledTextStringEditor(Composite parent, int style, int heighHint, int widthHint) {
        super(parent, style, heighHint, widthHint);
        this.createReferenceTargetValidator();
    }

    public CompletionStyledTextStringEditor(Composite parent, int style, String label, int heighHint, int widthHint) {
        super(parent, style, label, heighHint, widthHint);
        this.createReferenceTargetValidator();
    }

    public CompletionStyledTextStringEditor(Composite parent, int style, String label) {
        super(parent, style, label);
        this.createReferenceTargetValidator();
    }

    @Override
    public void setValue(Object value) {
        if (this.parser != null && value instanceof Collection) {
            String val = this.parser.canonicalToEditValue(value, 0);
            super.setValue(val);
        } else {
            super.setValue(value);
        }
    }

    public CompletionStyledTextStringEditor(Composite parent, int style) {
        super(parent, style);
        this.createReferenceTargetValidator();
    }

    @Override
    protected void notifyChange() {
        this.text.notifyListeners(16, new Event());
        if (this.targetValidator != null) {
            IStatus status = this.targetValidator.validate(this.text.getText());
            this.updateStatus(status);
        }
        this.commit();
        this.changeColorField();
    }

    protected void createReferenceTargetValidator() {
        this.targetValidator = new AbstractValidator(){

            public IStatus validate(Object value) {
                if (CompletionStyledTextStringEditor.this.parser == null) {
                    return Status.OK_STATUS;
                }
                if (value instanceof String) {
                    return CompletionStyledTextStringEditor.this.parser.isValidEditString((String)value);
                }
                return new Status(4, "org.eclipse.papyrus.infra.widgets", "Impossible case");
            }
        };
    }

    @Override
    public StyledText createStyledText(Composite parent, String value, int style) {
        this.wrapper = new StringEditorWithCompletionWrapper(parent, style);
        return this.wrapper.getTextWidget();
    }

    @Override
    public void setPapyrusConverter(IPapyrusConverter parser) {
        this.parser = parser;
        this.wrapper.setPapyrusConverter(parser);
    }
}

