/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.utils.EMFHelper;

public class ProxyModificationTrackingAdapter
extends EContentAdapter {
    public boolean shouldSave(Resource resource) {
        return !resource.isTrackingModification() || resource.isModified();
    }

    protected void setTarget(Resource target) {
        this.basicSetTarget((Notifier)target);
    }

    protected void unsetTarget(Resource target) {
        this.basicUnsetTarget((Notifier)target);
    }

    protected void setTarget(EObject target) {
    }

    protected void unsetTarget(EObject target) {
    }

    public void notifyChanged(Notification n) {
        Object notifier = n.getNotifier();
        if (notifier instanceof Resource.Internal) {
            Resource.Internal r = (Resource.Internal)notifier;
            if (n.getEventType() == 1 && n.getFeatureID(Resource.class) == 1) {
                r.setModified(true);
                this.setOtherResourcesAsModified((Resource)r);
            } else {
                if (r.isLoaded() && !r.isLoading() && !(switch (n.getEventType()) {
                    case 5 -> (List<Object>)n.getNewValue();
                    case 6 -> (List)n.getOldValue();
                    case 3 -> Collections.singletonList(n.getNewValue());
                    case 4 -> Collections.singletonList(n.getOldValue());
                    default -> Collections.emptyList();
                }).isEmpty()) {
                    r.setModified(true);
                    this.setOtherResourcesAsModified((Resource)r);
                }
            }
        }
        super.notifyChanged(n);
    }

    protected void setReferencingResourcesAsModified(EObject eObj) {
        Collection<EStructuralFeature.Setting> references = EMFHelper.getUsages(eObj);
        for (EStructuralFeature.Setting setting : references) {
            Resource.Internal refResource;
            EStructuralFeature f = setting.getEStructuralFeature();
            if (setting.getEObject() == null || f.isDerived() || f.isTransient() || (refResource = (Resource.Internal)setting.getEObject().eResource()) == null || refResource.isLoading()) continue;
            refResource.setModified(true);
        }
    }

    protected void setOtherResourcesAsModified(Resource resource) {
        IEditingDomainProvider editingDomainProvider;
        ResourceSet resourceSet = resource.getResourceSet();
        TransactionalEditingDomain domain = null;
        if (resourceSet instanceof ModelSet) {
            domain = ((ModelSet)resourceSet).getTransactionalEditingDomain();
        } else if (resourceSet instanceof IEditingDomainProvider) {
            domain = ((IEditingDomainProvider)resourceSet).getEditingDomain();
        } else if (resourceSet != null && (editingDomainProvider = (IEditingDomainProvider)EcoreUtil.getExistingAdapter((Notifier)resourceSet, IEditingDomainProvider.class)) != null) {
            domain = editingDomainProvider.getEditingDomain();
        }
        for (Resource subResource : resourceSet.getResources()) {
            if (!(subResource instanceof Resource.Internal) || !subResource.isLoaded() || ((Resource.Internal)subResource).isLoading() || domain != null && domain.isReadOnly(subResource)) continue;
            subResource.setModified(true);
        }
    }
}

