/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import java.io.IOException;
import java.net.URL;
import java.util.function.Function;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.ui.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public abstract class HttpRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private boolean syncLabel = true;
    private boolean editingUrl = false;
    private boolean needsUser = true;
    private Button useToken;

    public HttpRepositorySettingsPage(String title, String description, TaskRepository taskRepository) {
        super(title, description, taskRepository);
        this.setHttpAuth(false);
        this.setNeedsAdvanced(false);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsTimeZone(false);
        this.setNeedsHttpAuth(false);
    }

    protected boolean isValidUrl(String url) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            try {
                new URL(url);
                return GitHub.getRepository((String)url) != null;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public boolean canValidate() {
        return this.isPageComplete() && (this.getMessage() == null || this.getMessageType() != 3);
    }

    private void syncRepositoryLabel(Function<RepositoryId, String> labelProvider) {
        String url;
        RepositoryId repo;
        if (this.syncLabel && (repo = GitHub.getRepository((String)(url = this.serverUrlCombo.getText()))) != null) {
            this.repositoryLabelEditor.setStringValue(labelProvider.apply(repo));
        }
    }

    protected void setInitialUrl(Function<RepositoryId, String> labelProvider) {
        String fullUrlText = "https://github.com/user/repository";
        this.serverUrlCombo.setText(fullUrlText);
        this.serverUrlCombo.setFocus();
        this.serverUrlCombo.setSelection(new Point("https://github.com".length() + 1, fullUrlText.length()));
        this.syncRepositoryLabel(labelProvider);
        this.serverUrlCombo.addModifyListener(e -> {
            this.editingUrl = true;
            try {
                this.syncRepositoryLabel(labelProvider);
            }
            finally {
                this.editingUrl = false;
            }
        });
        this.repositoryLabelEditor.getTextControl(this.compositeContainer).addModifyListener(e -> {
            if (!this.editingUrl) {
                this.syncLabel = false;
            }
        });
    }

    protected void addTokenCheckbox(final boolean userOptional) {
        this.needsUser = !userOptional;
        this.useToken = new Button(this.compositeContainer, 32);
        this.useToken.setText(Messages.HttpRepositorySettingsPage_LabelUseToken);
        this.useToken.setToolTipText(Messages.HttpRepositorySettingsPage_TooltipUseToken);
        this.useToken.moveBelow((Control)this.savePasswordButton);
        GridDataFactory.defaultsFor((Control)this.useToken).span(3, 1).applyTo((Control)this.useToken);
        final String savePasswordText = this.savePasswordButton.getText();
        final boolean[] allowAnon = new boolean[]{this.isAnonymousAccess()};
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isChecked = HttpRepositorySettingsPage.this.useToken.getSelection();
                if (isChecked) {
                    HttpRepositorySettingsPage.this.repositoryPasswordEditor.setLabelText(Messages.HttpRepositorySettingsPage_LabelToken);
                    HttpRepositorySettingsPage.this.savePasswordButton.setText(Messages.HttpRepositorySettingsPage_LabelSaveToken);
                    if (HttpRepositorySettingsPage.this.anonymousButton != null) {
                        allowAnon[0] = HttpRepositorySettingsPage.this.isAnonymousAccess();
                        HttpRepositorySettingsPage.this.setAnonymous(false);
                        HttpRepositorySettingsPage.this.anonymousButton.setEnabled(false);
                    }
                } else {
                    HttpRepositorySettingsPage.this.repositoryPasswordEditor.setLabelText(LABEL_PASSWORD);
                    HttpRepositorySettingsPage.this.savePasswordButton.setText(savePasswordText);
                    if (HttpRepositorySettingsPage.this.anonymousButton != null) {
                        HttpRepositorySettingsPage.this.anonymousButton.setEnabled(true);
                        HttpRepositorySettingsPage.this.setAnonymous(allowAnon[0]);
                    }
                }
                if (userOptional) {
                    HttpRepositorySettingsPage.this.repositoryUserNameEditor.getTextControl(HttpRepositorySettingsPage.this.compositeContainer).setEnabled(!isChecked);
                    HttpRepositorySettingsPage.this.repositoryUserNameEditor.setEmptyStringAllowed(isChecked);
                }
                HttpRepositorySettingsPage.this.repositoryPasswordEditor.getLabelControl(HttpRepositorySettingsPage.this.compositeContainer).requestLayout();
                if (userOptional && HttpRepositorySettingsPage.this.getWizard() != null) {
                    HttpRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.useToken.addSelectionListener((SelectionListener)listener);
        TaskRepository taskRepository = this.getRepository();
        if (taskRepository != null) {
            this.useToken.setSelection(Boolean.parseBoolean(taskRepository.getProperty(GitHub.PROPERTY_USE_TOKEN)));
            listener.widgetSelected(null);
        }
    }

    protected boolean useTokenAuth() {
        return this.useToken != null && this.useToken.getSelection();
    }

    protected boolean isMissingCredentials() {
        if (!this.needsUser && this.useTokenAuth()) {
            return this.repositoryPasswordEditor.getStringValue().trim().isEmpty();
        }
        return super.isMissingCredentials();
    }

    public void setMessage(String newMessage, int newType) {
        if (this.useTokenAuth() && org.eclipse.mylyn.internal.tasks.ui.wizards.Messages.AbstractRepositorySettingsPage_Enter_a_user_id_Message0.equals(newMessage)) {
            if (this.needsUser) {
                super.setMessage(Messages.HttpRepositorySettingsPage_EnterUserAndToken, newType);
            } else {
                super.setMessage(Messages.HttpRepositorySettingsPage_EnterToken, newType);
            }
        } else {
            super.setMessage(newMessage, newType);
        }
    }

    public void applyTo(TaskRepository taskRepository) {
        taskRepository.setProperty(GitHub.PROPERTY_USE_TOKEN, Boolean.toString(this.useToken != null && this.useToken.getSelection()));
        super.applyTo(taskRepository);
    }
}

