/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.PlatformPluginUnitResolver;
import org.osgi.framework.Bundle;

public class PlatformPluginUnitResolverFactory
extends UnitResolverFactory {
    public boolean accepts(URI uri) {
        return EMFPlugin.IS_ECLIPSE_RUNNING && uri.isPlatformPlugin();
    }

    public UnitResolver getResolver(URI uri) {
        PlatformPluginUnitResolver resolver;
        if (!uri.isPlatformPlugin() || uri.segmentCount() < 2) {
            return null;
        }
        String bundleId = uri.segment(1);
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            return null;
        }
        URI sourceFolderURI = ResolverUtils.getSourceFolderURI((URI)uri);
        if (sourceFolderURI != null && sourceFolderURI.segmentCount() > 2) {
            IPath pluginRelativePath = new Path(sourceFolderURI.toPlatformString(true)).removeFirstSegments(1);
            resolver = new PlatformPluginUnitResolver(bundle, pluginRelativePath);
        } else {
            resolver = new PlatformPluginUnitResolver(bundle);
        }
        PlatformPluginUnitResolver.setupResolver(resolver, true, true);
        return resolver;
    }

    public String getQualifiedName(URI uri) {
        IPath qualifiedName;
        if (!uri.isPlatformPlugin() || uri.segmentCount() < 2) {
            return null;
        }
        String bundleId = uri.segment(1);
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            return null;
        }
        Path path = new Path(uri.toPlatformString(true));
        URI sourceFolderURI = ResolverUtils.getSourceFolderURI((URI)uri);
        if (sourceFolderURI != null && sourceFolderURI.segmentCount() > 2) {
            qualifiedName = new Path(uri.deresolve(sourceFolderURI).trimFileExtension().trimQuery().toString());
        } else {
            qualifiedName = path.removeFirstSegments(1).removeFileExtension();
            IPath[] iPathArray = PlatformPluginUnitResolver.getSourceContainers(bundle);
            int n = iPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPath sourceContainer = iPathArray[n2];
                int matchCount = qualifiedName.matchingFirstSegments(sourceContainer);
                if (matchCount > 0) {
                    qualifiedName = qualifiedName.removeFirstSegments(matchCount);
                    break;
                }
                ++n2;
            }
        }
        return ResolverUtils.toQualifiedName((IPath)qualifiedName);
    }
}

