/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.validation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;

public class DiagnosticUtil {
    private final Map<Integer, String> severityStrings = new HashMap<Integer, String>(){
        {
            this.put(0, "OK");
            this.put(4, "ERROR");
            this.put(2, "WARNING");
            this.put(1, "INFO");
            this.put(8, "CANCEL");
        }
    };

    public List<Diagnostic> flatten(Diagnostic diagnostic) {
        ArrayList<Diagnostic> flattened = new ArrayList<Diagnostic>();
        this.traverseDiagnostic(flattened, diagnostic);
        return flattened;
    }

    public Iterable<Diagnostic> errors(Diagnostic diagnostic) {
        return Iterables.filter(this.flatten(diagnostic), (Predicate)new Predicate<Diagnostic>(){

            public boolean apply(Diagnostic input) {
                return input.getSeverity() == 4;
            }
        });
    }

    protected void traverseDiagnostic(List<Diagnostic> diagnostics, Diagnostic diagnostic) {
        if (diagnostic.getChildren().isEmpty()) {
            diagnostics.add(diagnostic);
        } else {
            for (Diagnostic diagnosticChild : diagnostic.getChildren()) {
                this.traverseDiagnostic(diagnostics, diagnosticChild);
            }
        }
    }

    public String format(Diagnostic d) {
        return String.valueOf(this.severityStrings.get(d.getSeverity())) + ": " + d.getMessage();
    }
}

