/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.eclipse.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.emf.mwe.core.WorkflowRunner;
import org.eclipse.emf.mwe.internal.core.debug.processing.DebugMonitor;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugTarget;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugThread;
import org.eclipse.emf.mwe.internal.ui.eclipse.launch.MWEDebuggerLauncher;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class MWELaunchDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final String wfRunnerClassName = WorkflowRunner.class.getName();
    private String wfFileName;
    private Job refreshJob = new Job("refresh resources"){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, monitor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    };

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.beginTask("Launching VM...", 3);
        monitor.worked(1);
        this.wfFileName = configuration.getAttribute("startWorkflow", null);
        if (this.wfFileName == null) {
            throw new DebugException(Activator.createErrorStatus("Workflow file is not specified --> aborting", null));
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.wfFileName));
        if (this.wfFileName.startsWith("/")) {
            this.wfFileName = file.getLocation().toString();
        }
        if (!file.exists()) {
            throw new DebugException(Activator.createErrorStatus("file " + file.getFullPath() + " does not exist. --> aborting", null));
        }
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        boolean javaDebug = configuration.getAttribute("java_debug", false);
        if (!mode.equals("debug") || javaDebug) {
            Job[] manBuildJobs;
            Job[] autoBuildJobs;
            monitor.subTask("preparing Java launch...");
            ILaunchConfigurationWorkingCopy wc = configuration.copy("JavaLaunch");
            try {
                ILaunchConfigurationType configType = this.getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
                wc = configType.newInstance(null, configuration.getName());
            }
            catch (CoreException e) {
                throw new DebugException(Activator.createErrorStatus("Error creating launch configuration. --> aborting", (Exception)((Object)e)));
            }
            wc.setAttributes(configuration.getAttributes());
            String programArguments = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, wfRunnerClassName);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "\"" + this.wfFileName + "\" " + programArguments);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION, "workflow - " + this.wfFileName);
            monitor.worked(1);
            monitor.subTask("delegating to Java launch...");
            do {
                autoBuildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_AUTO_BUILD);
                manBuildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
            } while (autoBuildJobs.length > 0 || manBuildJobs.length > 0);
            this.getLaunchManager().removeLaunch(launch);
            DebugUITools.launch((ILaunchConfiguration)wc, (String)mode);
        } else {
            monitor.subTask("preparing debugger launch...");
            IVMInstall vm = JavaRuntime.computeVMInstall((ILaunchConfiguration)configuration);
            MWEDebuggerLauncher launcher = new MWEDebuggerLauncher(vm);
            String[] classpath = this.getClasspath(configuration);
            String workingDirName = null;
            IJavaProject jp = this.getJavaProject(configuration);
            if (jp != null) {
                IProject p = jp.getProject();
                workingDirName = p.getLocation().toFile().getAbsolutePath();
            }
            String attribute = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            ArrayList<String> progArgs = new ArrayList<String>();
            progArgs.add(this.wfFileName);
            progArgs.add("-m");
            progArgs.add(DebugMonitor.class.getName());
            if (!attribute.equals("")) {
                String[] split;
                String[] stringArray = split = attribute.split("\\s");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (!string.equals("")) {
                        progArgs.add(string);
                    }
                    ++n2;
                }
            }
            String vmArgs = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
            VMRunnerConfiguration runnerConfig = new VMRunnerConfiguration(wfRunnerClassName, classpath);
            runnerConfig.setWorkingDirectory(workingDirName);
            runnerConfig.setProgramArguments(progArgs.toArray(new String[0]));
            runnerConfig.setVMArguments(DebugPlugin.parseArguments((String)vmArgs));
            monitor.worked(1);
            monitor.subTask("launching debugger ...");
            launcher.run(runnerConfig, launch, monitor);
        }
        monitor.done();
    }

    public void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if ((event.getSource() instanceof DebugTarget || event.getSource() instanceof DebugThread || event.getSource() instanceof RuntimeProcess) && event.getKind() == 8) {
                if (this.refreshJob.getState() != 2) {
                    this.refreshJob.schedule();
                }
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
            }
            ++n2;
        }
        super.handleDebugEvents(events);
    }
}

