/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.testing;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.dltk.internal.testing.model.DLTKTestingModel;
import org.eclipse.dltk.testing.TestRunListener;
import org.eclipse.dltk.testing.model.ITestRunSession;
import org.eclipse.dltk.testing.model.ITestingModel;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class DLTKTestingPlugin
extends AbstractUIPlugin {
    private static DLTKTestingPlugin fgPlugin = null;
    public static final String PLUGIN_ID = "org.eclipse.dltk.testing";
    public static final String JUNIT_HOME = "JUNIT_HOME";
    private static final IPath ICONS_PATH = new Path("$nl$/icons/full");
    private static final String HISTORY_DIR_NAME = "history";
    private final DLTKTestingModel fTestingModel = new DLTKTestingModel();
    private ListenerList<TestRunListener> fNewTestRunListeners;
    private BundleContext fBundleContext;
    private static boolean fIsStopped = false;

    public DLTKTestingPlugin() {
        fgPlugin = this;
        this.fNewTestRunListeners = new ListenerList();
    }

    public static DLTKTestingPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow workBenchWindow = DLTKTestingPlugin.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (fgPlugin == null) {
            return null;
        }
        IWorkbench workBench = fgPlugin.getWorkbench();
        if (workBench == null) {
            return null;
        }
        return workBench.getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = DLTKTestingPlugin.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        return activeWorkbenchWindow.getActivePage();
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static void log(Throwable e) {
        DLTKTestingPlugin.log("Error", e);
    }

    public static void log(String message, Throwable e) {
        DLTKTestingPlugin.log((IStatus)new Status(4, DLTKTestingPlugin.getPluginId(), 4, message, e));
    }

    public static void log(IStatus status) {
        DLTKTestingPlugin.getDefault().getLog().log(status);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        IPath path = ICONS_PATH.append(relativePath);
        return DLTKTestingPlugin.createImageDescriptor(DLTKTestingPlugin.getDefault().getBundle(), path, true);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        DLTKTestingPlugin.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = DLTKTestingPlugin.createImageDescriptor("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = DLTKTestingPlugin.createImageDescriptor("e" + type, relPath, true);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createImageDescriptor(String pathPrefix, String imageName, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(pathPrefix).append(imageName);
        return DLTKTestingPlugin.createImageDescriptor(DLTKTestingPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        this.fTestingModel.start();
    }

    public void stop(BundleContext context) throws Exception {
        fIsStopped = true;
        try {
            this.fTestingModel.stop();
        }
        finally {
            super.stop(context);
        }
        this.fBundleContext = null;
    }

    public static ITestingModel getModel() {
        return DLTKTestingPlugin.getDefault().fTestingModel;
    }

    public Bundle getBundle(String bundleName) {
        Bundle[] bundles = this.getBundles(bundleName, null);
        if (bundles != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public Bundle[] getBundles(String bundleName, String version) {
        Bundle[] bundles = Platform.getBundles((String)bundleName, (String)version);
        if (bundles != null) {
            return bundles;
        }
        ServiceReference serviceRef = this.fBundleContext.getServiceReference(PackageAdmin.class);
        PackageAdmin admin = (PackageAdmin)this.fBundleContext.getService(serviceRef);
        bundles = admin.getBundles(bundleName, version);
        if (bundles != null && bundles.length > 0) {
            return bundles;
        }
        return null;
    }

    public ListenerList<TestRunListener> getNewTestRunListeners() {
        return this.fNewTestRunListeners;
    }

    public static boolean isStopped() {
        return fIsStopped;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static File getHistoryDirectory() throws IllegalStateException {
        File historyDir = DLTKTestingPlugin.getDefault().getStateLocation().append(HISTORY_DIR_NAME).toFile();
        if (!historyDir.isDirectory()) {
            historyDir.mkdir();
        }
        return historyDir;
    }

    public static ITestRunSession getTestRunSession(ILaunch launch) {
        return DLTKTestingPlugin.getModel().getTestRunSession(launch);
    }

    public static IViewPart showTestRunnerViewPartInActivePage() {
        return DLTKTestingPlugin.getDefault().fTestingModel.showTestRunnerViewPartInActivePage();
    }
}

