/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.tasks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InputSet;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.OutputSet;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.modeler.core.adapters.InsertionAdapter;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultListComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.ListCompositeColumnProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.TableColumn;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.ui.property.tasks.IoParameterMappingColumn;
import org.eclipse.bpmn2.modeler.ui.property.tasks.IoParameterNameColumn;
import org.eclipse.bpmn2.modeler.ui.property.tasks.IoParametersDetailComposite;
import org.eclipse.bpmn2.modeler.ui.property.tasks.Messages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.widgets.Composite;

public class IoParametersListComposite
extends DefaultListComposite {
    protected Activity activity;
    protected CallableElement element;
    protected EStructuralFeature ioFeature;
    protected boolean isInput;

    public IoParametersListComposite(IoParametersDetailComposite detailComposite, EObject container, InputOutputSpecification ioSpec, EStructuralFeature ioFeature) {
        super((Composite)detailComposite, 28835840);
        this.ioFeature = ioFeature;
        this.isInput = "dataInputs".equals(ioFeature.getName());
        if (container instanceof Activity) {
            this.activity = (Activity)container;
            this.columnProvider = new ListCompositeColumnProvider((AbstractListComposite)this);
            EClass listItemClass = (EClass)ioFeature.getEType();
            this.setListItemClass(listItemClass);
            if (this.isInput) {
                EReference f = PACKAGE.getActivity_DataInputAssociations();
                this.columnProvider.add((TableColumn)new IoParameterMappingColumn((EObject)this.activity, (EStructuralFeature)f)).setHeaderText(Messages.IoParametersListComposite_From_Header);
                f = (EAttribute)listItemClass.getEStructuralFeature("name");
                this.columnProvider.add((TableColumn)new IoParameterNameColumn((EObject)this.activity, (EStructuralFeature)f)).setHeaderText(Messages.IoParametersListComposite_To_Header);
                this.columnProvider.add(new TableColumn((EObject)this.activity, (EStructuralFeature)PACKAGE.getDataInput_IsCollection()));
            } else {
                EAttribute f = (EAttribute)listItemClass.getEStructuralFeature("name");
                this.columnProvider.add((TableColumn)new IoParameterNameColumn((EObject)this.activity, (EStructuralFeature)f)).setHeaderText(Messages.IoParametersListComposite_From_Header);
                f = PACKAGE.getActivity_DataOutputAssociations();
                this.columnProvider.add((TableColumn)new IoParameterMappingColumn((EObject)this.activity, (EStructuralFeature)f)).setHeaderText(Messages.IoParametersListComposite_To_Header);
                this.columnProvider.add(new TableColumn((EObject)this.activity, (EStructuralFeature)PACKAGE.getDataOutput_IsCollection()));
            }
        } else if (container instanceof CallableElement) {
            this.element = (CallableElement)container;
        }
    }

    InputOutputSpecification getIoSpec() {
        return (InputOutputSpecification)this.getBusinessObject();
    }

    protected EObject addListItem(EObject object, EStructuralFeature feature) {
        EObject param = null;
        InsertionAdapter.executeIfNeeded((EObject)this.getIoSpec());
        param = super.addListItem(object, feature);
        if (this.getIoSpec().getInputSets().size() == 0) {
            InputSet is = (InputSet)Bpmn2ModelerFactory.createObject((Resource)this.getIoSpec().eResource(), InputSet.class);
            this.getIoSpec().getInputSets().add(is);
        }
        if (this.getIoSpec().getOutputSets().size() == 0) {
            OutputSet os = (OutputSet)Bpmn2ModelerFactory.createObject((Resource)this.getIoSpec().eResource(), OutputSet.class);
            this.getIoSpec().getOutputSets().add(os);
        }
        if (this.activity != null) {
            if (param instanceof DataInput) {
                DataInputAssociation inputAssociation = (DataInputAssociation)this.createModelObject(DataInputAssociation.class);
                this.activity.getDataInputAssociations().add(inputAssociation);
                inputAssociation.setTargetRef((ItemAwareElement)((DataInput)param));
            } else if (param instanceof DataOutput) {
                DataOutputAssociation outputAssociation = (DataOutputAssociation)this.createModelObject(DataOutputAssociation.class);
                this.activity.getDataOutputAssociations().add(outputAssociation);
                outputAssociation.getSourceRef().clear();
                outputAssociation.getSourceRef().add((DataOutput)param);
            }
        }
        return param;
    }

    protected EObject editListItem(EObject object, EStructuralFeature feature) {
        return super.editListItem(object, feature);
    }

    protected Object removeListItem(EObject object, EStructuralFeature feature, int index) {
        EList list = this.getItemList();
        EObject item = (EObject)list.get(index);
        if (item instanceof DataInput) {
            List inputSets = this.getIoSpec().getInputSets();
            for (InputSet is : inputSets) {
                if (!is.getDataInputRefs().contains(item)) continue;
                is.getDataInputRefs().remove(item);
            }
        } else if (item instanceof DataOutput) {
            List OutputSets = this.getIoSpec().getOutputSets();
            for (InputSet is : OutputSets) {
                if (!is.getDataOutputRefs().contains(item)) continue;
                is.getDataOutputRefs().remove(item);
            }
        }
        if (this.activity != null) {
            ArrayList<DataInputAssociation> dataAssociationsRemoved = new ArrayList<DataInputAssociation>();
            ArrayList<BPMNEdge> edgesRemoved = new ArrayList<BPMNEdge>();
            if (item instanceof DataInput) {
                List dataInputAssociations = this.activity.getDataInputAssociations();
                for (DataInputAssociation da : dataInputAssociations) {
                    if (da.getTargetRef() == null || !da.getTargetRef().equals(item)) continue;
                    dataAssociationsRemoved.add(da);
                    Diagram diagram = this.getDiagramEditor().getDiagramTypeProvider().getDiagram();
                    BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)diagram);
                    BPMNEdge edge = DIUtils.findBPMNEdge((BPMNDiagram)bpmnDiagram, (EObject)da);
                    if (edge == null) continue;
                    edgesRemoved.add(edge);
                }
                dataInputAssociations.removeAll(dataAssociationsRemoved);
            } else if (item instanceof DataOutput) {
                List dataOutputAssociations = this.activity.getDataOutputAssociations();
                for (DataInputAssociation da : dataOutputAssociations) {
                    if (da.getSourceRef() == null || !da.getSourceRef().contains(item)) continue;
                    dataAssociationsRemoved.add(da);
                    BPMNEdge edge = DIUtils.findBPMNEdge((EObject)da);
                    if (edge == null) continue;
                    edgesRemoved.add(edge);
                }
                dataOutputAssociations.removeAll(dataAssociationsRemoved);
            }
            for (BPMNEdge edge : edgesRemoved) {
                Diagram diagram = this.getDiagramEditor().getDiagramTypeProvider().getDiagram();
                Object[] objectArray = Graphiti.getPeService().getLinkedPictogramElements(new EObject[]{edge}, diagram);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object pe = objectArray[n2];
                    if (pe instanceof Connection) {
                        Graphiti.getPeService().deletePictogramElement((PictogramElement)((Connection)pe));
                    }
                    ++n2;
                }
                EcoreUtil.delete((EObject)edge, (boolean)true);
            }
        } else if (this.element == null) {
            return false;
        }
        return super.removeListItem(object, feature, index);
    }
}

