package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link UpdateStatus}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUpdateStatus.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableUpdateStatus implements UpdateStatus {
  private final @Nullable String state;
  private final Date startedAt;
  private final @Nullable Date completedAt;
  private final @Nullable String message;

  private ImmutableUpdateStatus(
      @Nullable String state,
      Date startedAt,
      @Nullable Date completedAt,
      @Nullable String message) {
    this.state = state;
    this.startedAt = startedAt;
    this.completedAt = completedAt;
    this.message = message;
  }

  /**
   * @return The value of the {@code state} attribute
   */
  @JsonProperty("State")
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   * @return The value of the {@code startedAt} attribute
   */
  @JsonProperty("StartedAt")
  @Override
  public Date startedAt() {
    return startedAt;
  }

  /**
   * @return The value of the {@code completedAt} attribute
   */
  @JsonProperty("CompletedAt")
  @Override
  public @Nullable Date completedAt() {
    return completedAt;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty("Message")
  @Override
  public @Nullable String message() {
    return message;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateStatus#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateStatus withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableUpdateStatus(value, this.startedAt, this.completedAt, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateStatus#startedAt() startedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for startedAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateStatus withStartedAt(Date value) {
    if (this.startedAt == value) return this;
    Date newValue = Objects.requireNonNull(value, "startedAt");
    return new ImmutableUpdateStatus(this.state, newValue, this.completedAt, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateStatus#completedAt() completedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for completedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateStatus withCompletedAt(@Nullable Date value) {
    if (this.completedAt == value) return this;
    return new ImmutableUpdateStatus(this.state, this.startedAt, value, this.message);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateStatus#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateStatus withMessage(@Nullable String value) {
    if (Objects.equals(this.message, value)) return this;
    return new ImmutableUpdateStatus(this.state, this.startedAt, this.completedAt, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUpdateStatus} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUpdateStatus
        && equalTo((ImmutableUpdateStatus) another);
  }

  private boolean equalTo(ImmutableUpdateStatus another) {
    return Objects.equals(state, another.state)
        && startedAt.equals(another.startedAt)
        && Objects.equals(completedAt, another.completedAt)
        && Objects.equals(message, another.message);
  }

  /**
   * Computes a hash code from attributes: {@code state}, {@code startedAt}, {@code completedAt}, {@code message}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + startedAt.hashCode();
    h += (h << 5) + Objects.hashCode(completedAt);
    h += (h << 5) + Objects.hashCode(message);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateStatus} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateStatus{"
        + "state=" + state
        + ", startedAt=" + startedAt
        + ", completedAt=" + completedAt
        + ", message=" + message
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link UpdateStatus} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UpdateStatus instance
   */
  public static ImmutableUpdateStatus copyOf(UpdateStatus instance) {
    if (instance instanceof ImmutableUpdateStatus) {
      return (ImmutableUpdateStatus) instance;
    }
    return ImmutableUpdateStatus.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUpdateStatus ImmutableUpdateStatus}.
   * <pre>
   * ImmutableUpdateStatus.builder()
   *    .state(String | null) // nullable {@link UpdateStatus#state() state}
   *    .startedAt(Date) // required {@link UpdateStatus#startedAt() startedAt}
   *    .completedAt(Date | null) // nullable {@link UpdateStatus#completedAt() completedAt}
   *    .message(String | null) // nullable {@link UpdateStatus#message() message}
   *    .build();
   * </pre>
   * @return A new ImmutableUpdateStatus builder
   */
  public static ImmutableUpdateStatus.Builder builder() {
    return new ImmutableUpdateStatus.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUpdateStatus ImmutableUpdateStatus}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_STARTED_AT = 0x1L;
    private long initBits = 0x1L;

    private String state;
    private Date startedAt;
    private Date completedAt;
    private String message;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateStatus} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateStatus instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String stateValue = instance.state();
      if (stateValue != null) {
        state(stateValue);
      }
      startedAt(instance.startedAt());
      @Nullable Date completedAtValue = instance.completedAt();
      if (completedAtValue != null) {
        completedAt(completedAtValue);
      }
      @Nullable String messageValue = instance.message();
      if (messageValue != null) {
        message(messageValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateStatus#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("State")
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateStatus#startedAt() startedAt} attribute.
     * @param startedAt The value for startedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("StartedAt")
    public final Builder startedAt(Date startedAt) {
      this.startedAt = Objects.requireNonNull(startedAt, "startedAt");
      initBits &= ~INIT_BIT_STARTED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateStatus#completedAt() completedAt} attribute.
     * @param completedAt The value for completedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("CompletedAt")
    public final Builder completedAt(@Nullable Date completedAt) {
      this.completedAt = completedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateStatus#message() message} attribute.
     * @param message The value for message (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Message")
    public final Builder message(@Nullable String message) {
      this.message = message;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUpdateStatus ImmutableUpdateStatus}.
     * @return An immutable instance of UpdateStatus
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUpdateStatus build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUpdateStatus(state, startedAt, completedAt, message);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STARTED_AT) != 0) attributes.add("startedAt");
      return "Cannot build UpdateStatus, some of required attributes are not set " + attributes;
    }
  }
}
