/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.SchemaAssociation;
import org.eclipse.wildwebdeveloper.SchemaAssociationDialog;
import org.eclipse.wildwebdeveloper.SchemaAssociationsMessages;

public class SchemaAssociationsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.wildwebdeveloper.SchemaAssociationsPreferencePage";
    private IPreferenceStore store;
    private Table schemaTable;

    public void init(IWorkbench workbench) {
        this.store = this.doGetPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        Link pageTitle = new Link(parent, 0);
        pageTitle.setLayoutData((Object)new GridData(4));
        pageTitle.setText(SchemaAssociationsMessages.SchemaAssociations_PreferencePage_title);
        pageTitle.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IPreferencePageContainer iPreferencePageContainer = this.getContainer();
            if (iPreferencePageContainer instanceof IWorkbenchPreferenceContainer var2_3) {
                void prefContainer;
                prefContainer.openPage("org.eclipse.ui.preferencePages.ContentTypes", null);
            }
        }));
        this.schemaTable = new Table(parent, 68356);
        this.schemaTable.setHeaderVisible(true);
        this.schemaTable.setLinesVisible(true);
        this.schemaTable.setLayoutData((Object)new GridData(4));
        TableColumn contentTypeCol = new TableColumn(this.schemaTable, 16384);
        contentTypeCol.setText(SchemaAssociationsMessages.ContentType);
        TableColumn contentTypeIdCol = new TableColumn(this.schemaTable, 16384);
        contentTypeIdCol.setText(SchemaAssociationsMessages.ContentTypeId);
        TableColumn schemaLocationCol = new TableColumn(this.schemaTable, 16384);
        schemaLocationCol.setText(SchemaAssociationsMessages.SchemaLocation);
        String schemaString = this.store.getString("wildwebdeveloper.yaml.schema");
        this.insertTableItems(schemaString);
        Composite buttonsBar = new Composite(parent, 0);
        buttonsBar.setLayout((Layout)new RowLayout());
        buttonsBar.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        Button addButton = new Button(buttonsBar, 8);
        addButton.setText(SchemaAssociationsMessages.Add);
        addButton.addListener(13, event -> {
            SchemaAssociationDialog dialog = new SchemaAssociationDialog(parent.getShell(), this.getSchemaAssociations());
            dialog.create();
            if (dialog.open() == 0) {
                TableItem newItem = new TableItem(this.schemaTable, 0);
                newItem.setText(0, dialog.getContentType());
                newItem.setText(1, dialog.getContentTypeId());
                newItem.setText(2, dialog.getSchemaLocation());
            }
        });
        Button editButton = new Button(buttonsBar, 8);
        editButton.setText(SchemaAssociationsMessages.Edit);
        editButton.addListener(13, event -> {
            TableItem[] selection = this.schemaTable.getSelection();
            if (selection.length == 0) {
                return;
            }
            TableItem selectedItem = selection[0];
            SchemaAssociation selectedAssociation = new SchemaAssociation(selectedItem.getText(0), selectedItem.getText(1), selectedItem.getText(2));
            SchemaAssociationDialog dialog = new SchemaAssociationDialog(parent.getShell(), this.getSchemaAssociations(), selectedAssociation);
            dialog.create();
            if (dialog.open() == 0) {
                selectedItem.setText(0, dialog.getContentType());
                selectedItem.setText(1, dialog.getContentTypeId());
                selectedItem.setText(2, dialog.getSchemaLocation());
            }
        });
        Button removeButton = new Button(buttonsBar, 8);
        removeButton.setText(SchemaAssociationsMessages.Remove);
        removeButton.addListener(13, event -> {
            if (this.schemaTable.getSelectionCount() > 0) {
                this.schemaTable.remove(this.schemaTable.getSelectionIndex());
            }
        });
        contentTypeCol.pack();
        contentTypeIdCol.pack();
        schemaLocationCol.pack();
        Composite extensionPointNote = this.createNoteComposite(parent.getFont(), parent, WorkbenchMessages.Preference_note, SchemaAssociationsMessages.SchemaAssociations_PreferencePage_note);
        extensionPointNote.setLayoutData((Object)new GridData(4));
        parent.layout();
        return new Composite(parent, 0);
    }

    public boolean performOk() {
        JsonObject schemaAssociation = new JsonObject();
        TableItem[] tableItemArray = this.schemaTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            schemaAssociation.addProperty(item.getText(1), item.getText(2));
            ++n2;
        }
        this.store.setValue("wildwebdeveloper.yaml.schema", schemaAssociation.toString());
        this.refreshTable();
        return true;
    }

    protected void refreshTable() {
        this.schemaTable.removeAll();
        String schemaString = this.store.getString("wildwebdeveloper.yaml.schema");
        this.insertTableItems(schemaString);
    }

    protected void performDefaults() {
        this.schemaTable.removeAll();
        String defaultSchemaAssociations = this.store.getDefaultString("wildwebdeveloper.yaml.schema");
        this.insertTableItems(defaultSchemaAssociations);
        super.performDefaults();
    }

    private void insertTableItems(String schemaAssociationsString) {
        TreeMap associations = (TreeMap)new Gson().fromJson(schemaAssociationsString, new TypeToken<TreeMap<String, String>>(){}.getType());
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        for (String contentTypeId : associations.keySet()) {
            IContentType contentType = contentTypeManager.getContentType(contentTypeId);
            TableItem item = new TableItem(this.schemaTable, 0);
            item.setText(0, contentType.getName());
            item.setText(1, contentTypeId);
            item.setText(2, (String)associations.get(contentTypeId));
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private Set<SchemaAssociation> getSchemaAssociations() {
        HashSet<SchemaAssociation> associations = new HashSet<SchemaAssociation>();
        TableItem[] tableItemArray = this.schemaTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            associations.add(new SchemaAssociation(item.getText(0), item.getText(1), item.getText(2)));
            ++n2;
        }
        return associations;
    }
}

