/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;

public class LocatorProxy
implements ILocator {
    private final IChannel channel;
    private final Map<String, IPeer> peers = new HashMap<String, IPeer>();
    private final Collection<ILocator.LocatorListener> listeners = new ArrayList<ILocator.LocatorListener>();
    private boolean get_peers_done = false;
    private final IChannel.IEventListener event_listener = new IChannel.IEventListener(){

        @Override
        public void event(String name, byte[] data) {
            block27: {
                try {
                    Object[] args = JSON.parseSequence(data);
                    if (name.equals("peerAdded")) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                        Peer peer = new Peer(LocatorProxy.this.channel.getRemotePeer(), (Map)args[0]);
                        if (LocatorProxy.this.peers.get(peer.getID()) != null) {
                            Protocol.log("Invalid peerAdded event", new Error());
                            return;
                        }
                        LocatorProxy.this.peers.put(peer.getID(), peer);
                        ILocator.LocatorListener[] locatorListenerArray = LocatorProxy.this.listeners.toArray(new ILocator.LocatorListener[LocatorProxy.this.listeners.size()]);
                        int n = locatorListenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILocator.LocatorListener l = locatorListenerArray[n2];
                            try {
                                l.peerAdded(peer);
                            }
                            catch (Throwable x) {
                                Protocol.log("Unhandled exception in Locator listener", x);
                            }
                            ++n2;
                        }
                        break block27;
                    }
                    if (name.equals("peerChanged")) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                        Map m = (Map)args[0];
                        if (m == null) {
                            throw new Error("Locator service: invalid peerChanged event - no peer ID");
                        }
                        IPeer peer = (IPeer)LocatorProxy.this.peers.get(m.get("ID"));
                        if (peer == null) {
                            return;
                        }
                        LocatorProxy.this.peers.put(peer.getID(), peer);
                        ILocator.LocatorListener[] locatorListenerArray = LocatorProxy.this.listeners.toArray(new ILocator.LocatorListener[LocatorProxy.this.listeners.size()]);
                        int n = locatorListenerArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            ILocator.LocatorListener l = locatorListenerArray[n3];
                            try {
                                l.peerChanged(peer);
                            }
                            catch (Throwable x) {
                                Protocol.log("Unhandled exception in Locator listener", x);
                            }
                            ++n3;
                        }
                        break block27;
                    }
                    if (name.equals("peerRemoved")) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                        String id = (String)args[0];
                        IPeer peer = (IPeer)LocatorProxy.this.peers.remove(id);
                        if (peer == null) {
                            return;
                        }
                        ILocator.LocatorListener[] locatorListenerArray = LocatorProxy.this.listeners.toArray(new ILocator.LocatorListener[LocatorProxy.this.listeners.size()]);
                        int n = locatorListenerArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            ILocator.LocatorListener l = locatorListenerArray[n4];
                            try {
                                l.peerRemoved(id);
                            }
                            catch (Throwable x) {
                                Protocol.log("Unhandled exception in Locator listener", x);
                            }
                            ++n4;
                        }
                        break block27;
                    }
                    if (name.equals("peerHeartBeat")) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                        String id = (String)args[0];
                        IPeer peer = (IPeer)LocatorProxy.this.peers.get(id);
                        if (peer == null) {
                            return;
                        }
                        ILocator.LocatorListener[] locatorListenerArray = LocatorProxy.this.listeners.toArray(new ILocator.LocatorListener[LocatorProxy.this.listeners.size()]);
                        int n = locatorListenerArray.length;
                        int n5 = 0;
                        while (n5 < n) {
                            ILocator.LocatorListener l = locatorListenerArray[n5];
                            try {
                                l.peerHeartBeat(id);
                            }
                            catch (Throwable x) {
                                Protocol.log("Unhandled exception in Locator listener", x);
                            }
                            ++n5;
                        }
                        break block27;
                    }
                    throw new IOException("Locator service: unknown event: " + name);
                }
                catch (Throwable x) {
                    LocatorProxy.this.channel.terminate(x);
                }
            }
        }
    };

    public LocatorProxy(IChannel channel) {
        this.channel = channel;
        channel.addEventListener(this, this.event_listener);
    }

    @Override
    public String getName() {
        return "Locator";
    }

    @Override
    public Map<String, IPeer> getPeers() {
        return this.peers;
    }

    @Override
    public IToken redirect(String peer_id, final ILocator.DoneRedirect done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"redirect", (Object[])new Object[]{peer_id}){

            @Override
            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneRedirect(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken redirect(Map<String, String> peer, final ILocator.DoneRedirect done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"redirect", (Object[])new Object[]{peer}){

            @Override
            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneRedirect(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken sync(final ILocator.DoneSync done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"sync", null){

            @Override
            public void done(Exception error, Object[] args) {
                if (error != null) {
                    LocatorProxy.this.channel.terminate(error);
                }
                done.doneSync(this.token);
            }
        }.token;
    }

    @Override
    public IToken getAgentID(final ILocator.DoneGetAgentID done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getAgentID", null){

            @Override
            public void done(Exception error, Object[] args) {
                String agentID = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] instanceof String) {
                        agentID = (String)args[1];
                    }
                }
                done.doneGetAgentID(this.token, error, agentID);
            }
        }.token;
    }

    @Override
    public void addListener(ILocator.LocatorListener listener) {
        this.listeners.add(listener);
        if (!this.get_peers_done) {
            new Command(this.channel, this, "getPeers", null){

                @Override
                public void done(Exception error, Object[] args) {
                    if (error == null) {
                        if (!$assertionsDisabled && args.length != 2) {
                            throw new AssertionError();
                        }
                        error = this.toError(args[0]);
                    }
                    if (error != null) {
                        if (LocatorProxy.this.channel.getState() == 2) {
                            return;
                        }
                        Protocol.log("Locator error", error);
                        return;
                    }
                    Collection c = (Collection)args[1];
                    if (c != null) {
                        for (Object o : c) {
                            Map m = (Map)o;
                            String id = (String)m.get("ID");
                            if (LocatorProxy.this.peers.get(id) != null) continue;
                            Peer peer = new Peer(LocatorProxy.this.channel.getRemotePeer(), m);
                            LocatorProxy.this.peers.put(id, peer);
                            ILocator.LocatorListener[] locatorListenerArray = LocatorProxy.this.listeners.toArray(new ILocator.LocatorListener[LocatorProxy.this.listeners.size()]);
                            int n = locatorListenerArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ILocator.LocatorListener l = locatorListenerArray[n2];
                                try {
                                    l.peerAdded(peer);
                                }
                                catch (Throwable x) {
                                    Protocol.log("Unhandled exception in Locator listener", x);
                                }
                                ++n2;
                            }
                        }
                    }
                }
            };
            this.get_peers_done = true;
        }
    }

    @Override
    public void removeListener(ILocator.LocatorListener listener) {
        this.listeners.remove(listener);
    }

    private class Peer
    extends TransientPeer {
        private final IPeer parent;

        Peer(IPeer parent, Map<String, String> attrs) {
            super(attrs);
            this.parent = parent;
        }

        @Override
        public IChannel openChannel() {
            assert (Protocol.isDispatchThread());
            IChannel c = this.parent.openChannel();
            c.redirect(this.getID());
            return c;
        }
    }
}

