/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.openperspective;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.eclipse.ui.perspectives.AbstractPerspective;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.requirements.exception.RequirementsLayerException;

public class OpenPerspectiveRequirement
implements Requirement<OpenPerspective> {
    protected final Logger log = Logger.getLogger(this.getClass());
    private OpenPerspective openPerspective;

    public void fulfill() {
        try {
            final AbstractPerspective perspective = this.getPerspectiveInstance();
            perspective.open();
            if (this.openPerspective.reset()) {
                new WaitUntil((WaitCondition)new AbstractWaitCondition(){

                    public boolean test() {
                        return perspective.isResetEnabled();
                    }
                }, TimePeriod.SHORT, false);
                if (!perspective.isResetEnabled()) {
                    this.log.info("Reset Perspective menu is not enabled, skipping");
                    return;
                }
                perspective.reset();
            }
        }
        catch (Exception e) {
            throw new RequirementsLayerException("Unable to fullffill requirement 'Open Perspective'", e);
        }
    }

    public void setDeclaration(OpenPerspective openPerspective) {
        this.openPerspective = openPerspective;
    }

    private AbstractPerspective getPerspectiveInstance() throws InstantiationException, IllegalAccessException {
        AbstractPerspective perspectiveInstance = null;
        perspectiveInstance = this.openPerspective.value().newInstance();
        return perspectiveInstance;
    }

    public void cleanUp() {
    }

    public OpenPerspective getDeclaration() {
        return this.openPerspective;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Documented
    public static @interface OpenPerspective {
        public Class<? extends AbstractPerspective> value();

        public boolean reset() default true;
    }
}

