/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.swt.graphics.Image;

public class CrossFigure
extends PapyrusNodeFigure
implements IPapyrusUMLElementFigure {
    public static final int CROSS_SIZE = 8;

    public CrossFigure() {
        this.setShadow(false);
        this.setBorder(null);
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.pushState();
        graphics.setAntialias(1);
        Rectangle clipRect = graphics.getClip(new Rectangle());
        int additionalSizeForCross = 10;
        graphics.setClip(new Rectangle(this.getBounds()).expand(10, 10));
        int x = this.bounds.x - 10 + 1;
        int y = this.bounds.y - 10 + 1;
        int w = this.bounds.width + 20;
        int h = this.bounds.height + 20;
        int z = Math.max(w / 8, 1);
        graphics.setLineWidth(z);
        graphics.setLineCap(2);
        graphics.drawLine(x + z, y + z, x + w - z * 2, y + h - z * 2);
        graphics.drawLine(x + w - z * 2, y + z, x + z, y + h - z * 2);
        graphics.setClip(clipRect);
        graphics.popState();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension(8, 8);
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
    }
}

