/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.FrameworkUtil;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private final String XDG_DATA_DIRS = "XDG_DATA_DIRS";
    private final List<String> DEFAULT_DATA_DIRS = List.of("/usr/local/share", "/usr/share");
    private final List<String> DEFAULT_FLATPAK_DATA_DIRS = List.of("/run/host/usr/local/share", "/run/host/usr/share");

    public void initializeDefaultPreferences() {
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName());
        List<Path> locations = this.computeDefaultDevhelpLocations();
        String defaults = locations.stream().filter(path -> Files.exists(path, new LinkOption[0])).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
        prefs.put("org.eclipse.linuxtools.cdt.libhover.devhelp.directory", defaults);
    }

    private List<Path> computeDefaultDevhelpLocations() {
        String datadirsEnv = System.getenv("XDG_DATA_DIRS");
        List<String> datadirs = null;
        datadirs = datadirsEnv == null || datadirsEnv.isBlank() ? this.DEFAULT_DATA_DIRS : Arrays.asList(datadirsEnv.split(File.pathSeparator));
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String datadir : datadirs) {
            this.addBookPathsForDataDir(datadir, paths);
        }
        if (Files.exists(Path.of("/.flatpak-info", new String[0]), new LinkOption[0])) {
            for (String datadir : this.DEFAULT_FLATPAK_DATA_DIRS) {
                this.addBookPathsForDataDir(datadir, paths);
            }
        }
        return paths;
    }

    private void addBookPathsForDataDir(String datadir, List<Path> bookPaths) {
        bookPaths.add(Path.of(datadir, "doc"));
        bookPaths.add(Path.of(datadir, "gtk-doc", "html"));
        bookPaths.add(Path.of(datadir, "devhelp", "books"));
    }
}

