/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter.jsp;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory2;
import org.eclipse.jst.pagedesigner.converter.HiddenTagConverter;
import org.eclipse.jst.pagedesigner.converter.IConverterFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.converter.TagConverterToDumBlock;
import org.eclipse.jst.pagedesigner.converter.jsp.IncludeTagConverterPreview;
import org.eclipse.jst.pagedesigner.editors.palette.TagImageManager;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;

public class JSPConverterFactory
implements IConverterFactory {
    private final ILabelProvider _labelProvider = new MyLabelProvider();

    public ITagConverter createConverter(Element element, int mode) {
        String tagName = element.getLocalName();
        if (mode == 1) {
            if ("include".equalsIgnoreCase(tagName)) {
                IncludeTagConverterPreview c = new IncludeTagConverterPreview(element, "page");
                c.setMode(mode);
                return c;
            }
            if ("directive.include".equalsIgnoreCase(tagName)) {
                IncludeTagConverterPreview c = new IncludeTagConverterPreview(element, "file");
                c.setMode(mode);
                return c;
            }
            if ("root".equalsIgnoreCase(tagName)) {
                TagConverterToDumBlock c = new TagConverterToDumBlock(element);
                c.setNeedBorderDecorator(true);
                c.setMode(mode);
                return c;
            }
            return new HiddenTagConverter(element, this._labelProvider);
        }
        if ("root".equalsIgnoreCase(tagName)) {
            TagConverterToDumBlock c = new TagConverterToDumBlock(element);
            c.setNeedBorderDecorator(true);
            c.setMode(mode);
            return c;
        }
        return new HiddenTagConverter(element, this._labelProvider);
    }

    public String getSupportedURI() {
        return "jsp";
    }

    private static class MyLabelProvider
    extends LabelProvider {
        private MyLabelProvider() {
        }

        public Image getImage(Object element) {
            IWorkspaceContextResolver wsResolver;
            Element hostElement;
            IStructuredDocumentContext context;
            if (element instanceof ITagConverter && (context = IStructuredDocumentContextFactory2.INSTANCE.getContext(hostElement = ((ITagConverter)element).getHostElement())) != null && (wsResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context)) != null) {
                return TagImageManager.getInstance().getSmallIconImage((IFile)wsResolver.getResource(), "JSP11", "jsp:" + hostElement.getLocalName());
            }
            return null;
        }
    }
}

